/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;
import mmcorej.CMMCore;
import mmcorej.DeviceDetectionStatus;
import mmcorej.DeviceType;
import mmcorej.MMCoreJ;
import mmcorej.StrVector;
import org.micromanager.conf2.ComPropTableModel;
import org.micromanager.conf2.DetectorJDialog;
import org.micromanager.conf2.Device;
import org.micromanager.conf2.MMConfigFileException;
import org.micromanager.conf2.MicroscopeModel;
import org.micromanager.conf2.PropertyTableModel;
import org.micromanager.conf2.Setting;
import org.micromanager.utils.MMDialog;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.PropertyNameCellRenderer;
import org.micromanager.utils.PropertyValueCellEditor;
import org.micromanager.utils.PropertyValueCellRenderer;
import org.micromanager.utils.ReportingUtils;

public class DeviceSetupDlg
extends MMDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private CMMCore core;
    private Device portDev;
    private MicroscopeModel model;
    private Device dev;
    private JTable propTable;
    private JButton detectButton;
    private DetectorJDialog progressDialog;
    private DetectionTask dt;
    private final String DETECT_PORTS = "Scan";
    private JTable comTable;
    private JTextField devLabel;

    public DeviceSetupDlg(MicroscopeModel microscopeModel, CMMCore cMMCore, Device device) {
        this.setModal(true);
        this.setBounds(100, 100, 478, 528);
        this.loadPosition(100, 100);
        this.model = microscopeModel;
        this.core = cMMCore;
        this.portDev = null;
        this.dev = device;
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(null);
        JComponent jComponent = new JLabel("Label");
        jComponent.setBounds(10, 11, 35, 14);
        this.contentPanel.add(jComponent);
        this.devLabel = new JTextField(this.dev.getName());
        this.devLabel.setBounds(47, 8, 165, 20);
        this.contentPanel.add(this.devLabel);
        this.devLabel.setColumns(10);
        jComponent = new JPanel();
        jComponent.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)jComponent, "South");
        JComponent jComponent2 = new JButton("OK");
        ((AbstractButton)jComponent2).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DeviceSetupDlg.this.onOK();
            }
        });
        ((AbstractButton)jComponent2).setActionCommand("OK");
        jComponent.add(jComponent2);
        this.getRootPane().setDefaultButton((JButton)jComponent2);
        jComponent2 = new JButton("Cancel");
        ((AbstractButton)jComponent2).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DeviceSetupDlg.this.onCancel();
            }
        });
        ((AbstractButton)jComponent2).setActionCommand("Cancel");
        jComponent.add(jComponent2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DeviceSetupDlg.this.savePosition();
            }
        });
        this.setTitle("Device: " + this.dev.getAdapterName() + " | Library: " + this.dev.getLibrary());
        jComponent = new JScrollPane();
        jComponent.setBounds(10, 64, 442, 164);
        this.contentPanel.add(jComponent);
        this.propTable = new JTable();
        this.propTable.setSelectionMode(0);
        this.propTable.setAutoCreateColumnsFromModel(false);
        ((JScrollPane)jComponent).setViewportView(this.propTable);
        this.detectButton = new JButton("Scan");
        this.detectButton.setEnabled(false);
        this.detectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DeviceSetupDlg.this.dt != null && DeviceSetupDlg.this.dt.isAlive()) {
                    return;
                }
                DeviceSetupDlg.this.progressDialog = new DetectorJDialog((Dialog)DeviceSetupDlg.this, false);
                DeviceSetupDlg.this.progressDialog.setTitle("\u00b5Manager device detection");
                DeviceSetupDlg.this.progressDialog.setLocationRelativeTo(DeviceSetupDlg.this);
                DeviceSetupDlg.this.progressDialog.setSize(483, 288);
                DeviceSetupDlg.this.progressDialog.setVisible(true);
                DeviceSetupDlg.this.dt = new DetectionTask("serial_detect");
                DeviceSetupDlg.this.dt.start();
            }
        });
        this.detectButton.setToolTipText("Scan COM ports to detect this device");
        this.detectButton.setBounds(359, 247, 93, 23);
        this.contentPanel.add(this.detectButton);
        jComponent2 = new JLabel("Port Properties (RS 232 settings)");
        jComponent2.setBounds(10, 251, 442, 14);
        this.contentPanel.add(jComponent2);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBounds(10, 281, 442, 169);
        this.contentPanel.add(jScrollPane);
        this.comTable = new JTable();
        jScrollPane.setViewportView(this.comTable);
        this.comTable.setSelectionMode(0);
        this.comTable.setAutoCreateColumnsFromModel(false);
        JLabel jLabel = new JLabel("Initialization Properties");
        jLabel.setBounds(10, 49, 442, 14);
        this.contentPanel.add(jLabel);
        JLabel jLabel2 = new JLabel(this.dev.getParentHub().length() == 0 ? "" : "Parent: " + this.dev.getParentHub());
        jLabel2.setBounds(227, 11, 225, 14);
        this.contentPanel.add(jLabel2);
        this.loadSettings();
    }

    protected void onCancel() {
        this.savePosition();
        this.dispose();
    }

    protected void onOK() {
        Device device;
        this.propTable.editingStopped(null);
        this.savePosition();
        String string = this.dev.getName();
        String string2 = this.devLabel.getText();
        if (this.dev.getName().compareTo(this.devLabel.getText()) != 0) {
            if (this.model.findDevice(this.devLabel.getText()) != null) {
                this.showMessage("Device name " + this.devLabel.getText() + " is already in use.\nPress Cancel and try again.");
                return;
            }
            try {
                this.core.unloadDevice(this.dev.getName());
                this.dev.setInitialized(false);
                this.core.loadDevice(this.devLabel.getText(), this.dev.getLibrary(), this.dev.getAdapterName());
                this.core.setParentLabel(this.devLabel.getText(), this.dev.getParentHub());
            }
            catch (Exception exception) {
                this.showMessage("Device failed to re-load with changed name.");
                return;
            }
            this.dev.setName(this.devLabel.getText());
        }
        if ((device = this.model.findDevice(this.devLabel.getText())) == null) {
            this.showMessage("Device " + this.devLabel.getText() + " is not loaded properly.\nPress Cancel and try again.");
            return;
        }
        if (device.isInitialized()) {
            try {
                this.core.unloadDevice(device.getName());
                this.core.loadDevice(device.getName(), device.getLibrary(), device.getAdapterName());
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception);
            }
        }
        if (this.initializeDevice()) {
            this.dispose();
            if (this.portDev != null) {
                this.model.useSerialPort(this.portDev, true);
            }
        } else {
            this.dev.setInitialized(false);
            return;
        }
        this.model.setModified(true);
        if (!string.contentEquals(string2)) {
            Device[] deviceArray = this.model.getDevices();
            for (int i = 0; i < deviceArray.length; ++i) {
                if (!deviceArray[i].getParentHub().contentEquals(string)) continue;
                deviceArray[i].setParentHub(string2);
            }
        }
    }

    private void loadSettings() {
        int n;
        this.rebuildPropTable();
        ArrayList<Device> arrayList = new ArrayList<Device>();
        Device[] deviceArray = this.model.getAvailableSerialPorts();
        for (n = 0; n < deviceArray.length; ++n) {
            arrayList.add(deviceArray[n]);
        }
        n = 0;
        boolean bl = false;
        for (int i = 0; i < this.dev.getNumberOfProperties(); ++i) {
            PropertyItem propertyItem = this.dev.getProperty(i);
            if (propertyItem.preInit) {
                bl = true;
            }
            if (propertyItem.name.compareTo(MMCoreJ.getG_Keyword_Port()) != 0) continue;
            n = 1;
            if (arrayList.size() == 0) {
                JOptionPane.showMessageDialog(null, "There are no unused ports available!");
                return;
            }
            String[] stringArray = new String[arrayList.size()];
            for (int j = 0; j < arrayList.size(); ++j) {
                stringArray[j] = ((Device)arrayList.get(j)).getName();
            }
            propertyItem.allowed = stringArray;
            this.rebuildComTable(propertyItem.value);
        }
        if (bl && n == 0) {
            Rectangle rectangle = this.getBounds();
            rectangle.height = 300;
            this.setBounds(rectangle);
        } else if (!bl && n == 0) {
            Rectangle rectangle = this.getBounds();
            rectangle.height = 112;
            this.setBounds(rectangle);
        }
    }

    private void rebuildPropTable() {
        PropertyTableModel propertyTableModel = new PropertyTableModel(this.model, this.dev, this);
        this.propTable.setModel(propertyTableModel);
        PropertyValueCellEditor propertyValueCellEditor = new PropertyValueCellEditor();
        PropertyValueCellRenderer propertyValueCellRenderer = new PropertyValueCellRenderer();
        PropertyNameCellRenderer propertyNameCellRenderer = new PropertyNameCellRenderer();
        if (this.propTable.getColumnCount() == 0) {
            TableColumn tableColumn = new TableColumn(0, 200, propertyNameCellRenderer, null);
            this.propTable.addColumn(tableColumn);
            tableColumn = new TableColumn(1, 200, propertyNameCellRenderer, null);
            this.propTable.addColumn(tableColumn);
            tableColumn = new TableColumn(2, 200, propertyValueCellRenderer, propertyValueCellEditor);
            this.propTable.addColumn(tableColumn);
        }
        propertyTableModel.fireTableStructureChanged();
        propertyTableModel.fireTableDataChanged();
        boolean bl = false;
        Device[] deviceArray = this.model.getDevices();
        for (int i = 0; i < deviceArray.length; ++i) {
            for (int j = 0; j < deviceArray[i].getNumberOfProperties(); ++j) {
                PropertyItem propertyItem = deviceArray[i].getProperty(j);
                if (propertyItem.name.compareTo(MMCoreJ.getG_Keyword_Port()) != 0) continue;
                bl = true;
                break;
            }
            if (bl) break;
        }
        this.detectButton.setEnabled(bl);
        this.propTable.repaint();
    }

    public void rebuildComTable(String string) {
        if (string == null) {
            return;
        }
        this.portDev = this.model.findSerialPort(string);
        if (this.portDev == null) {
            return;
        }
        StrVector strVector = this.core.getLoadedDevicesOfType(DeviceType.SerialDevice);
        Iterator<String> iterator = strVector.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            iterator.next().compareTo(string);
            bl = true;
        }
        if (!bl) {
            try {
                this.core.loadDevice(this.portDev.getName(), this.portDev.getLibrary(), this.portDev.getAdapterName());
                this.portDev.loadDataFromHardware(this.core);
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception);
            }
        }
        try {
            System.out.println("rebuild " + this.portDev.getPropertyValue("BaudRate"));
        }
        catch (MMConfigFileException mMConfigFileException) {
            ReportingUtils.logError(mMConfigFileException);
        }
        ComPropTableModel comPropTableModel = new ComPropTableModel(this.model, this.portDev);
        this.comTable.setModel(comPropTableModel);
        PropertyValueCellEditor propertyValueCellEditor = new PropertyValueCellEditor();
        PropertyValueCellRenderer propertyValueCellRenderer = new PropertyValueCellRenderer();
        PropertyNameCellRenderer propertyNameCellRenderer = new PropertyNameCellRenderer();
        if (this.comTable.getColumnCount() == 0) {
            TableColumn tableColumn = new TableColumn(0, 200, propertyNameCellRenderer, null);
            this.comTable.addColumn(tableColumn);
            tableColumn = new TableColumn(1, 200, propertyNameCellRenderer, null);
            this.comTable.addColumn(tableColumn);
            tableColumn = new TableColumn(2, 200, propertyValueCellRenderer, propertyValueCellEditor);
            this.comTable.addColumn(tableColumn);
        }
        comPropTableModel.fireTableStructureChanged();
        comPropTableModel.fireTableDataChanged();
        this.comTable.repaint();
    }

    private boolean initializeDevice() {
        try {
            if (this.dev.isInitialized()) {
                this.core.unloadDevice(this.dev.getName());
                this.core.loadDevice(this.dev.getName(), this.dev.getLibrary(), this.dev.getAdapterName());
            }
            PropertyTableModel propertyTableModel = (PropertyTableModel)this.propTable.getModel();
            for (int i = 0; i < propertyTableModel.getRowCount(); ++i) {
                Setting setting = propertyTableModel.getSetting(i);
                this.core.setProperty(this.dev.getName(), setting.propertyName_, setting.propertyValue_);
            }
            this.dev.loadDataFromHardware(this.core);
            if (this.initializePort()) {
                this.dev.setName(this.devLabel.getText());
                this.core.initializeDevice(this.dev.getName());
                this.dev.loadDataFromHardware(this.core);
                this.dev.setInitialized(true);
                this.dev.updateSetupProperties();
                this.dev.discoverPeripherals(this.core);
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            this.showMessage(exception.getMessage());
            try {
                this.core.unloadDevice(this.dev.getName());
                this.core.loadDevice(this.dev.getName(), this.dev.getLibrary(), this.dev.getAdapterName());
            }
            catch (Exception exception2) {
                ReportingUtils.logError(exception2);
            }
            return false;
        }
    }

    private boolean initializePort() {
        if (this.portDev != null) {
            try {
                this.core.unloadDevice(this.portDev.getName());
                Thread.sleep(1000L);
                this.core.loadDevice(this.portDev.getName(), this.portDev.getLibrary(), this.portDev.getAdapterName());
                for (int i = 0; i < this.portDev.getNumberOfProperties(); ++i) {
                    PropertyItem propertyItem = this.portDev.getProperty(i);
                    if (!propertyItem.preInit) continue;
                    this.core.setProperty(this.portDev.getName(), propertyItem.name, propertyItem.value);
                    if (this.portDev.findSetupProperty(propertyItem.name) == null) {
                        this.portDev.addSetupProperty(new PropertyItem(propertyItem.name, propertyItem.value, true));
                        continue;
                    }
                    this.portDev.setSetupPropertyValue(propertyItem.name, propertyItem.value);
                }
                this.core.initializeDevice(this.portDev.getName());
                Thread.sleep(1000L);
                this.portDev.loadDataFromHardware(this.core);
                this.model.useSerialPort(this.portDev, true);
            }
            catch (Exception exception) {
                this.showMessage(exception.getMessage());
                return false;
            }
        }
        return true;
    }

    public void showMessage(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    public String getDeviceName() {
        return this.devLabel.getText();
    }

    static /* synthetic */ CMMCore access$300(DeviceSetupDlg deviceSetupDlg) {
        return deviceSetupDlg.core;
    }

    static /* synthetic */ MicroscopeModel access$400(DeviceSetupDlg deviceSetupDlg) {
        return deviceSetupDlg.model;
    }

    static /* synthetic */ Device access$500(DeviceSetupDlg deviceSetupDlg) {
        return deviceSetupDlg.dev;
    }

    static /* synthetic */ void access$600(DeviceSetupDlg deviceSetupDlg) {
        deviceSetupDlg.rebuildPropTable();
    }

    static /* synthetic */ JButton access$700(DeviceSetupDlg deviceSetupDlg) {
        return deviceSetupDlg.detectButton;
    }

    private class DetectionTask
    extends Thread {
        private String[] foundPorts;
        private String selectedPort;

        DetectionTask(String string) {
            super(string);
            this.foundPorts = new String[0];
            this.selectedPort = new String();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block33: {
                block32: {
                    block31: {
                        var1_1 = DeviceSetupDlg.access$300(DeviceSetupDlg.this).debugLogEnabled();
                        try {
                            var2_2 = new ArrayList<Device>();
                            DeviceSetupDlg.access$400(DeviceSetupDlg.this).removeDuplicateComPorts();
                            var3_3 = DeviceSetupDlg.access$400(DeviceSetupDlg.this).getAvailableSerialPorts();
                            var4_4 = "Serial ports available in configuration: ";
                            for (var5_5 = 0; var5_5 < var3_3.length; ++var5_5) {
                                var2_2.add(var3_3[var5_5]);
                            }
                            for (Device var6_7 : var2_2) {
                                if (0 < var4_4.length()) {
                                    var4_4 = var4_4 + " ";
                                }
                                var4_4 = var4_4 + var6_7.getName();
                            }
                            var5_6 = new HashMap<K, V>();
                            var6_8 = "";
                            DeviceSetupDlg.access$300(DeviceSetupDlg.this).enableDebugLog(false);
                            for (var7_15 = 0; var7_15 < var2_2.size(); ++var7_15) {
                                var6_10 = "";
                                try {
                                    DeviceSetupDlg.access$300(DeviceSetupDlg.this).setProperty(DeviceSetupDlg.access$500(DeviceSetupDlg.this).getName(), MMCoreJ.getG_Keyword_Port(), ((Device)var2_2.get(var7_15)).getName());
                                    if (0 < var6_10.length()) {
                                        var6_11 = var6_10 + "\n";
                                    }
                                    var6_13 = (String)var6_12 + DeviceSetupDlg.access$500(DeviceSetupDlg.this).getName() + " on " + ((Device)var2_2.get(var7_15)).getName();
                                }
                                catch (Exception var8_18) {
                                    ReportingUtils.logError(var8_18);
                                }
                                DeviceSetupDlg.access$200(DeviceSetupDlg.this).ProgressText("Looking for:\n" + (String)var6_14);
                                var8_17 = DeviceSetupDlg.access$300(DeviceSetupDlg.this).detectDevice(DeviceSetupDlg.access$500(DeviceSetupDlg.this).getName());
                                if (var8_17 == DeviceDetectionStatus.Unimplemented) {
                                    JOptionPane.showMessageDialog(null, "This device does not support auto-detection.\nYou have to manually choose port and settings.");
                                    var13_24 = null;
                                    break block31;
                                }
                                if (DeviceSetupDlg.access$200(DeviceSetupDlg.this).CancelRequest()) {
                                    System.out.print("cancel request");
                                    break block32;
                                }
                                if (DeviceDetectionStatus.CanCommunicate != var8_17) continue;
                                var9_19 = (ArrayList<String>)var5_6.get(DeviceSetupDlg.access$500(DeviceSetupDlg.this).getName());
                                if (null == var9_19) {
                                    var9_19 = new ArrayList<String>();
                                    var5_6.put(DeviceSetupDlg.access$500(DeviceSetupDlg.this).getName(), var9_19);
                                }
                                var9_19.add(((Device)var2_2.get(var7_15)).getName());
                            }
                            var7_16 = "";
                            var8_17 = (ArrayList)var5_6.get(DeviceSetupDlg.access$500(DeviceSetupDlg.this).getName());
                            this.foundPorts = new String[0];
                            if (null != var8_17) {
                                if (0 < var8_17.size()) {
                                    this.foundPorts = new String[var8_17.size()];
                                    var9_20 = 0;
                                    var7_16 = var7_16 + DeviceSetupDlg.access$500(DeviceSetupDlg.this).getName() + " on ";
                                    var10_36 = var8_17.iterator();
                                    while (var10_36.hasNext()) {
                                        var11_37 = (String)var10_36.next();
                                        var7_16 = var7_16 + var11_37 + "\n";
                                        this.foundPorts[var9_20++] = var11_37;
                                    }
                                }
                                var9_22 = DeviceSetupDlg.access$500(DeviceSetupDlg.this).findProperty(MMCoreJ.getG_Keyword_Port());
                                var9_22.allowed = this.foundPorts;
                                var9_22.value = "";
                                this.selectedPort = "";
                                if (0 < this.foundPorts.length) {
                                    var9_22.value = this.foundPorts.length > 1 ? (var10_36 = (String)JOptionPane.showInputDialog(null, "Multiple ports found, choose one", "Port", 1, null, this.foundPorts, this.foundPorts[0])) : this.foundPorts[0];
                                    this.selectedPort = var9_22.value;
                                }
                            }
                            DeviceSetupDlg.access$200(DeviceSetupDlg.this).ProgressText("Found:\n " + var7_16);
                            try {
                                Thread.sleep(900L);
                            }
                            catch (InterruptedException var9_23) {
                            }
                            break block33;
                        }
                        catch (Throwable var12_38) {
                            var13_27 = null;
                            DeviceSetupDlg.access$200(DeviceSetupDlg.this).setVisible(false);
                            DeviceSetupDlg.access$300(DeviceSetupDlg.this).enableDebugLog(var1_1);
                            DeviceSetupDlg.access$600(DeviceSetupDlg.this);
                            if (this.selectedPort.length() != 0) {
                                var14_31 = DeviceSetupDlg.access$400(DeviceSetupDlg.this).findSerialPort(this.selectedPort);
                                if (var14_31 != null) {
                                    try {
                                        var14_31.loadDataFromHardware(DeviceSetupDlg.access$300(DeviceSetupDlg.this));
                                    }
                                    catch (Exception var15_35) {
                                        ReportingUtils.logError(var15_35);
                                    }
                                }
                                DeviceSetupDlg.this.rebuildComTable(this.selectedPort);
                            }
                            DeviceSetupDlg.access$700(DeviceSetupDlg.this).setText("Scan");
                            throw var12_38;
                        }
                    }
                    DeviceSetupDlg.access$200(DeviceSetupDlg.this).setVisible(false);
                    DeviceSetupDlg.access$300(DeviceSetupDlg.this).enableDebugLog(var1_1);
                    DeviceSetupDlg.access$600(DeviceSetupDlg.this);
                    if (this.selectedPort.length() != 0) {
                        block35: {
                            var14_28 = DeviceSetupDlg.access$400(DeviceSetupDlg.this).findSerialPort(this.selectedPort);
                            if (var14_28 != null) {
                                ** try [egrp 3[TRYBLOCK] [6 : 902->917)] { 
lbl103:
                                // 1 sources

                                var14_28.loadDataFromHardware(DeviceSetupDlg.access$300(DeviceSetupDlg.this));
                                break block35;
lbl105:
                                // 1 sources

                                catch (Exception var15_32) {
                                    ReportingUtils.logError(var15_32);
                                }
                            }
                        }
                        DeviceSetupDlg.this.rebuildComTable(this.selectedPort);
                    }
                    DeviceSetupDlg.access$700(DeviceSetupDlg.this).setText("Scan");
                    return;
                }
                var13_25 = null;
                DeviceSetupDlg.access$200(DeviceSetupDlg.this).setVisible(false);
                DeviceSetupDlg.access$300(DeviceSetupDlg.this).enableDebugLog(var1_1);
                DeviceSetupDlg.access$600(DeviceSetupDlg.this);
                if (this.selectedPort.length() != 0) {
                    block36: {
                        var14_29 = DeviceSetupDlg.access$400(DeviceSetupDlg.this).findSerialPort(this.selectedPort);
                        if (var14_29 != null) {
                            ** try [egrp 3[TRYBLOCK] [6 : 902->917)] { 
lbl120:
                            // 1 sources

                            var14_29.loadDataFromHardware(DeviceSetupDlg.access$300(DeviceSetupDlg.this));
                            break block36;
lbl122:
                            // 1 sources

                            catch (Exception var15_33) {
                                ReportingUtils.logError(var15_33);
                            }
                        }
                    }
                    DeviceSetupDlg.this.rebuildComTable(this.selectedPort);
                }
                DeviceSetupDlg.access$700(DeviceSetupDlg.this).setText("Scan");
                return;
            }
            var13_26 = null;
            DeviceSetupDlg.access$200(DeviceSetupDlg.this).setVisible(false);
            DeviceSetupDlg.access$300(DeviceSetupDlg.this).enableDebugLog(var1_1);
            DeviceSetupDlg.access$600(DeviceSetupDlg.this);
            if (this.selectedPort.length() != 0) {
                block37: {
                    var14_30 = DeviceSetupDlg.access$400(DeviceSetupDlg.this).findSerialPort(this.selectedPort);
                    if (var14_30 != null) {
                        ** try [egrp 3[TRYBLOCK] [6 : 902->917)] { 
lbl137:
                        // 1 sources

                        var14_30.loadDataFromHardware(DeviceSetupDlg.access$300(DeviceSetupDlg.this));
                        break block37;
lbl139:
                        // 1 sources

                        catch (Exception var15_34) {
                            ReportingUtils.logError(var15_34);
                        }
                    }
                }
                DeviceSetupDlg.this.rebuildComTable(this.selectedPort);
            }
            DeviceSetupDlg.access$700(DeviceSetupDlg.this).setText("Scan");
        }

        public void finish() {
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

