/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.text.DefaultCaret;
import mmcorej.CMMCore;
import mmcorej.StrVector;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.conf2.DelayPage;
import org.micromanager.conf2.DevicesPage;
import org.micromanager.conf2.FinishPage;
import org.micromanager.conf2.IntroPage;
import org.micromanager.conf2.LabelsPage;
import org.micromanager.conf2.MMConfigFileException;
import org.micromanager.conf2.MicroscopeModel;
import org.micromanager.conf2.PagePanel;
import org.micromanager.conf2.RolesPage;
import org.micromanager.utils.FileDialogs;
import org.micromanager.utils.HotKeys;
import org.micromanager.utils.HttpUtils;
import org.micromanager.utils.MMDialog;
import org.micromanager.utils.ReportingUtils;

public class ConfiguratorDlg2
extends MMDialog {
    private static final long serialVersionUID = 1L;
    private JLabel pagesLabel_;
    private JButton backButton_;
    private JButton nextButton_;
    private PagePanel[] pages_;
    private int curPage_ = 0;
    private MicroscopeModel microModel_;
    private CMMCore core_;
    private Preferences prefs_;
    private static final String APP_NAME = "Configurator";
    private JLabel titleLabel_;
    private JEditorPane helpTextPane_;
    private String defaultPath_;
    private static final String CFG_OKAY_TO_SEND = "CFG_Okay_To_Send";

    public ConfiguratorDlg2(CMMCore cMMCore, String string) {
        this.core_ = cMMCore;
        this.defaultPath_ = string;
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.initialize();
    }

    private void initialize() {
        this.prefs_ = Preferences.userNodeForPackage(this.getClass());
        HotKeys.active_ = false;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ConfiguratorDlg2.this.onCloseWindow();
            }
        });
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.setTitle("Hardware Configuration Wizard");
        this.setBounds(50, 100, 859, 641);
        this.loadPosition(50, 100);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBounds(584, 28, 259, 526);
        this.getContentPane().add(jScrollPane);
        jScrollPane.getViewport().setViewPosition(new Point(0, 0));
        this.helpTextPane_ = new JEditorPane();
        jScrollPane.setViewportView(this.helpTextPane_);
        this.helpTextPane_.setEditable(false);
        DefaultCaret defaultCaret = (DefaultCaret)this.helpTextPane_.getCaret();
        defaultCaret.setUpdatePolicy(1);
        this.helpTextPane_.setContentType("text/html; charset=ISO-8859-1");
        this.nextButton_ = new JButton();
        this.nextButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ConfiguratorDlg2.this.curPage_ == ConfiguratorDlg2.this.pages_.length - 1) {
                    ConfiguratorDlg2.this.pages_[ConfiguratorDlg2.this.curPage_].exitPage(true);
                    ConfiguratorDlg2.this.onCloseWindow();
                } else {
                    ConfiguratorDlg2.this.setPage(ConfiguratorDlg2.this.curPage_ + 1);
                }
            }
        });
        this.nextButton_.setText("Next >");
        this.nextButton_.setBounds(750, 565, 93, 23);
        this.getContentPane().add(this.nextButton_);
        this.getRootPane().setDefaultButton(this.nextButton_);
        this.backButton_ = new JButton();
        this.backButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfiguratorDlg2.this.setPage(ConfiguratorDlg2.this.curPage_ - 1);
            }
        });
        this.backButton_.setText("< Back");
        this.backButton_.setBounds(647, 565, 93, 23);
        this.getContentPane().add(this.backButton_);
        this.pagesLabel_ = new JLabel();
        this.pagesLabel_.setBorder(new LineBorder(Color.black, 1, false));
        this.pagesLabel_.setBounds(9, 28, 565, 560);
        this.getContentPane().add(this.pagesLabel_);
        this.pages_ = new PagePanel[6];
        int n = 0;
        this.pages_[n++] = new IntroPage(this.prefs_);
        this.pages_[n++] = new DevicesPage(this.prefs_);
        this.pages_[n++] = new RolesPage(this.prefs_);
        this.pages_[n++] = new DelayPage(this.prefs_);
        this.pages_[n++] = new LabelsPage(this.prefs_);
        this.pages_[n++] = new FinishPage(this.prefs_);
        this.microModel_ = new MicroscopeModel();
        boolean bl = this.prefs_.getBoolean(CFG_OKAY_TO_SEND, true);
        this.microModel_.setSendConfiguration(bl);
        this.microModel_.loadAvailableDeviceList(this.core_);
        this.microModel_.setFileName(this.defaultPath_);
        Rectangle rectangle = this.pagesLabel_.getBounds();
        this.titleLabel_ = new JLabel();
        this.titleLabel_.setText("Title");
        this.titleLabel_.setBounds(9, 4, 578, 21);
        this.getContentPane().add(this.titleLabel_);
        for (int i = 0; i < this.pages_.length; ++i) {
            try {
                this.pages_[i].setModel(this.microModel_, this.core_);
                this.pages_[i].loadSettings();
                this.pages_[i].setBounds(rectangle);
                this.pages_[i].setTitle("Step " + (i + 1) + " of " + this.pages_.length + ": " + this.pages_[i].getTitle());
                this.pages_[i].setParentDialog(this);
                continue;
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception);
            }
        }
        this.setPage(0);
    }

    private void setPage(int n) {
        if (n > 0 && !this.pages_[this.curPage_].exitPage(this.curPage_ < n)) {
            return;
        }
        int n2 = 0;
        n2 = n < 0 ? 0 : (n >= this.pages_.length ? this.pages_.length - 1 : n);
        if (!this.pages_[n2].enterPage(this.curPage_ > n2)) {
            return;
        }
        this.getContentPane().remove(this.pages_[this.curPage_]);
        this.curPage_ = n2;
        this.getContentPane().add(this.pages_[this.curPage_]);
        this.getContentPane().repaint();
        this.pages_[this.curPage_].refresh();
        if (this.curPage_ == 0) {
            this.backButton_.setEnabled(false);
        } else {
            this.backButton_.setEnabled(true);
        }
        if (this.curPage_ == this.pages_.length - 1) {
            this.nextButton_.setText("Finish");
        } else {
            this.nextButton_.setText("Next >");
        }
        this.titleLabel_.setText(this.pages_[this.curPage_].getTitle());
        this.helpTextPane_.setContentType("text/plain");
        this.helpTextPane_.setText(this.pages_[this.curPage_].getHelpText());
        try {
            File file = new File(".");
            String string = this.pages_[this.curPage_].getHelpFileName();
            if (string == null) {
                return;
            }
            URL uRL = ConfiguratorDlg2.class.getResource(string);
            String string2 = ConfiguratorDlg2.readStream(ConfiguratorDlg2.class.getResourceAsStream(string));
            this.helpTextPane_.setContentType("text/html; charset=ISO-8859-1");
            this.helpTextPane_.setText(string2);
        }
        catch (MalformedURLException malformedURLException) {
            ReportingUtils.showError(malformedURLException);
        }
        catch (IOException iOException) {
            ReportingUtils.showError(iOException);
        }
    }

    private String UploadCurrentConfigFile() {
        String string;
        block21: {
            string = "";
            try {
                int n;
                Object object;
                Object object2;
                Object object3;
                Serializable serializable;
                HttpUtils httpUtils = new HttpUtils();
                ArrayList arrayList = new ArrayList();
                File file = new File(this.getFileName());
                if (!file.exists()) break block21;
                String string2 = "#";
                String string3 = "";
                try {
                    serializable = new SimpleDateFormat("yyyyMMddHHmmss");
                    string3 = string3 + ((DateFormat)serializable).format(new Date());
                    object3 = TimeZone.getDefault().getDisplayName(false, 0);
                    string3 = string3 + (String)object3;
                    string3 = string3 + "@";
                    try {
                        object2 = "00-00-00-00-00-00";
                        StrVector strVector = this.core_.getMACAddresses();
                        if (0L < strVector.size() && null != (object = strVector.get(0)) && 0 < ((String)object).length()) {
                            object2 = object;
                        }
                        string3 = string3 + (String)object2;
                        string2 = string2 + "Host: " + InetAddress.getLocalHost().getHostName() + " ";
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                    string2 = string2 + "User: " + this.core_.getUserId() + " configuration file: " + file.getName() + "\n";
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                string3.replace(':', '_');
                string3.replace(';', '_');
                serializable = new File(string3);
                object3 = new FileReader(file);
                object2 = new FileWriter((File)serializable);
                ((OutputStreamWriter)object2).append(string2);
                while (-1 != (n = ((InputStreamReader)object3).read())) {
                    ((OutputStreamWriter)object2).write(n);
                }
                try {
                    ((InputStreamReader)object3).close();
                }
                catch (Exception exception) {
                    ReportingUtils.logError(exception);
                }
                try {
                    ((OutputStreamWriter)object2).close();
                }
                catch (Exception exception) {
                    ReportingUtils.logError(exception);
                }
                try {
                    object = new URL("http://valelab.ucsf.edu/~MM/upload_file.php");
                    ArrayList<Serializable> arrayList2 = new ArrayList<Serializable>();
                    arrayList2.add(serializable);
                    for (Object e : arrayList2) {
                        File file2 = (File)e;
                        try {
                            httpUtils.upload((URL)object, file2);
                        }
                        catch (UnknownHostException unknownHostException) {
                            string = unknownHostException.toString();
                        }
                        catch (IOException iOException) {
                            string = iOException.toString();
                        }
                        catch (SecurityException securityException) {
                            string = securityException.toString();
                        }
                        catch (Exception exception) {
                            string = exception.toString();
                        }
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    string = malformedURLException.toString();
                }
                if (!((File)serializable).delete()) {
                    ReportingUtils.logError("Couldn't delete temporary file " + string3);
                }
            }
            catch (IOException iOException) {
                string = iOException.toString();
            }
        }
        return string;
    }

    private void onCloseWindow() {
        int n;
        for (n = 0; n < this.pages_.length; ++n) {
            this.pages_[n].saveSettings();
        }
        this.savePosition();
        if (this.microModel_.isModified()) {
            n = JOptionPane.showConfirmDialog(this, "Save changes to the configuration file?\nIf you press YES you will get a chance to change the file name.", APP_NAME, 1, 1);
            switch (n) {
                case 0: {
                    this.saveConfiguration();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        if (this.microModel_.getSendConfiguration()) {
            class Uploader
            extends Thread {
                private String statusMessage_;

                public Uploader() {
                    super("uploader");
                    this.statusMessage_ = "";
                }

                public void run() {
                    this.statusMessage_ = ConfiguratorDlg2.this.UploadCurrentConfigFile();
                }

                public String Status() {
                    return this.statusMessage_;
                }
            }
            Uploader uploader = new Uploader();
            uploader.start();
            try {
                uploader.join();
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(ConfiguratorDlg2.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            if (0 < uploader.Status().length()) {
                ReportingUtils.logError("Error uploading configuration file: " + uploader.Status());
            }
        }
        this.prefs_.putBoolean(CFG_OKAY_TO_SEND, this.microModel_.getSendConfiguration());
        HotKeys.active_ = true;
        this.dispose();
    }

    private void saveConfiguration() {
        File file = FileDialogs.save(this, "Create a config file", MMStudioMainFrame.MM_CONFIG_FILE);
        if (file == null) {
            return;
        }
        try {
            this.microModel_.saveToFile(file.getAbsolutePath());
        }
        catch (MMConfigFileException mMConfigFileException) {
            JOptionPane.showMessageDialog(this, mMConfigFileException.getMessage());
        }
    }

    public String getFileName() {
        return this.microModel_.getFileName();
    }

    private static String readStream(InputStream inputStream) throws IOException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

