/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.api;

import ij.ImagePlus;
import ij.process.ImageProcessor;
import org.json.JSONObject;
import org.micromanager.acquisition.VirtualAcquisitionDisplay;
import org.micromanager.utils.MMScriptException;

public class MMWindow {
    private final VirtualAcquisitionDisplay virtAcq_;
    private final ImagePlus imp_;

    public MMWindow(ImagePlus imagePlus) {
        this.imp_ = imagePlus;
        this.virtAcq_ = VirtualAcquisitionDisplay.getDisplay(imagePlus);
    }

    public boolean isMMWindow() {
        return this.virtAcq_ != null;
    }

    public int getNumberOfPositions() {
        if (this.virtAcq_ == null) {
            return 0;
        }
        return this.virtAcq_.getNumPositions();
    }

    public int getNumberOfChannels() {
        if (this.virtAcq_ == null) {
            return 0;
        }
        return this.virtAcq_.getNumGrayChannels();
    }

    public int getNumberOfSlices() {
        if (this.virtAcq_ == null) {
            return 0;
        }
        return this.virtAcq_.getImagePlus().getNSlices();
    }

    public int getNumberOfFrames() {
        if (this.virtAcq_ == null) {
            return 0;
        }
        return this.virtAcq_.getImagePlus().getNFrames();
    }

    public void setPosition(int n) throws MMScriptException {
        if (n < 1 || n > this.getNumberOfPositions()) {
            throw new MMScriptException("Invalid position requested");
        }
        if (this.virtAcq_ != null) {
            this.virtAcq_.setPosition(n - 1);
        }
    }

    public int getPosition() throws MMScriptException {
        if (this.virtAcq_ != null) {
            return this.virtAcq_.getCurrentPosition() + 1;
        }
        throw new MMScriptException("This is not a MMWindow");
    }

    public ImagePlus getImagePlus(int n) {
        return this.virtAcq_.getImagePlus(n);
    }

    public ImageProcessor getImageProcessor(int n, int n2, int n3, int n4) throws MMScriptException {
        this.setPosition(n4);
        if (n >= this.getNumberOfChannels() || n2 >= this.getNumberOfSlices() || n3 >= this.getNumberOfFrames()) {
            throw new MMScriptException("Parameters out of bounds");
        }
        if (this.virtAcq_ == null) {
            return null;
        }
        ImagePlus imagePlus = this.virtAcq_.getImagePlus();
        return imagePlus.getImageStack().getProcessor(imagePlus.getStackIndex(n + 1, n2, n3));
    }

    public JSONObject getSummaryMetaData() {
        return this.virtAcq_.getSummaryMetadata();
    }

    public JSONObject getImageMetadata(int n, int n2, int n3, int n4) {
        return this.virtAcq_.getImageCache().getImageTags(n, n2, n3, n4);
    }
}

