/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import java.util.Set;
import java.util.TreeMap;
import mmcorej.TaggedImage;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.api.TaggedImageStorage;
import org.micromanager.utils.ImageLabelComparator;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMException;
import org.micromanager.utils.ReportingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggedImageStorageRam
implements TaggedImageStorage {
    public static String menuName_ = null;
    private boolean finished_ = false;
    protected TreeMap<String, TaggedImage> imageMap_ = new TreeMap(new ImageLabelComparator());
    private JSONObject summaryMetadata_;
    private JSONObject displaySettings_;
    private int lastFrame_ = -1;

    public TaggedImageStorageRam(JSONObject jSONObject) {
        this.setSummaryMetadata(jSONObject);
        this.displaySettings_ = new JSONObject();
    }

    @Override
    public void putImage(TaggedImage taggedImage) throws MMException {
        String string = MDUtils.getLabel(taggedImage.tags);
        this.imageMap_.put(string, taggedImage);
        try {
            this.lastFrame_ = Math.max(this.lastFrame_, MDUtils.getFrameIndex(taggedImage.tags));
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
    }

    @Override
    public TaggedImage getImage(int n, int n2, int n3, int n4) {
        if (this.imageMap_ == null) {
            return null;
        }
        return this.imageMap_.get(MDUtils.generateLabel(n, n2, n3, n4));
    }

    @Override
    public JSONObject getImageTags(int n, int n2, int n3, int n4) {
        return this.getImage((int)n, (int)n2, (int)n3, (int)n4).tags;
    }

    @Override
    public Set<String> imageKeys() {
        return this.imageMap_.keySet();
    }

    @Override
    public void finished() {
        this.finished_ = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished_;
    }

    @Override
    public void setSummaryMetadata(JSONObject jSONObject) {
        this.summaryMetadata_ = jSONObject;
        if (this.summaryMetadata_ != null) {
            try {
                boolean bl = this.summaryMetadata_.getBoolean("SlicesFirst");
                boolean bl2 = this.summaryMetadata_.getBoolean("TimeFirst");
                TreeMap<String, TaggedImage> treeMap = this.imageMap_;
                this.imageMap_ = new TreeMap(new ImageLabelComparator(bl, bl2));
                this.imageMap_.putAll(treeMap);
            }
            catch (JSONException jSONException) {
                ReportingUtils.logError("Couldn't find SlicesFirst or TimeFirst in summary metadata");
            }
        }
    }

    @Override
    public JSONObject getSummaryMetadata() {
        return this.summaryMetadata_;
    }

    @Override
    public void setDisplayAndComments(JSONObject jSONObject) {
        this.displaySettings_ = jSONObject;
    }

    @Override
    public JSONObject getDisplayAndComments() {
        return this.displaySettings_;
    }

    @Override
    public void close() {
        this.imageMap_ = null;
        this.summaryMetadata_ = null;
        this.displaySettings_ = null;
    }

    @Override
    public String getDiskLocation() {
        return null;
    }

    @Override
    public int lastAcquiredFrame() {
        return this.lastFrame_;
    }

    @Override
    public long getDataSetSize() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeDisplaySettings() {
    }
}

