/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import ij.CompositeImage;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileSaver;
import ij.io.Opener;
import ij.io.TiffDecoder;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import mmcorej.TaggedImage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.api.TaggedImageStorage;
import org.micromanager.utils.ImageLabelComparator;
import org.micromanager.utils.ImageUtils;
import org.micromanager.utils.JavaUtils;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMException;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.TextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggedImageStorageDiskDefault
implements TaggedImageStorage {
    public static String menuName_ = "Micro-Manager default file format";
    private final String dir_;
    private boolean firstElement_;
    private HashMap<Integer, Writer> metadataStreams_;
    private boolean newDataSet_;
    private JSONObject summaryMetadata_;
    private TreeMap<String, String> filenameTable_;
    private HashMap<String, JSONObject> metadataTable_ = null;
    private JSONObject displaySettings_;
    private int lastFrame_ = -1;
    private Thread shutdownHook_;
    private HashMap<Integer, String> positionNames_;

    public TaggedImageStorageDiskDefault(String string) throws Exception {
        this(string, false, null);
    }

    public TaggedImageStorageDiskDefault(String string, Boolean bl, JSONObject jSONObject) throws Exception {
        this.dir_ = string;
        this.newDataSet_ = bl;
        this.filenameTable_ = new TreeMap(new ImageLabelComparator());
        this.metadataStreams_ = new HashMap();
        this.metadataTable_ = new HashMap();
        this.displaySettings_ = new JSONObject();
        this.positionNames_ = new HashMap();
        this.setSummaryMetadata(jSONObject);
        if (!this.newDataSet_) {
            this.openExistingDataSet();
        }
        this.shutdownHook_ = new Thread(){

            public void run() {
                TaggedImageStorageDiskDefault.this.writeDisplaySettings();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook_);
    }

    @Override
    public int lastAcquiredFrame() {
        return this.lastFrame_;
    }

    private String getPosition(TaggedImage taggedImage) {
        return this.getPosition(taggedImage.tags);
    }

    private String getPosition(JSONObject jSONObject) {
        try {
            if (jSONObject.has("PositionName") && !jSONObject.isNull("PositionName")) {
                return MDUtils.getPositionName(jSONObject);
            }
            return "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public void putImage(TaggedImage taggedImage) throws MMException {
        try {
            if (!this.newDataSet_) {
                throw new MMException("This ImageFileManager is read-only.");
            }
            if (!this.metadataStreams_.containsKey(MDUtils.getPositionIndex(taggedImage.tags))) {
                try {
                    this.openNewDataSet(taggedImage);
                }
                catch (Exception exception) {
                    ReportingUtils.logError(exception);
                }
            }
            JSONObject jSONObject = taggedImage.tags;
            Object object = taggedImage.pix;
            String string = this.createFileName(jSONObject);
            MDUtils.setFileName(jSONObject, string);
            String string2 = "";
            String string3 = string;
            try {
                string2 = this.positionNames_.get(MDUtils.getPositionIndex(jSONObject));
                if (string2 != null && string2.length() > 0 && !string2.contentEquals("null")) {
                    JavaUtils.createDirectory(this.dir_ + "/" + string2);
                    string3 = string2 + "/" + string;
                } else {
                    string3 = string;
                }
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception);
            }
            File file = new File(this.dir_, string3);
            if (file.exists()) {
                MMStudioMainFrame.seriousErrorReported_.set(true);
                throw new Exception("Image saving failed: " + file.getAbsolutePath());
            }
            this.saveImageFile(object, jSONObject, this.dir_, string3);
            this.writeFrameMetadata(jSONObject);
            String string4 = MDUtils.getLabel(jSONObject);
            this.filenameTable_.put(string4, string3);
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
        }
    }

    @Override
    public TaggedImage getImage(int n, int n2, int n3, int n4) {
        String string = MDUtils.generateLabel(n, n2, n3, n4);
        if (this.filenameTable_.get(string) == null) {
            return null;
        }
        ImagePlus imagePlus = new Opener().openImage(this.dir_ + "/" + this.filenameTable_.get(string));
        if (imagePlus != null) {
            try {
                TaggedImage taggedImage;
                Object object;
                JSONObject jSONObject;
                ImageProcessor imageProcessor;
                block12: {
                    imageProcessor = imagePlus.getProcessor();
                    jSONObject = null;
                    try {
                        jSONObject = imagePlus.getProperty("Info") != null ? new JSONObject((String)imagePlus.getProperty("Info")) : this.metadataTable_.get(string);
                    }
                    catch (Exception exception) {
                        if (this.metadataTable_.size() <= 0) break block12;
                        jSONObject = this.metadataTable_.get(string);
                        return null;
                    }
                }
                String string2 = MDUtils.getPixelType(jSONObject);
                if (string2.contentEquals("GRAY8") || string2.contentEquals("GRAY16")) {
                    object = imageProcessor.getPixels();
                } else if (string2.contentEquals("RGB32")) {
                    object = imageProcessor.getPixels();
                    object = ImageUtils.convertRGB32IntToBytes((int[])object);
                } else if (string2.contentEquals("RGB64")) {
                    taggedImage = ((CompositeImage)imagePlus).getStack();
                    short[] sArray = (short[])taggedImage.getProcessor(1).getPixels();
                    short[] sArray2 = (short[])taggedImage.getProcessor(2).getPixels();
                    short[] sArray3 = (short[])taggedImage.getProcessor(3).getPixels();
                    short[][] sArrayArray = new short[][]{sArray, sArray2, sArray3};
                    object = ImageUtils.getRGB64PixelsFromColorPlanes(sArrayArray);
                } else {
                    return null;
                }
                taggedImage = new TaggedImage(object, jSONObject);
                return taggedImage;
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception);
                return null;
            }
        }
        return null;
    }

    @Override
    public JSONObject getImageTags(int n, int n2, int n3, int n4) {
        String string = MDUtils.generateLabel(n, n2, n3, n4);
        TiffDecoder tiffDecoder = new TiffDecoder(this.dir_, this.filenameTable_.get(string));
        try {
            return new JSONObject(tiffDecoder.getTiffInfo()[0].info);
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
            return null;
        }
    }

    @Override
    public Set<String> imageKeys() {
        return this.filenameTable_.keySet();
    }

    private String createFileName(JSONObject jSONObject) {
        try {
            int n;
            String string;
            int n2;
            try {
                n2 = MDUtils.getFrameIndex(jSONObject);
            }
            catch (Exception exception) {
                n2 = 0;
            }
            try {
                string = MDUtils.getChannelName(jSONObject);
            }
            catch (Exception exception) {
                string = "";
            }
            try {
                n = MDUtils.getSliceIndex(jSONObject);
            }
            catch (Exception exception) {
                n = 0;
            }
            return String.format("img_%09d_%s_%03d.tif", n2, string, n);
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
            return "";
        }
    }

    private void writeFrameMetadata(JSONObject jSONObject) {
        try {
            String string = "FrameKey-" + MDUtils.getFrameIndex(jSONObject) + "-" + MDUtils.getChannelIndex(jSONObject) + "-" + MDUtils.getSliceIndex(jSONObject);
            int n = MDUtils.getPositionIndex(jSONObject);
            this.writeMetadata(n, jSONObject, string);
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
    }

    private void writeMetadata(int n, JSONObject jSONObject, String string) {
        try {
            Writer writer = this.metadataStreams_.get(n);
            if (!this.firstElement_) {
                writer.write(",\r\n");
            }
            writer.write("\"" + string + "\": ");
            writer.write(jSONObject.toString(2));
            writer.flush();
            this.firstElement_ = false;
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
    }

    private void saveImageFile(Object object, JSONObject jSONObject, String string, String string2) {
        try {
            ByteProcessor byteProcessor = null;
            int n = MDUtils.getWidth(jSONObject);
            int n2 = MDUtils.getHeight(jSONObject);
            String string3 = MDUtils.getPixelType(jSONObject);
            if (string3.equals("GRAY8")) {
                byteProcessor = new ByteProcessor(n, n2);
                byteProcessor.setPixels((Object)((byte[])object));
                this.saveImageProcessor((ImageProcessor)byteProcessor, jSONObject, string, string2);
            } else if (string3.equals("GRAY16")) {
                byteProcessor = new ShortProcessor(n, n2);
                byteProcessor.setPixels((Object)((short[])object));
                this.saveImageProcessor((ImageProcessor)byteProcessor, jSONObject, string, string2);
            } else if (string3.equals("RGB32")) {
                byte[][] byArray = ImageUtils.getColorPlanesFromRGB32((byte[])object);
                ColorProcessor colorProcessor = new ColorProcessor(n, n2);
                colorProcessor.setRGB(byArray[0], byArray[1], byArray[2]);
                this.saveImageProcessor((ImageProcessor)colorProcessor, jSONObject, string, string2);
            } else if (string3.equals("RGB64")) {
                short[][] sArray = ImageUtils.getColorPlanesFromRGB64((short[])object);
                ImageStack imageStack = new ImageStack(n, n2);
                imageStack.addSlice("Red", (Object)sArray[0]);
                imageStack.addSlice("Green", (Object)sArray[1]);
                imageStack.addSlice("Blue", (Object)sArray[2]);
                ImagePlus imagePlus = new ImagePlus(string + "/" + string2, imageStack);
                imagePlus.setDimensions(3, 1, 1);
                imagePlus = new CompositeImage(imagePlus, 2);
                this.saveImagePlus(imagePlus, jSONObject, string, string2);
            }
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
    }

    private void saveImageProcessor(ImageProcessor imageProcessor, JSONObject jSONObject, String string, String string2) {
        if (imageProcessor != null) {
            ImagePlus imagePlus = new ImagePlus(string + "/" + string2, imageProcessor);
            this.saveImagePlus(imagePlus, jSONObject, string, string2);
        }
    }

    public void saveImagePlus(ImagePlus imagePlus, JSONObject jSONObject, String string, String string2) {
        try {
            imagePlus.setProperty("Info", (Object)jSONObject.toString(2));
        }
        catch (JSONException jSONException) {
            ReportingUtils.logError(jSONException);
        }
        FileSaver fileSaver = new FileSaver(imagePlus);
        fileSaver.saveAsTiff(string + "/" + string2);
    }

    private void openNewDataSet(TaggedImage taggedImage) throws Exception, IOException {
        int n;
        String string = taggedImage.tags.getString("Time");
        String string2 = this.getPosition(taggedImage);
        try {
            n = MDUtils.getPositionIndex(taggedImage.tags);
        }
        catch (JSONException jSONException) {
            n = 0;
            string2 = "";
        }
        if (this.positionNames_.containsKey(n) && this.positionNames_.get(n) != null && !this.positionNames_.get(n).contentEquals(string2)) {
            throw new Exception("Position name changed during acquisition.");
        }
        this.positionNames_.put(n, string2);
        JavaUtils.createDirectory(this.dir_ + "/" + string2);
        this.firstElement_ = true;
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.dir_ + "/" + string2 + "/metadata.txt"));
        this.metadataStreams_.put(n, bufferedWriter);
        bufferedWriter.write("{\r\n");
        JSONObject jSONObject = this.getSummaryMetadata();
        jSONObject.put("Time", string);
        jSONObject.put("Date", string.split(" ")[0]);
        jSONObject.put("PositionIndex", MDUtils.getPositionIndex(taggedImage.tags));
        this.writeMetadata(n, jSONObject, "Summary");
    }

    @Override
    public void finished() {
        this.closeMetadataStreams();
        this.newDataSet_ = false;
    }

    @Override
    public boolean isFinished() {
        return !this.newDataSet_;
    }

    private void closeMetadataStreams() {
        if (this.newDataSet_) {
            try {
                for (Writer writer : this.metadataStreams_.values()) {
                    writer.write("\r\n}\r\n");
                    writer.close();
                }
            }
            catch (IOException iOException) {
                ReportingUtils.logError(iOException);
            }
        }
    }

    private void openExistingDataSet() throws Exception {
        File file = new File(this.dir_ + "/metadata.txt");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (file.exists()) {
            arrayList.add("");
        } else {
            for (File file2 : new File(this.dir_).listFiles()) {
                if (!file2.isDirectory()) continue;
                arrayList.add(file2.getName());
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            JSONObject jSONObject = this.readJsonMetadata(string);
            if (jSONObject != null) {
                try {
                    this.summaryMetadata_ = this.jsonToMetadata(jSONObject.getJSONObject("Summary"));
                    int n = 0;
                    try {
                        n = this.summaryMetadata_.getInt("MetadataVersion");
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                    for (String string2 : this.makeJsonIterableKeys(jSONObject)) {
                        JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
                        if (!string2.startsWith("FrameKey")) continue;
                        JSONObject jSONObject3 = this.jsonToMetadata(jSONObject2);
                        try {
                            if (!jSONObject3.has("ChannelIndex")) {
                                jSONObject3.put("ChannelIndex", this.getChannelIndex(MDUtils.getChannelName(jSONObject3)));
                            }
                            if (!jSONObject3.has("PositionIndex")) {
                                jSONObject3.put("PositionIndex", i);
                            }
                            if (!jSONObject3.has("PixelType") && !jSONObject3.has("IJType")) {
                                jSONObject3.put("PixelType", MDUtils.getPixelType(this.summaryMetadata_));
                            }
                            this.lastFrame_ = Math.max(MDUtils.getFrameIndex(jSONObject3), this.lastFrame_);
                            String string3 = MDUtils.getFileName(jSONObject3);
                            if (string3 == null) {
                                string3 = "img_" + String.format("%9d", MDUtils.getFrameIndex(jSONObject3)) + "_" + MDUtils.getChannelName(jSONObject3) + "_" + String.format("%3d", MDUtils.getSliceIndex(jSONObject3));
                            }
                            if (string.length() > 0) {
                                string3 = string + "/" + string3;
                            }
                            this.filenameTable_.put(MDUtils.getLabel(jSONObject3), string3);
                            if (n >= 10) continue;
                            this.metadataTable_.put(MDUtils.getLabel(jSONObject3), jSONObject3);
                        }
                        catch (Exception exception) {
                            ReportingUtils.showError(exception);
                        }
                    }
                    continue;
                }
                catch (JSONException jSONException) {
                    ReportingUtils.showError(jSONException);
                    continue;
                }
            }
            throw new Exception("No metadata file found");
        }
        this.readDisplaySettings();
    }

    private int getChannelIndex(String string) {
        Object object = null;
        try {
            object = this.getSummaryMetadata().get("ChNames");
            JSONArray jSONArray = object instanceof String ? new JSONArray((String)object) : (JSONArray)object;
            for (int i = 0; i < jSONArray.length(); ++i) {
                if (!jSONArray.getString(i).contentEquals(string)) continue;
                return i;
            }
            jSONArray.put(string);
            return jSONArray.length();
        }
        catch (JSONException jSONException) {
            try {
                JSONArray jSONArray = new JSONArray();
                jSONArray.put(string);
                this.getSummaryMetadata().put("ChNames", jSONArray);
                return 0;
            }
            catch (JSONException jSONException2) {
                ReportingUtils.logError(jSONException2);
                return 0;
            }
        }
    }

    private Iterable<String> makeJsonIterableKeys(final JSONObject jSONObject) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return jSONObject.keys();
            }
        };
    }

    private JSONObject jsonToMetadata(JSONObject jSONObject) {
        JSONObject jSONObject2 = new JSONObject();
        try {
            Iterable<String> iterable = this.makeJsonIterableKeys(jSONObject);
            for (String string : iterable) {
                jSONObject2.put(string, jSONObject.getString(string));
            }
        }
        catch (JSONException jSONException) {
            ReportingUtils.showError(jSONException);
        }
        return jSONObject2;
    }

    private JSONObject readJsonMetadata(String string) throws Exception {
        String string2 = TextUtils.readTextFile(this.dir_ + "/" + string + "/metadata.txt");
        try {
            return new JSONObject(string2);
        }
        catch (JSONException jSONException) {
            return new JSONObject(string2.concat("}"));
        }
    }

    @Override
    public JSONObject getSummaryMetadata() {
        return this.summaryMetadata_;
    }

    @Override
    public final void setSummaryMetadata(JSONObject jSONObject) {
        this.summaryMetadata_ = jSONObject;
        if (this.summaryMetadata_ != null) {
            try {
                boolean bl = this.summaryMetadata_.getBoolean("SlicesFirst");
                boolean bl2 = this.summaryMetadata_.getBoolean("TimeFirst");
                TreeMap<String, String> treeMap = this.filenameTable_;
                this.filenameTable_ = new TreeMap(new ImageLabelComparator(bl, bl2));
                this.filenameTable_.putAll(treeMap);
            }
            catch (JSONException jSONException) {
                ReportingUtils.logError("Couldn't find SlicesFirst or TimeFirst in summary metadata");
            }
        }
    }

    @Override
    public void setDisplayAndComments(JSONObject jSONObject) {
        this.displaySettings_ = jSONObject;
    }

    @Override
    public JSONObject getDisplayAndComments() {
        return this.displaySettings_;
    }

    @Override
    public void writeDisplaySettings() {
        if (this.displaySettings_ == null) {
            return;
        }
        if (!new File(this.dir_).exists()) {
            try {
                JavaUtils.createDirectory(this.dir_);
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception);
            }
        }
        File file = new File(this.dir_ + "/" + "display_and_comments.txt");
        try {
            FileWriter fileWriter = new FileWriter(file);
            ((Writer)fileWriter).append(this.displaySettings_.toString(2));
            ((Writer)fileWriter).close();
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
        }
    }

    private void readDisplaySettings() {
        this.displaySettings_ = null;
        String string = this.dir_ + "/" + "display_and_comments.txt";
        try {
            String string2 = JavaUtils.readTextFile(string);
            if (string2 != null) {
                JSONObject jSONObject = new JSONObject(string2);
                JSONArray jSONArray = (JSONArray)jSONObject.get("Channels");
                if (jSONArray != null) {
                    this.displaySettings_ = jSONObject;
                } else {
                    this.displaySettings_.put("Comments", jSONObject.get("Comments"));
                }
            }
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
    }

    @Override
    public void close() {
        try {
            this.writeDisplaySettings();
            if (this.shutdownHook_ != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook_);
            }
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
    }

    @Override
    public String getDiskLocation() {
        return this.dir_;
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public long getDataSetSize() {
        File[] fileArray = new File(this.dir_).listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".tif");
            }
        });
        int n = fileArray.length;
        long l = n > 0 ? fileArray[0].length() : 0L;
        return (long)n * l;
    }
}

