/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import java.nio.ByteOrder;
import java.util.TreeMap;
import loci.common.DateTools;
import loci.common.services.ServiceFactory;
import loci.formats.MetadataTools;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.services.OMEXMLService;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.acquisition.MultipageTiffWriter;
import org.micromanager.acquisition.TaggedImageStorageMultipageTiff;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ReportingUtils;

public class OMEMetadata {
    private IMetadata metadata_;
    private TaggedImageStorageMultipageTiff mptStorage_;
    private TreeMap<Integer, Indices> series_ = new TreeMap();
    private int omeXMLBaseLength_ = -1;
    private int omeXMLImageLength_ = -1;

    public OMEMetadata(TaggedImageStorageMultipageTiff taggedImageStorageMultipageTiff) {
        this.mptStorage_ = taggedImageStorageMultipageTiff;
        this.metadata_ = MetadataTools.createOMEXMLMetadata();
    }

    public String toString() {
        try {
            OMEXMLService oMEXMLService = (OMEXMLService)new ServiceFactory().getInstance(OMEXMLService.class);
            return oMEXMLService.getOMEXML((MetadataRetrieve)this.metadata_) + " ";
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
            return "";
        }
    }

    public int getOMEMetadataBaseLenght() {
        return this.omeXMLBaseLength_;
    }

    public int getOMEMetadataImageLength() {
        return this.omeXMLImageLength_;
    }

    public void setNumFrames(int n, int n2) {
        this.metadata_.setPixelsSizeT(new PositiveInteger(Integer.valueOf(n2)), n);
    }

    private void startSeriesMetadata(JSONObject jSONObject, int n, String string) throws JSONException, MMScriptException {
        String string2;
        double d;
        this.series_.put(n, new Indices());
        JSONObject jSONObject2 = this.mptStorage_.getSummaryMetadata();
        MetadataTools.populateMetadata((MetadataStore)this.metadata_, (int)n, (String)string, (boolean)MultipageTiffWriter.BYTE_ORDER.equals(ByteOrder.LITTLE_ENDIAN), (String)(this.mptStorage_.slicesFirst() ? "XYZCT" : "XYCZT"), (String)("uint" + (MDUtils.isGRAY8(jSONObject2) ? "8" : "16")), (int)MDUtils.getWidth(jSONObject2), (int)MDUtils.getHeight(jSONObject2), (int)MDUtils.getNumSlices(jSONObject2), (int)MDUtils.getNumChannels(jSONObject2), (int)MDUtils.getNumFrames(jSONObject2), (int)1);
        if (jSONObject2.has("PixelSize_um") && !jSONObject2.isNull("PixelSize_um") && (d = jSONObject2.getDouble("PixelSize_um")) > 0.0) {
            this.metadata_.setPixelsPhysicalSizeX(new PositiveFloat(Double.valueOf(d)), n);
            this.metadata_.setPixelsPhysicalSizeY(new PositiveFloat(Double.valueOf(d)), n);
        }
        if (jSONObject2.has("z-step_um") && !jSONObject2.isNull("z-step_um") && (d = jSONObject2.getDouble("z-step_um")) > 0.0) {
            this.metadata_.setPixelsPhysicalSizeZ(new PositiveFloat(Double.valueOf(d)), n);
        }
        try {
            string2 = MDUtils.getPositionName(jSONObject);
        }
        catch (JSONException jSONException) {
            ReportingUtils.logError("Couldn't find position name in image metadata");
            string2 = "pos" + MDUtils.getPositionIndex(jSONObject);
        }
        this.metadata_.setStageLabelName(string2, n);
        String string3 = MetadataTools.createLSID((String)"Microscope", (int[])new int[0]);
        this.metadata_.setInstrumentID(string3, 0);
        this.metadata_.setImageInstrumentRef(string3, n);
        JSONObject jSONObject3 = this.mptStorage_.getDisplayAndComments().getJSONObject("Comments");
        if (jSONObject3.has("Summary") && !jSONObject3.isNull("Summary")) {
            this.metadata_.setImageDescription(jSONObject3.getString("Summary"), n);
        }
        JSONArray jSONArray = this.mptStorage_.getDisplayAndComments().getJSONArray("Channels");
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject4 = jSONArray.getJSONObject(i);
            this.metadata_.setChannelColor(new Color(Integer.valueOf(jSONObject4.getInt("Color"))), n, i);
            this.metadata_.setChannelName(jSONObject4.getString("Name"), n, i);
        }
        if (this.omeXMLBaseLength_ == -1) {
            try {
                OMEXMLService oMEXMLService = (OMEXMLService)new ServiceFactory().getInstance(OMEXMLService.class);
                this.omeXMLBaseLength_ = oMEXMLService.getOMEXML((MetadataRetrieve)this.metadata_).length();
            }
            catch (Exception exception) {
                ReportingUtils.logError("Unable to calculate OME XML Base length");
            }
        }
    }

    public void addImageTagsToOME(JSONObject jSONObject, int n, String string, String string2) throws JSONException, MMScriptException {
        int n2;
        try {
            n2 = MDUtils.getPositionIndex(jSONObject);
        }
        catch (Exception exception) {
            n2 = 0;
        }
        if (!this.series_.containsKey(n2)) {
            this.startSeriesMetadata(jSONObject, n2, string);
            try {
                this.setOMEDetectorMetadata(jSONObject);
                if (jSONObject.has("Time") && !jSONObject.isNull("Time")) {
                    this.metadata_.setImageAcquisitionDate(new Timestamp(DateTools.formatDate((String)jSONObject.getString("Time"), (String)"yyyy-MM-dd HH:mm:ss")), n2);
                }
            }
            catch (Exception exception) {
                ReportingUtils.logError("Problem adding System state cahce metadata to OME Metadata");
            }
        }
        Indices indices = this.series_.get(n2);
        try {
            boolean bl;
            int n3 = MDUtils.getSliceIndex(jSONObject);
            int n4 = MDUtils.getFrameIndex(jSONObject);
            int n5 = MDUtils.getChannelIndex(jSONObject);
            boolean bl2 = bl = !this.mptStorage_.hasExpectedImageOrder() || n == 0 || indices.tiffDataPlaneCount_ == 0;
            if (bl) {
                ++indices.tiffDataIndex_;
                this.metadata_.setTiffDataFirstZ(new NonNegativeInteger(Integer.valueOf(n3)), n2, indices.tiffDataIndex_);
                this.metadata_.setTiffDataFirstC(new NonNegativeInteger(Integer.valueOf(n5)), n2, indices.tiffDataIndex_);
                this.metadata_.setTiffDataFirstT(new NonNegativeInteger(Integer.valueOf(n4)), n2, indices.tiffDataIndex_);
                this.metadata_.setTiffDataIFD(new NonNegativeInteger(Integer.valueOf(n)), n2, indices.tiffDataIndex_);
                this.metadata_.setUUIDFileName(string2, n2, indices.tiffDataIndex_);
                indices.tiffDataPlaneCount_ = 1;
            } else {
                ++indices.tiffDataPlaneCount_;
            }
            this.metadata_.setTiffDataPlaneCount(new NonNegativeInteger(Integer.valueOf(indices.tiffDataPlaneCount_)), n2, indices.tiffDataIndex_);
            this.metadata_.setPlaneTheZ(new NonNegativeInteger(Integer.valueOf(n3)), n2, indices.planeIndex_);
            this.metadata_.setPlaneTheC(new NonNegativeInteger(Integer.valueOf(n5)), n2, indices.planeIndex_);
            this.metadata_.setPlaneTheT(new NonNegativeInteger(Integer.valueOf(n4)), n2, indices.planeIndex_);
        }
        catch (JSONException jSONException) {
            ReportingUtils.showError("Image Metadata missing ChannelIndex, SliceIndex, or FrameIndex");
        }
        catch (Exception exception) {
            ReportingUtils.logError("Couldn't add to OME metadata");
        }
        try {
            if (jSONObject.has("Exposure-ms") && !jSONObject.isNull("Exposure-ms")) {
                this.metadata_.setPlaneExposureTime(Double.valueOf(jSONObject.getDouble("Exposure-ms") / 1000.0), n2, indices.planeIndex_);
            }
            if (jSONObject.has("XPositionUm") && !jSONObject.isNull("XPositionUm")) {
                this.metadata_.setPlanePositionX(Double.valueOf(jSONObject.getDouble("XPositionUm")), n2, indices.planeIndex_);
                if (indices.planeIndex_ == 0) {
                    this.metadata_.setStageLabelX(Double.valueOf(jSONObject.getDouble("XPositionUm")), n2);
                }
            }
            if (jSONObject.has("YPositionUm") && !jSONObject.isNull("YPositionUm")) {
                this.metadata_.setPlanePositionY(Double.valueOf(jSONObject.getDouble("YPositionUm")), n2, indices.planeIndex_);
                if (indices.planeIndex_ == 0) {
                    this.metadata_.setStageLabelY(Double.valueOf(jSONObject.getDouble("YPositionUm")), n2);
                }
            }
            if (jSONObject.has("ZPositionUm") && !jSONObject.isNull("ZPositionUm")) {
                this.metadata_.setPlanePositionZ(Double.valueOf(jSONObject.getDouble("ZPositionUm")), n2, indices.planeIndex_);
            }
            if (jSONObject.has("ElapsedTime-ms") && !jSONObject.isNull("ElapsedTime-ms")) {
                this.metadata_.setPlaneDeltaT(Double.valueOf(jSONObject.getDouble("ElapsedTime-ms") / 1000.0), n2, indices.planeIndex_);
            }
        }
        catch (JSONException jSONException) {
            ReportingUtils.logError("Problem adding tags to OME Metadata");
        }
        ++indices.planeIndex_;
        if (this.omeXMLImageLength_ == -1) {
            try {
                OMEXMLService oMEXMLService = (OMEXMLService)new ServiceFactory().getInstance(OMEXMLService.class);
                this.omeXMLImageLength_ = (int)(1.1 * (double)(oMEXMLService.getOMEXML((MetadataRetrieve)this.metadata_).length() - this.omeXMLBaseLength_));
            }
            catch (Exception exception) {
                ReportingUtils.logError("Unable to calculate OME XML Image length");
            }
        }
    }

    private void setOMEDetectorMetadata(JSONObject jSONObject) throws JSONException {
        String[] stringArray;
        int n;
        if (!jSONObject.has("Core-Camera") || jSONObject.isNull("Core-Camera")) {
            return;
        }
        String string = jSONObject.getString("Core-Camera");
        if (jSONObject.has(string + "-Physical Camera 1")) {
            n = 1;
            if (!jSONObject.getString(string + "-Physical Camera 3").equals("Undefined")) {
                n = 3;
            } else if (!jSONObject.getString(string + "-Physical Camera 2").equals("Undefined")) {
                n = 2;
            }
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = jSONObject.getString(string + "-Physical Camera " + (1 + i));
            }
        } else {
            stringArray = new String[]{string};
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string2 = stringArray[n];
            String string3 = MetadataTools.createLSID((String)string2, (int[])new int[0]);
            this.metadata_.setDetectorID(string3, 0, n);
            if (jSONObject.has(string2 + "-Name") && !jSONObject.isNull(string2 + "-Name")) {
                this.metadata_.setDetectorManufacturer(jSONObject.getString(string2 + "-Name"), 0, n);
            }
            if (jSONObject.has(string2 + "-CameraName") && !jSONObject.isNull(string2 + "-CameraName")) {
                this.metadata_.setDetectorModel(jSONObject.getString(string2 + "-CameraName"), 0, n);
            }
            if (jSONObject.has(string2 + "-Offset") && !jSONObject.isNull(string2 + "-Offset")) {
                this.metadata_.setDetectorOffset(Double.valueOf(Double.parseDouble(jSONObject.getString(string2 + "-Offset"))), 0, n);
            }
            if (!jSONObject.has(string2 + "-CameraID") || jSONObject.isNull(string2 + "-CameraID")) continue;
            this.metadata_.setDetectorSerialNumber(jSONObject.getString(string2 + "-CameraID"), 0, n);
        }
    }

    private class Indices {
        int tiffDataIndex_ = -1;
        int tiffDataPlaneCount_ = 0;
        int planeIndex_ = 0;

        private Indices() {
        }
    }
}

