/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import ij.process.LUT;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.LinkedList;
import mmcorej.TaggedImage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.acquisition.MultipageTiffReader;
import org.micromanager.acquisition.TaggedImageStorageMultipageTiff;
import org.micromanager.utils.ImageUtils;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ReportingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipageTiffWriter {
    private static final long BYTES_PER_GIG = 0x40000000L;
    private static final long MAX_FILE_SIZE = 0x100000000L;
    public static final int DISPLAY_SETTINGS_BYTES_PER_CHANNEL = 256;
    public static final long SPACE_FOR_COMMENTS = 0x100000L;
    public static final int INDEX_MAP_OFFSET_HEADER = 54773648;
    public static final int INDEX_MAP_HEADER = 3453623;
    public static final int DISPLAY_SETTINGS_OFFSET_HEADER = 483765892;
    public static final int DISPLAY_SETTINGS_HEADER = 347834724;
    public static final int COMMENTS_OFFSET_HEADER = 99384722;
    public static final int COMMENTS_HEADER = 84720485;
    public static final char ENTRIES_PER_IFD = '\r';
    public static final char WIDTH = '\u0100';
    public static final char HEIGHT = '\u0101';
    public static final char BITS_PER_SAMPLE = '\u0102';
    public static final char COMPRESSION = '\u0103';
    public static final char PHOTOMETRIC_INTERPRETATION = '\u0106';
    public static final char IMAGE_DESCRIPTION = '\u010e';
    public static final char STRIP_OFFSETS = '\u0111';
    public static final char SAMPLES_PER_PIXEL = '\u0115';
    public static final char ROWS_PER_STRIP = '\u0116';
    public static final char STRIP_BYTE_COUNTS = '\u0117';
    public static final char X_RESOLUTION = '\u011a';
    public static final char Y_RESOLUTION = '\u011b';
    public static final char RESOLUTION_UNIT = '\u0128';
    public static final char IJ_METADATA_BYTE_COUNTS = '\uc696';
    public static final char IJ_METADATA = '\uc697';
    public static final char MM_METADATA = '\uc7b3';
    public static final int SUMMARY_MD_HEADER = 2355492;
    public static final ByteOrder BYTE_ORDER = ByteOrder.BIG_ENDIAN;
    private final boolean omeTiff_;
    private TaggedImageStorageMultipageTiff masterMPTiffStorage_;
    private RandomAccessFile raFile_;
    private FileChannel fileChannel_;
    private long filePosition_ = 0L;
    private int bufferPosition_;
    private int numChannels_ = 1;
    private int numFrames_ = 1;
    private int numSlices_ = 1;
    private HashMap<String, Long> indexMap_;
    private long nextIFDOffsetLocation_ = -1L;
    private boolean rgb_ = false;
    private int byteDepth_;
    private int imageWidth_;
    private int imageHeight_;
    private int bytesPerImagePixels_;
    private long resNumerator_ = 1L;
    private long resDenomenator_ = 1L;
    private double zStepUm_ = 1.0;
    private LinkedList<ByteBuffer> buffers_;
    private boolean firstIFD_ = true;
    private long omeDescriptionTagPosition_;
    private long ijDescriptionTagPosition_;
    private long ijMetadataCountsTagPosition_;
    private long ijMetadataTagPosition_;
    private MultipageTiffReader reader_;
    private long blankPixelsOffset_ = -1L;
    private String summaryMDString_;

    public MultipageTiffWriter(String string, String string2, JSONObject jSONObject, TaggedImageStorageMultipageTiff taggedImageStorageMultipageTiff) {
        this.masterMPTiffStorage_ = taggedImageStorageMultipageTiff;
        this.omeTiff_ = taggedImageStorageMultipageTiff.omeTiff_;
        this.reader_ = new MultipageTiffReader(jSONObject);
        File file = new File(string + "/" + string2);
        try {
            this.processSummaryMD(jSONObject);
        }
        catch (MMScriptException mMScriptException) {
            ReportingUtils.logError(mMScriptException);
        }
        catch (JSONException jSONException) {
            ReportingUtils.logError(jSONException);
        }
        long l = Math.min(0x100000000L, (long)(jSONObject.toString().length() + 2000000) + (long)(this.numFrames_ * this.numChannels_ * this.numSlices_) * ((long)this.bytesPerImagePixels_ + 2000L));
        try {
            file.createNewFile();
            this.raFile_ = new RandomAccessFile(file, "rw");
            try {
                this.raFile_.setLength(l);
            }
            catch (IOException iOException) {
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        MMStudioMainFrame.getInstance().getAcquisitionEngine().abortRequest();
                    }
                }).start();
                ReportingUtils.showError("Insufficent space on disk: no room to write data");
            }
            this.fileChannel_ = this.raFile_.getChannel();
            this.indexMap_ = new HashMap();
            this.reader_.setFileChannel(this.fileChannel_);
            this.reader_.setIndexMap(this.indexMap_);
            this.buffers_ = new LinkedList();
            this.writeMMHeaderAndSummaryMD(jSONObject);
        }
        catch (IOException iOException) {
            ReportingUtils.logError(iOException);
        }
        try {
            this.summaryMDString_ = jSONObject.toString(2);
        }
        catch (JSONException jSONException) {
            this.summaryMDString_ = "";
        }
    }

    public MultipageTiffReader getReader() {
        return this.reader_;
    }

    public FileChannel getFileChannel() {
        return this.fileChannel_;
    }

    public HashMap<String, Long> getIndexMap() {
        return this.indexMap_;
    }

    private void writeMMHeaderAndSummaryMD(JSONObject jSONObject) throws IOException {
        if (jSONObject.has("Comment")) {
            jSONObject.remove("Comment");
        }
        String string = jSONObject.toString();
        int n = string.length();
        ByteBuffer byteBuffer = ByteBuffer.allocate(40).order(BYTE_ORDER);
        if (BYTE_ORDER.equals(ByteOrder.BIG_ENDIAN)) {
            byteBuffer.asCharBuffer().put(0, '\u4d4d');
        } else {
            byteBuffer.asCharBuffer().put(0, '\u4949');
        }
        byteBuffer.asCharBuffer().put(1, '*');
        byteBuffer.putInt(4, 40 + n);
        byteBuffer.putInt(32, 2355492);
        byteBuffer.putInt(36, n);
        ByteBuffer[] byteBufferArray = new ByteBuffer[]{byteBuffer, ByteBuffer.wrap(this.getBytesFromString(string))};
        this.fileChannel_.write(byteBufferArray);
        this.filePosition_ += (long)(byteBuffer.position() + n);
    }

    public void close(String string) throws IOException {
        this.writeNullOffsetAfterLastImage();
        this.writeIndexMap();
        String string2 = "";
        try {
            JSONObject jSONObject = this.masterMPTiffStorage_.getDisplayAndComments().getJSONObject("Comments");
            if (jSONObject.has("Summary") && !jSONObject.isNull("Summary")) {
                string2 = jSONObject.getString("Summary");
            }
        }
        catch (Exception exception) {
            ReportingUtils.logError("Could't get acquisition summary comment from displayAndComments");
        }
        this.writeImageJMetadata(this.numChannels_, string2);
        if (this.omeTiff_) {
            try {
                this.writeImageDescription(string, this.omeDescriptionTagPosition_);
            }
            catch (Exception exception) {
                ReportingUtils.showError("Error writing OME metadata");
            }
        }
        this.writeImageDescription(this.getIJDescriptionString(), this.ijDescriptionTagPosition_);
        this.writeDisplaySettings();
        this.writeComments();
        this.raFile_.setLength(this.filePosition_ + 8L);
        this.reader_.finishedWriting();
        this.fileChannel_ = null;
        this.raFile_ = null;
    }

    public boolean hasSpaceToWrite(TaggedImage taggedImage, int n) {
        int n2 = taggedImage.tags.toString().length();
        int n3 = this.indexMap_.size() * 20 + 8;
        int n4 = 176;
        int n5 = 5000000;
        long l = (long)(n2 + n3 + n4 + this.bytesPerImagePixels_) + 0x100000L + (long)(this.numChannels_ * 256) + (long)n5 + this.filePosition_;
        if (this.omeTiff_) {
            l += (long)n;
        }
        return l < 0x100000000L;
    }

    public boolean isClosed() {
        return this.raFile_ == null;
    }

    public void writeBlankImage(String string) throws IOException {
        this.writeBlankIFD();
        this.writeBuffers();
    }

    public void writeImage(TaggedImage taggedImage) throws IOException {
        long l = this.filePosition_;
        this.writeIFD(taggedImage);
        this.indexMap_.put(MDUtils.getLabel(taggedImage.tags), l);
        this.writeBuffers();
    }

    private void writeBuffers() throws IOException {
        ByteBuffer[] byteBufferArray = new ByteBuffer[this.buffers_.size()];
        for (int i = 0; i < byteBufferArray.length; ++i) {
            byteBufferArray[i] = this.buffers_.removeFirst();
        }
        this.fileChannel_.write(byteBufferArray);
    }

    private void writeIFD(TaggedImage taggedImage) throws IOException {
        char c;
        char c2 = c = this.firstIFD_ ? (char)'\u0011' : '\r';
        if (taggedImage.tags.has("Summary")) {
            taggedImage.tags.remove("Summary");
        }
        String string = taggedImage.tags.toString() + " ";
        int n = 2 + c * 12 + 4 + (this.rgb_ ? 6 : 0) + 16 + string.length() + this.bytesPerImagePixels_;
        int n2 = 2 + c * 12 + 4 + (this.rgb_ ? 6 : 0);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2).order(BYTE_ORDER);
        CharBuffer charBuffer = byteBuffer.asCharBuffer();
        long l = this.filePosition_ + 2L + (long)(c * 12) + 4L;
        this.nextIFDOffsetLocation_ = this.filePosition_ + 2L + (long)(c * 12);
        this.bufferPosition_ = 0;
        charBuffer.put(this.bufferPosition_, c);
        this.bufferPosition_ += 2;
        this.writeIFDEntry(byteBuffer, charBuffer, '\u0100', '\u0004', 1L, this.imageWidth_);
        this.writeIFDEntry(byteBuffer, charBuffer, '\u0101', '\u0004', 1L, this.imageHeight_);
        this.writeIFDEntry(byteBuffer, charBuffer, '\u0102', '\u0003', this.rgb_ ? 3L : 1L, this.rgb_ ? l : (long)(this.byteDepth_ * 8));
        if (this.rgb_) {
            l += 6L;
        }
        this.writeIFDEntry(byteBuffer, charBuffer, '\u0103', '\u0003', 1L, 1L);
        this.writeIFDEntry(byteBuffer, charBuffer, '\u0106', '\u0003', 1L, this.rgb_ ? 2L : 1L);
        if (this.firstIFD_) {
            this.omeDescriptionTagPosition_ = this.filePosition_ + (long)this.bufferPosition_;
            this.writeIFDEntry(byteBuffer, charBuffer, '\u010e', '\u0002', 0L, 0L);
            this.ijDescriptionTagPosition_ = this.filePosition_ + (long)this.bufferPosition_;
            this.writeIFDEntry(byteBuffer, charBuffer, '\u010e', '\u0002', 0L, 0L);
        }
        this.writeIFDEntry(byteBuffer, charBuffer, '\u0111', '\u0004', 1L, l);
        this.writeIFDEntry(byteBuffer, charBuffer, '\u0115', '\u0003', 1L, this.rgb_ ? 3 : 1);
        this.writeIFDEntry(byteBuffer, charBuffer, '\u0116', '\u0003', 1L, this.imageHeight_);
        this.writeIFDEntry(byteBuffer, charBuffer, '\u0117', '\u0004', 1L, this.bytesPerImagePixels_);
        this.writeIFDEntry(byteBuffer, charBuffer, '\u011a', '\u0005', 1L, l += (long)this.bytesPerImagePixels_);
        this.writeIFDEntry(byteBuffer, charBuffer, '\u011b', '\u0005', 1L, l += 8L);
        l += 8L;
        this.writeIFDEntry(byteBuffer, charBuffer, '\u0128', '\u0003', 1L, 3L);
        if (this.firstIFD_) {
            this.ijMetadataCountsTagPosition_ = this.filePosition_ + (long)this.bufferPosition_;
            this.writeIFDEntry(byteBuffer, charBuffer, '\uc696', '\u0004', 0L, 0L);
            this.ijMetadataTagPosition_ = this.filePosition_ + (long)this.bufferPosition_;
            this.writeIFDEntry(byteBuffer, charBuffer, '\uc697', '\u0001', 0L, 0L);
        }
        this.writeIFDEntry(byteBuffer, charBuffer, '\uc7b3', '\u0002', string.length(), l);
        byteBuffer.putInt(this.bufferPosition_, (int)(l += (long)string.length()));
        this.bufferPosition_ += 4;
        if (this.rgb_) {
            charBuffer.put(this.bufferPosition_ / 2, (char)(this.byteDepth_ * 8));
            charBuffer.put(this.bufferPosition_ / 2 + 1, (char)(this.byteDepth_ * 8));
            charBuffer.put(this.bufferPosition_ / 2 + 2, (char)(this.byteDepth_ * 8));
        }
        this.buffers_.add(byteBuffer);
        this.buffers_.add(this.getPixelBuffer(taggedImage));
        this.buffers_.add(this.getResolutionValuesBuffer());
        this.buffers_.add(ByteBuffer.wrap(this.getBytesFromString(string)));
        this.filePosition_ += (long)n;
        this.firstIFD_ = false;
    }

    private void writeIFDEntry(ByteBuffer byteBuffer, CharBuffer charBuffer, char c, char c2, long l, long l2) throws IOException {
        charBuffer.put(this.bufferPosition_ / 2, c);
        charBuffer.put(this.bufferPosition_ / 2 + 1, c2);
        byteBuffer.putInt(this.bufferPosition_ + 4, (int)l);
        if (c2 == '\u0003' && l == 1L) {
            charBuffer.put(this.bufferPosition_ / 2 + 4, (char)l2);
            charBuffer.put(this.bufferPosition_ / 2 + 5, '\u0000');
        } else {
            byteBuffer.putInt(this.bufferPosition_ + 8, (int)l2);
        }
        this.bufferPosition_ += 12;
    }

    private ByteBuffer getResolutionValuesBuffer() throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(16).order(BYTE_ORDER);
        byteBuffer.putInt(0, (int)this.resNumerator_);
        byteBuffer.putInt(4, (int)this.resDenomenator_);
        byteBuffer.putInt(8, (int)this.resNumerator_);
        byteBuffer.putInt(12, (int)this.resDenomenator_);
        return byteBuffer;
    }

    public void setAbortedNumFrames(int n) {
        this.numFrames_ = n;
    }

    private ByteBuffer getPixelBuffer(TaggedImage taggedImage) throws IOException {
        if (this.rgb_) {
            if (this.byteDepth_ == 1) {
                byte[] byArray = (byte[])taggedImage.pix;
                byte[] byArray2 = new byte[byArray.length * 3 / 4];
                int n = 0;
                for (int i = 0; i < byArray.length; ++i) {
                    if ((i + 1) % 4 == 0) continue;
                    byArray2[n] = byArray[i];
                    ++n;
                }
                return ByteBuffer.wrap(byArray2);
            }
            short[] sArray = (short[])taggedImage.pix;
            short[] sArray2 = new short[sArray.length * 3 / 4];
            int n = 0;
            for (int i = 0; i < sArray.length; ++i) {
                if ((i + 1) % 4 == 0) continue;
                sArray2[n] = sArray[i];
                ++n;
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(sArray2.length * 2).order(BYTE_ORDER);
            byteBuffer.asShortBuffer().put(sArray2);
            return byteBuffer;
        }
        if (this.byteDepth_ == 1) {
            return ByteBuffer.wrap((byte[])taggedImage.pix);
        }
        short[] sArray = (short[])taggedImage.pix;
        ByteBuffer byteBuffer = ByteBuffer.allocate(sArray.length * 2).order(BYTE_ORDER);
        byteBuffer.asShortBuffer().put(sArray);
        return byteBuffer;
    }

    private void processSummaryMD(JSONObject jSONObject) throws MMScriptException, JSONException {
        double d;
        this.rgb_ = MDUtils.isRGB(jSONObject);
        this.numChannels_ = MDUtils.getNumChannels(jSONObject);
        this.numFrames_ = MDUtils.getNumFrames(jSONObject);
        this.numSlices_ = MDUtils.getNumSlices(jSONObject);
        this.imageWidth_ = MDUtils.getWidth(jSONObject);
        this.imageHeight_ = MDUtils.getHeight(jSONObject);
        String string = MDUtils.getPixelType(jSONObject);
        this.byteDepth_ = string.equals("GRAY8") || string.equals("RGB32") || string.equals("RGB24") ? 1 : (string.equals("GRAY16") || string.equals("RGB64") ? 2 : (string.equals("GRAY32") ? 3 : 2));
        this.bytesPerImagePixels_ = this.imageHeight_ * this.imageWidth_ * this.byteDepth_ * (this.rgb_ ? 3 : 1);
        double d2 = 1.0E-4;
        if (jSONObject.has("PixelSizeUm")) {
            try {
                d2 = 1.0E-4 * jSONObject.getDouble("PixelSizeUm");
            }
            catch (JSONException jSONException) {}
        } else if (jSONObject.has("PixelSize_um")) {
            try {
                d2 = 1.0E-4 * jSONObject.getDouble("PixelSize_um");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if ((d = Math.log10(d2)) >= 0.0) {
            this.resDenomenator_ = (long)d2;
            this.resNumerator_ = 1L;
        } else {
            this.resNumerator_ = (long)(1.0 / d2);
            this.resDenomenator_ = 1L;
        }
        if (jSONObject.has("z-step_um") && !jSONObject.isNull("z-step_um")) {
            this.zStepUm_ = jSONObject.getDouble("z-step_um");
        }
    }

    private void writeImageJMetadata(int n, String string) throws IOException {
        int n2;
        String string2 = this.summaryMDString_;
        if (string != null && string.length() > 0) {
            string2 = "Acquisition comments: \n" + string + "\n\n\n" + this.summaryMDString_;
        }
        int n3 = 12 + 4 * n;
        int n4 = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3).order(BYTE_ORDER);
        int n5 = 3;
        int n6 = 4 + n5 * 8;
        byteBuffer.putInt(n4, 4 + n5 * 8);
        byteBuffer.putInt(n4 += 4, 2 * string2.length());
        n6 += string2.length() * 2;
        byteBuffer.putInt(n4 += 4, n * 2 * 8);
        n4 += 4;
        n6 += n * 2 * 8;
        for (n2 = 0; n2 < n; ++n2) {
            byteBuffer.putInt(n4, 768);
            n4 += 4;
            n6 += 768;
        }
        n2 = 3 + n;
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(8).order(BYTE_ORDER);
        byteBuffer2.putInt(0, n2);
        byteBuffer2.putInt(4, (int)this.filePosition_);
        this.fileChannel_.write(byteBuffer2, this.ijMetadataCountsTagPosition_ + 4L);
        this.fileChannel_.write(byteBuffer, this.filePosition_);
        this.filePosition_ += (long)n3;
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(n6).order(BYTE_ORDER);
        n4 = 0;
        byteBuffer3.putInt(n4, 0x494A494A);
        byteBuffer3.putInt(n4 += 4, 1768842863);
        byteBuffer3.putInt(n4 += 4, 1);
        byteBuffer3.putInt(n4 += 4, 1918987879);
        byteBuffer3.putInt(n4 += 4, 1);
        byteBuffer3.putInt(n4 += 4, 1819636851);
        byteBuffer3.putInt(n4 += 4, n);
        n4 += 4;
        for (char c : string2.toCharArray()) {
            byteBuffer3.putChar(n4, c);
            n4 += 2;
        }
        try {
            int n7;
            Object object = this.masterMPTiffStorage_.getDisplayAndComments().getJSONArray("Channels");
            for (n7 = 0; n7 < n; ++n7) {
                JSONObject jSONObject = ((JSONArray)object).getJSONObject(n7);
                byteBuffer3.putDouble(n4, jSONObject.getInt("Min"));
                byteBuffer3.putDouble(n4 += 8, jSONObject.getInt("Max"));
                n4 += 8;
            }
            for (n7 = 0; n7 < n; ++n7) {
                JSONObject jSONObject = ((JSONArray)object).getJSONObject(n7);
                LUT lUT = ImageUtils.makeLUT(new Color(jSONObject.getInt("Color")), jSONObject.getDouble("Gamma"));
                for (byte by : lUT.getBytes()) {
                    byteBuffer3.put(n4, by);
                    ++n4;
                }
            }
        }
        catch (JSONException jSONException) {
            ReportingUtils.logError("Problem with displayAndComments: Couldn't write ImageJ display settings as a result");
        }
        byteBuffer2 = ByteBuffer.allocate(8).order(BYTE_ORDER);
        byteBuffer2.putInt(0, n6);
        byteBuffer2.putInt(4, (int)this.filePosition_);
        this.fileChannel_.write(byteBuffer2, this.ijMetadataTagPosition_ + 4L);
        this.fileChannel_.write(byteBuffer3, this.filePosition_);
        this.filePosition_ += (long)n6;
    }

    private String getIJDescriptionString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ImageJ=1.47f\n");
        if (this.numChannels_ > 1) {
            stringBuffer.append("channels=" + this.numChannels_ + "\n");
        }
        if (this.numSlices_ > 1) {
            stringBuffer.append("slices=" + this.numSlices_ + "\n");
        }
        if (this.numFrames_ > 1) {
            stringBuffer.append("frames=" + this.numFrames_ + "\n");
        }
        if (this.numFrames_ > 1 || this.numSlices_ > 1 || this.numChannels_ > 1) {
            stringBuffer.append("hyperstack=true\n");
        }
        if (this.numChannels_ > 1 && this.numSlices_ > 1 && this.masterMPTiffStorage_.slicesFirst()) {
            stringBuffer.append("order=zct\n");
        }
        stringBuffer.append("unit=um\n");
        if (this.numSlices_ > 1) {
            stringBuffer.append("spacing=" + this.zStepUm_ + "\n");
        }
        try {
            JSONObject jSONObject = this.masterMPTiffStorage_.getDisplayAndComments().getJSONArray("Channels").getJSONObject(0);
            if (this.numChannels_ == 1) {
                double d = jSONObject.getInt("Min");
                double d2 = jSONObject.getInt("Max");
                stringBuffer.append("min=" + d + "\n");
                stringBuffer.append("max=" + d2 + "\n");
            } else {
                int n = jSONObject.getInt("DisplayMode");
                if (n == 1) {
                    stringBuffer.append("mode=composite\n");
                } else if (n == 2) {
                    stringBuffer.append("mode=color\n");
                } else if (n == 3) {
                    stringBuffer.append("mode=gray\n");
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        stringBuffer.append('\u0000');
        return new String(stringBuffer);
    }

    private void writeImageDescription(String string, long l) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(BYTE_ORDER);
        byteBuffer.putInt(0, string.length());
        byteBuffer.putInt(4, (int)this.filePosition_);
        this.fileChannel_.write(byteBuffer, l + 4L);
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(this.getBytesFromString(string));
        this.fileChannel_.write(byteBuffer2, this.filePosition_);
        this.filePosition_ += (long)byteBuffer2.capacity();
    }

    private byte[] getBytesFromString(String string) {
        try {
            return string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ReportingUtils.logError("Error encoding String to bytes");
            return null;
        }
    }

    private void writeNullOffsetAfterLastImage() throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.order(BYTE_ORDER);
        byteBuffer.putInt(0, 0);
        this.fileChannel_.write(byteBuffer, this.nextIFDOffsetLocation_);
    }

    private void writeComments() throws IOException {
        JSONObject jSONObject;
        try {
            jSONObject = this.masterMPTiffStorage_.getDisplayAndComments().getJSONObject("Comments");
        }
        catch (JSONException jSONException) {
            jSONObject = new JSONObject();
        }
        String string = jSONObject.toString();
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(BYTE_ORDER);
        byteBuffer.putInt(0, 84720485);
        byteBuffer.putInt(4, string.length());
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(this.getBytesFromString(string));
        this.fileChannel_.write(byteBuffer, this.filePosition_);
        this.fileChannel_.write(byteBuffer2, this.filePosition_ + 8L);
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(8).order(BYTE_ORDER);
        byteBuffer3.putInt(0, 99384722);
        byteBuffer3.putInt(4, (int)this.filePosition_);
        this.fileChannel_.write(byteBuffer3, 24L);
        this.filePosition_ += (long)(8 + string.length());
    }

    private void writeIndexMap() throws IOException {
        int n = this.indexMap_.size();
        ByteBuffer byteBuffer = ByteBuffer.allocate(8 + 20 * n).order(BYTE_ORDER);
        byteBuffer.putInt(0, 3453623);
        byteBuffer.putInt(4, n);
        int n2 = 2;
        for (String string : this.indexMap_.keySet()) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("_")) {
                byteBuffer.putInt(4 * n2, Integer.parseInt(string2));
                ++n2;
            }
            byteBuffer.putInt(4 * n2, this.indexMap_.get(string).intValue());
            ++n2;
        }
        this.fileChannel_.write(byteBuffer, this.filePosition_);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(8).order(BYTE_ORDER);
        byteBuffer2.putInt(0, 54773648);
        byteBuffer2.putInt(4, (int)this.filePosition_);
        this.fileChannel_.write(byteBuffer2, 8L);
        this.filePosition_ += (long)byteBuffer.capacity();
    }

    private void writeDisplaySettings() throws IOException {
        JSONArray jSONArray;
        try {
            jSONArray = this.masterMPTiffStorage_.getDisplayAndComments().getJSONArray("Channels");
        }
        catch (JSONException jSONException) {
            jSONArray = new JSONArray();
        }
        int n = this.numChannels_ * 256;
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(BYTE_ORDER);
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(this.getBytesFromString(jSONArray.toString()));
        byteBuffer.putInt(0, 347834724);
        byteBuffer.putInt(4, n);
        this.fileChannel_.write(byteBuffer, this.filePosition_);
        this.fileChannel_.write(byteBuffer2, this.filePosition_ + 8L);
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(8).order(BYTE_ORDER);
        byteBuffer3.putInt(0, 483765892);
        byteBuffer3.putInt(4, (int)this.filePosition_);
        this.fileChannel_.write(byteBuffer3, 16L);
        this.filePosition_ += (long)(n + 8);
    }

    private void writeBlankIFD() throws IOException {
        boolean bl = false;
        char c = (char)((this.firstIFD_ && this.omeTiff_ ? 15 : 13) + (this.firstIFD_ ? 2 : 0));
        String string = "NULL ";
        int n = 2 + c * 12 + 4 + (this.rgb_ ? 6 : 0) + 16 + string.length() + (bl ? 0 : this.bytesPerImagePixels_);
        int n2 = 2 + c * 12 + 4 + (this.rgb_ ? 6 : 0);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2).order(BYTE_ORDER);
        CharBuffer charBuffer = byteBuffer.asCharBuffer();
        long l = this.filePosition_ + 2L + (long)(c * 12) + 4L;
        this.nextIFDOffsetLocation_ = this.filePosition_ + 2L + (long)(c * 12);
        this.bufferPosition_ = 0;
        charBuffer.put(this.bufferPosition_, c);
        this.bufferPosition_ += 2;
        this.writeIFDEntry(byteBuffer, charBuffer, '\u0100', '\u0004', 1L, this.imageWidth_);
        this.writeIFDEntry(byteBuffer, charBuffer, '\u0101', '\u0004', 1L, this.imageHeight_);
        this.writeIFDEntry(byteBuffer, charBuffer, '\u0102', '\u0003', this.rgb_ ? 3L : 1L, this.rgb_ ? l : (long)(this.byteDepth_ * 8));
        if (this.rgb_) {
            l += 6L;
        }
        this.writeIFDEntry(byteBuffer, charBuffer, '\u0103', '\u0003', 1L, 1L);
        this.writeIFDEntry(byteBuffer, charBuffer, '\u0106', '\u0003', 1L, this.rgb_ ? 2L : 1L);
        if (this.firstIFD_ && this.omeTiff_) {
            this.omeDescriptionTagPosition_ = this.filePosition_ + (long)this.bufferPosition_;
            this.writeIFDEntry(byteBuffer, charBuffer, '\u010e', '\u0002', 0L, 0L);
        }
        if (this.firstIFD_) {
            this.ijDescriptionTagPosition_ = this.filePosition_ + (long)this.bufferPosition_;
            this.writeIFDEntry(byteBuffer, charBuffer, '\u010e', '\u0002', 0L, 0L);
        }
        if (!bl) {
            this.writeIFDEntry(byteBuffer, charBuffer, '\u0111', '\u0004', 1L, l);
            this.blankPixelsOffset_ = l;
            l += (long)this.bytesPerImagePixels_;
        } else {
            this.writeIFDEntry(byteBuffer, charBuffer, '\u0111', '\u0004', 1L, this.blankPixelsOffset_);
        }
        this.writeIFDEntry(byteBuffer, charBuffer, '\u0115', '\u0003', 1L, this.rgb_ ? 3 : 1);
        this.writeIFDEntry(byteBuffer, charBuffer, '\u0116', '\u0003', 1L, this.imageHeight_);
        this.writeIFDEntry(byteBuffer, charBuffer, '\u0117', '\u0004', 1L, this.bytesPerImagePixels_);
        this.writeIFDEntry(byteBuffer, charBuffer, '\u011a', '\u0005', 1L, l);
        this.writeIFDEntry(byteBuffer, charBuffer, '\u011b', '\u0005', 1L, l += 8L);
        l += 8L;
        this.writeIFDEntry(byteBuffer, charBuffer, '\u0128', '\u0003', 1L, 3L);
        if (this.firstIFD_) {
            this.ijMetadataCountsTagPosition_ = this.filePosition_ + (long)this.bufferPosition_;
            this.writeIFDEntry(byteBuffer, charBuffer, '\uc696', '\u0004', 0L, 0L);
            this.ijMetadataTagPosition_ = this.filePosition_ + (long)this.bufferPosition_;
            this.writeIFDEntry(byteBuffer, charBuffer, '\uc697', '\u0001', 0L, 0L);
        }
        this.writeIFDEntry(byteBuffer, charBuffer, '\uc7b3', '\u0002', string.length(), l);
        byteBuffer.putInt(this.bufferPosition_, (int)(l += (long)string.length()));
        this.bufferPosition_ += 4;
        if (this.rgb_) {
            charBuffer.put(this.bufferPosition_ / 2, (char)(this.byteDepth_ * 8));
            charBuffer.put(this.bufferPosition_ / 2 + 1, (char)(this.byteDepth_ * 8));
            charBuffer.put(this.bufferPosition_ / 2 + 2, (char)(this.byteDepth_ * 8));
        }
        this.buffers_.add(byteBuffer);
        if (!bl) {
            this.buffers_.add(ByteBuffer.wrap(new byte[this.bytesPerImagePixels_]));
        }
        this.buffers_.add(this.getResolutionValuesBuffer());
        this.buffers_.add(ByteBuffer.wrap(this.getBytesFromString(string)));
        this.filePosition_ += (long)n;
        this.firstIFD_ = false;
    }
}

