/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;
import mmcorej.TaggedImage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.acquisition.TaggedImageStorageRam;
import org.micromanager.api.ImageCache;
import org.micromanager.api.ImageCacheListener;
import org.micromanager.api.TaggedImageStorage;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMException;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ProgressBar;
import org.micromanager.utils.ReportingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MMImageCache
implements ImageCache {
    public static String menuName_ = null;
    public final List<ImageCacheListener> imageStorageListeners_ = Collections.synchronizedList(new ArrayList());
    private TaggedImageStorage imageStorage_;
    private Set<String> changingKeys_;
    private JSONObject firstTags_;
    private int lastFrame_ = -1;
    private JSONObject lastTags_;
    private final ExecutorService fileExecutor_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addImageCacheListener(ImageCacheListener imageCacheListener) {
        List<ImageCacheListener> list = this.imageStorageListeners_;
        synchronized (list) {
            this.imageStorageListeners_.add(imageCacheListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageCacheListener[] getImageCacheListeners() {
        List<ImageCacheListener> list = this.imageStorageListeners_;
        synchronized (list) {
            return (ImageCacheListener[])this.imageStorageListeners_.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeImageCacheListener(ImageCacheListener imageCacheListener) {
        List<ImageCacheListener> list = this.imageStorageListeners_;
        synchronized (list) {
            this.imageStorageListeners_.remove(imageCacheListener);
        }
    }

    public MMImageCache(TaggedImageStorage taggedImageStorage) {
        this.imageStorage_ = taggedImageStorage;
        this.changingKeys_ = new HashSet<String>();
        this.fileExecutor_ = Executors.newFixedThreadPool(1);
    }

    private void preloadImages() {
        new Thread(){

            public void run() {
                for (String string : MMImageCache.this.imageKeys()) {
                    int[] nArray = MDUtils.getIndices(string);
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished() {
        this.imageStorage_.finished();
        String string = this.getDiskLocation();
        List<ImageCacheListener> list = this.imageStorageListeners_;
        synchronized (list) {
            for (ImageCacheListener imageCacheListener : this.imageStorageListeners_) {
                imageCacheListener.imagingFinished(string);
            }
        }
    }

    @Override
    public boolean isFinished() {
        return this.imageStorage_.isFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastAcquiredFrame() {
        MMImageCache mMImageCache = this;
        synchronized (mMImageCache) {
            this.lastFrame_ = Math.max(this.imageStorage_.lastAcquiredFrame(), this.lastFrame_);
            return this.lastFrame_;
        }
    }

    @Override
    public String getDiskLocation() {
        return this.imageStorage_.getDiskLocation();
    }

    @Override
    public void setDisplayAndComments(JSONObject jSONObject) {
        this.imageStorage_.setDisplayAndComments(jSONObject);
    }

    @Override
    public JSONObject getDisplayAndComments() {
        return this.imageStorage_.getDisplayAndComments();
    }

    @Override
    public void writeDisplaySettings() {
        this.imageStorage_.writeDisplaySettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.imageStorage_.close();
        List<ImageCacheListener> list = this.imageStorageListeners_;
        synchronized (list) {
            this.imageStorageListeners_.clear();
        }
    }

    @Override
    public void saveAs(TaggedImageStorage taggedImageStorage) {
        this.saveAs(taggedImageStorage, true);
        this.finished();
    }

    @Override
    public void saveAs(TaggedImageStorage taggedImageStorage, boolean bl) {
        if (taggedImageStorage == null) {
            return;
        }
        taggedImageStorage.setSummaryMetadata(this.imageStorage_.getSummaryMetadata());
        taggedImageStorage.setDisplayAndComments(this.getDisplayAndComments());
        String string = taggedImageStorage instanceof TaggedImageStorageRam ? "Loading images..." : "Saving images...";
        final ProgressBar progressBar = new ProgressBar(string, 0, 100);
        ArrayList<String> arrayList = new ArrayList<String>(this.imageKeys());
        int n = arrayList.size();
        progressBar.setRange(0, n);
        progressBar.setProgress(0);
        progressBar.setVisible(true);
        for (int i = 0; i < n; ++i) {
            final int n2 = i;
            int[] nArray = MDUtils.getIndices(arrayList.get(i));
            try {
                taggedImageStorage.putImage(this.getImage(nArray[0], nArray[1], nArray[2], nArray[3]));
            }
            catch (MMException mMException) {
                ReportingUtils.logError(mMException);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    progressBar.setProgress(n2);
                }
            });
        }
        taggedImageStorage.finished();
        progressBar.setVisible(false);
        if (bl) {
            this.imageStorage_ = taggedImageStorage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putImage(TaggedImage taggedImage) {
        try {
            Object object;
            this.checkForChangingTags(taggedImage);
            this.imageStorage_.putImage(taggedImage);
            Object object2 = this;
            synchronized (object2) {
                this.lastFrame_ = Math.max(this.lastFrame_, MDUtils.getFrameIndex(taggedImage.tags));
                this.lastTags_ = taggedImage.tags;
            }
            object2 = this.imageStorage_.getDisplayAndComments();
            if (((JSONObject)object2).length() > 0) {
                object = this.imageStorage_.getDisplayAndComments().getJSONArray("Channels");
                JSONObject jSONObject = taggedImage.tags;
                int n = MDUtils.getChannelIndex(jSONObject);
                if (n >= ((JSONArray)object).length()) {
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("Name", MDUtils.getChannelName(jSONObject));
                    jSONObject2.put("Color", MDUtils.getChannelColor(jSONObject));
                    ((JSONArray)object).put(n, jSONObject2);
                }
            }
            object = this.imageStorageListeners_;
            synchronized (object) {
                for (ImageCacheListener imageCacheListener : this.imageStorageListeners_) {
                    imageCacheListener.imageReceived(taggedImage);
                }
            }
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject getLastImageTags() {
        MMImageCache mMImageCache = this;
        synchronized (mMImageCache) {
            return this.lastTags_;
        }
    }

    @Override
    public TaggedImage getImage(int n, int n2, int n3, int n4) {
        TaggedImage taggedImage = null;
        if (taggedImage == null && (taggedImage = this.imageStorage_.getImage(n, n2, n3, n4)) != null) {
            this.checkForChangingTags(taggedImage);
        }
        return taggedImage;
    }

    @Override
    public JSONObject getImageTags(int n, int n2, int n3, int n4) {
        String string = MDUtils.generateLabel(n, n2, n3, n4);
        JSONObject jSONObject = null;
        if (jSONObject == null) {
            jSONObject = this.imageStorage_.getImageTags(n, n2, n3, n4);
        }
        return jSONObject;
    }

    private void checkForChangingTags(TaggedImage taggedImage) {
        if (this.firstTags_ == null) {
            this.firstTags_ = taggedImage.tags;
        } else {
            Iterator<String> iterator = taggedImage.tags.keys();
            while (iterator.hasNext()) {
                String string = iterator.next();
                try {
                    if (taggedImage.tags.isNull(string)) continue;
                    if (!this.firstTags_.has(string) || this.firstTags_.isNull(string)) {
                        this.changingKeys_.add(string);
                        continue;
                    }
                    if (taggedImage.tags.getString(string).contentEquals(this.firstTags_.getString(string))) continue;
                    this.changingKeys_.add(string);
                }
                catch (Exception exception) {
                    ReportingUtils.logError(exception);
                }
            }
        }
    }

    private JSONObject getCommentsJSONObject() {
        JSONObject jSONObject;
        if (this.imageStorage_ == null) {
            ReportingUtils.logError("imageStorage_ is null in getCommentsJSONObject");
            return null;
        }
        try {
            jSONObject = this.imageStorage_.getDisplayAndComments().getJSONObject("Comments");
        }
        catch (JSONException jSONException) {
            jSONObject = new JSONObject();
            try {
                this.imageStorage_.getDisplayAndComments().put("Comments", jSONObject);
            }
            catch (JSONException jSONException2) {
                ReportingUtils.logError(jSONException2);
            }
        }
        return jSONObject;
    }

    @Override
    public void setComment(String string) {
        JSONObject jSONObject = this.getCommentsJSONObject();
        try {
            jSONObject.put("Summary", string);
        }
        catch (JSONException jSONException) {
            ReportingUtils.logError(jSONException);
        }
    }

    @Override
    public void setImageComment(String string, JSONObject jSONObject) {
        JSONObject jSONObject2 = this.getCommentsJSONObject();
        String string2 = MDUtils.getLabel(jSONObject);
        try {
            jSONObject2.put(string2, string);
        }
        catch (JSONException jSONException) {
            ReportingUtils.logError(jSONException);
        }
    }

    @Override
    public String getImageComment(JSONObject jSONObject) {
        if (jSONObject == null) {
            return "";
        }
        try {
            String string = MDUtils.getLabel(jSONObject);
            return this.getCommentsJSONObject().getString(string);
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public String getComment() {
        try {
            return this.getCommentsJSONObject().getString("Summary");
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public JSONObject getSummaryMetadata() {
        if (this.imageStorage_ == null) {
            ReportingUtils.logError("imageStorage_ is null in getSummaryMetadata");
            return null;
        }
        return this.imageStorage_.getSummaryMetadata();
    }

    @Override
    public void setSummaryMetadata(JSONObject jSONObject) {
        if (this.imageStorage_ == null) {
            ReportingUtils.logError("imageStorage_ is null in setSummaryMetadata");
            return;
        }
        this.imageStorage_.setSummaryMetadata(jSONObject);
    }

    @Override
    public Set<String> getChangingKeys() {
        return this.changingKeys_;
    }

    @Override
    public Set<String> imageKeys() {
        return this.imageStorage_.imageKeys();
    }

    private boolean isRGB() throws JSONException, MMScriptException {
        return MDUtils.isRGB(this.getSummaryMetadata());
    }

    @Override
    public String getPixelType() {
        try {
            return MDUtils.getPixelType(this.getSummaryMetadata());
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
            return null;
        }
    }

    @Override
    public void storeChannelDisplaySettings(int n, int n2, int n3, double d, int n4, int n5) {
        try {
            JSONObject jSONObject = this.getChannelSetting(n);
            jSONObject.put("Max", n3);
            jSONObject.put("Min", n2);
            jSONObject.put("Gamma", d);
            jSONObject.put("HistogramMax", n4);
            jSONObject.put("DisplayMode", n5);
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
    }

    @Override
    public JSONObject getChannelSetting(int n) {
        try {
            JSONArray jSONArray = this.getDisplayAndComments().getJSONArray("Channels");
            if (n >= jSONArray.length()) {
                jSONArray.put(n, new JSONObject(jSONArray.getJSONObject(0).toString()));
            }
            if (jSONArray != null && !jSONArray.isNull(n)) {
                return jSONArray.getJSONObject(n);
            }
            return null;
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
            return null;
        }
    }

    @Override
    public int getBitDepth() {
        try {
            return this.imageStorage_.getSummaryMetadata().getInt("BitDepth");
        }
        catch (JSONException jSONException) {
            ReportingUtils.logError("MMImageCache.BitDepth: no tag BitDepth found");
            return 16;
        }
    }

    @Override
    public Color getChannelColor(int n) {
        try {
            if (this.isRGB()) {
                return n == 0 ? Color.red : (n == 1 ? Color.green : Color.blue);
            }
            return new Color(this.getChannelSetting(n).getInt("Color"));
        }
        catch (Exception exception) {
            return Color.WHITE;
        }
    }

    @Override
    public void setChannelColor(int n, int n2) {
        JSONObject jSONObject = this.getChannelSetting(n);
        try {
            if (jSONObject == null) {
                return;
            }
            jSONObject.put("Color", n2);
        }
        catch (JSONException jSONException) {
            ReportingUtils.logError(jSONException);
        }
    }

    @Override
    public String getChannelName(int n) {
        try {
            if (this.isRGB()) {
                return n == 0 ? "Red" : (n == 1 ? "Green" : "Blue");
            }
            return this.getChannelSetting(n).getString("Name");
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
            return "";
        }
    }

    public void setChannelName(int n, String string) {
        try {
            JSONArray jSONArray;
            if (this.isRGB()) {
                return;
            }
            JSONObject jSONObject = this.getDisplayAndComments();
            if (jSONObject.has("Channels")) {
                jSONArray = jSONObject.getJSONArray("Channels");
            } else {
                jSONArray = new JSONArray();
                jSONObject.put("Channels", jSONArray);
            }
            if (jSONArray.isNull(n)) {
                jSONArray.put(n, new JSONObject().put("Name", string));
            }
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
    }

    @Override
    public int getDisplayMode() {
        try {
            return this.getChannelSetting(0).getInt("DisplayMode");
        }
        catch (JSONException jSONException) {
            return 1;
        }
    }

    @Override
    public int getChannelMin(int n) {
        try {
            return this.getChannelSetting(n).getInt("Min");
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public int getChannelMax(int n) {
        try {
            return this.getChannelSetting(n).getInt("Max");
        }
        catch (Exception exception) {
            return -1;
        }
    }

    @Override
    public double getChannelGamma(int n) {
        try {
            return this.getChannelSetting(n).getDouble("Gamma");
        }
        catch (Exception exception) {
            return 1.0;
        }
    }

    @Override
    public int getChannelHistogramMax(int n) {
        try {
            return this.getChannelSetting(n).getInt("HistogramMax");
        }
        catch (JSONException jSONException) {
            return -1;
        }
    }

    @Override
    public int getNumChannels() {
        JSONArray jSONArray;
        try {
            jSONArray = this.getDisplayAndComments().getJSONArray("Channels");
        }
        catch (Exception exception) {
            return 1;
        }
        return jSONArray.length();
    }

    @Override
    public long getDataSetSize() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

