/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import mmcorej.CMMCore;
import mmcorej.TaggedImage;
import org.json.JSONException;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.acquisition.TaggedImageQueue;
import org.micromanager.acquisition.VirtualAcquisitionDisplay;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ReportingUtils;

public class LiveModeTimer {
    private static final String CCHANNELINDEX = "CameraChannelIndex";
    private static final String ACQ_NAME = "Snap/Live Window";
    private VirtualAcquisitionDisplay win_;
    private CMMCore core_;
    private MMStudioMainFrame gui_ = MMStudioMainFrame.getInstance();
    private int multiChannelCameraNrCh_;
    private long fpsTimer_;
    private long fpsCounter_;
    private long imageNumber_;
    private long lastImageNumber_;
    private long oldImageNumber_;
    private long fpsInterval_ = 5000L;
    private final NumberFormat format_;
    private boolean running_ = false;
    private Timer timer_;
    private TimerTask task_;
    private MMStudioMainFrame.DisplayImageRoutine displayImageRoutine_;
    private LinkedBlockingQueue imageQueue_;

    public LiveModeTimer() {
        this.core_ = this.gui_.getCore();
        this.format_ = NumberFormat.getInstance();
        this.format_.setMaximumFractionDigits(1);
        this.displayImageRoutine_ = new MMStudioMainFrame.DisplayImageRoutine(){

            public void show(TaggedImage taggedImage) {
                try {
                    LiveModeTimer.this.gui_.normalizeTags(taggedImage);
                    LiveModeTimer.this.gui_.addImage(LiveModeTimer.ACQ_NAME, taggedImage, true, true);
                    LiveModeTimer.this.gui_.updateLineProfile();
                }
                catch (Exception exception) {
                    ReportingUtils.logError(exception);
                }
            }
        };
    }

    private long getInterval() {
        double d = 20.0;
        try {
            d = Math.max(this.core_.getExposure(), d);
        }
        catch (Exception exception) {
            ReportingUtils.logError("Unable to get exposure from core");
        }
        this.fpsInterval_ = (long)(20.0 * d);
        if (this.fpsInterval_ < 1000L) {
            this.fpsInterval_ = 1000L;
        }
        return (int)d;
    }

    private void setType() {
        this.multiChannelCameraNrCh_ = (int)this.core_.getNumberOfCameraChannels();
        this.task_ = this.multiChannelCameraNrCh_ == 1 ? this.singleCameraLiveTask() : this.multiCamLiveTask();
    }

    public boolean isRunning() {
        return this.running_;
    }

    public void begin() throws Exception {
        long l;
        if (this.running_) {
            return;
        }
        this.timer_ = new Timer("Live mode timer");
        this.core_.clearCircularBuffer();
        this.core_.startContinuousSequenceAcquisition(0.0);
        this.setType();
        long l2 = this.getInterval();
        long l3 = l = System.currentTimeMillis();
        long l4 = Math.min(10000L, l2 * 150L);
        while (this.core_.getRemainingImageCount() == 0 && l3 - l < l4) {
            l3 = System.currentTimeMillis();
            Thread.sleep(5L);
        }
        if (l3 - l >= l4) {
            throw new Exception("Camera did not send image within a reasonable time");
        }
        TaggedImage taggedImage = this.core_.getLastTaggedImage();
        this.gui_.checkSimpleAcquisition();
        this.win_ = MMStudioMainFrame.getSimpleDisplay();
        this.fpsCounter_ = 0L;
        this.fpsTimer_ = System.currentTimeMillis();
        this.imageNumber_ = taggedImage.tags.getLong("ImageNumber");
        this.lastImageNumber_ = this.imageNumber_ - 1L;
        this.oldImageNumber_ = this.imageNumber_;
        this.imageQueue_ = new LinkedBlockingQueue();
        this.timer_.schedule(this.task_, 0L, l2);
        this.win_.liveModeEnabled(true);
        this.win_.getImagePlus().getWindow().toFront();
        this.running_ = true;
        this.gui_.runDisplayThread(this.imageQueue_, this.displayImageRoutine_);
    }

    public void stop() {
        this.stop(true);
    }

    private void stop(boolean bl) {
        block8: {
            try {
                if (this.imageQueue_ != null) {
                    this.imageQueue_.put(TaggedImageQueue.POISON);
                }
            }
            catch (InterruptedException interruptedException) {
                ReportingUtils.logError(interruptedException);
            }
            if (this.timer_ != null) {
                this.timer_.cancel();
            }
            try {
                if (this.core_.isSequenceRunning()) {
                    this.core_.stopSequenceAcquisition();
                }
                if (this.win_ != null) {
                    this.win_.liveModeEnabled(false);
                }
                this.running_ = false;
            }
            catch (Exception exception) {
                ReportingUtils.showError(exception);
                if (!bl) break block8;
                Timer timer = new Timer();
                timer.schedule(new TimerTask(){

                    public void run() {
                        LiveModeTimer.this.stop(false);
                    }
                }, 1000L);
            }
        }
    }

    private synchronized void setImageNumber(long l) {
        this.imageNumber_ = l;
    }

    public synchronized void updateFPS() {
        if (!this.running_) {
            return;
        }
        try {
            ++this.fpsCounter_;
            long l = System.currentTimeMillis();
            long l2 = l - this.fpsTimer_;
            if (l2 > this.fpsInterval_) {
                double d = (double)l2 / 1000.0;
                double d2 = (double)this.fpsCounter_ / d;
                double d3 = (double)(this.imageNumber_ - this.oldImageNumber_) / d;
                this.win_.displayStatusLine("fps: " + this.format_.format(d3) + ", display fps: " + this.format_.format(d2));
                this.fpsCounter_ = 0L;
                this.fpsTimer_ = l;
                this.oldImageNumber_ = this.imageNumber_;
            }
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
    }

    private TimerTask singleCameraLiveTask() {
        return new TimerTask(){

            public void run() {
                if (LiveModeTimer.this.core_.getRemainingImageCount() == 0) {
                    return;
                }
                if (LiveModeTimer.this.win_.windowClosed()) {
                    LiveModeTimer.this.gui_.enableLiveMode(false);
                } else {
                    try {
                        TaggedImage taggedImage = LiveModeTimer.this.core_.getLastTaggedImage();
                        LiveModeTimer.this.setImageNumber(taggedImage.tags.getLong("ImageNumber"));
                        LiveModeTimer.this.imageQueue_.put(taggedImage);
                    }
                    catch (Exception exception) {
                        ReportingUtils.logMessage("Stopping live mode because of error...");
                        LiveModeTimer.this.gui_.enableLiveMode(false);
                        ReportingUtils.showError(exception);
                    }
                }
            }
        };
    }

    private TimerTask multiCamLiveTask() {
        return new TimerTask(){

            public void run() {
                if (LiveModeTimer.this.core_.getRemainingImageCount() == 0) {
                    return;
                }
                if (LiveModeTimer.this.win_.windowClosed() || !LiveModeTimer.this.gui_.acquisitionExists(LiveModeTimer.ACQ_NAME).booleanValue()) {
                    LiveModeTimer.this.gui_.enableLiveMode(false);
                } else {
                    try {
                        String string = LiveModeTimer.this.core_.getCameraDevice();
                        HashSet<String> hashSet = new HashSet<String>();
                        for (int i = 0; i < 2 * LiveModeTimer.this.multiChannelCameraNrCh_; ++i) {
                            TaggedImage taggedImage = LiveModeTimer.this.core_.getNBeforeLastTaggedImage(i);
                            if (i == 0) {
                                LiveModeTimer.this.setImageNumber(taggedImage.tags.getLong("ImageNumber"));
                            }
                            if (!taggedImage.tags.has(string + "-CameraChannelName")) continue;
                            String string2 = taggedImage.tags.getString(string + "-CameraChannelName");
                            if (!hashSet.contains(string2)) {
                                taggedImage.tags.put("Channel", string2);
                                taggedImage.tags.put("ChannelIndex", taggedImage.tags.getInt(string + "-CameraChannelIndex"));
                                LiveModeTimer.this.imageQueue_.put(taggedImage);
                                hashSet.add(string2);
                            }
                            if (hashSet.size() != LiveModeTimer.this.multiChannelCameraNrCh_) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        ReportingUtils.logMessage("Stopping live mode because of error...");
                        LiveModeTimer.this.gui_.enableLiveMode(false);
                        ReportingUtils.showError(exception);
                    }
                }
            }
        };
    }

    private void addTags(TaggedImage taggedImage, int n) throws JSONException {
        MDUtils.setChannelIndex(taggedImage.tags, n);
        MDUtils.setFrameIndex(taggedImage.tags, 0);
        MDUtils.setPositionIndex(taggedImage.tags, 0);
        MDUtils.setSliceIndex(taggedImage.tags, 0);
        try {
            taggedImage.tags.put("Summary", MMStudioMainFrame.getInstance().getAcquisition(ACQ_NAME).getSummaryMetadata());
        }
        catch (MMScriptException mMScriptException) {
            ReportingUtils.logError("Error adding summary metadata to tags");
        }
        this.gui_.addStagePositionToTags(taggedImage);
    }
}

