/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import ij.ImagePlus;
import ij.VirtualStack;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;
import mmcorej.TaggedImage;
import org.json.JSONObject;
import org.micromanager.acquisition.VirtualAcquisitionDisplay;
import org.micromanager.api.TaggedImageStorage;
import org.micromanager.utils.ImageUtils;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.ReportingUtils;

public class AcquisitionVirtualStack
extends VirtualStack {
    private final TaggedImageStorage imageCache_;
    private final VirtualAcquisitionDisplay acq_;
    protected final int width_;
    protected final int height_;
    protected final int type_;
    private int nSlices_;
    private int positionIndex_ = 0;

    public AcquisitionVirtualStack(int n, int n2, int n3, ColorModel colorModel, TaggedImageStorage taggedImageStorage, int n4, VirtualAcquisitionDisplay virtualAcquisitionDisplay) {
        super(n, n2, colorModel, "");
        this.imageCache_ = taggedImageStorage;
        this.width_ = n;
        this.height_ = n2;
        this.nSlices_ = n4;
        this.acq_ = virtualAcquisitionDisplay;
        this.type_ = n3;
    }

    public void setPositionIndex(int n) {
        this.positionIndex_ = n;
    }

    public int getPositionIndex() {
        return this.positionIndex_;
    }

    public VirtualAcquisitionDisplay getVirtualAcquisitionDisplay() {
        return this.acq_;
    }

    public void setSize(int n) {
        this.nSlices_ = n;
    }

    public TaggedImageStorage getCache() {
        return this.imageCache_;
    }

    public TaggedImage getTaggedImage(int n) {
        ImagePlus imagePlus = this.acq_.getImagePlus();
        if (imagePlus == null) {
            return this.getTaggedImage(0, 0, 0);
        }
        int[] nArray = imagePlus.convertIndexToPosition(n);
        int n2 = this.acq_.grayToRGBChannel(nArray[0] - 1);
        int n3 = nArray[2] - 1;
        int n4 = nArray[1] - 1;
        return this.getTaggedImage(n2, n4, n3);
    }

    public TaggedImage getTaggedImage(int n, int n2, int n3) {
        ImagePlus imagePlus = this.acq_.getImagePlus();
        int n4 = imagePlus == null ? 1 : imagePlus.getNSlices();
        try {
            TaggedImage taggedImage = this.imageCache_.getImage(n, n2, n3, this.positionIndex_);
            int n5 = n2 - 1;
            int n6 = n2 + 1;
            int n7 = n3;
            while (taggedImage == null && (taggedImage = this.imageCache_.getImage(n, n2, n7, this.positionIndex_)) == null) {
                if (n5 >= 0) {
                    taggedImage = this.imageCache_.getImage(n, n5, n7, this.positionIndex_);
                    if (taggedImage != null) break;
                    --n5;
                }
                if (n6 < n4) {
                    taggedImage = this.imageCache_.getImage(n, n6, n7, this.positionIndex_);
                    if (taggedImage != null) break;
                    ++n6;
                }
                if (n5 >= 0 || n6 < n4) continue;
                n5 = n2 - 1;
                n6 = n2 + 1;
                if (--n7 >= 0) continue;
            }
            return taggedImage;
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
            return null;
        }
    }

    public Object getPixels(int n) {
        Object object = null;
        try {
            TaggedImage taggedImage = this.getTaggedImage(n);
            if (taggedImage == null) {
                object = ImageUtils.makeProcessor(this.type_, this.width_, this.height_).getPixels();
            } else if (MDUtils.isGRAY(taggedImage)) {
                object = taggedImage.pix;
            } else if (MDUtils.isRGB32(taggedImage)) {
                object = ImageUtils.singleChannelFromRGB32((byte[])taggedImage.pix, (n - 1) % 3);
            } else if (MDUtils.isRGB64(taggedImage)) {
                object = ImageUtils.singleChannelFromRGB64((short[])taggedImage.pix, (n - 1) % 3);
            }
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
        return object;
    }

    public ImageProcessor getProcessor(int n) {
        return ImageUtils.makeProcessor(this.type_, this.width_, this.height_, this.getPixels(n));
    }

    public int getSize() {
        int n = this.acq_.getStackSize();
        if (n == -1) {
            return this.nSlices_;
        }
        return n;
    }

    public String getSliceLabel(int n) {
        TaggedImage taggedImage = this.getTaggedImage(n);
        if (taggedImage == null) {
            return "";
        }
        JSONObject jSONObject = taggedImage.tags;
        try {
            return jSONObject.get("Acquisition-PixelSizeUm") + " um/px";
        }
        catch (Exception exception) {
            return "";
        }
    }
}

