/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import ij.gui.ImageWindow;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.prefs.Preferences;
import mmcorej.TaggedImage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.acquisition.MMAcquisition;
import org.micromanager.api.AcquisitionEngine;
import org.micromanager.api.ImageCache;
import org.micromanager.utils.GUIUtils;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ReportingUtils;

public class AcquisitionManager {
    private static final String ALBUM_WIN_X = "album_x";
    private static final String ALBUM_WIN_Y = "album_y";
    Hashtable<String, MMAcquisition> acqs_ = new Hashtable();
    private String album_ = null;

    public void openAcquisition(String string, String string2) throws MMScriptException {
        if (this.acquisitionExists(string)) {
            throw new MMScriptException("The name is in use");
        }
        MMAcquisition mMAcquisition = new MMAcquisition(string, string2);
        this.acqs_.put(string, mMAcquisition);
    }

    public void openAcquisition(String string, String string2, boolean bl) throws MMScriptException {
        this.openAcquisition(string, string2, bl, false);
    }

    public void openAcquisition(String string, String string2, boolean bl, boolean bl2) throws MMScriptException {
        this.openAcquisition(string, string2, bl, bl2, false);
    }

    public void openAcquisition(String string, String string2, boolean bl, boolean bl2, boolean bl3) throws MMScriptException {
        if (this.acquisitionExists(string)) {
            throw new MMScriptException("The name is in use");
        }
        this.acqs_.put(string, new MMAcquisition(string, string2, bl, bl2, bl3));
    }

    public void closeAcquisition(final String string) throws MMScriptException {
        if (string == null) {
            return;
        }
        final MMScriptException[] mMScriptExceptionArray = new MMScriptException[]{null};
        try {
            GUIUtils.invokeAndWait(new Runnable(){

                public void run() {
                    if (!AcquisitionManager.this.acqs_.containsKey(string)) {
                        mMScriptExceptionArray[0] = new MMScriptException("The name does not exist");
                    } else {
                        AcquisitionManager.this.acqs_.get(string).close();
                        AcquisitionManager.this.acqs_.remove(string);
                    }
                }
            });
            if (mMScriptExceptionArray[0] != null) {
                throw mMScriptExceptionArray[0];
            }
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
        }
    }

    public void closeImageWindow(String string) throws MMScriptException {
        if (!this.acquisitionExists(string)) {
            throw new MMScriptException("The name does not exist");
        }
        this.acqs_.get(string).closeImageWindow();
    }

    public boolean acquisitionExists(String string) {
        if (this.acqs_.containsKey(string)) {
            MMAcquisition mMAcquisition = this.acqs_.get(string);
            if (mMAcquisition.getShow() && mMAcquisition.windowClosed()) {
                mMAcquisition.close();
                this.acqs_.remove(string);
                return false;
            }
            return true;
        }
        return false;
    }

    public MMAcquisition getAcquisition(String string) throws MMScriptException {
        if (this.acquisitionExists(string)) {
            return this.acqs_.get(string);
        }
        throw new MMScriptException("Undefined acquisition name: " + string);
    }

    public void closeAll() {
        Enumeration<MMAcquisition> enumeration = this.acqs_.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().close();
        }
        this.acqs_.clear();
    }

    public String getUniqueAcquisitionName(String string) {
        char c = '_';
        while (this.acquisitionExists(string)) {
            Integer n;
            int n2 = string.lastIndexOf(c);
            if (n2 == -1) {
                string = string + c + "1";
                continue;
            }
            Integer n3 = n = Integer.valueOf(Integer.parseInt(string.substring(n2 + 1)));
            Integer n4 = n = Integer.valueOf(n + 1);
            string = string.substring(0, n2) + c + n;
        }
        return string;
    }

    public String getCurrentAlbum() {
        if (this.album_ == null) {
            return this.createNewAlbum();
        }
        return this.album_;
    }

    public String createNewAlbum() {
        this.album_ = this.getUniqueAcquisitionName("Album");
        return this.album_;
    }

    public String addToAlbum(TaggedImage taggedImage, JSONObject jSONObject) throws MMScriptException {
        Object object;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl = true;
        MMAcquisition mMAcquisition = null;
        String string = this.getCurrentAlbum();
        JSONObject jSONObject2 = taggedImage.tags;
        try {
            n5 = MDUtils.getWidth(jSONObject2);
            n4 = MDUtils.getHeight(jSONObject2);
            n3 = MDUtils.getDepth(jSONObject2);
            n2 = MDUtils.getBitDepth(jSONObject2);
            n = MDUtils.getNumChannels(jSONObject2);
        }
        catch (Exception exception) {
            throw new MMScriptException("Something wrong with image tags.");
        }
        if (this.acquisitionExists(string)) {
            mMAcquisition = this.acqs_.get(string);
            try {
                if (mMAcquisition.getWidth() == n5 && mMAcquisition.getHeight() == n4 && mMAcquisition.getByteDepth() == n3 && mMAcquisition.getMultiCameraNumChannels() == n && !mMAcquisition.getImageCache().isFinished()) {
                    bl = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl) {
            JSONObject jSONObject3;
            string = this.createNewAlbum();
            this.openAcquisition(string, "", true, false);
            mMAcquisition = this.getAcquisition(string);
            mMAcquisition.setDimensions(2, n, 1, 1);
            mMAcquisition.setImagePhysicalDimensions(n5, n4, n3, n2, n);
            try {
                jSONObject3 = new JSONObject();
                jSONObject3.put("PixelType", jSONObject2.get("PixelType"));
                mMAcquisition.setSummaryProperties(jSONObject3);
            }
            catch (JSONException jSONException) {
                ReportingUtils.logError(jSONException);
            }
            mMAcquisition.initialize();
            jSONObject3 = mMAcquisition.getAcquisitionWindow().getImagePlus().getWindow();
            object = Preferences.userNodeForPackage(this.getClass());
            jSONObject3.addWindowListener(new WindowAdapter((ImageWindow)jSONObject3, (Preferences)object){
                final /* synthetic */ ImageWindow val$win;
                final /* synthetic */ Preferences val$prefs;
                {
                    this.val$win = imageWindow;
                    this.val$prefs = preferences;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    Point point = this.val$win.getLocation();
                    this.val$prefs.putInt(AcquisitionManager.ALBUM_WIN_X, point.x);
                    this.val$prefs.putInt(AcquisitionManager.ALBUM_WIN_Y, point.y);
                }
            });
            jSONObject3.setLocation(((Preferences)object).getInt(ALBUM_WIN_X, 0), ((Preferences)object).getInt(ALBUM_WIN_Y, 0));
        }
        int n6 = 1 + mMAcquisition.getLastAcquiredFrame();
        if (n > 1) {
            try {
                object = mMAcquisition.getImageCache().getLastImageTags();
                int n7 = -1;
                if (object != null) {
                    n7 = MDUtils.getChannelIndex((JSONObject)object);
                }
                if (n7 == 0) {
                    n6 = mMAcquisition.getLastAcquiredFrame();
                }
            }
            catch (JSONException jSONException) {
                ReportingUtils.logError(jSONException);
            }
        }
        try {
            MDUtils.setFrameIndex(jSONObject2, n6);
        }
        catch (JSONException jSONException) {
            ReportingUtils.showError(jSONException);
        }
        mMAcquisition.insertImage(taggedImage);
        if (n == 1) {
            try {
                if (MDUtils.getFrameIndex(jSONObject2) == 0 && jSONObject != null) {
                    this.copyDisplaySettings(mMAcquisition, jSONObject);
                }
            }
            catch (JSONException jSONException) {
                ReportingUtils.logError(jSONException);
            }
        } else {
            try {
                if (n > 1 && MDUtils.getChannelIndex(jSONObject2) == n - 1 && mMAcquisition.getLastAcquiredFrame() == 0 && jSONObject != null) {
                    this.copyDisplaySettings(mMAcquisition, jSONObject);
                }
            }
            catch (JSONException jSONException) {
                ReportingUtils.logError(jSONException);
            }
        }
        return string;
    }

    private void copyDisplaySettings(MMAcquisition mMAcquisition, JSONObject jSONObject) {
        if (jSONObject == null) {
            return;
        }
        ImageCache imageCache = mMAcquisition.getImageCache();
        for (int i = 0; i < imageCache.getNumChannels(); ++i) {
            try {
                JSONObject jSONObject2 = (JSONObject)((JSONArray)jSONObject.get("Channels")).get(i);
                int n = jSONObject2.getInt("Color");
                int n2 = jSONObject2.getInt("Min");
                int n3 = jSONObject2.getInt("Max");
                double d = jSONObject2.getDouble("Gamma");
                String string = jSONObject2.getString("Name");
                int n4 = jSONObject2.has("HistogramMax") ? jSONObject2.getInt("HistogramMax") : -1;
                int n5 = 1;
                if (jSONObject2.has("DisplayMode")) {
                    n5 = jSONObject2.getInt("DisplayMode");
                }
                imageCache.storeChannelDisplaySettings(i, n2, n3, d, n4, n5);
                mMAcquisition.getAcquisitionWindow().setChannelHistogramDisplayMax(i, n4);
                mMAcquisition.getAcquisitionWindow().setChannelContrast(i, n2, n3, d);
                mMAcquisition.getAcquisitionWindow().setDisplayMode(n5);
                mMAcquisition.setChannelColor(i, n);
                mMAcquisition.setChannelName(i, string);
                continue;
            }
            catch (JSONException jSONException) {
                ReportingUtils.logError("Something wrong with Display and Comments");
                continue;
            }
            catch (MMScriptException mMScriptException) {
                ReportingUtils.logError(mMScriptException);
            }
        }
    }

    public String[] getAcqusitionNames() {
        Set<String> set = this.acqs_.keySet();
        String[] stringArray = new String[set.size()];
        return set.toArray(stringArray);
    }

    public String createAcquisition(JSONObject jSONObject, boolean bl, AcquisitionEngine acquisitionEngine) {
        String string = this.getUniqueAcquisitionName("Acq");
        this.acqs_.put(string, new MMAcquisition(string, jSONObject, bl, acquisitionEngine));
        return string;
    }
}

