/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.micromanager.utils.ReportingUtils;

public class RegistrationDlg
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static final String REGISTRATION = "registered";
    public static final String REGISTRATION_NEVER = "reg_never";
    public static final String REGISTRATION_ATTEMPTS = "registration_attempts";
    public static final String REGISTRATION_NAME = "reg_name";
    public static final String REGISTRATION_INST = "reg_institution";
    private JTextArea welcomeTextArea_;
    private JTextField email_;
    private JTextField inst_;
    private JTextField name_;
    private Preferences prefs_;

    public RegistrationDlg(Preferences preferences) {
        this.prefs_ = preferences;
        this.incrementRegistrationAttempts();
        this.setModal(true);
        this.setUndecorated(true);
        this.setTitle("Micro-Manager Registration");
        this.getContentPane().setLayout(null);
        this.setResizable(false);
        this.setBounds(100, 100, 398, 299);
        Dimension dimension = this.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dimension2.width / 2 - dimension.width / 2, dimension2.height / 2 - dimension.height / 2);
        JLabel jLabel = new JLabel();
        jLabel.setText("Name");
        jLabel.setBounds(10, 198, 65, 14);
        this.getContentPane().add(jLabel);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Institution");
        jLabel2.setBounds(10, 220, 65, 14);
        this.getContentPane().add(jLabel2);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Email");
        jLabel3.setBounds(10, 240, 65, 14);
        this.getContentPane().add(jLabel3);
        this.name_ = new JTextField();
        this.name_.setBounds(77, 195, 256, 20);
        this.getContentPane().add(this.name_);
        this.inst_ = new JTextField();
        this.inst_.setBounds(77, 218, 256, 20);
        this.getContentPane().add(this.inst_);
        this.email_ = new JTextField();
        this.email_.setBounds(77, 240, 256, 20);
        this.getContentPane().add(this.email_);
        JButton jButton = new JButton();
        jButton.setFont(new Font("", 1, 12));
        jButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void actionPerformed(ActionEvent actionEvent) {
                block11: {
                    block9: {
                        if (RegistrationDlg.this.name_.getText().length() == 0 || RegistrationDlg.this.email_.getText().length() == 0) {
                            JOptionPane.showMessageDialog(RegistrationDlg.this, "Name and email fields can't be empty.");
                            return;
                        }
                        try {
                            try {
                                RegistrationDlg.this.prefs_.put(RegistrationDlg.REGISTRATION_NAME, RegistrationDlg.this.name_.getText());
                                RegistrationDlg.this.prefs_.put(RegistrationDlg.REGISTRATION_INST, RegistrationDlg.this.inst_.getText());
                                String string = RegistrationDlg.this.name_.getText().replaceAll("[ \t]", "%20");
                                string = string.replaceAll("[&]", "%20and%20");
                                String string2 = RegistrationDlg.this.inst_.getText().replaceAll("[ \t]", "%20");
                                string2 = string2.replaceAll("[&]", "%20and%20");
                                String string3 = RegistrationDlg.this.email_.getText().replaceAll("[ \t]", "%20");
                                string3 = string3.replaceAll("[&]", "%20and%20");
                                String string4 = "http://valelab.ucsf.edu/micro-manager-registration.php?Name=" + string + "&Institute=" + string2 + "&email=" + string3;
                                URL uRL = new URL(string4);
                                InputStream inputStream = uRL.openStream();
                                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                                String string5 = bufferedReader.readLine();
                                if (string5.compareTo("SUCCESS") == 0) break block9;
                                JOptionPane.showMessageDialog(RegistrationDlg.this, "Registration did not succeed. You will be prompted again next time.");
                                RegistrationDlg.this.dispose();
                                Object var11_15 = null;
                            }
                            catch (UnknownHostException unknownHostException) {
                                ReportingUtils.showError(unknownHostException, "Registration did not succeed. You are probably not connected to the Internet.\nYou will be prompted again next time you start.");
                                Object var11_17 = null;
                                RegistrationDlg.this.dispose();
                                break block11;
                            }
                            catch (MalformedURLException malformedURLException) {
                                ReportingUtils.showError(malformedURLException);
                                Object var11_18 = null;
                                RegistrationDlg.this.dispose();
                                break block11;
                            }
                            catch (IOException iOException) {
                                ReportingUtils.showError(iOException);
                                Object var11_19 = null;
                                RegistrationDlg.this.dispose();
                                break block11;
                            }
                            catch (SecurityException securityException) {
                                ReportingUtils.showError(securityException, "\nThe program failed to save registration status.\nMost likely you are not logged in with administrator privileges.\nPlease try registering again using the administrator's account.");
                                Object var11_20 = null;
                                RegistrationDlg.this.dispose();
                                break block11;
                            }
                            catch (Exception exception) {
                                ReportingUtils.logError(exception);
                                Object var11_21 = null;
                                RegistrationDlg.this.dispose();
                                break block11;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var11_22 = null;
                            RegistrationDlg.this.dispose();
                            throw throwable;
                        }
                        RegistrationDlg.this.dispose();
                        return;
                    }
                    Object var11_16 = null;
                    RegistrationDlg.this.dispose();
                }
                RegistrationDlg.this.prefs_.putBoolean(RegistrationDlg.REGISTRATION, true);
            }
        });
        jButton.setText("OK");
        jButton.setBounds(50, 266, 100, 23);
        this.getContentPane().add(jButton);
        this.welcomeTextArea_ = new JTextArea();
        this.welcomeTextArea_.setMargin(new Insets(10, 10, 10, 10));
        this.welcomeTextArea_.setLineWrap(true);
        this.welcomeTextArea_.setBackground(new Color(192, 192, 192));
        this.welcomeTextArea_.setFocusable(false);
        this.welcomeTextArea_.setEditable(false);
        this.welcomeTextArea_.setFont(new Font("Arial", 0, 12));
        this.welcomeTextArea_.setWrapStyleWord(true);
        this.welcomeTextArea_.setText("Welcome to Micro-Manager.\n\nPlease take a minute to let us know that you are using this software. The information you enter will only be used to estimate how many people use Micro-Manager. Accurate tracking of the number of users is very important for our funding efforts and essential for the long-term survival of Micro-Manager.\n\nYour information will never be made public or given away to third parties, however, we might very occasionally inform you of Micro-Manager developments.");
        this.welcomeTextArea_.setBounds(10, 10, 378, 179);
        this.getContentPane().add(this.welcomeTextArea_);
        JButton jButton2 = new JButton();
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(RegistrationDlg.this, "You choose to postpone registration.\nThis prompt will appear again next time you start the application.");
                RegistrationDlg.this.prefs_.putBoolean(RegistrationDlg.REGISTRATION_NEVER, false);
                RegistrationDlg.this.dispose();
            }
        });
        jButton2.setText("Later");
        jButton2.setBounds(160, 266, 100, 23);
        this.getContentPane().add(jButton2);
        if (this.getRegistrationAttempts() > 1) {
            JButton jButton3 = new JButton();
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JOptionPane.showMessageDialog(RegistrationDlg.this, "You have chosen never to register. \nIf you change your mind in the future, please\nchoose the \"Register\" option in the Help menu.");
                    RegistrationDlg.this.prefs_.putBoolean(RegistrationDlg.REGISTRATION_NEVER, true);
                    RegistrationDlg.this.dispose();
                }
            });
            jButton3.setText("Never");
            jButton3.setBounds(270, 266, 100, 23);
            this.getContentPane().add(jButton3);
        }
    }

    private int incrementRegistrationAttempts() {
        int n = this.getRegistrationAttempts();
        this.prefs_.putInt(REGISTRATION_ATTEMPTS, ++n);
        return n;
    }

    public int getRegistrationAttempts() {
        return this.prefs_.getInt(REGISTRATION_ATTEMPTS, 0);
    }
}

