/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import bsh.EvalError;
import bsh.Interpreter;
import com.swtdesigner.SwingResourceManager;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.Roi;
import ij.plugin.BrowserLauncher;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import mmcorej.CMMCore;
import mmcorej.DeviceType;
import mmcorej.MMCoreJ;
import mmcorej.MMEventCallback;
import mmcorej.StrVector;
import mmcorej.TaggedImage;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.AcqControlDlg;
import org.micromanager.CalibrationListDlg;
import org.micromanager.ConfigGroupPad;
import org.micromanager.ConfigPadButtonPanel;
import org.micromanager.MMAboutDlg;
import org.micromanager.MMIntroDlg;
import org.micromanager.MMOptions;
import org.micromanager.OptionsDlg;
import org.micromanager.PositionListDlg;
import org.micromanager.PropertyEditor;
import org.micromanager.RegistrationDlg;
import org.micromanager.ReportProblemDialog;
import org.micromanager.ScriptPanel;
import org.micromanager.acquisition.AcquisitionManager;
import org.micromanager.acquisition.AcquisitionWrapperEngine;
import org.micromanager.acquisition.LiveModeTimer;
import org.micromanager.acquisition.MMAcquisition;
import org.micromanager.acquisition.MetadataPanel;
import org.micromanager.acquisition.ProcessorStack;
import org.micromanager.acquisition.TaggedImageQueue;
import org.micromanager.acquisition.TaggedImageStorageDiskDefault;
import org.micromanager.acquisition.TaggedImageStorageMultipageTiff;
import org.micromanager.acquisition.VirtualAcquisitionDisplay;
import org.micromanager.api.AcquisitionEngine;
import org.micromanager.api.Autofocus;
import org.micromanager.api.DeviceControlGUI;
import org.micromanager.api.IAcquisitionEngine2010;
import org.micromanager.api.ImageCache;
import org.micromanager.api.MMListenerInterface;
import org.micromanager.api.MMPlugin;
import org.micromanager.api.ScriptInterface;
import org.micromanager.conf2.ConfiguratorDlg2;
import org.micromanager.conf2.MMConfigFileException;
import org.micromanager.conf2.MicroscopeModel;
import org.micromanager.graph.GraphData;
import org.micromanager.graph.GraphFrame;
import org.micromanager.navigation.CenterAndDragListener;
import org.micromanager.navigation.PositionList;
import org.micromanager.navigation.XYZKeyListener;
import org.micromanager.navigation.ZWheelListener;
import org.micromanager.utils.AutofocusManager;
import org.micromanager.utils.ContrastSettings;
import org.micromanager.utils.FileDialogs;
import org.micromanager.utils.GUIColors;
import org.micromanager.utils.GUIUtils;
import org.micromanager.utils.HotKeys;
import org.micromanager.utils.HotKeysDialog;
import org.micromanager.utils.ImageUtils;
import org.micromanager.utils.JavaUtils;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMException;
import org.micromanager.utils.MMKeyDispatcher;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.SnapLiveContrastSettings;
import org.micromanager.utils.TextUtils;
import org.micromanager.utils.TooltipTextMaker;
import org.micromanager.utils.WaitDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MMStudioMainFrame
extends JFrame
implements ScriptInterface,
DeviceControlGUI {
    private static final String MICRO_MANAGER_TITLE = "Micro-Manager";
    private static final String VERSION = "1.4.13";
    private static final long serialVersionUID = 3556500289598574541L;
    private static final String MAIN_FRAME_X = "x";
    private static final String MAIN_FRAME_Y = "y";
    private static final String MAIN_FRAME_WIDTH = "width";
    private static final String MAIN_FRAME_HEIGHT = "height";
    private static final String MAIN_FRAME_DIVIDER_POS = "divider_pos";
    private static final String MAIN_EXPOSURE = "exposure";
    private static final String MAIN_SAVE_METHOD = "saveMethod";
    private static final String SYSTEM_CONFIG_FILE = "sysconfig_file";
    private static final String OPEN_ACQ_DIR = "openDataDir";
    private static final String SCRIPT_CORE_OBJECT = "mmc";
    private static final String SCRIPT_ACQENG_OBJECT = "acq";
    private static final String SCRIPT_GUI_OBJECT = "gui";
    private static final String AUTOFOCUS_DEVICE = "autofocus_device";
    private static final String MOUSE_MOVES_STAGE = "mouse_moves_stage";
    private static final int TOOLTIP_DISPLAY_DURATION_MILLISECONDS = 15000;
    private static final int TOOLTIP_DISPLAY_INITIAL_DELAY_MILLISECONDS = 2000;
    private static final String CFGFILE_ENTRY_BASE = "CFGFileEntry";
    private JComboBox comboBinning_;
    private JComboBox shutterComboBox_;
    private JTextField textFieldExp_;
    private JLabel labelImageDimensions_;
    private JToggleButton toggleButtonLive_;
    private JButton toAlbumButton_;
    private JCheckBox autoShutterCheckBox_;
    private MMOptions options_;
    private boolean runsAsPlugin_;
    private JCheckBoxMenuItem centerAndDragMenuItem_;
    private JButton buttonSnap_;
    private JButton buttonAutofocus_;
    private JButton buttonAutofocusTools_;
    private JToggleButton toggleButtonShutter_;
    private GUIColors guiColors_;
    private GraphFrame profileWin_;
    private PropertyEditor propertyBrowser_;
    private CalibrationListDlg calibrationListDlg_;
    private AcqControlDlg acqControlWin_;
    private ReportProblemDialog reportProblemDialog_;
    private JMenu pluginMenu_;
    private ArrayList<PluginItem> plugins_;
    private List<MMListenerInterface> MMListeners_ = Collections.synchronizedList(new ArrayList());
    private List<Component> MMFrames_ = Collections.synchronizedList(new ArrayList());
    private AutofocusManager afMgr_;
    private static final String DEFAULT_CONFIG_FILE_NAME = "MMConfig_demo.cfg";
    private ArrayList<String> MRUConfigFiles_;
    private static final int maxMRUCfgs_ = 5;
    private String sysConfigFile_;
    private String startupScriptFile_;
    private String sysStateFile_ = "MMSystemState.cfg";
    private ConfigGroupPad configPad_;
    private LiveModeTimer liveModeTimer_;
    private GraphData lineProfileData_;
    private String cameraLabel_;
    private String zStageLabel_;
    private String shutterLabel_;
    private String xyStageLabel_;
    private Preferences mainPrefs_;
    private Preferences systemPrefs_;
    private Preferences colorPrefs_;
    private CMMCore core_;
    private AcquisitionEngine engine_;
    private PositionList posList_;
    private PositionListDlg posListDlg_;
    private String openAcqDirectory_ = "";
    private boolean running_;
    private boolean configChanged_ = false;
    private StrVector shutters_ = null;
    private JButton saveConfigButton_;
    private ScriptPanel scriptPanel_;
    private HotKeys hotKeys_;
    private CenterAndDragListener centerAndDragListener_;
    private ZWheelListener zWheelListener_;
    private XYZKeyListener xyzKeyListener_;
    private AcquisitionManager acqMgr_;
    private static VirtualAcquisitionDisplay simpleDisplay_;
    private SnapLiveContrastSettings simpleContrastSettings_;
    private Color[] multiCameraColors_ = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.YELLOW, Color.CYAN};
    private int snapCount_ = -1;
    private boolean liveModeSuspended_;
    public Font defaultScriptFont_ = null;
    public static final String SIMPLE_ACQ = "Snap/Live Window";
    public static FileDialogs.FileType MM_CONFIG_FILE;
    private static MMStudioMainFrame gui_;
    private CoreEventCallback cb_;
    private final Object shutdownLock_ = new Object();
    private JMenuBar menuBar_;
    private ConfigPadButtonPanel configPadButtonPanel_;
    private final JMenu switchConfigurationMenu_;
    private final MetadataPanel metadataPanel_;
    public static FileDialogs.FileType MM_DATA_SET;
    private Thread acquisitionEngine2010LoadingThread = null;
    private Class acquisitionEngine2010Class = null;
    private IAcquisitionEngine2010 acquisitionEngine2010 = null;
    private final JSplitPane splitPane_;
    private volatile boolean ignorePropertyChanges_;
    public static AtomicBoolean seriousErrorReported_;
    private JButton setRoiButton_;
    private JButton clearRoiButton_;
    private StaticInfo staticInfo_ = new StaticInfo();

    @Override
    public ImageWindow getImageWin() {
        return this.getSnapLiveWin();
    }

    @Override
    public boolean isSeriousErrorReported() {
        return seriousErrorReported_.get();
    }

    @Override
    public ImageWindow getSnapLiveWin() {
        return simpleDisplay_.getHyperImage().getWindow();
    }

    public static VirtualAcquisitionDisplay getSimpleDisplay() {
        return simpleDisplay_;
    }

    public static void createSimpleDisplay(String string, ImageCache imageCache) throws MMScriptException {
        simpleDisplay_ = new VirtualAcquisitionDisplay(imageCache, string);
    }

    public void checkSimpleAcquisition() {
        if (this.core_.getCameraDevice().length() == 0) {
            ReportingUtils.showError("No camera configured");
            return;
        }
        int n = (int)this.core_.getImageWidth();
        int n2 = (int)this.core_.getImageHeight();
        int n3 = (int)this.core_.getBytesPerPixel();
        int n4 = (int)this.core_.getImageBitDepth();
        int n5 = (int)this.core_.getNumberOfCameraChannels();
        try {
            if (this.acquisitionExists(SIMPLE_ACQ).booleanValue() && (this.getAcquisitionImageWidth(SIMPLE_ACQ) != n || this.getAcquisitionImageHeight(SIMPLE_ACQ) != n2 || this.getAcquisitionImageByteDepth(SIMPLE_ACQ) != n3 || this.getAcquisitionImageBitDepth(SIMPLE_ACQ) != n4 || this.getAcquisitionMultiCamNumChannels(SIMPLE_ACQ) != n5)) {
                this.closeAcquisitionWindow(SIMPLE_ACQ);
            }
            if (!this.acquisitionExists(SIMPLE_ACQ).booleanValue()) {
                this.openAcquisition(SIMPLE_ACQ, "", 1, n5, 1, true);
                if (n5 > 1) {
                    for (long i = 0L; i < (long)n5; ++i) {
                        String string = this.core_.getCameraChannelName(i);
                        int n6 = this.multiCameraColors_[(int)i % this.multiCameraColors_.length].getRGB();
                        this.setChannelColor(SIMPLE_ACQ, (int)i, this.getChannelColor(string, n6));
                        this.setChannelName(SIMPLE_ACQ, (int)i, string);
                    }
                }
                this.initializeSimpleAcquisition(SIMPLE_ACQ, n, n2, n3, n4, n5);
                this.getAcquisition(SIMPLE_ACQ).promptToSave(false);
                this.getAcquisition(SIMPLE_ACQ).toFront();
            }
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
        }
    }

    public void checkSimpleAcquisition(TaggedImage taggedImage) {
        try {
            JSONObject jSONObject = taggedImage.tags;
            int n = MDUtils.getWidth(jSONObject);
            int n2 = MDUtils.getHeight(jSONObject);
            int n3 = MDUtils.getDepth(jSONObject);
            int n4 = MDUtils.getBitDepth(jSONObject);
            int n5 = (int)this.core_.getNumberOfCameraChannels();
            if (this.acquisitionExists(SIMPLE_ACQ).booleanValue() && (this.getAcquisitionImageWidth(SIMPLE_ACQ) != n || this.getAcquisitionImageHeight(SIMPLE_ACQ) != n2 || this.getAcquisitionImageByteDepth(SIMPLE_ACQ) != n3 || this.getAcquisitionImageBitDepth(SIMPLE_ACQ) != n4 || this.getAcquisitionMultiCamNumChannels(SIMPLE_ACQ) != n5)) {
                this.closeAcquisitionWindow(SIMPLE_ACQ);
            }
            if (!this.acquisitionExists(SIMPLE_ACQ).booleanValue()) {
                this.openAcquisition(SIMPLE_ACQ, "", 1, n5, 1, true);
                if (n5 > 1) {
                    for (long i = 0L; i < (long)n5; ++i) {
                        String string = this.core_.getCameraChannelName(i);
                        int n6 = this.multiCameraColors_[(int)i % this.multiCameraColors_.length].getRGB();
                        this.setChannelColor(SIMPLE_ACQ, (int)i, this.getChannelColor(string, n6));
                        this.setChannelName(SIMPLE_ACQ, (int)i, string);
                    }
                }
                this.initializeSimpleAcquisition(SIMPLE_ACQ, n, n2, n3, n4, n5);
                this.getAcquisition(SIMPLE_ACQ).promptToSave(false);
                this.getAcquisition(SIMPLE_ACQ).toFront();
            }
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
        }
    }

    public void saveSimpleContrastSettings(ContrastSettings contrastSettings, int n, String string) {
        this.simpleContrastSettings_.saveSettings(contrastSettings, n, string);
    }

    public ContrastSettings loadSimpleContrastSettigns(String string, int n) {
        try {
            return this.simpleContrastSettings_.loadSettings(string, n);
        }
        catch (MMException mMException) {
            ReportingUtils.logError(mMException);
            return null;
        }
    }

    public void saveChannelColor(String string, int n) {
        if (this.colorPrefs_ != null) {
            this.colorPrefs_.putInt("Color_" + string, n);
        }
    }

    public Color getChannelColor(String string, int n) {
        if (this.colorPrefs_ != null) {
            n = this.colorPrefs_.getInt("Color_" + string, n);
        }
        return new Color(n);
    }

    @Override
    public void enableRoiButtons(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MMStudioMainFrame.this.setRoiButton_.setEnabled(bl);
                MMStudioMainFrame.this.clearRoiButton_.setEnabled(bl);
            }
        });
    }

    public void copyFromLiveModeToAlbum(VirtualAcquisitionDisplay virtualAcquisitionDisplay) throws MMScriptException, JSONException {
        ImageCache imageCache = virtualAcquisitionDisplay.getImageCache();
        int n = imageCache.getSummaryMetadata().getInt("Channels");
        if (n == 1) {
            this.addToAlbum(imageCache.getImage(0, 0, 0, 0), imageCache.getDisplayAndComments());
        } else {
            for (int i = 0; i < n; ++i) {
                this.addToAlbum(imageCache.getImage(i, 0, 0, 0), imageCache.getDisplayAndComments());
            }
        }
    }

    private void initializeHelpMenu() {
        Container container;
        JMenu jMenu = new JMenu();
        jMenu.setText("Help");
        this.menuBar_.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BrowserLauncher.openURL((String)"http://valelab.ucsf.edu/~MM/MMwiki/index.php/Micro-Manager_User%27s_Guide");
                }
                catch (IOException iOException) {
                    ReportingUtils.showError(iOException);
                }
            }
        });
        jMenuItem.setText("User's Guide");
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem();
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BrowserLauncher.openURL((String)"http://valelab.ucsf.edu/~MM/MMwiki/index.php/Micro-Manager_Configuration_Guide");
                }
                catch (IOException iOException) {
                    ReportingUtils.showError(iOException);
                }
            }
        });
        jMenuItem2.setText("Configuration Guide");
        jMenu.add(jMenuItem2);
        if (!this.systemPrefs_.getBoolean("registered", false)) {
            container = new JMenuItem();
            ((AbstractButton)container).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        RegistrationDlg registrationDlg = new RegistrationDlg(MMStudioMainFrame.this.systemPrefs_);
                        registrationDlg.setVisible(true);
                    }
                    catch (Exception exception) {
                        ReportingUtils.showError(exception);
                    }
                }
            });
            ((AbstractButton)container).setText("Register your copy of Micro-Manager...");
            jMenu.add((JMenuItem)container);
        }
        container = this;
        JMenuItem jMenuItem3 = new JMenuItem();
        jMenuItem3.addActionListener(new ActionListener((MMStudioMainFrame)container){
            final /* synthetic */ MMStudioMainFrame val$thisFrame;
            {
                this.val$thisFrame = mMStudioMainFrame2;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (null == MMStudioMainFrame.this.reportProblemDialog_) {
                    MMStudioMainFrame.this.reportProblemDialog_ = new ReportProblemDialog(MMStudioMainFrame.this.core_, this.val$thisFrame, MMStudioMainFrame.this.options_);
                    this.val$thisFrame.addMMBackgroundListener(MMStudioMainFrame.this.reportProblemDialog_);
                    MMStudioMainFrame.this.reportProblemDialog_.setBackground(((MMStudioMainFrame)MMStudioMainFrame.this).guiColors_.background.get(((MMStudioMainFrame)MMStudioMainFrame.this).options_.displayBackground_));
                }
                MMStudioMainFrame.this.reportProblemDialog_.setVisible(true);
            }
        });
        jMenuItem3.setText("Report Problem...");
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem();
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMAboutDlg mMAboutDlg = new MMAboutDlg();
                String string = "MM Studio version: 1.4.13";
                string = string + "\n" + MMStudioMainFrame.this.core_.getVersionInfo();
                string = string + "\n" + MMStudioMainFrame.this.core_.getAPIVersionInfo();
                string = string + "\nUser: " + MMStudioMainFrame.this.core_.getUserId();
                string = string + "\nHost: " + MMStudioMainFrame.this.core_.getHostName();
                mMAboutDlg.setVersionInfo(string);
                mMAboutDlg.setVisible(true);
            }
        });
        jMenuItem4.setText("About Micromanager");
        jMenu.add(jMenuItem4);
        this.menuBar_.validate();
    }

    private void updateSwitchConfigurationMenu() {
        this.switchConfigurationMenu_.removeAll();
        for (final String string : this.MRUConfigFiles_) {
            if (string.equals(this.sysConfigFile_)) continue;
            JMenuItem jMenuItem = new JMenuItem();
            jMenuItem.setText(string);
            jMenuItem.addActionListener(new ActionListener(){
                String theConfigFile;
                {
                    this.theConfigFile = string;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    MMStudioMainFrame.this.sysConfigFile_ = this.theConfigFile;
                    MMStudioMainFrame.this.loadSystemConfiguration();
                    MMStudioMainFrame.this.mainPrefs_.put(MMStudioMainFrame.SYSTEM_CONFIG_FILE, MMStudioMainFrame.this.sysConfigFile_);
                }
            });
            this.switchConfigurationMenu_.add(jMenuItem);
        }
    }

    @Override
    public void addMMListener(MMListenerInterface mMListenerInterface) {
        if (this.MMListeners_.contains(mMListenerInterface)) {
            return;
        }
        this.MMListeners_.add(mMListenerInterface);
    }

    @Override
    public void removeMMListener(MMListenerInterface mMListenerInterface) {
        if (!this.MMListeners_.contains(mMListenerInterface)) {
            return;
        }
        this.MMListeners_.remove(mMListenerInterface);
    }

    @Override
    public void addMMBackgroundListener(Component component) {
        if (this.MMFrames_.contains(component)) {
            return;
        }
        this.MMFrames_.add(component);
    }

    @Override
    public void removeMMBackgroundListener(Component component) {
        if (!this.MMFrames_.contains(component)) {
            return;
        }
        this.MMFrames_.remove(component);
    }

    @Override
    public void runBurstAcquisition() throws MMScriptException {
        double d = this.engine_.getFrameIntervalMs();
        int n = this.engine_.getNumFrames();
        boolean bl = this.engine_.isZSliceSettingEnabled();
        boolean bl2 = this.engine_.isChannelsSettingEnabled();
        this.engine_.enableZSliceSetting(false);
        this.engine_.setFrames(n, 0.0);
        this.engine_.enableChannelsSetting(false);
        try {
            this.engine_.acquire();
        }
        catch (MMException mMException) {
            throw new MMScriptException(mMException);
        }
        this.engine_.setFrames(n, d);
        this.engine_.enableZSliceSetting(bl);
        this.engine_.enableChannelsSetting(bl2);
    }

    @Override
    public void runBurstAcquisition(int n) throws MMScriptException {
        int n2 = this.engine_.getNumFrames();
        double d = this.engine_.getFrameIntervalMs();
        this.engine_.setFrames(n, 0.0);
        this.runBurstAcquisition();
        this.engine_.setFrames(n2, d);
    }

    @Override
    public void runBurstAcquisition(int n, String string, String string2) throws MMScriptException {
        String string3 = this.engine_.getRootName();
        this.engine_.setDirName(string);
        this.engine_.setRootName(string2);
        this.runBurstAcquisition(n);
        this.engine_.setRootName(string3);
    }

    @Override
    public void logStartupProperties() {
        this.core_.enableDebugLog(this.options_.debugLogEnabled_);
        this.core_.logMessage("MM Studio version: " + this.getVersion());
        this.core_.logMessage(this.core_.getVersionInfo());
        this.core_.logMessage(this.core_.getAPIVersionInfo());
        this.core_.logMessage("Operating System: " + System.getProperty("os.name") + " " + System.getProperty("os.version"));
        this.core_.logMessage("JVM: " + System.getProperty("java.vm.name") + ", version " + System.getProperty("java.version") + "; " + System.getProperty("sun.arch.data.model") + " bit");
    }

    @Override
    public void startBurstAcquisition() throws MMScriptException {
        this.runAcquisition();
    }

    @Override
    public boolean isBurstAcquisitionRunning() throws MMScriptException {
        if (this.engine_ == null) {
            return false;
        }
        return this.engine_.isAcquisitionRunning();
    }

    private void startLoadingPipelineClass() {
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.acquisitionEngine2010LoadingThread = new Thread("Pipeline Class loading thread"){

            public void run() {
                try {
                    MMStudioMainFrame.this.acquisitionEngine2010Class = Class.forName("org.micromanager.AcquisitionEngine2010");
                }
                catch (Exception exception) {
                    ReportingUtils.logError(exception);
                    MMStudioMainFrame.this.acquisitionEngine2010Class = null;
                }
            }
        };
        this.acquisitionEngine2010LoadingThread.start();
    }

    @Override
    public ImageCache getAcquisitionImageCache(String string) throws MMScriptException {
        return this.getAcquisition(string).getImageCache();
    }

    public void runDisplayThread(BlockingQueue blockingQueue, final DisplayImageRoutine displayImageRoutine) {
        final BlockingQueue blockingQueue2 = ProcessorStack.run(blockingQueue, this.getAcquisitionEngine().getImageProcessors());
        new Thread("Display thread"){

            public void run() {
                try {
                    TaggedImage taggedImage = null;
                    do {
                        if ((taggedImage = (TaggedImage)blockingQueue2.take()) == TaggedImageQueue.POISON) continue;
                        displayImageRoutine.show(taggedImage);
                    } while (taggedImage != TaggedImageQueue.POISON);
                }
                catch (InterruptedException interruptedException) {
                    ReportingUtils.logError(interruptedException);
                }
            }
        }.start();
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            MMStudioMainFrame mMStudioMainFrame = new MMStudioMainFrame(false);
            mMStudioMainFrame.setVisible(true);
            mMStudioMainFrame.setDefaultCloseOperation(0);
        }
        catch (Throwable throwable) {
            ReportingUtils.showError(throwable, "A java error has caused Micro-Manager to exit.");
            System.exit(1);
        }
    }

    public MMStudioMainFrame(boolean bl) {
        JMenuItem jMenuItem;
        int n;
        boolean bl2;
        this.startLoadingPipelineClass();
        this.options_ = new MMOptions();
        try {
            this.options_.loadSettings();
        }
        catch (NullPointerException nullPointerException) {
            ReportingUtils.logError(nullPointerException);
        }
        this.guiColors_ = new GUIColors();
        this.plugins_ = new ArrayList();
        gui_ = this;
        this.runsAsPlugin_ = bl;
        this.setIconImage(SwingResourceManager.getImage(MMStudioMainFrame.class, "icons/microscope.gif"));
        this.running_ = true;
        this.acqMgr_ = new AcquisitionManager();
        this.simpleContrastSettings_ = new SnapLiveContrastSettings();
        this.sysConfigFile_ = System.getProperty("user.dir") + "/" + DEFAULT_CONFIG_FILE_NAME;
        this.startupScriptFile_ = this.options_.startupScript_.length() > 0 ? System.getProperty("user.dir") + "/" + this.options_.startupScript_ : "";
        ReportingUtils.SetContainingFrame(gui_);
        try {
            this.mainPrefs_ = Preferences.userNodeForPackage(this.getClass());
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
        this.systemPrefs_ = this.mainPrefs_;
        this.colorPrefs_ = this.mainPrefs_.node(this.mainPrefs_.absolutePath() + "/" + "ColorSettings");
        try {
            Preferences preferences = Preferences.systemNodeForPackage(this.getClass());
            if (null != preferences && JavaUtils.backingStoreAvailable(preferences)) {
                this.systemPrefs_ = preferences;
            }
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
        boolean bl3 = bl2 = this.mainPrefs_.getBoolean("registered", false) || this.mainPrefs_.getBoolean("reg_never", false);
        if (!bl2) {
            int n2 = n = this.systemPrefs_.getBoolean("registered", false) || this.systemPrefs_.getBoolean("reg_never", false) ? 1 : 0;
            if (n == 0) {
                RegistrationDlg registrationDlg = new RegistrationDlg(this.systemPrefs_);
                registrationDlg.setVisible(true);
            }
        }
        n = this.mainPrefs_.getInt(MAIN_FRAME_X, 100);
        int n3 = this.mainPrefs_.getInt(MAIN_FRAME_Y, 100);
        int n4 = this.mainPrefs_.getInt(MAIN_FRAME_WIDTH, 644);
        int n5 = this.mainPrefs_.getInt(MAIN_FRAME_HEIGHT, 570);
        int n6 = this.mainPrefs_.getInt(MAIN_FRAME_DIVIDER_POS, 200);
        this.openAcqDirectory_ = this.mainPrefs_.get(OPEN_ACQ_DIR, "");
        try {
            ImageUtils.setImageStorageClass(Class.forName(this.mainPrefs_.get(MAIN_SAVE_METHOD, ImageUtils.getImageStorageClass().getName())));
        }
        catch (ClassNotFoundException classNotFoundException) {
            ReportingUtils.logError(classNotFoundException, "Class not found error.  Should never happen");
        }
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.setDismissDelay(15000);
        toolTipManager.setInitialDelay(2000);
        this.setBounds(n, n3, n4, n5);
        this.setExitStrategy(this.options_.closeOnExit_);
        this.setTitle("Micro-Manager 1.4.13");
        this.setBackground(this.guiColors_.background.get(this.options_.displayBackground_));
        SpringLayout springLayout = new SpringLayout();
        this.setMinimumSize(new Dimension(605, 480));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(springLayout);
        jPanel.setMinimumSize(new Dimension(580, 195));
        class ListeningJPanel
        extends JPanel
        implements AncestorListener {
            ListeningJPanel() {
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorAdded(AncestorEvent ancestorEvent) {
            }
        }
        ListeningJPanel listeningJPanel = new ListeningJPanel();
        listeningJPanel.setLayout(springLayout);
        this.splitPane_ = new JSplitPane(0, true, jPanel, listeningJPanel);
        this.splitPane_.setBorder(BorderFactory.createEmptyBorder());
        this.splitPane_.setDividerLocation(n6);
        this.splitPane_.setResizeWeight(0.0);
        this.splitPane_.addAncestorListener(listeningJPanel);
        this.getContentPane().add(this.splitPane_);
        this.buttonSnap_ = new JButton();
        this.buttonSnap_.setIconTextGap(6);
        this.buttonSnap_.setText("Snap");
        this.buttonSnap_.setIcon(SwingResourceManager.getIcon(MMStudioMainFrame.class, "/org/micromanager/icons/camera.png"));
        this.buttonSnap_.setFont(new Font("Arial", 0, 10));
        this.buttonSnap_.setToolTipText("Snap single image");
        this.buttonSnap_.setMaximumSize(new Dimension(0, 0));
        this.buttonSnap_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.doSnap();
            }
        });
        jPanel.add(this.buttonSnap_);
        springLayout.putConstraint("South", (Component)this.buttonSnap_, 25, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)this.buttonSnap_, 4, "North", (Component)jPanel);
        springLayout.putConstraint("East", (Component)this.buttonSnap_, 95, "West", (Component)jPanel);
        springLayout.putConstraint("West", (Component)this.buttonSnap_, 7, "West", (Component)jPanel);
        JLabel jLabel = new JLabel();
        jLabel.setFont(new Font("Arial", 0, 10));
        jLabel.setText("Exposure [ms]");
        jPanel.add(jLabel);
        springLayout.putConstraint("East", (Component)jLabel, 198, "West", (Component)jPanel);
        springLayout.putConstraint("West", (Component)jLabel, 111, "West", (Component)jPanel);
        springLayout.putConstraint("South", (Component)jLabel, 39, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jLabel, 23, "North", (Component)jPanel);
        this.textFieldExp_ = new JTextField();
        this.textFieldExp_.addFocusListener(new FocusAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void focusLost(FocusEvent focusEvent) {
                Object object = MMStudioMainFrame.this.shutdownLock_;
                synchronized (object) {
                    if (MMStudioMainFrame.this.core_ != null) {
                        MMStudioMainFrame.this.setExposure();
                    }
                }
            }
        });
        this.textFieldExp_.setFont(new Font("Arial", 0, 10));
        this.textFieldExp_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.setExposure();
            }
        });
        jPanel.add(this.textFieldExp_);
        springLayout.putConstraint("South", (Component)this.textFieldExp_, 40, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)this.textFieldExp_, 21, "North", (Component)jPanel);
        springLayout.putConstraint("East", (Component)this.textFieldExp_, 276, "West", (Component)jPanel);
        springLayout.putConstraint("West", (Component)this.textFieldExp_, 203, "West", (Component)jPanel);
        this.toggleButtonLive_ = new JToggleButton();
        this.toggleButtonLive_.setMargin(new Insets(2, 2, 2, 2));
        this.toggleButtonLive_.setIconTextGap(1);
        this.toggleButtonLive_.setIcon(SwingResourceManager.getIcon(MMStudioMainFrame.class, "/org/micromanager/icons/camera_go.png"));
        this.toggleButtonLive_.setIconTextGap(6);
        this.toggleButtonLive_.setToolTipText("Continuous live view");
        this.toggleButtonLive_.setFont(new Font("Arial", 0, 10));
        this.toggleButtonLive_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.enableLiveMode(!MMStudioMainFrame.this.isLiveModeOn());
            }
        });
        this.toggleButtonLive_.setText("Live");
        jPanel.add(this.toggleButtonLive_);
        springLayout.putConstraint("South", (Component)this.toggleButtonLive_, 47, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)this.toggleButtonLive_, 26, "North", (Component)jPanel);
        springLayout.putConstraint("East", (Component)this.toggleButtonLive_, 95, "West", (Component)jPanel);
        springLayout.putConstraint("West", (Component)this.toggleButtonLive_, 7, "West", (Component)jPanel);
        this.toAlbumButton_ = new JButton();
        this.toAlbumButton_.setMargin(new Insets(2, 2, 2, 2));
        this.toAlbumButton_.setIconTextGap(1);
        this.toAlbumButton_.setIcon(SwingResourceManager.getIcon(MMStudioMainFrame.class, "/org/micromanager/icons/camera_plus_arrow.png"));
        this.toAlbumButton_.setIconTextGap(6);
        this.toAlbumButton_.setToolTipText("Acquire single frame and add to an album");
        this.toAlbumButton_.setFont(new Font("Arial", 0, 10));
        this.toAlbumButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.snapAndAddToImage5D();
            }
        });
        this.toAlbumButton_.setText("Album");
        jPanel.add(this.toAlbumButton_);
        springLayout.putConstraint("South", (Component)this.toAlbumButton_, 69, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)this.toAlbumButton_, 48, "North", (Component)jPanel);
        springLayout.putConstraint("East", (Component)this.toAlbumButton_, 95, "West", (Component)jPanel);
        springLayout.putConstraint("West", (Component)this.toAlbumButton_, 7, "West", (Component)jPanel);
        this.toggleButtonShutter_ = new JToggleButton();
        this.toggleButtonShutter_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.toggleShutter();
            }
        });
        this.toggleButtonShutter_.setToolTipText("Open/close the shutter");
        this.toggleButtonShutter_.setIconTextGap(6);
        this.toggleButtonShutter_.setFont(new Font("Arial", 1, 10));
        this.toggleButtonShutter_.setText("Open");
        jPanel.add(this.toggleButtonShutter_);
        springLayout.putConstraint("East", (Component)this.toggleButtonShutter_, 275, "West", (Component)jPanel);
        springLayout.putConstraint("West", (Component)this.toggleButtonShutter_, 203, "West", (Component)jPanel);
        springLayout.putConstraint("South", (Component)this.toggleButtonShutter_, 117, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)this.toggleButtonShutter_, 96, "North", (Component)jPanel);
        JLabel jLabel2 = new JLabel();
        jLabel2.setFont(new Font("Arial", 0, 10));
        jLabel2.setText("Shutter");
        jPanel.add(jLabel2);
        springLayout.putConstraint("South", (Component)jLabel2, 86, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jLabel2, 73, "North", (Component)jPanel);
        springLayout.putConstraint("East", (Component)jLabel2, 158, "West", (Component)jPanel);
        springLayout.putConstraint("West", (Component)jLabel2, 111, "West", (Component)jPanel);
        this.shutterComboBox_ = new JComboBox();
        this.shutterComboBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (MMStudioMainFrame.this.shutterComboBox_.getSelectedItem() != null) {
                        MMStudioMainFrame.this.core_.setShutterDevice((String)MMStudioMainFrame.this.shutterComboBox_.getSelectedItem());
                    }
                }
                catch (Exception exception) {
                    ReportingUtils.showError(exception);
                }
            }
        });
        jPanel.add(this.shutterComboBox_);
        springLayout.putConstraint("South", (Component)this.shutterComboBox_, 92, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)this.shutterComboBox_, 70, "North", (Component)jPanel);
        springLayout.putConstraint("East", (Component)this.shutterComboBox_, 275, "West", (Component)jPanel);
        springLayout.putConstraint("West", (Component)this.shutterComboBox_, 170, "West", (Component)jPanel);
        this.menuBar_ = new JMenuBar();
        this.setJMenuBar(this.menuBar_);
        JMenu jMenu = new JMenu();
        jMenu.setText("File");
        this.menuBar_.add(jMenu);
        JMenuItem jMenuItem2 = new JMenuItem();
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new Thread(){

                    public void run() {
                        MMStudioMainFrame.this.openAcquisitionData(false);
                    }
                }.start();
            }
        });
        jMenuItem2.setText("Open (Virtual)...");
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem();
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new Thread(){

                    public void run() {
                        MMStudioMainFrame.this.openAcquisitionData(true);
                    }
                }.start();
            }
        });
        jMenuItem3.setText("Open (RAM)...");
        jMenu.add(jMenuItem3);
        jMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem();
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.closeSequence(false);
            }
        });
        jMenu.add(jMenuItem4);
        jMenuItem4.setText("Exit");
        JMenu jMenu2 = new JMenu();
        jMenu2.setText("Tools");
        this.menuBar_.add(jMenu2);
        JMenuItem jMenuItem5 = new JMenuItem();
        jMenuItem5.setIcon(SwingResourceManager.getIcon(MMStudioMainFrame.class, "icons/arrow_refresh.png"));
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.core_.updateSystemStateCache();
                MMStudioMainFrame.this.updateGUI(true);
            }
        });
        jMenuItem5.setText("Refresh GUI");
        jMenuItem5.setToolTipText("Refresh all GUI controls directly from the hardware");
        jMenu2.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem();
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.initializeGUI();
                MMStudioMainFrame.this.core_.updateSystemStateCache();
            }
        });
        jMenuItem6.setText("Rebuild GUI");
        jMenuItem6.setToolTipText("Regenerate micromanager user interface");
        jMenu2.add(jMenuItem6);
        jMenu2.addSeparator();
        JMenuItem jMenuItem7 = new JMenuItem();
        jMenu2.add(jMenuItem7);
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.scriptPanel_.setVisible(true);
            }
        });
        jMenuItem7.setText("Script Panel...");
        jMenuItem7.setToolTipText("Open micromanager script editor window");
        JMenuItem jMenuItem8 = new JMenuItem();
        jMenu2.add(jMenuItem8);
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HotKeysDialog hotKeysDialog = new HotKeysDialog(((MMStudioMainFrame)MMStudioMainFrame.this).guiColors_.background.get(((MMStudioMainFrame)MMStudioMainFrame.this).options_.displayBackground_));
            }
        });
        jMenuItem8.setText("Shortcuts...");
        jMenuItem8.setToolTipText("Create keyboard shortcuts to activate image acquisition, mark positions, or run custom scripts");
        JMenuItem jMenuItem9 = new JMenuItem();
        jMenu2.add(jMenuItem9);
        jMenuItem9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.createPropertyEditor();
            }
        });
        jMenuItem9.setText("Device/Property Browser...");
        jMenuItem9.setToolTipText("Open new window to view and edit property values in current configuration");
        jMenu2.addSeparator();
        JMenuItem jMenuItem10 = new JMenuItem();
        jMenuItem10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.showXYPositionList();
            }
        });
        jMenuItem10.setIcon(SwingResourceManager.getIcon(MMStudioMainFrame.class, "icons/application_view_list.png"));
        jMenuItem10.setText("XY List...");
        jMenu2.add(jMenuItem10);
        jMenuItem10.setToolTipText("Open position list manager window");
        JMenuItem jMenuItem11 = new JMenuItem();
        jMenuItem11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.openAcqControlDialog();
            }
        });
        jMenuItem11.setIcon(SwingResourceManager.getIcon(MMStudioMainFrame.class, "icons/film.png"));
        jMenuItem11.setText("Multi-Dimensional Acquisition...");
        jMenu2.add(jMenuItem11);
        jMenuItem11.setToolTipText("Open multi-dimensional acquisition window");
        this.centerAndDragMenuItem_ = new JCheckBoxMenuItem();
        this.centerAndDragMenuItem_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (MMStudioMainFrame.this.centerAndDragListener_ == null) {
                    MMStudioMainFrame.this.centerAndDragListener_ = new CenterAndDragListener(MMStudioMainFrame.this.core_, gui_);
                }
                if (!MMStudioMainFrame.this.centerAndDragListener_.isRunning()) {
                    MMStudioMainFrame.this.centerAndDragListener_.start();
                    MMStudioMainFrame.this.centerAndDragMenuItem_.setSelected(true);
                } else {
                    MMStudioMainFrame.this.centerAndDragListener_.stop();
                    MMStudioMainFrame.this.centerAndDragMenuItem_.setSelected(false);
                }
                MMStudioMainFrame.this.mainPrefs_.putBoolean(MMStudioMainFrame.MOUSE_MOVES_STAGE, MMStudioMainFrame.this.centerAndDragMenuItem_.isSelected());
            }
        });
        this.centerAndDragMenuItem_.setText("Mouse Moves Stage");
        this.centerAndDragMenuItem_.setSelected(this.mainPrefs_.getBoolean(MOUSE_MOVES_STAGE, false));
        this.centerAndDragMenuItem_.setToolTipText("When enabled, double clicking in live window moves stage");
        jMenu2.add(this.centerAndDragMenuItem_);
        JMenuItem jMenuItem12 = new JMenuItem();
        jMenu2.add(jMenuItem12);
        jMenuItem12.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.createCalibrationListDlg();
            }
        });
        jMenuItem12.setText("Pixel Size Calibration...");
        jMenu2.add(jMenuItem12);
        String string = "Define size calibrations specific to each objective lens.  When the objective in use has a calibration defined, micromanager will automatically use it when calculating metadata";
        String string2 = System.getProperty("mrj.version");
        if (string2 != null && !string2.equals("")) {
            jMenuItem12.setToolTipText(string);
        } else {
            jMenuItem12.setToolTipText(TooltipTextMaker.addHTMLBreaksForTooltip(string));
        }
        jMenu2.addSeparator();
        JMenuItem jMenuItem13 = new JMenuItem();
        jMenuItem13.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.runHardwareWizard();
            }
        });
        jMenuItem13.setText("Hardware Configuration Wizard...");
        jMenu2.add(jMenuItem13);
        jMenuItem13.setToolTipText("Open wizard to create new hardware configuration");
        JMenuItem jMenuItem14 = new JMenuItem();
        jMenu2.add(jMenuItem14);
        jMenuItem14.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.loadConfiguration();
                MMStudioMainFrame.this.initializeGUI();
            }
        });
        jMenuItem14.setText("Load Hardware Configuration...");
        jMenuItem14.setToolTipText("Un-initialize current configuration and initialize new one");
        this.switchConfigurationMenu_ = new JMenu();
        for (int i = 0; i < 5; ++i) {
            jMenuItem = new JMenuItem();
            jMenuItem.setText(Integer.toString(i));
            this.switchConfigurationMenu_.add(jMenuItem);
        }
        JMenuItem jMenuItem15 = new JMenuItem();
        jMenu2.add(jMenuItem15);
        jMenuItem15.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.loadSystemConfiguration();
                MMStudioMainFrame.this.initializeGUI();
            }
        });
        jMenuItem15.setText("Reload Hardware Configuration");
        jMenuItem15.setToolTipText("Un-initialize current configuration and initialize most recently loaded configuration");
        this.switchConfigurationMenu_.setText("Switch Hardware Configuration");
        jMenu2.add(this.switchConfigurationMenu_);
        this.switchConfigurationMenu_.setToolTipText("Switch between recently used configurations");
        jMenuItem = new JMenuItem();
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.saveConfigPresets();
                MMStudioMainFrame.this.updateChannelCombos();
            }
        });
        jMenuItem.setText("Save Configuration Settings as...");
        jMenu2.add(jMenuItem);
        jMenuItem.setToolTipText("Save current configuration settings as new configuration file");
        jMenu2.addSeparator();
        final MMStudioMainFrame mMStudioMainFrame = this;
        JMenuItem jMenuItem16 = new JMenuItem();
        jMenuItem16.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ((MMStudioMainFrame)MMStudioMainFrame.this).options_.circularBufferSizeMB_;
                OptionsDlg optionsDlg = new OptionsDlg(MMStudioMainFrame.this.options_, MMStudioMainFrame.this.core_, MMStudioMainFrame.this.mainPrefs_, mMStudioMainFrame, MMStudioMainFrame.this.sysConfigFile_);
                optionsDlg.setVisible(true);
                if (n != ((MMStudioMainFrame)MMStudioMainFrame.this).options_.circularBufferSizeMB_) {
                    try {
                        MMStudioMainFrame.this.core_.setCircularBufferMemoryFootprint(((MMStudioMainFrame)MMStudioMainFrame.this).options_.circularBufferSizeMB_);
                    }
                    catch (Exception exception) {
                        ReportingUtils.showError(exception);
                    }
                }
            }
        });
        jMenuItem16.setText("Options...");
        jMenu2.add(jMenuItem16);
        JLabel jLabel3 = new JLabel();
        jLabel3.setFont(new Font("Arial", 0, 10));
        jLabel3.setText("Binning");
        jPanel.add(jLabel3);
        springLayout.putConstraint("South", (Component)jLabel3, 64, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jLabel3, 43, "North", (Component)jPanel);
        springLayout.putConstraint("East", (Component)jLabel3, 199, "West", (Component)jPanel);
        springLayout.putConstraint("West", (Component)jLabel3, 111, "West", (Component)jPanel);
        this.metadataPanel_ = new MetadataPanel();
        listeningJPanel.add(this.metadataPanel_);
        springLayout.putConstraint("South", (Component)this.metadataPanel_, 0, "South", (Component)listeningJPanel);
        springLayout.putConstraint("North", (Component)this.metadataPanel_, 0, "North", (Component)listeningJPanel);
        springLayout.putConstraint("East", (Component)this.metadataPanel_, 0, "East", (Component)listeningJPanel);
        springLayout.putConstraint("West", (Component)this.metadataPanel_, 0, "West", (Component)listeningJPanel);
        this.metadataPanel_.setBorder(BorderFactory.createEmptyBorder());
        this.comboBinning_ = new JComboBox();
        this.comboBinning_.setFont(new Font("Arial", 0, 10));
        this.comboBinning_.setMaximumRowCount(4);
        this.comboBinning_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.changeBinning();
            }
        });
        jPanel.add(this.comboBinning_);
        springLayout.putConstraint("East", (Component)this.comboBinning_, 275, "West", (Component)jPanel);
        springLayout.putConstraint("West", (Component)this.comboBinning_, 200, "West", (Component)jPanel);
        springLayout.putConstraint("South", (Component)this.comboBinning_, 66, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)this.comboBinning_, 43, "North", (Component)jPanel);
        JLabel jLabel4 = new JLabel();
        jLabel4.setFont(new Font("Arial", 1, 11));
        jLabel4.setText("Camera settings");
        jPanel.add(jLabel4);
        springLayout.putConstraint("East", (Component)jLabel4, 211, "West", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jLabel4, 6, "North", (Component)jPanel);
        springLayout.putConstraint("West", (Component)jLabel4, 109, "West", (Component)jPanel);
        this.labelImageDimensions_ = new JLabel();
        this.labelImageDimensions_.setFont(new Font("Arial", 0, 10));
        jPanel.add(this.labelImageDimensions_);
        springLayout.putConstraint("South", (Component)this.labelImageDimensions_, 0, "South", (Component)jPanel);
        springLayout.putConstraint("North", (Component)this.labelImageDimensions_, -20, "South", (Component)jPanel);
        springLayout.putConstraint("East", (Component)this.labelImageDimensions_, 0, "East", (Component)jPanel);
        springLayout.putConstraint("West", (Component)this.labelImageDimensions_, 5, "West", (Component)jPanel);
        this.configPad_ = new ConfigGroupPad();
        this.configPadButtonPanel_ = new ConfigPadButtonPanel();
        this.configPadButtonPanel_.setConfigPad(this.configPad_);
        this.configPadButtonPanel_.setGUI(MMStudioMainFrame.getInstance());
        this.configPad_.setFont(new Font("", 0, 10));
        jPanel.add(this.configPad_);
        springLayout.putConstraint("East", (Component)this.configPad_, -4, "East", (Component)jPanel);
        springLayout.putConstraint("West", (Component)this.configPad_, 5, "East", (Component)this.comboBinning_);
        springLayout.putConstraint("South", (Component)this.configPad_, -4, "North", (Component)this.configPadButtonPanel_);
        springLayout.putConstraint("North", (Component)this.configPad_, 21, "North", (Component)jPanel);
        jPanel.add(this.configPadButtonPanel_);
        springLayout.putConstraint("East", (Component)this.configPadButtonPanel_, -4, "East", (Component)jPanel);
        springLayout.putConstraint("West", (Component)this.configPadButtonPanel_, 5, "East", (Component)this.comboBinning_);
        springLayout.putConstraint("North", (Component)this.configPadButtonPanel_, -40, "South", (Component)jPanel);
        springLayout.putConstraint("South", (Component)this.configPadButtonPanel_, -20, "South", (Component)jPanel);
        JLabel jLabel5 = new JLabel();
        jLabel5.setFont(new Font("Arial", 1, 11));
        jLabel5.setText("Configuration settings");
        jPanel.add(jLabel5);
        springLayout.putConstraint("South", (Component)jLabel5, 0, "South", (Component)jLabel4);
        springLayout.putConstraint("North", (Component)jLabel5, 0, "North", (Component)jLabel4);
        springLayout.putConstraint("East", (Component)jLabel5, 150, "West", (Component)this.configPad_);
        springLayout.putConstraint("West", (Component)jLabel5, 0, "West", (Component)this.configPad_);
        JButton jButton = new JButton();
        jButton.setMargin(new Insets(2, 2, 2, 2));
        jButton.setIconTextGap(1);
        jButton.setIcon(SwingResourceManager.getIcon(MMStudioMainFrame.class, "/org/micromanager/icons/film.png"));
        jButton.setToolTipText("Open multi-dimensional acquisition window");
        jButton.setFont(new Font("Arial", 0, 10));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.openAcqControlDialog();
            }
        });
        jButton.setText("Multi-D Acq.");
        jPanel.add(jButton);
        springLayout.putConstraint("South", (Component)jButton, 91, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jButton, 70, "North", (Component)jPanel);
        springLayout.putConstraint("East", (Component)jButton, 95, "West", (Component)jPanel);
        springLayout.putConstraint("West", (Component)jButton, 7, "West", (Component)jPanel);
        this.autoShutterCheckBox_ = new JCheckBox();
        this.autoShutterCheckBox_.setFont(new Font("Arial", 0, 10));
        this.autoShutterCheckBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.shutterLabel_ = MMStudioMainFrame.this.core_.getShutterDevice();
                if (MMStudioMainFrame.this.shutterLabel_.length() == 0) {
                    MMStudioMainFrame.this.toggleButtonShutter_.setEnabled(false);
                    return;
                }
                if (MMStudioMainFrame.this.autoShutterCheckBox_.isSelected()) {
                    try {
                        MMStudioMainFrame.this.core_.setAutoShutter(true);
                        MMStudioMainFrame.this.core_.setShutterOpen(false);
                        MMStudioMainFrame.this.toggleButtonShutter_.setSelected(false);
                        MMStudioMainFrame.this.toggleButtonShutter_.setText("Open");
                        MMStudioMainFrame.this.toggleButtonShutter_.setEnabled(false);
                    }
                    catch (Exception exception) {
                        ReportingUtils.logError(exception);
                    }
                } else {
                    try {
                        MMStudioMainFrame.this.core_.setAutoShutter(false);
                        MMStudioMainFrame.this.core_.setShutterOpen(false);
                        MMStudioMainFrame.this.toggleButtonShutter_.setEnabled(true);
                        MMStudioMainFrame.this.toggleButtonShutter_.setText("Open");
                    }
                    catch (Exception exception) {
                        ReportingUtils.logError(exception);
                    }
                }
            }
        });
        this.autoShutterCheckBox_.setIconTextGap(6);
        this.autoShutterCheckBox_.setHorizontalTextPosition(10);
        this.autoShutterCheckBox_.setText("Auto shutter");
        jPanel.add(this.autoShutterCheckBox_);
        springLayout.putConstraint("East", (Component)this.autoShutterCheckBox_, 199, "West", (Component)jPanel);
        springLayout.putConstraint("West", (Component)this.autoShutterCheckBox_, 107, "West", (Component)jPanel);
        springLayout.putConstraint("South", (Component)this.autoShutterCheckBox_, 119, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)this.autoShutterCheckBox_, 96, "North", (Component)jPanel);
        JButton jButton2 = new JButton();
        jButton2.setMargin(new Insets(2, 2, 2, 2));
        jButton2.setIconTextGap(1);
        jButton2.setIcon(SwingResourceManager.getIcon(MMStudioMainFrame.class, "/org/micromanager/icons/arrow_refresh.png"));
        jButton2.setFont(new Font("Arial", 0, 10));
        jButton2.setToolTipText("Refresh all GUI controls directly from the hardware");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.core_.updateSystemStateCache();
                MMStudioMainFrame.this.updateGUI(true);
            }
        });
        jButton2.setText("Refresh");
        jPanel.add(jButton2);
        springLayout.putConstraint("South", (Component)jButton2, 113, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jButton2, 92, "North", (Component)jPanel);
        springLayout.putConstraint("East", (Component)jButton2, 95, "West", (Component)jPanel);
        springLayout.putConstraint("West", (Component)jButton2, 7, "West", (Component)jPanel);
        JLabel jLabel6 = new JLabel("<html>Please <a href=\"http://micro-manager.org\">cite Micro-Manager</a> so funding will continue!</html>");
        jPanel.add(jLabel6);
        jLabel6.setFont(new Font("Arial", 0, 11));
        springLayout.putConstraint("South", (Component)jLabel6, 139, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jLabel6, 119, "North", (Component)jPanel);
        springLayout.putConstraint("East", (Component)jLabel6, 270, "West", (Component)jPanel);
        springLayout.putConstraint("West", (Component)jLabel6, 7, "West", (Component)jPanel);
        jLabel6.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                class Pleader
                extends Thread {
                    Pleader() {
                        super("pleader");
                    }

                    public void run() {
                        try {
                            BrowserLauncher.openURL((String)"https://valelab.ucsf.edu/~MM/MMwiki/index.php/Citing_Micro-Manager");
                        }
                        catch (IOException iOException) {
                            ReportingUtils.showError(iOException);
                        }
                    }
                }
                Pleader pleader = new Pleader();
                pleader.start();
            }
        });
        if (IJ.getInstance() != null) {
            IJ.getInstance().addWindowListener((WindowListener)new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    MMStudioMainFrame.this.closeSequence(true);
                }
            });
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MMStudioMainFrame.this.closeSequence(false);
            }

            public void windowOpened(WindowEvent windowEvent) {
                Object object;
                try {
                    MMStudioMainFrame.this.core_ = new CMMCore();
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    ReportingUtils.showError(unsatisfiedLinkError, "Failed to open libMMCoreJ_wrap.jnilib");
                    return;
                }
                ReportingUtils.setCore(MMStudioMainFrame.this.core_);
                MMStudioMainFrame.this.logStartupProperties();
                MMStudioMainFrame.this.cameraLabel_ = "";
                MMStudioMainFrame.this.shutterLabel_ = "";
                MMStudioMainFrame.this.zStageLabel_ = "";
                MMStudioMainFrame.this.xyStageLabel_ = "";
                MMStudioMainFrame.this.engine_ = new AcquisitionWrapperEngine();
                MMStudioMainFrame.this.cb_ = new CoreEventCallback();
                MMStudioMainFrame.this.core_.registerCallback(MMStudioMainFrame.this.cb_);
                try {
                    MMStudioMainFrame.this.core_.setCircularBufferMemoryFootprint(((MMStudioMainFrame)MMStudioMainFrame.this).options_.circularBufferSizeMB_);
                }
                catch (Exception exception) {
                    ReportingUtils.showError(exception);
                }
                MMStudioMainFrame mMStudioMainFrame = (MMStudioMainFrame)windowEvent.getWindow();
                if (mMStudioMainFrame != null) {
                    MMStudioMainFrame.this.engine_.setParentGUI(mMStudioMainFrame);
                }
                MMStudioMainFrame.this.loadMRUConfigFiles();
                this.initializePlugins();
                MMStudioMainFrame.this.toFront();
                if (!((MMStudioMainFrame)MMStudioMainFrame.this).options_.doNotAskForConfigFile_) {
                    object = new MMIntroDlg(MMStudioMainFrame.VERSION, MMStudioMainFrame.this.MRUConfigFiles_);
                    ((MMIntroDlg)object).setConfigFile(MMStudioMainFrame.this.sysConfigFile_);
                    ((Dialog)object).setBackground(((MMStudioMainFrame)MMStudioMainFrame.this).guiColors_.background.get(((MMStudioMainFrame)MMStudioMainFrame.this).options_.displayBackground_));
                    ((Dialog)object).setVisible(true);
                    MMStudioMainFrame.this.sysConfigFile_ = ((MMIntroDlg)object).getConfigFile();
                }
                MMStudioMainFrame.this.saveMRUConfigFiles();
                MMStudioMainFrame.this.mainPrefs_.put(MMStudioMainFrame.SYSTEM_CONFIG_FILE, MMStudioMainFrame.this.sysConfigFile_);
                MMStudioMainFrame.this.paint(MMStudioMainFrame.this.getGraphics());
                MMStudioMainFrame.this.engine_.setCore(MMStudioMainFrame.this.core_, MMStudioMainFrame.this.afMgr_);
                MMStudioMainFrame.this.posList_ = new PositionList();
                MMStudioMainFrame.this.engine_.setPositionList(MMStudioMainFrame.this.posList_);
                MMStudioMainFrame.this.createScriptPanel();
                MMStudioMainFrame.this.hotKeys_ = new HotKeys();
                MMStudioMainFrame.this.hotKeys_.loadSettings();
                if (!MMStudioMainFrame.this.loadSystemConfiguration()) {
                    ReportingUtils.showErrorOn(false);
                }
                MMStudioMainFrame.this.executeStartupScript();
                MMStudioMainFrame.this.acqControlWin_ = new AcqControlDlg(MMStudioMainFrame.this.engine_, MMStudioMainFrame.this.mainPrefs_, MMStudioMainFrame.this);
                MMStudioMainFrame.this.addMMBackgroundListener(MMStudioMainFrame.this.acqControlWin_);
                MMStudioMainFrame.this.configPad_.setCore(MMStudioMainFrame.this.core_);
                if (mMStudioMainFrame != null) {
                    MMStudioMainFrame.this.configPad_.setParentGUI(mMStudioMainFrame);
                }
                MMStudioMainFrame.this.configPadButtonPanel_.setCore(MMStudioMainFrame.this.core_);
                MMStudioMainFrame.this.initializeHelpMenu();
                object = MMStudioMainFrame.this.mainPrefs_.get(MMStudioMainFrame.AUTOFOCUS_DEVICE, "");
                if (MMStudioMainFrame.this.afMgr_.hasDevice((String)object)) {
                    try {
                        MMStudioMainFrame.this.afMgr_.selectDevice((String)object);
                    }
                    catch (MMException mMException) {
                        ReportingUtils.showError(mMException);
                    }
                }
                ReportingUtils.showErrorOn(true);
            }

            private void initializePlugins() {
                MMStudioMainFrame.this.pluginMenu_ = new JMenu();
                MMStudioMainFrame.this.pluginMenu_.setText("Plugins");
                MMStudioMainFrame.this.menuBar_.add(MMStudioMainFrame.this.pluginMenu_);
                new Thread("Plugin loading"){

                    public void run() {
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        MMStudioMainFrame.this.loadPlugins();
                    }
                }.start();
            }
        });
        this.setRoiButton_ = new JButton();
        this.setRoiButton_.setIcon(SwingResourceManager.getIcon(MMStudioMainFrame.class, "/org/micromanager/icons/shape_handles.png"));
        this.setRoiButton_.setFont(new Font("Arial", 0, 10));
        this.setRoiButton_.setToolTipText("Set Region Of Interest to selected rectangle");
        this.setRoiButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.setROI();
            }
        });
        jPanel.add(this.setRoiButton_);
        springLayout.putConstraint("East", (Component)this.setRoiButton_, 37, "West", (Component)jPanel);
        springLayout.putConstraint("West", (Component)this.setRoiButton_, 7, "West", (Component)jPanel);
        springLayout.putConstraint("South", (Component)this.setRoiButton_, 174, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)this.setRoiButton_, 154, "North", (Component)jPanel);
        this.clearRoiButton_ = new JButton();
        this.clearRoiButton_.setIcon(SwingResourceManager.getIcon(MMStudioMainFrame.class, "/org/micromanager/icons/arrow_out.png"));
        this.clearRoiButton_.setFont(new Font("Arial", 0, 10));
        this.clearRoiButton_.setToolTipText("Reset Region of Interest to full frame");
        this.clearRoiButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.clearROI();
            }
        });
        jPanel.add(this.clearRoiButton_);
        springLayout.putConstraint("East", (Component)this.clearRoiButton_, 70, "West", (Component)jPanel);
        springLayout.putConstraint("West", (Component)this.clearRoiButton_, 40, "West", (Component)jPanel);
        springLayout.putConstraint("South", (Component)this.clearRoiButton_, 174, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)this.clearRoiButton_, 154, "North", (Component)jPanel);
        JLabel jLabel7 = new JLabel();
        jLabel7.setFont(new Font("Arial", 1, 11));
        jLabel7.setText("ROI");
        jPanel.add(jLabel7);
        springLayout.putConstraint("South", (Component)jLabel7, 154, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jLabel7, 140, "North", (Component)jPanel);
        springLayout.putConstraint("East", (Component)jLabel7, 71, "West", (Component)jPanel);
        springLayout.putConstraint("West", (Component)jLabel7, 8, "West", (Component)jPanel);
        JLabel jLabel8 = new JLabel();
        jLabel8.setFont(new Font("Arial", 1, 11));
        jLabel8.setText("Zoom");
        jPanel.add(jLabel8);
        springLayout.putConstraint("South", (Component)jLabel8, 154, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jLabel8, 140, "North", (Component)jPanel);
        springLayout.putConstraint("East", (Component)jLabel8, 139, "West", (Component)jPanel);
        springLayout.putConstraint("West", (Component)jLabel8, 81, "West", (Component)jPanel);
        JButton jButton3 = new JButton();
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.zoomIn();
            }
        });
        jButton3.setIcon(SwingResourceManager.getIcon(MMStudioMainFrame.class, "/org/micromanager/icons/zoom_in.png"));
        jButton3.setToolTipText("Zoom in");
        jButton3.setFont(new Font("Arial", 0, 10));
        jPanel.add(jButton3);
        springLayout.putConstraint("South", (Component)jButton3, 174, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jButton3, 154, "North", (Component)jPanel);
        springLayout.putConstraint("East", (Component)jButton3, 110, "West", (Component)jPanel);
        springLayout.putConstraint("West", (Component)jButton3, 80, "West", (Component)jPanel);
        JButton jButton4 = new JButton();
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.zoomOut();
            }
        });
        jButton4.setIcon(SwingResourceManager.getIcon(MMStudioMainFrame.class, "/org/micromanager/icons/zoom_out.png"));
        jButton4.setToolTipText("Zoom out");
        jButton4.setFont(new Font("Arial", 0, 10));
        jPanel.add(jButton4);
        springLayout.putConstraint("South", (Component)jButton4, 174, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jButton4, 154, "North", (Component)jPanel);
        springLayout.putConstraint("East", (Component)jButton4, 143, "West", (Component)jPanel);
        springLayout.putConstraint("West", (Component)jButton4, 113, "West", (Component)jPanel);
        JLabel jLabel9 = new JLabel();
        jLabel9.setFont(new Font("Arial", 1, 11));
        jLabel9.setText("Profile");
        jPanel.add(jLabel9);
        springLayout.putConstraint("South", (Component)jLabel9, 154, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jLabel9, 140, "North", (Component)jPanel);
        springLayout.putConstraint("East", (Component)jLabel9, 217, "West", (Component)jPanel);
        springLayout.putConstraint("West", (Component)jLabel9, 154, "West", (Component)jPanel);
        JButton jButton5 = new JButton();
        jButton5.setIcon(SwingResourceManager.getIcon(MMStudioMainFrame.class, "/org/micromanager/icons/chart_curve.png"));
        jButton5.setFont(new Font("Arial", 0, 10));
        jButton5.setToolTipText("Open line profile window (requires line selection)");
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.openLineProfileWindow();
            }
        });
        jPanel.add(jButton5);
        springLayout.putConstraint("South", (Component)jButton5, 174, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jButton5, 154, "North", (Component)jPanel);
        springLayout.putConstraint("East", (Component)jButton5, 183, "West", (Component)jPanel);
        springLayout.putConstraint("West", (Component)jButton5, 153, "West", (Component)jPanel);
        JLabel jLabel10 = new JLabel();
        jLabel10.setFont(new Font("Arial", 1, 11));
        jLabel10.setText("Autofocus");
        jPanel.add(jLabel10);
        springLayout.putConstraint("South", (Component)jLabel10, 154, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jLabel10, 140, "North", (Component)jPanel);
        springLayout.putConstraint("East", (Component)jLabel10, 274, "West", (Component)jPanel);
        springLayout.putConstraint("West", (Component)jLabel10, 194, "West", (Component)jPanel);
        this.buttonAutofocus_ = new JButton();
        this.buttonAutofocus_.setIcon(SwingResourceManager.getIcon(MMStudioMainFrame.class, "/org/micromanager/icons/find.png"));
        this.buttonAutofocus_.setFont(new Font("Arial", 0, 10));
        this.buttonAutofocus_.setToolTipText("Autofocus now");
        this.buttonAutofocus_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (MMStudioMainFrame.this.afMgr_.getDevice() != null) {
                    new Thread(){

                        public void run() {
                            try {
                                boolean bl = MMStudioMainFrame.this.isLiveModeOn();
                                if (bl) {
                                    MMStudioMainFrame.this.enableLiveMode(false);
                                }
                                MMStudioMainFrame.this.afMgr_.getDevice().fullFocus();
                                if (bl) {
                                    MMStudioMainFrame.this.enableLiveMode(true);
                                }
                            }
                            catch (MMException mMException) {
                                ReportingUtils.logError(mMException);
                            }
                        }
                    }.start();
                }
            }
        });
        jPanel.add(this.buttonAutofocus_);
        springLayout.putConstraint("South", (Component)this.buttonAutofocus_, 174, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)this.buttonAutofocus_, 154, "North", (Component)jPanel);
        springLayout.putConstraint("East", (Component)this.buttonAutofocus_, 223, "West", (Component)jPanel);
        springLayout.putConstraint("West", (Component)this.buttonAutofocus_, 193, "West", (Component)jPanel);
        this.buttonAutofocusTools_ = new JButton();
        this.buttonAutofocusTools_.setIcon(SwingResourceManager.getIcon(MMStudioMainFrame.class, "/org/micromanager/icons/wrench_orange.png"));
        this.buttonAutofocusTools_.setFont(new Font("Arial", 0, 10));
        this.buttonAutofocusTools_.setToolTipText("Set autofocus options");
        this.buttonAutofocusTools_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.showAutofocusDialog();
            }
        });
        jPanel.add(this.buttonAutofocusTools_);
        springLayout.putConstraint("South", (Component)this.buttonAutofocusTools_, 174, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)this.buttonAutofocusTools_, 154, "North", (Component)jPanel);
        springLayout.putConstraint("East", (Component)this.buttonAutofocusTools_, 256, "West", (Component)jPanel);
        springLayout.putConstraint("West", (Component)this.buttonAutofocusTools_, 226, "West", (Component)jPanel);
        this.saveConfigButton_ = new JButton();
        this.saveConfigButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.this.saveConfigPresets();
            }
        });
        this.saveConfigButton_.setToolTipText("Save current presets to the configuration file");
        this.saveConfigButton_.setText("Save");
        this.saveConfigButton_.setEnabled(false);
        jPanel.add(this.saveConfigButton_);
        springLayout.putConstraint("South", (Component)this.saveConfigButton_, 20, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)this.saveConfigButton_, 2, "North", (Component)jPanel);
        springLayout.putConstraint("East", (Component)this.saveConfigButton_, -5, "East", (Component)jPanel);
        springLayout.putConstraint("West", (Component)this.saveConfigButton_, -80, "East", (Component)jPanel);
        MMKeyDispatcher mMKeyDispatcher = new MMKeyDispatcher(gui_);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(mMKeyDispatcher);
        this.overrideImageJMenu();
    }

    private void overrideImageJMenu() {
    }

    private void handleException(Exception exception, String string) {
        String string2 = "Exception occurred: ";
        if (string.length() > 0) {
            string2 = string2 + string + " -- ";
        }
        if (this.options_.debugLogEnabled_) {
            string2 = string2 + exception.getMessage();
        } else {
            string2 = string2 + exception.toString() + "\n";
            ReportingUtils.showError(exception);
        }
        this.handleError(string2);
    }

    private void handleException(Exception exception) {
        this.handleException(exception, "");
    }

    private void handleError(String string) {
        if (this.isLiveModeOn()) {
            this.enableLiveMode(false);
        }
        JOptionPane.showMessageDialog(this, string);
        this.core_.logMessage(string);
    }

    @Override
    public void makeActive() {
        this.toFront();
    }

    private void setExposure() {
        try {
            if (!this.isLiveModeOn()) {
                this.core_.setExposure(NumberUtils.displayStringToDouble(this.textFieldExp_.getText()));
            } else {
                this.liveModeTimer_.stop();
                this.core_.setExposure(NumberUtils.displayStringToDouble(this.textFieldExp_.getText()));
                try {
                    this.liveModeTimer_.begin();
                }
                catch (Exception exception) {
                    ReportingUtils.showError("Couldn't restart live mode");
                    this.liveModeTimer_.stop();
                }
            }
            double d = this.core_.getExposure();
            this.textFieldExp_.setText(NumberUtils.doubleToDisplayString(d));
            String string = this.core_.getChannelGroup();
            String string2 = this.core_.getCurrentConfigFromCache(string);
            if (!string2.equals("")) {
                this.getAcqDlg().setChannelExposureTime(string, string2, d);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean getAutoreloadOption() {
        return this.options_.autoreloadDevices_;
    }

    public double getPreferredWindowMag() {
        return this.options_.windowMag_;
    }

    public boolean getMetadataFileWithMultipageTiff() {
        return this.options_.mpTiffMetadataFile_;
    }

    public boolean getSeperateFilesForPositionsMPTiff() {
        return this.options_.mpTiffSeperateFilesForPositions_;
    }

    private void updateTitle() {
        this.setTitle("Micro-Manager 1.4.13 - " + this.sysConfigFile_);
    }

    public void updateLineProfile() {
        if (WindowManager.getCurrentWindow() == null || this.profileWin_ == null || !this.profileWin_.isShowing()) {
            return;
        }
        this.calculateLineProfileData(WindowManager.getCurrentImage());
        this.profileWin_.setData(this.lineProfileData_);
    }

    private void openLineProfileWindow() {
        if (WindowManager.getCurrentWindow() == null || WindowManager.getCurrentWindow().isClosed()) {
            return;
        }
        this.calculateLineProfileData(WindowManager.getCurrentImage());
        if (this.lineProfileData_ == null) {
            return;
        }
        this.profileWin_ = new GraphFrame();
        this.profileWin_.setDefaultCloseOperation(2);
        this.profileWin_.setData(this.lineProfileData_);
        this.profileWin_.setAutoScale();
        this.profileWin_.setTitle("Live line profile");
        this.profileWin_.setBackground(this.guiColors_.background.get(this.options_.displayBackground_));
        this.addMMBackgroundListener(this.profileWin_);
        this.profileWin_.setVisible(true);
    }

    @Override
    public Rectangle getROI() throws MMScriptException {
        int[][] nArray = new int[4][1];
        try {
            this.core_.getROI(nArray[0], nArray[1], nArray[2], nArray[3]);
        }
        catch (Exception exception) {
            throw new MMScriptException(exception.getMessage());
        }
        return new Rectangle(nArray[0][0], nArray[1][0], nArray[2][0], nArray[3][0]);
    }

    private void calculateLineProfileData(ImagePlus imagePlus) {
        Rectangle rectangle;
        Roi roi = imagePlus.getRoi();
        if (roi == null || !roi.isLine()) {
            rectangle = imagePlus.getProcessor().getRoi();
            int n = rectangle.width;
            int n2 = rectangle.height;
            int n3 = rectangle.x;
            int n4 = rectangle.y;
            if (roi == null) {
                n3 += n / 2;
                n4 += n2 / 2;
            }
            roi = new Line(n3 - n / 4, n4 - n / 4, n3 + n / 4, n4 + n2 / 4);
            imagePlus.setRoi(roi);
            roi = imagePlus.getRoi();
        }
        rectangle = imagePlus.getProcessor();
        rectangle.setInterpolate(true);
        Line line = (Line)roi;
        if (this.lineProfileData_ == null) {
            this.lineProfileData_ = new GraphData();
        }
        this.lineProfileData_.setData(line.getPixels());
    }

    @Override
    public void setROI(Rectangle rectangle) throws MMScriptException {
        boolean bl = false;
        if (this.isLiveModeOn()) {
            bl = true;
            this.enableLiveMode(false);
        }
        try {
            this.core_.setROI(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        catch (Exception exception) {
            throw new MMScriptException(exception.getMessage());
        }
        this.updateStaticInfo();
        if (bl) {
            this.enableLiveMode(true);
        }
    }

    private void setROI() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            return;
        }
        Roi roi = imagePlus.getRoi();
        try {
            Rectangle rectangle;
            if (roi == null) {
                rectangle = imagePlus.getProcessor().getRoi();
                int n = rectangle.width;
                int n2 = rectangle.height;
                int n3 = rectangle.x;
                int n4 = rectangle.y;
                if (roi == null) {
                    n3 += (n /= 2) / 2;
                    n4 += (n2 /= 2) / 2;
                }
                imagePlus.setRoi(n3, n4, n, n2);
                roi = imagePlus.getRoi();
            }
            if (roi.getType() != 0) {
                this.handleError("ROI must be a rectangle.\nUse the ImageJ rectangle tool to draw the ROI.");
                return;
            }
            rectangle = roi.getBoundingRect();
            Rectangle rectangle2 = this.getROI();
            rectangle.x += rectangle2.x;
            rectangle.y += rectangle2.y;
            this.setROI(rectangle);
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
        }
    }

    private void clearROI() {
        try {
            boolean bl = false;
            if (this.isLiveModeOn()) {
                bl = true;
                this.enableLiveMode(false);
            }
            this.core_.clearROI();
            this.updateStaticInfo();
            if (bl) {
                this.enableLiveMode(true);
            }
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
        }
    }

    @Override
    public CMMCore getMMCore() {
        return this.core_;
    }

    public static MMStudioMainFrame getInstance() {
        return gui_;
    }

    public MetadataPanel getMetadataPanel() {
        return this.metadataPanel_;
    }

    public final void setExitStrategy(boolean bl) {
        if (bl) {
            this.setDefaultCloseOperation(3);
        } else {
            this.setDefaultCloseOperation(2);
        }
    }

    @Override
    public void saveConfigPresets() {
        MicroscopeModel microscopeModel = new MicroscopeModel();
        try {
            microscopeModel.loadFromFile(this.sysConfigFile_);
            microscopeModel.createSetupConfigsFromHardware(this.core_);
            microscopeModel.createResolutionsFromHardware(this.core_);
            File file = FileDialogs.save(this, "Save the configuration file", MM_CONFIG_FILE);
            if (file != null) {
                microscopeModel.saveToFile(file.getAbsolutePath());
                this.sysConfigFile_ = file.getAbsolutePath();
                this.mainPrefs_.put(SYSTEM_CONFIG_FILE, this.sysConfigFile_);
                this.configChanged_ = false;
                this.setConfigSaveButtonStatus(this.configChanged_);
                this.updateTitle();
            }
        }
        catch (MMConfigFileException mMConfigFileException) {
            ReportingUtils.showError(mMConfigFileException);
        }
    }

    protected void setConfigSaveButtonStatus(boolean bl) {
        this.saveConfigButton_.setEnabled(bl);
    }

    public String getAcqDirectory() {
        return this.openAcqDirectory_;
    }

    public String getSysConfigFile() {
        return this.sysConfigFile_;
    }

    public void setAcqDirectory(String string) {
        this.openAcqDirectory_ = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void openAcquisitionData(boolean bl) {
        block9: {
            File file = FileDialogs.openDir(this, "Please select an image data set", MM_DATA_SET);
            if (file != null) {
                this.openAcqDirectory_ = file.isDirectory() ? file.getAbsolutePath() : file.getParent();
                String string = null;
                string = this.openAcquisitionData(this.openAcqDirectory_, bl);
                Object var6_4 = null;
                try {
                    this.acqMgr_.closeAcquisition(string);
                }
                catch (MMScriptException mMScriptException) {
                    ReportingUtils.logError(mMScriptException);
                }
                break block9;
                {
                    catch (MMScriptException mMScriptException) {
                        ReportingUtils.showError(mMScriptException);
                        Object var6_5 = null;
                        try {
                            this.acqMgr_.closeAcquisition(string);
                        }
                        catch (MMScriptException mMScriptException2) {
                            ReportingUtils.logError(mMScriptException2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    try {
                        this.acqMgr_.closeAcquisition(string);
                    }
                    catch (MMScriptException mMScriptException) {
                        ReportingUtils.logError(mMScriptException);
                    }
                    throw throwable;
                }
            }
        }
    }

    @Override
    public String openAcquisitionData(String string, boolean bl, boolean bl2) throws MMScriptException {
        String string2 = new File(string).getAbsolutePath();
        String string3 = new File(string).getName();
        string2 = string2.substring(0, string2.length() - (string3.length() + 1));
        this.acqMgr_.openAcquisition(string3, string2, bl2, !bl, true);
        try {
            this.getAcquisition(string3).initialize();
        }
        catch (MMScriptException mMScriptException) {
            this.acqMgr_.closeAcquisition(string3);
            throw mMScriptException;
        }
        return string3;
    }

    @Override
    public String openAcquisitionData(String string, boolean bl) throws MMScriptException {
        return this.openAcquisitionData(string, bl, true);
    }

    protected void zoomOut() {
        ImageWindow imageWindow = WindowManager.getCurrentWindow();
        if (imageWindow != null) {
            ImageCanvas imageCanvas = imageWindow.getCanvas();
            Rectangle rectangle = imageCanvas.getBounds();
            imageCanvas.zoomOut(rectangle.width / 2, rectangle.height / 2);
            VirtualAcquisitionDisplay virtualAcquisitionDisplay = VirtualAcquisitionDisplay.getDisplay(imageWindow.getImagePlus());
            if (virtualAcquisitionDisplay != null) {
                virtualAcquisitionDisplay.storeWindowSizeAfterZoom(imageWindow);
                virtualAcquisitionDisplay.updateWindowTitleAndStatus();
            }
        }
    }

    protected void zoomIn() {
        ImageWindow imageWindow = WindowManager.getCurrentWindow();
        if (imageWindow != null) {
            ImageCanvas imageCanvas = imageWindow.getCanvas();
            Rectangle rectangle = imageCanvas.getBounds();
            imageCanvas.zoomIn(rectangle.width / 2, rectangle.height / 2);
            VirtualAcquisitionDisplay virtualAcquisitionDisplay = VirtualAcquisitionDisplay.getDisplay(imageWindow.getImagePlus());
            if (virtualAcquisitionDisplay != null) {
                virtualAcquisitionDisplay.storeWindowSizeAfterZoom(imageWindow);
                virtualAcquisitionDisplay.updateWindowTitleAndStatus();
            }
        }
    }

    protected void changeBinning() {
        try {
            Object object;
            boolean bl = false;
            if (this.isLiveModeOn()) {
                bl = true;
                this.enableLiveMode(false);
            }
            if (this.isCameraAvailable() && (object = this.comboBinning_.getSelectedItem()) != null) {
                this.core_.setProperty(this.cameraLabel_, MMCoreJ.getG_Keyword_Binning(), object.toString());
            }
            this.updateStaticInfo();
            if (bl) {
                this.enableLiveMode(true);
            }
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
        }
    }

    private void createPropertyEditor() {
        if (this.propertyBrowser_ != null) {
            this.propertyBrowser_.dispose();
        }
        this.propertyBrowser_ = new PropertyEditor();
        this.propertyBrowser_.setGui(this);
        this.propertyBrowser_.setVisible(true);
        this.propertyBrowser_.setDefaultCloseOperation(2);
        this.propertyBrowser_.setCore(this.core_);
    }

    private void createCalibrationListDlg() {
        if (this.calibrationListDlg_ != null) {
            this.calibrationListDlg_.dispose();
        }
        this.calibrationListDlg_ = new CalibrationListDlg(this.core_);
        this.calibrationListDlg_.setVisible(true);
        this.calibrationListDlg_.setDefaultCloseOperation(2);
        this.calibrationListDlg_.setParentGUI(this);
    }

    public CalibrationListDlg getCalibrationListDlg() {
        if (this.calibrationListDlg_ == null) {
            this.createCalibrationListDlg();
        }
        return this.calibrationListDlg_;
    }

    private void createScriptPanel() {
        if (this.scriptPanel_ == null) {
            this.scriptPanel_ = new ScriptPanel(this.core_, this.options_, this);
            this.scriptPanel_.insertScriptingObject(SCRIPT_CORE_OBJECT, this.core_);
            this.scriptPanel_.insertScriptingObject(SCRIPT_ACQENG_OBJECT, this.engine_);
            this.scriptPanel_.setParentGUI(this);
            this.scriptPanel_.setBackground(this.guiColors_.background.get(this.options_.displayBackground_));
            this.addMMBackgroundListener(this.scriptPanel_);
        }
    }

    private void updateStaticInfoFromCache() {
        String string = "Image info (from camera): " + this.staticInfo_.width_ + " X " + this.staticInfo_.height_ + " X " + this.staticInfo_.bytesPerPixel_ + ", Intensity range: " + this.staticInfo_.imageBitDepth_ + " bits";
        string = string + ", " + TextUtils.FMT0.format(this.staticInfo_.pixSizeUm_ * 1000.0) + "nm/pix";
        if (this.zStageLabel_.length() > 0) {
            string = string + ", Z=" + TextUtils.FMT2.format(this.staticInfo_.zPos_) + "um";
        }
        if (this.xyStageLabel_.length() > 0) {
            string = string + ", XY=(" + TextUtils.FMT2.format(this.staticInfo_.x_) + "," + TextUtils.FMT2.format(this.staticInfo_.y_) + ")um";
        }
        this.labelImageDimensions_.setText(string);
    }

    public void updateXYPos(double d, double d2) {
        this.staticInfo_.x_ = d;
        this.staticInfo_.y_ = d2;
        this.updateStaticInfoFromCache();
    }

    public void updateZPos(double d) {
        this.staticInfo_.zPos_ = d;
        this.updateStaticInfoFromCache();
    }

    public void updateXYPosRelative(double d, double d2) {
        this.staticInfo_.x_ += d;
        this.staticInfo_.y_ += d2;
        this.updateStaticInfoFromCache();
    }

    public void updateZPosRelative(double d) {
        this.staticInfo_.zPos_ += d;
        this.updateStaticInfoFromCache();
    }

    public void updateXYStagePosition() {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        try {
            if (this.xyStageLabel_.length() > 0) {
                this.core_.getXYPosition(this.xyStageLabel_, dArray, dArray2);
            }
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
        }
        this.staticInfo_.x_ = dArray[0];
        this.staticInfo_.y_ = dArray2[0];
        this.updateStaticInfoFromCache();
    }

    private void updatePixSizeUm(double d) {
        this.staticInfo_.pixSizeUm_ = d;
        this.updateStaticInfoFromCache();
    }

    private void updateStaticInfo() {
        double d = 0.0;
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        try {
            if (this.zStageLabel_.length() > 0) {
                d = this.core_.getPosition(this.zStageLabel_);
            }
            if (this.xyStageLabel_.length() > 0) {
                this.core_.getXYPosition(this.xyStageLabel_, dArray, dArray2);
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        this.staticInfo_.width_ = this.core_.getImageWidth();
        this.staticInfo_.height_ = this.core_.getImageHeight();
        this.staticInfo_.bytesPerPixel_ = this.core_.getBytesPerPixel();
        this.staticInfo_.imageBitDepth_ = this.core_.getImageBitDepth();
        this.staticInfo_.pixSizeUm_ = this.core_.getPixelSizeUm();
        this.staticInfo_.zPos_ = d;
        this.staticInfo_.x_ = dArray[0];
        this.staticInfo_.y_ = dArray2[0];
        this.updateStaticInfoFromCache();
    }

    public void toggleShutter() {
        try {
            if (!this.toggleButtonShutter_.isEnabled()) {
                return;
            }
            this.toggleButtonShutter_.requestFocusInWindow();
            if (this.toggleButtonShutter_.getText().equals("Open")) {
                this.setShutterButton(true);
                this.core_.setShutterOpen(true);
            } else {
                this.core_.setShutterOpen(false);
                this.setShutterButton(false);
            }
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
        }
    }

    private void setShutterButton(boolean bl) {
        if (bl) {
            this.toggleButtonShutter_.setText("Close");
        } else {
            this.toggleButtonShutter_.setText("Open");
        }
    }

    @Override
    public void snapSingleImage() {
        this.doSnap();
    }

    public Object getPixels() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null) {
            return imagePlus.getProcessor().getPixels();
        }
        return null;
    }

    public void setPixels(Object object) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            return;
        }
        imagePlus.getProcessor().setPixels(object);
    }

    public int getImageHeight() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null) {
            return imagePlus.getHeight();
        }
        return 0;
    }

    public int getImageWidth() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null) {
            return imagePlus.getWidth();
        }
        return 0;
    }

    public int getImageDepth() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null) {
            return imagePlus.getBitDepth();
        }
        return 0;
    }

    public ImageProcessor getImageProcessor() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            return null;
        }
        return imagePlus.getProcessor();
    }

    private boolean isCameraAvailable() {
        return this.cameraLabel_.length() > 0;
    }

    @Override
    public void markCurrentPosition() {
        if (this.posListDlg_ == null) {
            this.showXYPositionList();
        }
        if (this.posListDlg_ != null) {
            this.posListDlg_.markPosition();
        }
    }

    @Override
    public AcqControlDlg getAcqDlg() {
        return this.acqControlWin_;
    }

    @Override
    public PositionListDlg getXYPosListDlg() {
        if (this.posListDlg_ == null) {
            this.posListDlg_ = new PositionListDlg(this.core_, this, this.posList_, this.options_);
        }
        return this.posListDlg_;
    }

    @Override
    public boolean isAcquisitionRunning() {
        if (this.engine_ == null) {
            return false;
        }
        return this.engine_.isAcquisitionRunning();
    }

    @Override
    public boolean versionLessThan(String string) throws MMScriptException {
        try {
            String[] stringArray = VERSION.split(" ", 2);
            String[] stringArray2 = stringArray[0].split("\\.", 3);
            String[] stringArray3 = string.split(" ", 2);
            String[] stringArray4 = stringArray3[0].split("\\.", 3);
            for (int i = 0; i < 3; ++i) {
                if (Integer.parseInt(stringArray2[i]) < Integer.parseInt(stringArray4[i])) {
                    ReportingUtils.showError("This code needs Micro-Manager version " + string + " or greater");
                    return true;
                }
                if (Integer.parseInt(stringArray2[i]) <= Integer.parseInt(stringArray4[i])) continue;
                return false;
            }
            if (stringArray3.length < 2 || stringArray3[1].equals("")) {
                return false;
            }
            if (stringArray.length < 2) {
                ReportingUtils.showError("This code needs Micro-Manager version " + string + " or greater");
                return true;
            }
            if (Integer.parseInt(stringArray[1]) < Integer.parseInt(stringArray3[1])) {
                ReportingUtils.showError("This code needs Micro-Manager version " + string + " or greater");
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            throw new MMScriptException("Format of version String should be \"a.b.c\"");
        }
    }

    @Override
    public boolean isLiveModeOn() {
        return this.liveModeTimer_ != null && this.liveModeTimer_.isRunning();
    }

    public LiveModeTimer getLiveModeTimer() {
        if (this.liveModeTimer_ == null) {
            this.liveModeTimer_ = new LiveModeTimer();
        }
        return this.liveModeTimer_;
    }

    @Override
    public void enableLiveMode(boolean bl) {
        if (this.core_ == null) {
            return;
        }
        if (bl == this.isLiveModeOn()) {
            return;
        }
        if (bl) {
            try {
                if (this.core_.getCameraDevice().length() == 0) {
                    ReportingUtils.showError("No camera configured");
                    this.updateButtonsForLiveMode(false);
                    return;
                }
                if (this.liveModeTimer_ == null) {
                    this.liveModeTimer_ = new LiveModeTimer();
                }
                this.liveModeTimer_.begin();
                this.enableLiveModeListeners(bl);
            }
            catch (Exception exception) {
                ReportingUtils.showError(exception);
                this.liveModeTimer_.stop();
                this.enableLiveModeListeners(false);
                this.updateButtonsForLiveMode(false);
                return;
            }
        } else {
            this.liveModeTimer_.stop();
            this.enableLiveModeListeners(bl);
        }
        this.updateButtonsForLiveMode(bl);
    }

    public void updateButtonsForLiveMode(boolean bl) {
        this.autoShutterCheckBox_.setEnabled(!bl);
        if (this.core_.getAutoShutter()) {
            this.toggleButtonShutter_.setText(bl ? "Close" : "Open");
        }
        this.buttonSnap_.setEnabled(!bl);
        this.toggleButtonLive_.setIcon(bl ? SwingResourceManager.getIcon(MMStudioMainFrame.class, "/org/micromanager/icons/cancel.png") : SwingResourceManager.getIcon(MMStudioMainFrame.class, "/org/micromanager/icons/camera_go.png"));
        this.toggleButtonLive_.setSelected(false);
        this.toggleButtonLive_.setText(bl ? "Stop Live" : "Live");
    }

    private void enableLiveModeListeners(boolean bl) {
        if (bl) {
            if (this.zWheelListener_ == null) {
                this.zWheelListener_ = new ZWheelListener(this.core_, this);
            }
            this.zWheelListener_.start(this.getImageWin());
            if (this.xyzKeyListener_ == null) {
                this.xyzKeyListener_ = new XYZKeyListener(this.core_, this);
            }
            this.xyzKeyListener_.start(this.getImageWin());
            if (this.centerAndDragListener_ == null) {
                this.centerAndDragListener_ = new CenterAndDragListener(this.core_, this);
            }
            this.centerAndDragListener_.start();
        } else {
            if (this.zWheelListener_ != null) {
                this.zWheelListener_.stop();
            }
            if (this.xyzKeyListener_ != null) {
                this.xyzKeyListener_.stop();
            }
            if (this.centerAndDragListener_ != null) {
                this.centerAndDragListener_.stop();
            }
        }
    }

    @Override
    public boolean getLiveMode() {
        return this.isLiveModeOn();
    }

    @Override
    public boolean updateImage() {
        try {
            if (this.isLiveModeOn()) {
                this.enableLiveMode(false);
                return true;
            }
            if (WindowManager.getCurrentWindow() == null) {
                return false;
            }
            ImagePlus imagePlus = WindowManager.getCurrentImage();
            this.core_.snapImage();
            Object object = this.core_.getImage();
            imagePlus.getProcessor().setPixels(object);
            imagePlus.updateAndRepaintWindow();
            if (!this.isCurrentImageFormatSupported()) {
                return false;
            }
            this.updateLineProfile();
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
            return false;
        }
        return true;
    }

    @Override
    public boolean displayImage(Object object) {
        if (object instanceof TaggedImage) {
            return this.displayTaggedImage((TaggedImage)object, true);
        }
        return this.displayImage(object, true);
    }

    public boolean displayImage(Object object, boolean bl) {
        this.checkSimpleAcquisition();
        try {
            int n = this.getAcquisition(SIMPLE_ACQ).getWidth();
            int n2 = this.getAcquisition(SIMPLE_ACQ).getHeight();
            int n3 = this.getAcquisition(SIMPLE_ACQ).getByteDepth();
            TaggedImage taggedImage = ImageUtils.makeTaggedImage(object, 0, 0, 0, 0, n, n2, n3);
            simpleDisplay_.getImageCache().putImage(taggedImage);
            simpleDisplay_.showImage(taggedImage, bl);
            return true;
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
            return false;
        }
    }

    @Override
    public boolean displayImageWithStatusLine(Object object, String string) {
        boolean bl = this.displayImage(object);
        simpleDisplay_.displayStatusLine(string);
        return bl;
    }

    @Override
    public void displayStatusLine(String string) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (!(imagePlus.getWindow() instanceof VirtualAcquisitionDisplay.DisplayWindow)) {
            return;
        }
        VirtualAcquisitionDisplay.getDisplay(imagePlus).displayStatusLine(string);
    }

    private boolean isCurrentImageFormatSupported() {
        boolean bl = false;
        long l = this.core_.getNumberOfComponents();
        long l2 = this.core_.getBytesPerPixel();
        if (l > 1L && l != 4L && l2 != 1L) {
            this.handleError("Unsupported image format.");
        } else {
            bl = true;
        }
        return bl;
    }

    public void doSnap() {
        this.doSnap(false);
    }

    public void doSnap(final boolean bl) {
        if (this.core_.getCameraDevice().length() == 0) {
            ReportingUtils.showError("No camera configured");
            return;
        }
        LinkedBlockingQueue<TaggedImage> linkedBlockingQueue = new LinkedBlockingQueue<TaggedImage>();
        try {
            ImagePlus imagePlus;
            TaggedImage taggedImage;
            this.core_.snapImage();
            long l = this.core_.getNumberOfCameraChannels();
            this.runDisplayThread(linkedBlockingQueue, new DisplayImageRoutine(){

                public void show(TaggedImage taggedImage) {
                    MMStudioMainFrame.this.normalizeTags(taggedImage);
                    if (bl) {
                        try {
                            MMStudioMainFrame.this.addToAlbum(taggedImage);
                        }
                        catch (MMScriptException mMScriptException) {
                            ReportingUtils.showError(mMScriptException);
                        }
                    } else {
                        MMStudioMainFrame.this.displayImage(taggedImage);
                    }
                }
            });
            int n = 0;
            while ((long)n < l) {
                taggedImage = this.core_.getTaggedImage(n);
                taggedImage.tags.put("Channels", l);
                linkedBlockingQueue.put(taggedImage);
                ++n;
            }
            linkedBlockingQueue.put(TaggedImageQueue.POISON);
            if (simpleDisplay_ != null && (imagePlus = simpleDisplay_.getImagePlus()) != null && (taggedImage = imagePlus.getWindow()) != null) {
                taggedImage.toFront();
            }
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
        }
    }

    public void normalizeTags(TaggedImage taggedImage) {
        if (taggedImage != TaggedImageQueue.POISON) {
            int n = 0;
            try {
                if (taggedImage.tags.has("Multi Camera-CameraChannelIndex")) {
                    n = taggedImage.tags.getInt("Multi Camera-CameraChannelIndex");
                } else if (taggedImage.tags.has("CameraChannelIndex")) {
                    n = taggedImage.tags.getInt("CameraChannelIndex");
                } else if (taggedImage.tags.has("ChannelIndex")) {
                    n = MDUtils.getChannelIndex(taggedImage.tags);
                }
                taggedImage.tags.put("ChannelIndex", n);
                taggedImage.tags.put("PositionIndex", 0);
                taggedImage.tags.put("SliceIndex", 0);
                taggedImage.tags.put("FrameIndex", 0);
            }
            catch (JSONException jSONException) {
                ReportingUtils.logError(jSONException);
            }
        }
    }

    @Override
    public boolean displayImage(TaggedImage taggedImage) {
        this.normalizeTags(taggedImage);
        return this.displayTaggedImage(taggedImage, true);
    }

    private boolean displayTaggedImage(TaggedImage taggedImage, boolean bl) {
        try {
            this.checkSimpleAcquisition(taggedImage);
            this.setCursor(new Cursor(3));
            taggedImage.tags.put("Summary", this.getAcquisition(SIMPLE_ACQ).getSummaryMetadata());
            this.addStagePositionToTags(taggedImage);
            this.addImage(SIMPLE_ACQ, taggedImage, bl, true);
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
            return false;
        }
        if (bl) {
            this.setCursor(new Cursor(0));
            this.updateLineProfile();
        }
        return true;
    }

    public void addStagePositionToTags(TaggedImage taggedImage) throws JSONException {
        if (MMStudioMainFrame.gui_.xyStageLabel_.length() > 0) {
            taggedImage.tags.put("XPositionUm", MMStudioMainFrame.gui_.staticInfo_.x_);
            taggedImage.tags.put("YPositionUm", MMStudioMainFrame.gui_.staticInfo_.y_);
        }
        if (MMStudioMainFrame.gui_.zStageLabel_.length() > 0) {
            taggedImage.tags.put("ZPositionUm", MMStudioMainFrame.gui_.staticInfo_.zPos_);
        }
    }

    private void configureBinningCombo() throws Exception {
        if (this.cameraLabel_.length() > 0) {
            int n;
            if (this.comboBinning_.getItemCount() > 0) {
                this.comboBinning_.removeAllItems();
            }
            StrVector strVector = this.core_.getAllowedPropertyValues(this.cameraLabel_, MMCoreJ.getG_Keyword_Binning());
            ActionListener[] actionListenerArray = this.comboBinning_.getActionListeners();
            for (n = 0; n < actionListenerArray.length; ++n) {
                this.comboBinning_.removeActionListener(actionListenerArray[n]);
            }
            n = 0;
            while ((long)n < strVector.size()) {
                this.comboBinning_.addItem(strVector.get(n));
                ++n;
            }
            this.comboBinning_.setMaximumRowCount((int)strVector.size());
            if (strVector.size() == 0L) {
                this.comboBinning_.setEditable(true);
            } else {
                this.comboBinning_.setEditable(false);
            }
            for (n = 0; n < actionListenerArray.length; ++n) {
                this.comboBinning_.addActionListener(actionListenerArray[n]);
            }
        }
    }

    @Override
    public void initializeGUI() {
        try {
            this.cameraLabel_ = this.core_.getCameraDevice();
            this.shutterLabel_ = this.core_.getShutterDevice();
            this.zStageLabel_ = this.core_.getFocusDevice();
            this.xyStageLabel_ = this.core_.getXYStageDevice();
            this.engine_.setZStageDevice(this.zStageLabel_);
            this.configureBinningCombo();
            try {
                this.shutters_ = this.core_.getLoadedDevicesOfType(DeviceType.ShutterDevice);
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception);
            }
            if (this.shutters_ != null) {
                String[] stringArray = new String[(int)this.shutters_.size()];
                int n = 0;
                while ((long)n < this.shutters_.size()) {
                    stringArray[n] = this.shutters_.get(n);
                    ++n;
                }
                GUIUtils.replaceComboContents(this.shutterComboBox_, stringArray);
                String string = this.core_.getShutterDevice();
                if (string != null) {
                    this.shutterComboBox_.setSelectedItem(string);
                } else {
                    this.shutterComboBox_.setSelectedItem("");
                }
            }
            this.buttonAutofocusTools_.setEnabled(this.afMgr_.getDevice() != null);
            this.buttonAutofocus_.setEnabled(this.afMgr_.getDevice() != null);
            if (this.posListDlg_ != null) {
                this.posListDlg_.rebuildAxisList();
            }
            this.updateGUI(true);
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
        }
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    private void addPluginToMenu(final PluginItem pluginItem, Class<?> clazz) {
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportingUtils.logMessage("Plugin command: " + actionEvent.getActionCommand());
                pluginItem.instantiate();
                pluginItem.plugin.show();
            }
        });
        jMenuItem.setText(pluginItem.menuItem);
        String string = "";
        try {
            string = (String)clazz.getDeclaredField("tooltipDescription").get(null);
        }
        catch (SecurityException securityException) {
            ReportingUtils.logError(securityException);
            string = "Description not available";
        }
        catch (NoSuchFieldException noSuchFieldException) {
            string = "Description not available";
            ReportingUtils.logError(clazz.getName() + " fails to implement static String tooltipDescription.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ReportingUtils.logError(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ReportingUtils.logError(illegalAccessException);
        }
        String string2 = System.getProperty("mrj.version");
        if (string2 != null) {
            jMenuItem.setToolTipText(string);
        } else {
            jMenuItem.setToolTipText(TooltipTextMaker.addHTMLBreaksForTooltip(string));
        }
        this.pluginMenu_.add(jMenuItem);
        this.pluginMenu_.validate();
        this.menuBar_.validate();
    }

    @Override
    public void updateGUI(boolean bl) {
        this.updateGUI(bl, false);
    }

    public void updateGUI(boolean bl, boolean bl2) {
        try {
            this.cameraLabel_ = this.core_.getCameraDevice();
            this.shutterLabel_ = this.core_.getShutterDevice();
            this.zStageLabel_ = this.core_.getFocusDevice();
            this.xyStageLabel_ = this.core_.getXYStageDevice();
            this.afMgr_.refresh();
            if (this.isCameraAvailable()) {
                double d = this.core_.getExposure();
                this.textFieldExp_.setText(NumberUtils.doubleToDisplayString(d));
                this.configureBinningCombo();
                String string = "";
                string = bl2 ? this.core_.getPropertyFromCache(this.cameraLabel_, MMCoreJ.getG_Keyword_Binning()) : this.core_.getProperty(this.cameraLabel_, MMCoreJ.getG_Keyword_Binning());
                GUIUtils.setComboSelection(this.comboBinning_, string);
            }
            if (this.liveModeTimer_ == null || !this.liveModeTimer_.isRunning()) {
                this.autoShutterCheckBox_.setSelected(this.core_.getAutoShutter());
                boolean bl3 = this.core_.getShutterOpen();
                this.setShutterButton(bl3);
                if (this.autoShutterCheckBox_.isSelected()) {
                    this.toggleButtonShutter_.setEnabled(false);
                } else {
                    this.toggleButtonShutter_.setEnabled(true);
                }
            }
            if (this.shutters_ != null) {
                String string = this.core_.getShutterDevice();
                if (string != null) {
                    this.shutterComboBox_.setSelectedItem(string);
                } else {
                    this.shutterComboBox_.setSelectedItem("");
                }
            }
            if (bl && this.configPad_ != null) {
                this.configPad_.refreshStructure(bl2);
                if (!bl2) {
                    this.core_.updateSystemStateCache();
                }
            }
            this.updateChannelCombos();
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
        this.updateStaticInfo();
        this.updateTitle();
    }

    @Override
    public boolean okToAcquire() {
        return !this.isLiveModeOn();
    }

    @Override
    public void stopAllActivity() {
        this.enableLiveMode(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cleanupOnClose(boolean bl) {
        Object[] objectArray;
        int n;
        if (this.configChanged_ && (n = JOptionPane.showOptionDialog(null, "Save Changed Configuration?", MICRO_MANAGER_TITLE, 0, 3, null, objectArray = new Object[]{"Yes", "No"}, objectArray[0])) == 0) {
            this.saveConfigPresets();
        }
        if (this.liveModeTimer_ != null) {
            this.liveModeTimer_.stop();
        }
        if (!bl && !WindowManager.closeAllWindows()) {
            this.core_.logMessage("Failed to close some windows");
        }
        if (this.profileWin_ != null) {
            this.removeMMBackgroundListener(this.profileWin_);
            this.profileWin_.dispose();
        }
        if (this.scriptPanel_ != null) {
            this.removeMMBackgroundListener(this.scriptPanel_);
            this.scriptPanel_.closePanel();
        }
        if (this.propertyBrowser_ != null) {
            this.removeMMBackgroundListener(this.propertyBrowser_);
            this.propertyBrowser_.dispose();
        }
        if (this.acqControlWin_ != null) {
            this.removeMMBackgroundListener(this.acqControlWin_);
            this.acqControlWin_.close();
        }
        if (this.engine_ != null) {
            this.engine_.shutdown();
        }
        if (this.afMgr_ != null) {
            this.afMgr_.closeOptionsDialog();
        }
        for (int i = 0; i < this.plugins_.size(); ++i) {
            MMPlugin mMPlugin = this.plugins_.get((int)i).plugin;
            if (mMPlugin == null) continue;
            mMPlugin.dispose();
        }
        Object object = this.shutdownLock_;
        synchronized (object) {
            try {
                if (this.core_ != null) {
                    this.core_.delete();
                    this.core_ = null;
                }
            }
            catch (Exception exception) {
                ReportingUtils.showError(exception);
            }
        }
        return true;
    }

    private void saveSettings() {
        Rectangle rectangle = this.getBounds();
        this.mainPrefs_.putInt(MAIN_FRAME_X, rectangle.x);
        this.mainPrefs_.putInt(MAIN_FRAME_Y, rectangle.y);
        this.mainPrefs_.putInt(MAIN_FRAME_WIDTH, rectangle.width);
        this.mainPrefs_.putInt(MAIN_FRAME_HEIGHT, rectangle.height);
        this.mainPrefs_.putInt(MAIN_FRAME_DIVIDER_POS, this.splitPane_.getDividerLocation());
        this.mainPrefs_.put(OPEN_ACQ_DIR, this.openAcqDirectory_);
        this.mainPrefs_.put(MAIN_SAVE_METHOD, ImageUtils.getImageStorageClass().getName());
        this.mainPrefs_.put(MAIN_EXPOSURE, this.textFieldExp_.getText());
        if (this.afMgr_ != null && this.afMgr_.getDevice() != null) {
            this.mainPrefs_.put(AUTOFOCUS_DEVICE, this.afMgr_.getDevice().getDeviceName());
        }
    }

    private void loadConfiguration() {
        File file = FileDialogs.openFile(this, "Load a config file", MM_CONFIG_FILE);
        if (file != null) {
            this.sysConfigFile_ = file.getAbsolutePath();
            this.configChanged_ = false;
            this.setConfigSaveButtonStatus(this.configChanged_);
            this.mainPrefs_.put(SYSTEM_CONFIG_FILE, this.sysConfigFile_);
            this.loadSystemConfiguration();
        }
    }

    public synchronized void closeSequence(boolean bl) {
        block10: {
            int n;
            if (!this.isRunning()) {
                if (this.core_ != null) {
                    this.core_.logMessage("MMStudioMainFrame::closeSequence called while running_ is false");
                }
                return;
            }
            if (this.engine_ != null && this.engine_.isAcquisitionRunning() && (n = JOptionPane.showConfirmDialog(this, "Acquisition in progress. Are you sure you want to exit and discard all data?", MICRO_MANAGER_TITLE, 0, 1)) == 1) {
                return;
            }
            this.stopAllActivity();
            if (!this.cleanupOnClose(bl)) {
                return;
            }
            this.running_ = false;
            this.saveSettings();
            try {
                this.configPad_.saveSettings();
                this.options_.saveSettings();
                this.hotKeys_.saveSettings();
            }
            catch (NullPointerException nullPointerException) {
                if (this.core_ == null) break block10;
                this.logError(nullPointerException);
            }
        }
        if (this.options_.closeOnExit_) {
            if (!this.runsAsPlugin_) {
                System.exit(0);
            } else {
                ImageJ imageJ = IJ.getInstance();
                if (imageJ != null) {
                    imageJ.quit();
                }
            }
        }
    }

    @Override
    public void applyContrastSettings(ContrastSettings contrastSettings, ContrastSettings contrastSettings2) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null || VirtualAcquisitionDisplay.getDisplay(imagePlus) == null) {
            return;
        }
        if (imagePlus.getBytesPerPixel() == 1) {
            VirtualAcquisitionDisplay.getDisplay(imagePlus).setChannelContrast(0, contrastSettings.min, contrastSettings.max, contrastSettings.gamma);
        } else {
            VirtualAcquisitionDisplay.getDisplay(imagePlus).setChannelContrast(0, contrastSettings2.min, contrastSettings2.max, contrastSettings2.gamma);
        }
    }

    @Override
    public ContrastSettings getContrastSettings() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null || VirtualAcquisitionDisplay.getDisplay(imagePlus) == null) {
            return null;
        }
        return VirtualAcquisitionDisplay.getDisplay(imagePlus).getChannelContrastSettings(0);
    }

    @Override
    public boolean is16bit() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        return imagePlus != null && imagePlus.getProcessor() instanceof ShortProcessor;
    }

    public boolean isRunning() {
        return this.running_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeStartupScript() {
        File file = new File(this.startupScriptFile_);
        if (this.startupScriptFile_.length() > 0 && file.exists()) {
            WaitDialog waitDialog = new WaitDialog("Executing startup script, please wait...");
            waitDialog.showDialog();
            Interpreter interpreter = new Interpreter();
            try {
                try {
                    interpreter.set(SCRIPT_CORE_OBJECT, (Object)this.core_);
                    interpreter.set(SCRIPT_ACQENG_OBJECT, (Object)this.engine_);
                    interpreter.set(SCRIPT_GUI_OBJECT, (Object)this);
                    interpreter.eval(TextUtils.readTextFile(this.startupScriptFile_));
                }
                catch (IOException iOException) {
                    ReportingUtils.showError(iOException, "Unable to read the startup script (" + this.startupScriptFile_ + ").");
                    Object var6_5 = null;
                    waitDialog.closeDialog();
                }
                catch (EvalError evalError) {
                    ReportingUtils.showError(evalError);
                    Object var6_6 = null;
                    waitDialog.closeDialog();
                }
                Object var6_4 = null;
                waitDialog.closeDialog();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                waitDialog.closeDialog();
                throw throwable;
            }
        } else if (this.startupScriptFile_.length() > 0) {
            ReportingUtils.logMessage("Startup script file (" + this.startupScriptFile_ + ") not present.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadSystemConfiguration() {
        boolean bl = true;
        this.saveMRUConfigFiles();
        WaitDialog waitDialog = new WaitDialog("Loading system configuration, please wait...");
        waitDialog.setAlwaysOnTop(true);
        waitDialog.showDialog();
        this.setEnabled(false);
        try {
            block4: {
                try {
                    if (this.sysConfigFile_.length() <= 0) break block4;
                    GUIUtils.preventDisplayAdapterChangeExceptions();
                    this.core_.waitForSystem();
                    this.ignorePropertyChanges_ = true;
                    this.core_.loadSystemConfiguration(this.sysConfigFile_);
                    this.ignorePropertyChanges_ = false;
                    GUIUtils.preventDisplayAdapterChangeExceptions();
                }
                catch (Exception exception) {
                    GUIUtils.preventDisplayAdapterChangeExceptions();
                    ReportingUtils.showError(exception);
                    bl = false;
                    Object var5_4 = null;
                    waitDialog.closeDialog();
                }
            }
            Object var5_3 = null;
            waitDialog.closeDialog();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            waitDialog.closeDialog();
            throw throwable;
        }
        this.setEnabled(true);
        this.initializeGUI();
        this.updateSwitchConfigurationMenu();
        FileDialogs.storePath(MM_CONFIG_FILE, new File(this.sysConfigFile_));
        return bl;
    }

    private void saveMRUConfigFiles() {
        if (0 < this.sysConfigFile_.length()) {
            if (this.MRUConfigFiles_.contains(this.sysConfigFile_)) {
                this.MRUConfigFiles_.remove(this.sysConfigFile_);
            }
            if (5 <= this.MRUConfigFiles_.size()) {
                this.MRUConfigFiles_.remove(4);
            }
            this.MRUConfigFiles_.add(0, this.sysConfigFile_);
            Integer n = 0;
            while (n < this.MRUConfigFiles_.size()) {
                String string = "";
                if (null != this.MRUConfigFiles_.get(n)) {
                    string = this.MRUConfigFiles_.get(n).toString();
                }
                this.mainPrefs_.put(CFGFILE_ENTRY_BASE + n.toString(), string);
                n = n + 1;
            }
        }
    }

    private void loadMRUConfigFiles() {
        this.sysConfigFile_ = this.mainPrefs_.get(SYSTEM_CONFIG_FILE, this.sysConfigFile_);
        this.MRUConfigFiles_ = new ArrayList();
        Integer n = 0;
        while (n < 5) {
            File file;
            String string = "";
            string = this.mainPrefs_.get(CFGFILE_ENTRY_BASE + n.toString(), string);
            if (0 < string.length() && (file = new File(string)).exists() && !this.MRUConfigFiles_.contains(string)) {
                this.MRUConfigFiles_.add(string);
            }
            n = n + 1;
        }
        if (0 < this.sysConfigFile_.length() && !this.MRUConfigFiles_.contains(this.sysConfigFile_)) {
            if (5 <= this.MRUConfigFiles_.size()) {
                this.MRUConfigFiles_.remove(4);
            }
            this.MRUConfigFiles_.add(0, this.sysConfigFile_);
        }
    }

    private void openAcqControlDialog() {
        try {
            if (this.acqControlWin_ == null) {
                this.acqControlWin_ = new AcqControlDlg(this.engine_, this.mainPrefs_, this);
            }
            if (this.acqControlWin_.isActive()) {
                this.acqControlWin_.setTopPosition();
            }
            this.acqControlWin_.setVisible(true);
            this.acqControlWin_.repaint();
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception, "\nAcquistion window failed to open due to invalid or corrupted settings.\nTry resetting registry settings to factory defaults (Menu Tools|Options).");
        }
    }

    @Override
    public void showXYPositionList() {
        if (this.posListDlg_ == null) {
            this.posListDlg_ = new PositionListDlg(this.core_, this, this.posList_, this.options_);
        }
        this.posListDlg_.setVisible(true);
    }

    private void updateChannelCombos() {
        if (this.acqControlWin_ != null) {
            this.acqControlWin_.updateChannelAndGroupCombo();
        }
    }

    @Override
    public void setConfigChanged(boolean bl) {
        this.configChanged_ = bl;
        this.setConfigSaveButtonStatus(this.configChanged_);
    }

    @Override
    public Color getBackgroundColor() {
        return this.guiColors_.background.get(this.options_.displayBackground_);
    }

    @Override
    public void setBackgroundStyle(String string) {
        this.setBackground(this.guiColors_.background.get(string));
        this.paint(this.getGraphics());
        for (Component component : this.MMFrames_) {
            if (component == null) continue;
            component.setBackground(this.guiColors_.background.get(string));
        }
    }

    @Override
    public String getBackgroundStyle() {
        return this.options_.displayBackground_;
    }

    private void testForAbortRequests() throws MMScriptException {
        if (this.scriptPanel_ != null && this.scriptPanel_.stopRequestPending()) {
            throw new MMScriptException("Script interrupted by the user!");
        }
    }

    @Override
    public void startAcquisition() throws MMScriptException {
        this.testForAbortRequests();
        SwingUtilities.invokeLater(new ExecuteAcq());
    }

    @Override
    public String runAcquisition() throws MMScriptException {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new MMScriptException("Acquisition can not be run from this (EDT) thread");
        }
        this.testForAbortRequests();
        if (this.acqControlWin_ != null) {
            String string = this.acqControlWin_.runAcquisition();
            try {
                while (this.acqControlWin_.isAcquisitionRunning()) {
                    Thread.sleep(50L);
                }
            }
            catch (InterruptedException interruptedException) {
                ReportingUtils.showError(interruptedException);
            }
            return string;
        }
        throw new MMScriptException("Acquisition setup window must be open for this command to work.");
    }

    @Override
    public String runAcquisition(String string, String string2) throws MMScriptException {
        this.testForAbortRequests();
        if (this.acqControlWin_ != null) {
            String string3 = this.acqControlWin_.runAcquisition(string, string2);
            try {
                while (this.acqControlWin_.isAcquisitionRunning()) {
                    Thread.sleep(100L);
                }
                MMAcquisition mMAcquisition = this.acqMgr_.getAcquisition(string3);
                boolean bl = false;
                while (!bl) {
                    ImageCache imageCache = mMAcquisition.getImageCache();
                    if (imageCache == null) continue;
                    if (imageCache.isFinished()) {
                        bl = true;
                        continue;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                ReportingUtils.showError(interruptedException);
            }
            return string3;
        }
        throw new MMScriptException("Acquisition setup window must be open for this command to work.");
    }

    @Override
    public String runAcqusition(String string, String string2) throws MMScriptException {
        return this.runAcquisition(string, string2);
    }

    @Override
    public void loadAcquisition(String string) throws MMScriptException {
        this.testForAbortRequests();
        try {
            this.engine_.shutdown();
            if (this.acqControlWin_ != null) {
                this.acqControlWin_.loadAcqSettingsFromFile(string);
            }
        }
        catch (Exception exception) {
            throw new MMScriptException(exception.getMessage());
        }
    }

    @Override
    public void setPositionList(PositionList positionList) throws MMScriptException {
        this.testForAbortRequests();
        this.posList_ = positionList;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (MMStudioMainFrame.this.posListDlg_ != null) {
                    MMStudioMainFrame.this.posListDlg_.setPositionList(MMStudioMainFrame.this.posList_);
                    MMStudioMainFrame.this.engine_.setPositionList(MMStudioMainFrame.this.posList_);
                }
            }
        });
    }

    @Override
    public PositionList getPositionList() throws MMScriptException {
        this.testForAbortRequests();
        return this.posList_;
    }

    @Override
    public void sleep(long l) throws MMScriptException {
        if (this.scriptPanel_ != null) {
            if (this.scriptPanel_.stopRequestPending()) {
                throw new MMScriptException("Script interrupted by the user!");
            }
            this.scriptPanel_.sleep(l);
        }
    }

    @Override
    public String getUniqueAcquisitionName(String string) {
        return this.acqMgr_.getUniqueAcquisitionName(string);
    }

    @Override
    public MMAcquisition getCurrentAcquisition() {
        return null;
    }

    @Override
    public void openAcquisition(String string, String string2, int n, int n2, int n3, int n4) throws MMScriptException {
        this.openAcquisition(string, string2, n, n2, n3, n4, true, false);
    }

    @Override
    public void openAcquisition(String string, String string2, int n, int n2, int n3) throws MMScriptException {
        this.openAcquisition(string, string2, n, n2, n3, 0);
    }

    @Override
    public void openAcquisition(String string, String string2, int n, int n2, int n3, int n4, boolean bl) throws MMScriptException {
        this.openAcquisition(string, string2, n, n2, n3, n4, bl, false);
    }

    @Override
    public void openAcquisition(String string, String string2, int n, int n2, int n3, boolean bl) throws MMScriptException {
        this.openAcquisition(string, string2, n, n2, n3, 0, bl, false);
    }

    @Override
    public void openAcquisition(String string, String string2, int n, int n2, int n3, int n4, boolean bl, boolean bl2) throws MMScriptException {
        this.acqMgr_.openAcquisition(string, string2, bl, bl2);
        MMAcquisition mMAcquisition = this.acqMgr_.getAcquisition(string);
        mMAcquisition.setDimensions(n, n2, n3, n4);
    }

    @Override
    public void openAcquisition(String string, String string2, int n, int n2, int n3, boolean bl, boolean bl2) throws MMScriptException {
        this.openAcquisition(string, string2, n, n2, n3, 0, bl, bl2);
    }

    @Override
    public String createAcquisition(JSONObject jSONObject, boolean bl) {
        return this.acqMgr_.createAcquisition(jSONObject, bl, this.engine_);
    }

    private void openAcquisitionSnap(String string, String string2, boolean bl) throws MMScriptException {
    }

    @Override
    public void initializeSimpleAcquisition(String string, int n, int n2, int n3, int n4, int n5) throws MMScriptException {
        MMAcquisition mMAcquisition = this.acqMgr_.getAcquisition(string);
        mMAcquisition.setImagePhysicalDimensions(n, n2, n3, n4, n5);
        mMAcquisition.initializeSimpleAcq();
    }

    @Override
    public void initializeAcquisition(String string, int n, int n2, int n3) throws MMScriptException {
        this.initializeAcquisition(string, n, n2, n3, 8 * n3);
    }

    @Override
    public void initializeAcquisition(String string, int n, int n2, int n3, int n4) throws MMScriptException {
        MMAcquisition mMAcquisition = this.acqMgr_.getAcquisition(string);
        mMAcquisition.setImagePhysicalDimensions(n, n2, n3, n4, 1);
        mMAcquisition.initialize();
    }

    @Override
    public int getAcquisitionImageWidth(String string) throws MMScriptException {
        MMAcquisition mMAcquisition = this.acqMgr_.getAcquisition(string);
        return mMAcquisition.getWidth();
    }

    @Override
    public int getAcquisitionImageHeight(String string) throws MMScriptException {
        MMAcquisition mMAcquisition = this.acqMgr_.getAcquisition(string);
        return mMAcquisition.getHeight();
    }

    @Override
    public int getAcquisitionImageBitDepth(String string) throws MMScriptException {
        MMAcquisition mMAcquisition = this.acqMgr_.getAcquisition(string);
        return mMAcquisition.getBitDepth();
    }

    @Override
    public int getAcquisitionImageByteDepth(String string) throws MMScriptException {
        MMAcquisition mMAcquisition = this.acqMgr_.getAcquisition(string);
        return mMAcquisition.getByteDepth();
    }

    @Override
    public int getAcquisitionMultiCamNumChannels(String string) throws MMScriptException {
        MMAcquisition mMAcquisition = this.acqMgr_.getAcquisition(string);
        return mMAcquisition.getMultiCameraNumChannels();
    }

    @Override
    public Boolean acquisitionExists(String string) {
        return this.acqMgr_.acquisitionExists(string);
    }

    @Override
    public void closeAcquisition(String string) throws MMScriptException {
        this.acqMgr_.closeAcquisition(string);
    }

    @Override
    public void closeAcquisitionImage5D(String string) throws MMScriptException {
        this.acqMgr_.closeImageWindow(string);
    }

    @Override
    public void closeAcquisitionWindow(String string) throws MMScriptException {
        this.acqMgr_.closeImageWindow(string);
    }

    @Override
    public void loadBurstAcquisition(String string) throws MMScriptException {
        this.loadAcquisition(string);
    }

    @Override
    public void refreshGUI() {
        this.updateGUI(true);
    }

    @Override
    public void refreshGUIFromCache() {
        this.updateGUI(true, true);
    }

    @Override
    public void setAcquisitionProperty(String string, String string2, String string3) throws MMScriptException {
        MMAcquisition mMAcquisition = this.acqMgr_.getAcquisition(string);
        mMAcquisition.setProperty(string2, string3);
    }

    @Override
    public void setAcquisitionSystemState(String string, JSONObject jSONObject) throws MMScriptException {
        this.setAcquisitionSummary(string, jSONObject);
    }

    @Override
    public void setAcquisitionSummary(String string, JSONObject jSONObject) throws MMScriptException {
        this.acqMgr_.getAcquisition(string).setSummaryProperties(jSONObject);
    }

    @Override
    public void setImageProperty(String string, int n, int n2, int n3, String string2, String string3) throws MMScriptException {
        MMAcquisition mMAcquisition = this.acqMgr_.getAcquisition(string);
        mMAcquisition.setProperty(n, n2, n3, string2, string3);
    }

    @Override
    public void snapAndAddImage(String string, int n, int n2, int n3) throws MMScriptException {
        this.snapAndAddImage(string, n, n2, n3, 0);
    }

    @Override
    public void snapAndAddImage(String string, int n, int n2, int n3, int n4) throws MMScriptException {
        try {
            TaggedImage taggedImage;
            if (this.core_.isSequenceRunning()) {
                taggedImage = this.core_.getLastTaggedImage();
            } else {
                this.core_.snapImage();
                taggedImage = this.core_.getTaggedImage();
            }
            taggedImage.tags.put("ChannelIndex", n2);
            taggedImage.tags.put("FrameIndex", n);
            taggedImage.tags.put("SliceIndex", n3);
            taggedImage.tags.put("PositionIndex", n4);
            MMAcquisition mMAcquisition = this.acqMgr_.getAcquisition(string);
            if (!mMAcquisition.isInitialized()) {
                long l = this.core_.getImageWidth();
                long l2 = this.core_.getImageHeight();
                long l3 = this.core_.getBytesPerPixel();
                long l4 = this.core_.getImageBitDepth();
                int n5 = (int)this.core_.getNumberOfCameraChannels();
                mMAcquisition.setImagePhysicalDimensions((int)l, (int)l2, (int)l3, (int)l4, n5);
                mMAcquisition.initialize();
            }
            if (mMAcquisition.getPositions() > 1) {
                taggedImage.tags.put("PositionName", "Pos" + n4);
            }
            this.addImage(string, taggedImage, true);
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
        }
    }

    @Override
    public String getCurrentAlbum() {
        return this.acqMgr_.getCurrentAlbum();
    }

    public String createNewAlbum() {
        return this.acqMgr_.createNewAlbum();
    }

    public void appendImage(String string, TaggedImage taggedImage) throws MMScriptException {
        MMAcquisition mMAcquisition = this.acqMgr_.getAcquisition(string);
        int n = 1 + mMAcquisition.getLastAcquiredFrame();
        try {
            MDUtils.setFrameIndex(taggedImage.tags, n);
        }
        catch (JSONException jSONException) {
            throw new MMScriptException("Unable to set the frame index.");
        }
        mMAcquisition.insertTaggedImage(taggedImage, n, 0, 0);
    }

    @Override
    public void addToAlbum(TaggedImage taggedImage) throws MMScriptException {
        this.addToAlbum(taggedImage, null);
    }

    public void addToAlbum(TaggedImage taggedImage, JSONObject jSONObject) throws MMScriptException {
        this.normalizeTags(taggedImage);
        this.acqMgr_.addToAlbum(taggedImage, jSONObject);
    }

    @Override
    public void addImage(String string, Object object, int n, int n2, int n3) throws MMScriptException {
        MMAcquisition mMAcquisition = this.acqMgr_.getAcquisition(string);
        mMAcquisition.insertImage(object, n, n2, n3);
    }

    @Override
    public void addImage(String string, TaggedImage taggedImage) throws MMScriptException {
        this.acqMgr_.getAcquisition(string).insertImage(taggedImage);
    }

    @Override
    public void addImage(String string, TaggedImage taggedImage, boolean bl) throws MMScriptException {
        this.acqMgr_.getAcquisition(string).insertImage(taggedImage, bl);
    }

    @Override
    public void addImage(String string, TaggedImage taggedImage, boolean bl, boolean bl2) throws MMScriptException {
        this.acqMgr_.getAcquisition(string).insertImage(taggedImage, bl, bl2);
    }

    @Override
    public void addImage(String string, TaggedImage taggedImage, int n, int n2, int n3, int n4) throws MMScriptException {
        try {
            this.acqMgr_.getAcquisition(string).insertImage(taggedImage, n, n2, n3, n4);
        }
        catch (JSONException jSONException) {
            ReportingUtils.showError(jSONException);
        }
    }

    @Override
    public void addImage(String string, TaggedImage taggedImage, int n, int n2, int n3, int n4, boolean bl) throws MMScriptException {
        try {
            this.acqMgr_.getAcquisition(string).insertImage(taggedImage, n, n2, n3, n4, bl);
        }
        catch (JSONException jSONException) {
            ReportingUtils.showError(jSONException);
        }
    }

    @Override
    public void addImage(String string, TaggedImage taggedImage, int n, int n2, int n3, int n4, boolean bl, boolean bl2) throws MMScriptException {
        try {
            this.acqMgr_.getAcquisition(string).insertImage(taggedImage, n, n2, n3, n4, bl, bl2);
        }
        catch (JSONException jSONException) {
            ReportingUtils.showError(jSONException);
        }
    }

    @Override
    public void closeAllAcquisitions() {
        this.acqMgr_.closeAll();
    }

    @Override
    public String[] getAcquisitionNames() {
        return this.acqMgr_.getAcqusitionNames();
    }

    @Override
    public MMAcquisition getAcquisition(String string) throws MMScriptException {
        return this.acqMgr_.getAcquisition(string);
    }

    @Override
    public void message(String string) throws MMScriptException {
        if (this.scriptPanel_ != null) {
            if (this.scriptPanel_.stopRequestPending()) {
                throw new MMScriptException("Script interrupted by the user!");
            }
            SwingUtilities.invokeLater(new ScriptConsoleMessage(string));
        }
    }

    @Override
    public void clearMessageWindow() throws MMScriptException {
        if (this.scriptPanel_ != null) {
            if (this.scriptPanel_.stopRequestPending()) {
                throw new MMScriptException("Script interrupted by the user!");
            }
            this.scriptPanel_.clearOutput();
        }
    }

    public void clearOutput() throws MMScriptException {
        this.clearMessageWindow();
    }

    public void clear() throws MMScriptException {
        this.clearMessageWindow();
    }

    @Override
    public void setChannelContrast(String string, int n, int n2, int n3) throws MMScriptException {
        MMAcquisition mMAcquisition = this.acqMgr_.getAcquisition(string);
        mMAcquisition.setChannelContrast(n, n2, n3);
    }

    @Override
    public void setChannelName(String string, int n, String string2) throws MMScriptException {
        MMAcquisition mMAcquisition = this.acqMgr_.getAcquisition(string);
        mMAcquisition.setChannelName(n, string2);
    }

    @Override
    public void setChannelColor(String string, int n, Color color) throws MMScriptException {
        MMAcquisition mMAcquisition = this.acqMgr_.getAcquisition(string);
        mMAcquisition.setChannelColor(n, color.getRGB());
    }

    @Override
    public void setContrastBasedOnFrame(String string, int n, int n2) throws MMScriptException {
        MMAcquisition mMAcquisition = this.acqMgr_.getAcquisition(string);
        mMAcquisition.setContrastBasedOnFrame(n, n2);
    }

    @Override
    public void setStagePosition(double d) throws MMScriptException {
        try {
            this.core_.setPosition(this.core_.getFocusDevice(), d);
            this.core_.waitForDevice(this.core_.getFocusDevice());
        }
        catch (Exception exception) {
            throw new MMScriptException(exception.getMessage());
        }
    }

    @Override
    public void setRelativeStagePosition(double d) throws MMScriptException {
        try {
            this.core_.setRelativePosition(this.core_.getFocusDevice(), d);
            this.core_.waitForDevice(this.core_.getFocusDevice());
        }
        catch (Exception exception) {
            throw new MMScriptException(exception.getMessage());
        }
    }

    @Override
    public void setXYStagePosition(double d, double d2) throws MMScriptException {
        try {
            this.core_.setXYPosition(this.core_.getXYStageDevice(), d, d2);
            this.core_.waitForDevice(this.core_.getXYStageDevice());
        }
        catch (Exception exception) {
            throw new MMScriptException(exception.getMessage());
        }
    }

    @Override
    public void setRelativeXYStagePosition(double d, double d2) throws MMScriptException {
        try {
            this.core_.setRelativeXYPosition(this.core_.getXYStageDevice(), d, d2);
            this.core_.waitForDevice(this.core_.getXYStageDevice());
        }
        catch (Exception exception) {
            throw new MMScriptException(exception.getMessage());
        }
    }

    @Override
    public Point2D.Double getXYStagePosition() throws MMScriptException {
        String string = this.core_.getXYStageDevice();
        if (string.length() == 0) {
            throw new MMScriptException("XY Stage device is not available");
        }
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        try {
            this.core_.getXYPosition(string, dArray, dArray2);
            Point2D.Double double_ = new Point2D.Double(dArray[0], dArray2[0]);
            return double_;
        }
        catch (Exception exception) {
            throw new MMScriptException(exception.getMessage());
        }
    }

    @Override
    public String getXYStageName() {
        return this.core_.getXYStageDevice();
    }

    @Override
    public void setXYOrigin(double d, double d2) throws MMScriptException {
        String string = this.core_.getXYStageDevice();
        try {
            this.core_.setAdapterOriginXY(string, d, d2);
        }
        catch (Exception exception) {
            throw new MMScriptException(exception);
        }
    }

    @Override
    public AcquisitionEngine getAcquisitionEngine() {
        return this.engine_;
    }

    public String installPlugin(Class<?> clazz) {
        String string = clazz.getSimpleName();
        String string2 = string + " module loaded.";
        try {
            for (PluginItem object2 : this.plugins_) {
                if (!object2.className.contentEquals(string)) continue;
                return string + " already loaded.";
            }
            PluginItem pluginItem = new PluginItem();
            pluginItem.className = string;
            try {
                pluginItem.menuItem = (String)clazz.getDeclaredField("menuName").get(null);
            }
            catch (SecurityException securityException) {
                ReportingUtils.logError(securityException);
                pluginItem.menuItem = string;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                pluginItem.menuItem = string;
                ReportingUtils.logError(string + " fails to implement static String menuName.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ReportingUtils.logError(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                ReportingUtils.logError(illegalAccessException);
            }
            if (pluginItem.menuItem == null) {
                pluginItem.menuItem = string;
            }
            pluginItem.menuItem = pluginItem.menuItem.replace("_", " ");
            pluginItem.pluginClass = clazz;
            this.plugins_.add(pluginItem);
            Object object = pluginItem;
            Class<?> clazz2 = clazz;
            SwingUtilities.invokeLater(new Runnable((PluginItem)object, clazz2){
                final /* synthetic */ PluginItem val$pi2;
                final /* synthetic */ Class val$cl2;
                {
                    this.val$pi2 = pluginItem;
                    this.val$cl2 = clazz;
                }

                public void run() {
                    MMStudioMainFrame.this.addPluginToMenu(this.val$pi2, this.val$cl2);
                }
            });
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            string2 = string + " class definition not found.";
            ReportingUtils.logError(noClassDefFoundError, string2);
        }
        return string2;
    }

    @Override
    public String installPlugin(String string, String string2) {
        String string3 = "installPlugin(String className, String menuName) is deprecated. Use installPlugin(String className) instead.";
        this.core_.logMessage(string3);
        this.installPlugin(string);
        return string3;
    }

    @Override
    public String installPlugin(String string) {
        String string2 = "";
        try {
            Class<?> clazz = Class.forName(string);
            return this.installPlugin(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            string2 = string + " plugin not found.";
            ReportingUtils.logError(classNotFoundException, string2);
            return string2;
        }
    }

    @Override
    public String installAutofocusPlugin(String string) {
        try {
            return this.installAutofocusPlugin(Class.forName(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string2 = "Internal error: AF manager not instantiated.";
            ReportingUtils.logError(classNotFoundException, string2);
            return string2;
        }
    }

    public String installAutofocusPlugin(Class<?> clazz) {
        String string = clazz.getSimpleName() + " module loaded.";
        if (this.afMgr_ != null) {
            try {
                this.afMgr_.refresh();
            }
            catch (MMException mMException) {
                string = mMException.getMessage();
                ReportingUtils.logError(mMException);
            }
            this.afMgr_.setAFPluginClassName(clazz.getSimpleName());
        } else {
            string = "Internal error: AF manager not instantiated.";
        }
        return string;
    }

    public CMMCore getCore() {
        return this.core_;
    }

    @Override
    public IAcquisitionEngine2010 getAcquisitionEngine2010() {
        try {
            this.acquisitionEngine2010LoadingThread.join();
            if (this.acquisitionEngine2010 == null) {
                this.acquisitionEngine2010 = (IAcquisitionEngine2010)this.acquisitionEngine2010Class.getConstructors()[0].newInstance(this);
            }
            return this.acquisitionEngine2010;
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
            return null;
        }
    }

    public void snapAndAddToImage5D() {
        if (this.core_.getCameraDevice().length() == 0) {
            ReportingUtils.showError("No camera configured");
            return;
        }
        try {
            if (this.isLiveModeOn()) {
                this.copyFromLiveModeToAlbum(simpleDisplay_);
            } else {
                this.doSnap(true);
            }
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
    }

    public void setAcquisitionEngine(AcquisitionEngine acquisitionEngine) {
        this.engine_ = acquisitionEngine;
    }

    public void suspendLiveMode() {
        this.liveModeSuspended_ = this.isLiveModeOn();
        this.enableLiveMode(false);
    }

    public void resumeLiveMode() {
        if (this.liveModeSuspended_) {
            this.enableLiveMode(true);
        }
    }

    @Override
    public Autofocus getAutofocus() {
        return this.afMgr_.getDevice();
    }

    @Override
    public void showAutofocusDialog() {
        if (this.afMgr_.getDevice() != null) {
            this.afMgr_.showOptionsDialog();
        }
    }

    @Override
    public AutofocusManager getAutofocusManager() {
        return this.afMgr_;
    }

    public void selectConfigGroup(String string) {
        this.configPad_.setGroup(string);
    }

    public String regenerateDeviceList() {
        Cursor cursor = Cursor.getDefaultCursor();
        Cursor cursor2 = new Cursor(3);
        this.setCursor(cursor2);
        StringBuffer stringBuffer = new StringBuffer();
        MicroscopeModel.generateDeviceListFile(stringBuffer, this.core_);
        this.setCursor(cursor);
        return stringBuffer.toString();
    }

    @Override
    public void setImageSavingFormat(Class clazz) throws MMScriptException {
        if (!clazz.equals(TaggedImageStorageDiskDefault.class) && !clazz.equals(TaggedImageStorageMultipageTiff.class)) {
            throw new MMScriptException("Unrecognized saving class");
        }
        ImageUtils.setImageStorageClass(clazz);
        if (this.acqControlWin_ != null) {
            this.acqControlWin_.updateSavingTypeButtons();
        }
    }

    private void loadPlugins() {
        this.afMgr_ = new AutofocusManager(this);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        try {
            long l = System.currentTimeMillis();
            List<Class<?>> list = JavaUtils.findClasses(new File("mmplugins"), 2);
            for (Class<?> clazz : list) {
                for (Class<?> clazz2 : clazz.getInterfaces()) {
                    if (clazz2 != MMPlugin.class) continue;
                    arrayList.add(clazz);
                }
            }
            list = JavaUtils.findClasses(new File("mmautofocus"), 2);
            for (Class<?> clazz : list) {
                for (Class<?> clazz2 : clazz.getInterfaces()) {
                    if (clazz2 != Autofocus.class) continue;
                    arrayList2.add(clazz);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            ReportingUtils.logError(classNotFoundException);
        }
        for (Class clazz : arrayList) {
            try {
                ReportingUtils.logMessage("Attempting to install plugin " + clazz.getName());
                this.installPlugin(clazz);
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception, "Failed to install the \"" + clazz.getName() + "\" plugin .");
            }
        }
        for (Class clazz : arrayList2) {
            try {
                ReportingUtils.logMessage("Attempting to install autofocus plugin " + clazz.getName());
                this.installAutofocusPlugin(clazz.getName());
            }
            catch (Exception exception) {
                ReportingUtils.logError("Failed to install the \"" + clazz.getName() + "\" autofocus plugin.");
            }
        }
    }

    @Override
    public void logMessage(String string) {
        ReportingUtils.logMessage(string);
    }

    @Override
    public void showMessage(String string) {
        ReportingUtils.showMessage(string);
    }

    @Override
    public void logError(Exception exception, String string) {
        ReportingUtils.logError(exception, string);
    }

    @Override
    public void logError(Exception exception) {
        ReportingUtils.logError(exception);
    }

    @Override
    public void logError(String string) {
        ReportingUtils.logError(string);
    }

    @Override
    public void showError(Exception exception, String string) {
        ReportingUtils.showError(exception, string);
    }

    @Override
    public void showError(Exception exception) {
        ReportingUtils.showError(exception);
    }

    @Override
    public void showError(String string) {
        ReportingUtils.showError(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runHardwareWizard() {
        try {
            if (this.configChanged_) {
                Object[] objectArray = new Object[]{"Yes", "No"};
                int n = JOptionPane.showOptionDialog(null, "Save Changed Configuration?", MICRO_MANAGER_TITLE, 0, 3, null, objectArray, objectArray[0]);
                if (n == 0) {
                    this.saveConfigPresets();
                }
                this.configChanged_ = false;
            }
            boolean bl = false;
            if (this.isLiveModeOn()) {
                bl = true;
                this.enableLiveMode(false);
            }
            this.core_.reset();
            GUIUtils.preventDisplayAdapterChangeExceptions();
            ConfiguratorDlg2 configuratorDlg2 = null;
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                configuratorDlg2 = new ConfiguratorDlg2(this.core_, this.sysConfigFile_);
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                this.setCursor(Cursor.getDefaultCursor());
                throw throwable;
            }
            this.setCursor(Cursor.getDefaultCursor());
            configuratorDlg2.setVisible(true);
            GUIUtils.preventDisplayAdapterChangeExceptions();
            this.sysConfigFile_ = configuratorDlg2.getFileName();
            this.mainPrefs_.put(SYSTEM_CONFIG_FILE, this.sysConfigFile_);
            this.loadSystemConfiguration();
            GUIUtils.preventDisplayAdapterChangeExceptions();
            if (bl) {
                this.enableLiveMode(bl);
            }
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
            return;
        }
    }

    static {
        MM_CONFIG_FILE = new FileDialogs.FileType("MM_CONFIG_FILE", "Micro-Manager Config File", "./MyScope.cfg", true, "cfg");
        MM_DATA_SET = new FileDialogs.FileType("MM_DATA_SET", "Micro-Manager Image Location", System.getProperty("user.home") + "/Untitled", false, null);
        seriousErrorReported_ = new AtomicBoolean(false);
    }

    private class ScriptConsoleMessage
    implements Runnable {
        String msg_;

        public ScriptConsoleMessage(String string) {
            this.msg_ = string;
        }

        public void run() {
            if (MMStudioMainFrame.this.scriptPanel_ != null) {
                MMStudioMainFrame.this.scriptPanel_.message(this.msg_);
            }
        }
    }

    private class ExecuteAcq
    implements Runnable {
        public void run() {
            if (MMStudioMainFrame.this.acqControlWin_ != null) {
                MMStudioMainFrame.this.acqControlWin_.runAcquisition();
            }
        }
    }

    private class StaticInfo {
        public long width_;
        public long height_;
        public long bytesPerPixel_;
        public long imageBitDepth_;
        public double pixSizeUm_;
        public double zPos_;
        public double x_;
        public double y_;

        private StaticInfo() {
        }
    }

    private class PluginItem {
        public Class<?> pluginClass = null;
        public String menuItem = "undefined";
        public MMPlugin plugin = null;
        public String className = "";

        private PluginItem() {
        }

        public void instantiate() {
            try {
                if (this.plugin == null) {
                    this.plugin = (MMPlugin)this.pluginClass.newInstance();
                }
            }
            catch (InstantiationException instantiationException) {
                ReportingUtils.logError(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                ReportingUtils.logError(illegalAccessException);
            }
            this.plugin.setApp(MMStudioMainFrame.this);
        }
    }

    public class CoreEventCallback
    extends MMEventCallback {
        public void onPropertiesChanged() {
            if (MMStudioMainFrame.this.engine_ != null && MMStudioMainFrame.this.engine_.isAcquisitionRunning()) {
                MMStudioMainFrame.this.core_.logMessage("Notification from MMCore ignored because acquistion is running!");
            } else if (MMStudioMainFrame.this.ignorePropertyChanges_) {
                MMStudioMainFrame.this.core_.logMessage("Notification from MMCore ignored since the system is still loading");
            } else {
                MMStudioMainFrame.this.core_.updateSystemStateCache();
                MMStudioMainFrame.this.updateGUI(true);
                for (MMListenerInterface mMListenerInterface : MMStudioMainFrame.this.MMListeners_) {
                    mMListenerInterface.propertiesChangedAlert();
                }
                MMStudioMainFrame.this.core_.logMessage("Notification from MMCore!");
            }
        }

        public void onPropertyChanged(String string, String string2, String string3) {
            MMStudioMainFrame.this.core_.logMessage("Notification for Device: " + string + " Property: " + string2 + " changed to value: " + string3);
            for (MMListenerInterface mMListenerInterface : MMStudioMainFrame.this.MMListeners_) {
                mMListenerInterface.propertyChangedAlert(string, string2, string3);
            }
        }

        public void onConfigGroupChanged(String string, String string2) {
            try {
                MMStudioMainFrame.this.configPad_.refreshGroup(string, string2);
                for (MMListenerInterface mMListenerInterface : MMStudioMainFrame.this.MMListeners_) {
                    mMListenerInterface.configGroupChangedAlert(string, string2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void onPixelSizeChanged(double d) {
            MMStudioMainFrame.this.updatePixSizeUm(d);
            for (MMListenerInterface mMListenerInterface : MMStudioMainFrame.this.MMListeners_) {
                mMListenerInterface.pixelSizeChangedAlert(d);
            }
        }

        public void onStagePositionChanged(String string, double d) {
            if (string.equals(MMStudioMainFrame.this.zStageLabel_)) {
                MMStudioMainFrame.this.updateZPos(d);
                for (MMListenerInterface mMListenerInterface : MMStudioMainFrame.this.MMListeners_) {
                    mMListenerInterface.stagePositionChangedAlert(string, d);
                }
            }
        }

        public void onStagePositionChangedRelative(String string, double d) {
            if (string.equals(MMStudioMainFrame.this.zStageLabel_)) {
                MMStudioMainFrame.this.updateZPosRelative(d);
            }
        }

        public void onXYStagePositionChanged(String string, double d, double d2) {
            if (string.equals(MMStudioMainFrame.this.xyStageLabel_)) {
                MMStudioMainFrame.this.updateXYPos(d, d2);
                for (MMListenerInterface mMListenerInterface : MMStudioMainFrame.this.MMListeners_) {
                    mMListenerInterface.xyStagePositionChanged(string, d, d2);
                }
            }
        }

        public void onXYStagePositionChangedRelative(String string, double d, double d2) {
            if (string.equals(MMStudioMainFrame.this.xyStageLabel_)) {
                MMStudioMainFrame.this.updateXYPosRelative(d, d2);
            }
        }

        public void onExposureChanged(String string, double d) {
            if (string.equals(MMStudioMainFrame.this.cameraLabel_)) {
                MMStudioMainFrame.this.textFieldExp_.setText(NumberUtils.doubleToDisplayString(d));
            }
        }
    }

    public static interface DisplayImageRoutine {
        public void show(TaggedImage var1);
    }
}

