/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import com.swtdesigner.SwingResourceManager;
import ij.IJ;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.utils.FileDialogs;
import org.micromanager.utils.JavaUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MMIntroDlg
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JTextArea welcomeTextArea_;
    private JTextArea supportTextArea_;
    ArrayList<String> mruCFGFileList_;
    private JComboBox cfgFileDropperDown_;
    public static String DISCLAIMER_TEXT = "This software is distributed free of charge in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of merchantability or fitness for a particular purpose. In no event shall the copyright owner or contributors be liable for any direct, indirect, incidental, special, examplary, or consequential damages.\n\nCopyright University of California San Francisco, 2007, 2008, 2009, 2010. All rights reserved.";
    public static String SUPPORT_TEXT = "Micro-Manager was initially funded by grants from the Sandler Foundation and is now supported by a grant from the NIH.";
    public static String CITATION_TEXT = "If you have found this software useful, please cite Micro-Manager in your publications.";

    public MMIntroDlg(String string, ArrayList<String> arrayList) {
        this.mruCFGFileList_ = arrayList;
        this.setFont(new Font("Arial", 0, 10));
        this.setTitle("Micro-Manager Startup");
        this.getContentPane().setLayout(null);
        this.setName("Intro");
        this.setResizable(false);
        this.setModal(true);
        this.setUndecorated(true);
        if (!IJ.isMacOSX()) {
            ((JPanel)this.getContentPane()).setBorder(BorderFactory.createLineBorder(Color.GRAY));
        }
        this.setSize(new Dimension(392, 533));
        Dimension dimension = this.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dimension2.width / 2 - dimension.width / 2, dimension2.height / 2 - dimension.height / 2);
        JLabel jLabel = new JLabel();
        jLabel.setIcon(SwingResourceManager.getIcon(MMIntroDlg.class, "/org/micromanager/icons/splash.gif"));
        jLabel.setLayout(null);
        jLabel.setBounds(0, 0, 392, 197);
        jLabel.setFocusable(false);
        jLabel.setBorder(new LineBorder(Color.black, 1, false));
        jLabel.setText("New JLabel");
        this.getContentPane().add(jLabel);
        JButton jButton = new JButton();
        jButton.setFont(new Font("Arial", 0, 10));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMIntroDlg.this.setVisible(false);
            }
        });
        jButton.setText("OK");
        if (JavaUtils.isMac()) {
            jButton.setBounds(150, 497, 81, 24);
        } else {
            jButton.setBounds(150, 492, 81, 24);
        }
        this.getContentPane().add(jButton);
        this.getRootPane().setDefaultButton(jButton);
        JLabel jLabel2 = new JLabel();
        jLabel2.setFont(new Font("", 1, 12));
        jLabel2.setText("Micro-Manager startup configuration");
        jLabel2.setBounds(5, 198, 259, 22);
        this.getContentPane().add(jLabel2);
        JLabel jLabel3 = new JLabel();
        jLabel3.setFont(new Font("Arial", 0, 10));
        jLabel3.setText("MMStudio Version " + string);
        jLabel3.setBounds(5, 216, 193, 13);
        this.getContentPane().add(jLabel3);
        JLabel jLabel4 = new JLabel();
        jLabel4.setFont(new Font("Arial", 0, 10));
        jLabel4.setText("Configuration file:");
        jLabel4.setBounds(5, 225, 319, 19);
        this.getContentPane().add(jLabel4);
        JButton jButton2 = new JButton();
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMIntroDlg.this.loadConfigFile();
            }
        });
        jButton2.setText("...");
        jButton2.setBounds(350, 245, 36, 26);
        this.getContentPane().add(jButton2);
        this.cfgFileDropperDown_ = new JComboBox();
        this.cfgFileDropperDown_.setFont(new Font("Arial", 0, 10));
        this.cfgFileDropperDown_.setBounds(5, 245, 342, 26);
        this.getContentPane().add(this.cfgFileDropperDown_);
        this.welcomeTextArea_ = new JTextArea(){

            public Insets getInsets() {
                return new Insets(10, 10, 10, 10);
            }
        };
        this.welcomeTextArea_.setBorder(new EtchedBorder());
        this.welcomeTextArea_.setWrapStyleWord(true);
        this.welcomeTextArea_.setText(DISCLAIMER_TEXT + "\n\n" + SUPPORT_TEXT + "\n\n" + CITATION_TEXT);
        this.welcomeTextArea_.setLineWrap(true);
        this.welcomeTextArea_.setFont(new Font("Arial", 0, 10));
        this.welcomeTextArea_.setFocusable(false);
        this.welcomeTextArea_.setEditable(false);
        this.welcomeTextArea_.setBackground(Color.WHITE);
        this.welcomeTextArea_.setBounds(10, 284, 356, 205);
        this.getContentPane().add(this.welcomeTextArea_);
    }

    public void setConfigFile(String string) {
        this.cfgFileDropperDown_.removeAllItems();
        File file = new File(string);
        Boolean bl = file.exists();
        if (bl.booleanValue() && !this.mruCFGFileList_.contains(string)) {
            if (6 <= this.mruCFGFileList_.size()) {
                this.mruCFGFileList_.remove(this.mruCFGFileList_.size() - 2);
            }
            this.mruCFGFileList_.add(0, string);
        }
        for (String string2 : this.mruCFGFileList_) {
            String string3;
            this.cfgFileDropperDown_.addItem(string2.toString());
            if (!bl.booleanValue() || !(string3 = string2.toString()).equals(string)) continue;
            this.cfgFileDropperDown_.setSelectedIndex(this.cfgFileDropperDown_.getItemCount() - 1);
        }
        this.cfgFileDropperDown_.addItem("(none)");
        if (!bl.booleanValue()) {
            this.cfgFileDropperDown_.setSelectedIndex(this.cfgFileDropperDown_.getItemCount() - 1);
        }
    }

    public void setScriptFile(String string) {
    }

    public String getConfigFile() {
        String string = new String("(none)");
        String string2 = new String(this.cfgFileDropperDown_.getSelectedItem().toString());
        if (string.equals(string2)) {
            string2 = "";
        }
        return string2;
    }

    public String getScriptFile() {
        return new String("");
    }

    protected void loadConfigFile() {
        File file = FileDialogs.openFile(this, "Choose a config file", MMStudioMainFrame.MM_CONFIG_FILE);
        if (file != null) {
            this.setConfigFile(file.getAbsolutePath());
        }
    }

    private class IOcfgFileFilter
    implements FileFilter {
        private IOcfgFileFilter() {
        }

        public boolean accept(File file) {
            String string = file.getName().toLowerCase();
            return string.endsWith("cfg");
        }
    }
}

