/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import com.swtdesigner.SwingResourceManager;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import mmcorej.CMMCore;
import org.micromanager.ConfigGroupPad;
import org.micromanager.GroupEditor;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.PresetEditor;
import org.micromanager.api.ScriptInterface;
import org.micromanager.utils.ReportingUtils;

public final class ConfigPadButtonPanel
extends JPanel {
    private static final long serialVersionUID = 6481082898578589473L;
    private JButton addGroupButton_;
    private JButton removeGroupButton_;
    private JButton editGroupButton_;
    private JButton addPresetButton_;
    private JButton removePresetButton_;
    private JButton editPresetButton_;
    private ConfigGroupPad configPad_;
    private CMMCore core_;
    private ScriptInterface gui_;

    ConfigPadButtonPanel() {
        this.initialize();
    }

    public void initialize() {
        this.initializeWidgets();
    }

    public void initializeWidgets() {
        this.createLabel("Group:");
        this.addGroupButton_ = this.createButton("", "/org/micromanager/icons/plus.png");
        this.addGroupButton_.setToolTipText("Create new group of properties");
        this.removeGroupButton_ = this.createButton("", "/org/micromanager/icons/minus.png");
        this.removeGroupButton_.setToolTipText("Delete currently selected group");
        this.editGroupButton_ = this.createButton("Edit", "");
        this.editGroupButton_.setToolTipText("Edit currently selected group");
        this.createLabel("Preset:");
        this.addPresetButton_ = this.createButton("", "/org/micromanager/icons/plus.png");
        this.addPresetButton_.setToolTipText("Create new preset (set of values for each property in group)");
        this.removePresetButton_ = this.createButton("", "/org/micromanager/icons/minus.png");
        this.removePresetButton_.setToolTipText("Delete currently selected preset");
        this.editPresetButton_ = this.createButton("Edit", "");
        this.editPresetButton_.setToolTipText("Edit property values for currently selected preset");
        GridLayout gridLayout = new GridLayout(1, 8, 2, 1);
        this.setLayout(gridLayout);
    }

    public void setConfigPad(ConfigGroupPad configGroupPad) {
        this.configPad_ = configGroupPad;
    }

    public void setGUI(MMStudioMainFrame mMStudioMainFrame) {
        this.gui_ = mMStudioMainFrame;
    }

    public void setCore(CMMCore cMMCore) {
        this.core_ = cMMCore;
    }

    public void format(JComponent jComponent) {
        jComponent.setFont(new Font("Arial", 0, 10));
        this.add(jComponent);
    }

    public JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font("Arial", 1, 10));
        jLabel.setHorizontalAlignment(4);
        this.add(jLabel);
        return jLabel;
    }

    public JButton createButton() {
        JButton jButton = new JButton();
        jButton.setIconTextGap(0);
        jButton.setMargin(new Insets(-50, -50, -50, -50));
        this.format(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigPadButtonPanel.this.handleButtonPress(actionEvent);
            }
        });
        return jButton;
    }

    public JButton createButton(String string, String string2) {
        JButton jButton = this.createButton();
        jButton.setText(string);
        if (string2.length() > 0) {
            jButton.setIcon(SwingResourceManager.getIcon(MMStudioMainFrame.class, string2));
        }
        return jButton;
    }

    protected void handleButtonPress(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addGroupButton_) {
            this.addGroup();
        }
        if (actionEvent.getSource() == this.removeGroupButton_) {
            this.removeGroup();
        }
        if (actionEvent.getSource() == this.editGroupButton_) {
            this.editGroup();
        }
        if (actionEvent.getSource() == this.addPresetButton_) {
            this.addPreset();
        }
        if (actionEvent.getSource() == this.removePresetButton_) {
            this.removePreset();
        }
        if (actionEvent.getSource() == this.editPresetButton_) {
            this.editPreset();
        }
        this.gui_.refreshGUI();
    }

    public void addGroup() {
        new GroupEditor("", "", this.gui_, this.core_, true);
    }

    public void removeGroup() {
        String string = this.configPad_.getGroup();
        if (string.length() > 0) {
            int n = JOptionPane.showConfirmDialog(this, "Are you sure you want to remove group " + string + " and all associated presets?", "Remove the " + string + " group?", 0, 1);
            if (n == 0) {
                try {
                    this.core_.deleteConfigGroup(string);
                    this.gui_.setConfigChanged(true);
                }
                catch (Exception exception) {
                    this.handleException(exception);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "If you want to remove a group, select it on the Configurations panel first.");
        }
    }

    public void editGroup() {
        String string = this.configPad_.getGroup();
        if (string.length() == 0) {
            JOptionPane.showMessageDialog(this, "To edit a group, please select it first, then press the edit button.");
        } else {
            new GroupEditor(string, this.configPad_.getPreset(), this.gui_, this.core_, false);
        }
    }

    public void addPreset() {
        String string = this.configPad_.getGroup();
        if (string.length() == 0) {
            JOptionPane.showMessageDialog(this, "To add a preset to a group, please select the group first, then press the edit button.");
        } else {
            new PresetEditor(string, "", this.gui_, this.core_, true);
        }
    }

    public void removePreset() {
        String string = this.configPad_.getGroup();
        String string2 = this.configPad_.getPreset();
        if (string.length() > 0) {
            if (this.core_.getAvailableConfigs(string).size() == 1L) {
                int n = JOptionPane.showConfirmDialog(this, "\"" + string2 + "\" is the last preset for the \"" + string + "\" group.\nDelete both preset and group?", "Remove last preset in group", 0, 1);
                if (n == 0) {
                    try {
                        this.core_.deleteConfig(string, string2);
                        this.core_.deleteConfigGroup(string);
                    }
                    catch (Exception exception) {
                        this.handleException(exception);
                    }
                }
            } else {
                int n = JOptionPane.showConfirmDialog(this, "Are you sure you want to remove preset " + string2 + " from the " + string + " group?", "Remove preset", 0, 1);
                if (n == 0) {
                    try {
                        this.core_.deleteConfig(string, string2);
                    }
                    catch (Exception exception) {
                        this.handleException(exception);
                    }
                }
            }
        }
    }

    public String choosePreset(String string) {
        Object[] objectArray = this.core_.getAvailableConfigs(string).toArray();
        return (String)JOptionPane.showInputDialog(null, "Please choose a preset from the " + string + " group for editing.", "Preset not selected.", -1, null, objectArray, objectArray[0]);
    }

    public void editPreset() {
        String string = this.configPad_.getPreset();
        String string2 = this.configPad_.getGroup();
        if (string2.length() == 0) {
            JOptionPane.showMessageDialog(this, "To edit a preset, please select the preset first, then press the edit button.");
        } else if (string.length() == 0) {
            String string3 = this.choosePreset(string2);
            if (string3 != null) {
                try {
                    this.core_.setConfig(string2, string3);
                }
                catch (Exception exception) {
                    ReportingUtils.logError(exception);
                }
                new PresetEditor(string2, string3, this.gui_, this.core_, false);
            }
        } else {
            new PresetEditor(string2, string, this.gui_, this.core_, false);
        }
    }

    public void handleException(Exception exception) {
        ReportingUtils.logError(exception);
    }
}

