/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.prefs.Preferences;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import mmcorej.CMMCore;
import mmcorej.Configuration;
import mmcorej.StrVector;
import org.micromanager.PresetEditor;
import org.micromanager.api.ScriptInterface;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.StateGroupCellRenderer;
import org.micromanager.utils.StateItem;
import org.micromanager.utils.StatePresetCellEditor;
import org.micromanager.utils.StatePresetCellRenderer;

public class ConfigGroupPad
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private JTable table_;
    private StateTableData data_;
    private ScriptInterface parentGUI_;
    Preferences prefs_;
    private String COLUMN_WIDTH = "group_col_width";
    public PresetEditor presetEditor_ = null;
    public String groupName_ = "";

    public ConfigGroupPad() {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        this.prefs_ = preferences.node(preferences.absolutePath() + "/PresetPad");
    }

    private void handleException(Exception exception) {
        ReportingUtils.showError(exception);
    }

    public void setCore(CMMCore cMMCore) {
        this.table_ = new JTable();
        this.table_.setSelectionMode(0);
        this.table_.setAutoCreateColumnsFromModel(false);
        this.table_.setRowSelectionAllowed(true);
        this.setViewportView(this.table_);
        this.data_ = new StateTableData(cMMCore);
        this.table_.setModel(this.data_);
        this.table_.addColumn(new TableColumn(0, 200, new StateGroupCellRenderer(), null));
        this.table_.addColumn(new TableColumn(1, 200, new StatePresetCellRenderer(), new StatePresetCellEditor()));
        int n = this.prefs_.getInt(this.COLUMN_WIDTH, 0);
        if (n > 0) {
            this.table_.getColumnModel().getColumn(0).setPreferredWidth(n);
        }
    }

    public void saveSettings() {
        if (this.prefs_ != null && this.table_ != null) {
            this.prefs_.putInt(this.COLUMN_WIDTH, this.table_.getColumnModel().getColumn(0).getWidth());
        }
    }

    public void setParentGUI(ScriptInterface scriptInterface) {
        this.parentGUI_ = scriptInterface;
    }

    public void refreshStructure(boolean bl) {
        if (this.data_ != null) {
            this.data_.updateStatus(bl);
            this.data_.fireTableStructureChanged();
            this.table_.repaint();
        }
    }

    public void refreshGroup(String string, String string2) {
        if (this.data_ != null) {
            this.data_.refreshGroup(string, string2);
            this.data_.fireTableStructureChanged();
            this.table_.repaint();
        }
    }

    public String getGroup() {
        int n = this.table_.getSelectedRow();
        if (n < 0 || this.data_.getRowCount() <= 0) {
            return "";
        }
        return (String)this.data_.getValueAt(n, 0);
    }

    public void setGroup(String string) {
        for (int i = 0; i < this.data_.getRowCount(); ++i) {
            if (!this.data_.getValueAt(i, 0).toString().contentEquals(string)) continue;
            this.table_.setRowSelectionInterval(i, i);
        }
    }

    public String getPreset() {
        int n = this.table_.getSelectedRow();
        if (n < 0 || this.data_.getRowCount() <= 0) {
            return "";
        }
        try {
            return this.data_.core_.getCurrentConfig((String)this.data_.getValueAt(n, 0));
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
            return null;
        }
    }

    public final class StateTableData
    extends AbstractTableModel {
        private static final long serialVersionUID = -6584881796860806078L;
        public final String[] columnNames_ = new String[]{"Group", "Preset"};
        ArrayList<StateItem> groupList_ = new ArrayList();
        private CMMCore core_ = null;
        private boolean configDirty_;

        public StateTableData(CMMCore cMMCore) {
            this.core_ = cMMCore;
            this.updateStatus(false);
            this.configDirty_ = false;
        }

        public int getRowCount() {
            return this.groupList_.size();
        }

        public int getColumnCount() {
            return this.columnNames_.length;
        }

        public StateItem getPropertyItem(int n) {
            return this.groupList_.get(n);
        }

        public Object getValueAt(int n, int n2) {
            StateItem stateItem = this.groupList_.get(n);
            if (n2 == 0) {
                return stateItem.group;
            }
            if (n2 == 1) {
                return stateItem.config;
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            StateItem stateItem = this.groupList_.get(n);
            if (n2 == 1) {
                try {
                    if (object != null && object.toString().length() > 0) {
                        boolean bl = ConfigGroupPad.this.parentGUI_.isLiveModeOn();
                        if (bl) {
                            ConfigGroupPad.this.parentGUI_.enableLiveMode(false);
                        }
                        if (stateItem.singleProp) {
                            if (stateItem.hasLimits && stateItem.isInteger()) {
                                this.core_.setProperty(stateItem.device, stateItem.name, NumberUtils.intStringDisplayToCore(object));
                            } else if (stateItem.hasLimits && !stateItem.isInteger()) {
                                this.core_.setProperty(stateItem.device, stateItem.name, NumberUtils.doubleStringDisplayToCore(object));
                            } else {
                                this.core_.setProperty(stateItem.device, stateItem.name, object.toString());
                            }
                            this.core_.waitForDevice(stateItem.device);
                        } else {
                            this.core_.setConfig(stateItem.group, object.toString());
                            this.core_.waitForConfig(stateItem.group, object.toString());
                        }
                        if (stateItem.group.equals(this.core_.getChannelGroup())) {
                            this.core_.setExposure(ConfigGroupPad.this.parentGUI_.getAcqDlg().getChannelExposureTime(stateItem.group, object.toString(), this.core_.getExposure()));
                        }
                        this.refreshStatus();
                        ConfigGroupPad.this.repaint();
                        if (ConfigGroupPad.this.parentGUI_ != null) {
                            ConfigGroupPad.this.parentGUI_.updateGUI(false);
                        }
                        if (bl) {
                            ConfigGroupPad.this.parentGUI_.enableLiveMode(true);
                        }
                    }
                }
                catch (Exception exception) {
                    ConfigGroupPad.this.handleException(exception);
                }
            }
        }

        public String getColumnName(int n) {
            return this.columnNames_[n];
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }

        public void updateStatus(boolean bl) {
            try {
                StrVector strVector = this.core_.getAvailableConfigGroups();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (StateItem object : this.groupList_) {
                    hashMap.put(object.group, object.config);
                }
                this.groupList_.clear();
                for (String string : strVector) {
                    Configuration configuration;
                    StateItem stateItem = new StateItem();
                    stateItem.group = string;
                    stateItem.config = bl ? this.core_.getCurrentConfigFromCache(stateItem.group) : this.core_.getCurrentConfig(stateItem.group);
                    stateItem.allowed = this.core_.getAvailableConfigs(stateItem.group).toArray();
                    if (stateItem.config.length() > 0) {
                        configuration = this.core_.getConfigData(stateItem.group, stateItem.config);
                        stateItem.descr = configuration.getVerbose();
                    } else {
                        stateItem.descr = "";
                    }
                    if (stateItem.allowed.length == 1 && (configuration = this.core_.getConfigData(stateItem.group, stateItem.allowed[0])).size() == 1L) {
                        boolean bl2;
                        stateItem.device = configuration.getSetting(0L).getDeviceLabel();
                        stateItem.name = configuration.getSetting(0L).getPropertyName();
                        stateItem.hasLimits = this.core_.hasPropertyLimits(stateItem.device, stateItem.name);
                        boolean bl3 = bl2 = 0L < this.core_.getAllowedPropertyValues(stateItem.device, stateItem.name).size();
                        if (stateItem.hasLimits || !bl2) {
                            stateItem.singleProp = true;
                            stateItem.type = this.core_.getPropertyType(stateItem.device, stateItem.name);
                            if (bl) {
                                stateItem.setValueFromCoreString(this.core_.getPropertyFromCache(stateItem.device, stateItem.name));
                            } else {
                                stateItem.setValueFromCoreString(this.core_.getProperty(stateItem.device, stateItem.name));
                            }
                            stateItem.config = stateItem.value;
                            stateItem.lowerLimit = this.core_.getPropertyLowerLimit(stateItem.device, stateItem.name);
                            stateItem.upperLimit = this.core_.getPropertyUpperLimit(stateItem.device, stateItem.name);
                            stateItem.singlePropAllowed = this.core_.getAllowedPropertyValues(stateItem.device, stateItem.name).toArray();
                        }
                    }
                    this.groupList_.add(stateItem);
                }
            }
            catch (Exception exception) {
                ConfigGroupPad.this.handleException(exception);
            }
        }

        public void refreshStatus() {
            try {
                for (int i = 0; i < this.groupList_.size(); ++i) {
                    StateItem stateItem = this.groupList_.get(i);
                    if (stateItem.singleProp) {
                        stateItem.config = this.core_.getProperty(stateItem.device, stateItem.name);
                        continue;
                    }
                    stateItem.config = this.core_.getCurrentConfig(stateItem.group);
                    if (stateItem.config.length() > 0) {
                        Configuration configuration = this.core_.getConfigData(stateItem.group, stateItem.config);
                        stateItem.descr = configuration.getVerbose();
                        continue;
                    }
                    stateItem.descr = "";
                }
            }
            catch (Exception exception) {
                ConfigGroupPad.this.handleException(exception);
            }
        }

        public void refreshGroup(String string, String string2) {
            try {
                for (int i = 0; i < this.groupList_.size(); ++i) {
                    StateItem stateItem = this.groupList_.get(i);
                    if (!stateItem.group.equals(string)) continue;
                    stateItem.config = string2;
                }
            }
            catch (Exception exception) {
                ConfigGroupPad.this.handleException(exception);
            }
        }

        public boolean isConfigDirty() {
            return this.configDirty_;
        }
    }
}

