/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.table.AbstractTableModel;
import mmcorej.CMMCore;
import mmcorej.Configuration;
import org.micromanager.CalibrationEditor;
import org.micromanager.api.ScriptInterface;
import org.micromanager.utils.Calibration;
import org.micromanager.utils.CalibrationList;
import org.micromanager.utils.MMDialog;
import org.micromanager.utils.ReportingUtils;

public class CalibrationListDlg
extends MMDialog {
    private static final long serialVersionUID = 1L;
    private static final String TITLE = "Calibration Editor";
    public static final String PIXEL_SIZE_GROUP = "ConfigPixelSize";
    private JTable calTable_;
    private SpringLayout springLayout;
    private CMMCore core_;
    private Preferences prefs_;
    private CalibrationList calibrationList_;
    private ScriptInterface parentGUI_;

    public CalibrationListDlg(CMMCore cMMCore) {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CalibrationListDlg.this.savePosition();
            }
        });
        this.core_ = cMMCore;
        this.setTitle("Pixel Size calibration");
        this.springLayout = new SpringLayout();
        this.getContentPane().setLayout(this.springLayout);
        this.setBounds(100, 100, 362, 495);
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        this.prefs_ = preferences.node(preferences.absolutePath() + "/CalibrationListDlg");
        this.setPrefsNode(this.prefs_);
        Rectangle rectangle = this.getBounds();
        this.loadPosition(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        JScrollPane jScrollPane = new JScrollPane();
        this.getContentPane().add(jScrollPane);
        this.springLayout.putConstraint("South", (Component)jScrollPane, -16, "South", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)jScrollPane, 15, "North", (Component)this.getContentPane());
        this.calibrationList_ = new CalibrationList(this.core_);
        this.calibrationList_.getCalibrationsFromCore();
        this.calTable_ = new JTable(){
            private static final long serialVersionUID = -5870707914970187465L;

            public String getToolTipText(MouseEvent mouseEvent) {
                String string = "";
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                if (n < 0) {
                    return "";
                }
                CalTableModel calTableModel = (CalTableModel)CalibrationListDlg.this.calTable_.getModel();
                String string2 = (String)calTableModel.getValueAt(n, 0);
                if (CalibrationListDlg.this.core_.isPixelSizeConfigDefined(string2)) {
                    try {
                        Configuration configuration = CalibrationListDlg.this.core_.getPixelSizeConfigData(string2);
                        string = configuration.getVerbose();
                    }
                    catch (Exception exception) {
                        CalibrationListDlg.this.handleException(exception);
                    }
                }
                return string;
            }
        };
        this.calTable_.setFont(new Font("", 0, 10));
        CalTableModel calTableModel = new CalTableModel();
        calTableModel.setData(this.calibrationList_);
        this.calTable_.setModel(calTableModel);
        this.calTable_.setSelectionMode(0);
        jScrollPane.setViewportView(this.calTable_);
        JButton jButton = new JButton();
        jButton.setFont(new Font("", 0, 10));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CalibrationListDlg.this.addNewCalibration();
            }
        });
        jButton.setText("New");
        this.getContentPane().add(jButton);
        this.springLayout.putConstraint("South", (Component)jButton, 40, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)jButton, 17, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)jButton, -9, "East", (Component)this.getContentPane());
        JButton jButton2 = new JButton();
        jButton2.setFont(new Font("", 0, 10));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CalibrationListDlg.this.editCalibration();
            }
        });
        jButton2.setText("Edit");
        this.getContentPane().add(jButton2);
        this.springLayout.putConstraint("South", (Component)jButton2, 65, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)jButton2, 42, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)jButton2, -9, "East", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)jButton2, -109, "East", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)jButton, 0, "West", (Component)jButton2);
        JButton jButton3 = new JButton();
        jButton3.setFont(new Font("", 0, 10));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CalibrationListDlg.this.removeCalibration();
            }
        });
        jButton3.setText("Remove");
        this.getContentPane().add(jButton3);
        this.springLayout.putConstraint("South", (Component)jButton3, 88, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)jButton3, 65, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)jButton3, -9, "East", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)jButton3, -109, "East", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)jButton, 0, "West", (Component)jButton3);
        JButton jButton4 = new JButton();
        jButton4.setFont(new Font("", 0, 10));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CalibrationListDlg.this.removeAllCalibrations();
            }
        });
        jButton4.setText("Remove All");
        this.getContentPane().add(jButton4);
        this.springLayout.putConstraint("South", (Component)jButton4, 111, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)jButton4, 88, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)jButton4, 100, "West", (Component)jButton3);
        this.springLayout.putConstraint("West", (Component)jButton4, 0, "West", (Component)jButton3);
        JButton jButton5 = new JButton();
        jButton5.setFont(new Font("", 0, 10));
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CalibrationListDlg.this.savePosition();
                CalibrationListDlg.this.dispose();
            }
        });
        jButton5.setText("Close");
        this.getContentPane().add(jButton5);
        this.springLayout.putConstraint("South", (Component)jButton5, 0, "South", (Component)jScrollPane);
        this.springLayout.putConstraint("North", (Component)jButton5, -23, "South", (Component)jScrollPane);
        this.springLayout.putConstraint("East", (Component)jScrollPane, -5, "West", (Component)jButton5);
        this.springLayout.putConstraint("West", (Component)jScrollPane, 10, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)jButton5, -5, "East", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)jButton5, 0, "West", (Component)jButton3);
    }

    public void addNewCalibration() {
        String string = new String("Res" + this.calibrationList_.size());
        if (this.editPreset(string, "0.00")) {
            this.calibrationList_.getCalibrationsFromCore();
            CalTableModel calTableModel = (CalTableModel)this.calTable_.getModel();
            calTableModel.fireTableDataChanged();
            this.parentGUI_.setConfigChanged(true);
            this.parentGUI_.refreshGUI();
        }
    }

    public void editCalibration() {
        CalTableModel calTableModel = (CalTableModel)this.calTable_.getModel();
        int n = this.calTable_.getSelectedRow();
        if (n < 0) {
            this.handleError("A Pixel Size Calibration must be selected first.");
            return;
        }
        String string = (String)calTableModel.getValueAt(n, 1);
        String string2 = (String)calTableModel.getValueAt(n, 0);
        if (this.editPreset(string2, string)) {
            this.calibrationList_.getCalibrationsFromCore();
            calTableModel.fireTableDataChanged();
            this.parentGUI_.setConfigChanged(true);
            this.parentGUI_.refreshGUI();
        }
    }

    public void updateCalibrations() {
        CalTableModel calTableModel = (CalTableModel)this.calTable_.getModel();
        this.calibrationList_.getCalibrationsFromCore();
        calTableModel.fireTableDataChanged();
        this.parentGUI_.setConfigChanged(true);
        this.parentGUI_.refreshGUI();
        int n = calTableModel.getCurrentPixelConfigRow();
        if (n >= 0) {
            this.calTable_.setRowSelectionInterval(n, n);
        }
    }

    public void setParentGUI(ScriptInterface scriptInterface) {
        this.parentGUI_ = scriptInterface;
    }

    public void removeCalibration() {
        CalTableModel calTableModel = (CalTableModel)this.calTable_.getModel();
        int n = this.calTable_.getSelectedRow();
        String string = (String)calTableModel.getValueAt(n, 0);
        int n2 = JOptionPane.showConfirmDialog(this, "Are you sure you want to remove calibration group " + string + "?", TITLE, 0, 1);
        if (n2 == 0) {
            try {
                this.core_.deletePixelSizeConfig(string);
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
            this.calibrationList_.getCalibrationsFromCore();
            calTableModel.fireTableDataChanged();
            this.parentGUI_.refreshGUI();
            this.parentGUI_.setConfigChanged(true);
        }
    }

    public void removeAllCalibrations() {
        int n = JOptionPane.showConfirmDialog(this, "Are you absolutely sure you want to remove all calibrations? (No Undo possible!)", TITLE, 0, 1);
        if (n == 0) {
            try {
                for (int i = 0; i < this.calibrationList_.size(); ++i) {
                    this.core_.deletePixelSizeConfig(this.calibrationList_.get(i).getLabel());
                }
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
            this.calibrationList_.getCalibrationsFromCore();
            CalTableModel calTableModel = (CalTableModel)this.calTable_.getModel();
            calTableModel.fireTableDataChanged();
            this.parentGUI_.refreshGUI();
            this.parentGUI_.setConfigChanged(true);
        }
    }

    public boolean editPreset(String string, String string2) {
        CalibrationEditor calibrationEditor = new CalibrationEditor(string, string2);
        calibrationEditor.setCore(this.core_);
        calibrationEditor.setVisible(true);
        if (calibrationEditor.isChanged()) {
            this.parentGUI_.setConfigChanged(true);
        }
        return calibrationEditor.isChanged();
    }

    private void handleException(Exception exception) {
        ReportingUtils.showError(exception);
    }

    private void handleError(String string) {
        ReportingUtils.showError(string);
    }

    private class CalTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public final String[] COLUMN_NAMES = new String[]{"Label", "Pixel Size [um]"};
        private CalibrationList calibrationList;

        private CalTableModel() {
        }

        public void setData(CalibrationList calibrationList) {
            this.calibrationList = calibrationList;
        }

        public int getRowCount() {
            return this.calibrationList.size();
        }

        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        public Object getValueAt(int n, int n2) {
            Calibration calibration = this.calibrationList.get(n);
            if (n2 == 0) {
                return calibration.getLabel();
            }
            if (n2 == 1) {
                return calibration.getPixelSizeUm().toString();
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            Calibration calibration = this.calibrationList.get(n);
            if (n2 == 1) {
                try {
                    double d = Double.parseDouble(object.toString());
                    CalibrationListDlg.this.core_.setPixelSizeUm(calibration.getLabel(), d);
                    calibration.setPixelSizeUm(d);
                    CalibrationListDlg.this.parentGUI_.setConfigChanged(true);
                    CalibrationListDlg.this.parentGUI_.refreshGUI();
                }
                catch (Exception exception) {
                    this.handleException(exception);
                }
            }
        }

        public int getCurrentPixelConfigRow() {
            try {
                String string = CalibrationListDlg.this.core_.getCurrentPixelSizeConfig();
                for (int i = 0; i < this.getRowCount(); ++i) {
                    if (!this.getValueAt(i, 0).equals(string)) continue;
                    return i;
                }
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception);
            }
            return -1;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        private void handleException(Exception exception) {
            String string = "Exception occurred: " + exception.getMessage();
            JOptionPane.showMessageDialog(null, string);
        }
    }
}

