/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.prefs.Preferences;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.BevelBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import mmcorej.CMMCore;
import mmcorej.Configuration;
import mmcorej.DeviceType;
import mmcorej.PropertySetting;
import mmcorej.PropertyType;
import mmcorej.StrVector;
import org.micromanager.api.ScriptInterface;
import org.micromanager.utils.MMDialog;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.ShowFlags;
import org.micromanager.utils.SliderPanel;
import org.micromanager.utils.SortFunctionObjects;

public class CalibrationEditor
extends MMDialog {
    private static final long serialVersionUID = 1L;
    private JTextArea textArea_;
    private JTextField presetSizeField_;
    private JTextField presetLabelField_;
    private String label_;
    private String pixelSize_;
    private SpringLayout springLayout;
    Boolean changed_;
    private JTable table_;
    private PropertyTableData data_;
    private ScriptInterface parentGUI_;
    private ShowFlags flags_;
    private JCheckBox showCamerasCheckBox_;
    private JCheckBox showShuttersCheckBox_;
    private JCheckBox showStagesCheckBox_;
    private JCheckBox showStateDevicesCheckBox_;
    private JCheckBox showOtherCheckBox_;
    private JCheckBox showReadonlyCheckBox_;
    private Configuration initialCfg_;
    private JScrollPane scrollPane_;
    private boolean tableEditable_ = true;

    public CalibrationEditor(String string, String string2) {
        this.setModal(true);
        this.label_ = string;
        this.pixelSize_ = string2;
        this.changed_ = false;
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        this.setPrefsNode(preferences.node(preferences.absolutePath() + "/PresetEditor"));
        this.initialCfg_ = new Configuration();
        this.flags_ = new ShowFlags();
        this.flags_.load(this.getPrefsNode());
        this.springLayout = new SpringLayout();
        this.getContentPane().setLayout(this.springLayout);
        this.setSize(551, 562);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CalibrationEditor.this.savePosition();
                CalibrationEditor.this.flags_.save(CalibrationEditor.this.getPrefsNode());
            }

            public void windowOpened(WindowEvent windowEvent) {
                CalibrationEditor.this.data_.updateFlags();
                CalibrationEditor.this.data_.updateStatus();
                CalibrationEditor.this.data_.showOriginalSelection();
            }

            public void windowClosed(WindowEvent windowEvent) {
                CalibrationEditor.this.savePosition();
                CalibrationEditor.this.flags_.save(CalibrationEditor.this.getPrefsNode());
            }
        });
        this.setTitle("Calibration Group Editor");
        this.loadPosition(100, 100, 400, 300);
        this.setDefaultCloseOperation(2);
        this.scrollPane_ = new JScrollPane();
        this.scrollPane_.setFont(new Font("Arial", 0, 10));
        this.scrollPane_.setBorder(new BevelBorder(1));
        this.getContentPane().add(this.scrollPane_);
        this.springLayout.putConstraint("South", (Component)this.scrollPane_, -5, "South", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.scrollPane_, 160, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)this.scrollPane_, -5, "East", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.scrollPane_, 5, "West", (Component)this.getContentPane());
        this.table_ = new JTable();
        this.table_.setSelectionMode(2);
        this.table_.setAutoCreateColumnsFromModel(false);
        this.scrollPane_.setViewportView(this.table_);
        this.showCamerasCheckBox_ = new JCheckBox();
        this.showCamerasCheckBox_.setFont(new Font("", 0, 10));
        this.showCamerasCheckBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((CalibrationEditor)CalibrationEditor.this).flags_.cameras_ = CalibrationEditor.this.showCamerasCheckBox_.isSelected();
                CalibrationEditor.this.data_.updateStatus();
            }
        });
        this.showCamerasCheckBox_.setText("Show cameras");
        this.getContentPane().add(this.showCamerasCheckBox_);
        this.springLayout.putConstraint("South", (Component)this.showCamerasCheckBox_, 28, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.showCamerasCheckBox_, 10, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)this.showCamerasCheckBox_, 111, "West", (Component)this.getContentPane());
        this.showShuttersCheckBox_ = new JCheckBox();
        this.showShuttersCheckBox_.setFont(new Font("", 0, 10));
        this.showShuttersCheckBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((CalibrationEditor)CalibrationEditor.this).flags_.shutters_ = CalibrationEditor.this.showShuttersCheckBox_.isSelected();
                CalibrationEditor.this.data_.updateStatus();
            }
        });
        this.showShuttersCheckBox_.setText("Show shutters");
        this.getContentPane().add(this.showShuttersCheckBox_);
        this.springLayout.putConstraint("East", (Component)this.showShuttersCheckBox_, 111, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.showShuttersCheckBox_, 10, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)this.showShuttersCheckBox_, 50, "North", (Component)this.getContentPane());
        this.showStagesCheckBox_ = new JCheckBox();
        this.showStagesCheckBox_.setFont(new Font("", 0, 10));
        this.showStagesCheckBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((CalibrationEditor)CalibrationEditor.this).flags_.stages_ = CalibrationEditor.this.showStagesCheckBox_.isSelected();
                CalibrationEditor.this.data_.updateStatus();
            }
        });
        this.showStagesCheckBox_.setText("Show stages");
        this.getContentPane().add(this.showStagesCheckBox_);
        this.springLayout.putConstraint("East", (Component)this.showStagesCheckBox_, 111, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.showStagesCheckBox_, 10, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)this.showStagesCheckBox_, 73, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.showStagesCheckBox_, 50, "North", (Component)this.getContentPane());
        this.showStateDevicesCheckBox_ = new JCheckBox();
        this.showStateDevicesCheckBox_.setFont(new Font("", 0, 10));
        this.showStateDevicesCheckBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((CalibrationEditor)CalibrationEditor.this).flags_.state_ = CalibrationEditor.this.showStateDevicesCheckBox_.isSelected();
                CalibrationEditor.this.data_.updateStatus();
            }
        });
        this.showStateDevicesCheckBox_.setText("Show wheels, turrets,etc.");
        this.getContentPane().add(this.showStateDevicesCheckBox_);
        this.springLayout.putConstraint("East", (Component)this.showStateDevicesCheckBox_, 165, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.showStateDevicesCheckBox_, 10, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)this.showStateDevicesCheckBox_, 95, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.showStateDevicesCheckBox_, 72, "North", (Component)this.getContentPane());
        this.showOtherCheckBox_ = new JCheckBox();
        this.showOtherCheckBox_.setFont(new Font("", 0, 10));
        this.showOtherCheckBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((CalibrationEditor)CalibrationEditor.this).flags_.other_ = CalibrationEditor.this.showOtherCheckBox_.isSelected();
                CalibrationEditor.this.data_.updateStatus();
            }
        });
        this.showOtherCheckBox_.setText("Show other devices");
        this.getContentPane().add(this.showOtherCheckBox_);
        this.springLayout.putConstraint("East", (Component)this.showOtherCheckBox_, 155, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.showOtherCheckBox_, 10, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.showOtherCheckBox_, 95, "North", (Component)this.getContentPane());
        boolean bl = true;
        if (bl) {
            this.showReadonlyCheckBox_ = new JCheckBox();
            this.showReadonlyCheckBox_.setFont(new Font("Arial", 0, 10));
            this.showReadonlyCheckBox_.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CalibrationEditor.this.data_.setShowReadonly(CalibrationEditor.this.showReadonlyCheckBox_.isSelected());
                    CalibrationEditor.this.data_.updateStatus();
                }
            });
            this.showReadonlyCheckBox_.setText("Show read-only properties");
            this.getContentPane().add(this.showReadonlyCheckBox_);
            this.springLayout.putConstraint("West", (Component)this.showReadonlyCheckBox_, 190, "West", (Component)this.getContentPane());
            this.springLayout.putConstraint("North", (Component)this.showReadonlyCheckBox_, 0, "North", (Component)this.showOtherCheckBox_);
        }
        JLabel jLabel = new JLabel();
        jLabel.setText("Label: ");
        jLabel.setFont(new Font("", 0, 10));
        this.getContentPane().add(jLabel);
        this.springLayout.putConstraint("East", (Component)jLabel, 340, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)jLabel, 190, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)jLabel, 26, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)jLabel, 15, "North", (Component)this.getContentPane());
        this.presetLabelField_ = new JTextField(this.label_);
        this.getContentPane().add(this.presetLabelField_);
        this.springLayout.putConstraint("East", (Component)this.presetLabelField_, 340, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.presetLabelField_, 190, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)this.presetLabelField_, 46, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.presetLabelField_, 27, "North", (Component)this.getContentPane());
        JLabel jLabel2 = new JLabel();
        jLabel2.setFont(new Font("", 0, 10));
        jLabel2.setText("Pixel Size (um/pixel):");
        this.getContentPane().add(jLabel2);
        this.springLayout.putConstraint("South", (Component)jLabel2, 70, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)jLabel2, 56, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)jLabel2, 340, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)jLabel2, 190, "West", (Component)this.getContentPane());
        this.presetSizeField_ = new JTextField(this.pixelSize_);
        this.getContentPane().add(this.presetSizeField_);
        this.springLayout.putConstraint("East", (Component)this.presetSizeField_, 340, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.presetSizeField_, 190, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)this.presetSizeField_, 90, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.presetSizeField_, 71, "North", (Component)this.getContentPane());
        JButton jButton = new JButton();
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CalibrationEditor.this.applySettings()) {
                    CalibrationEditor.this.changed_ = Boolean.TRUE;
                    CalibrationEditor.this.dispose();
                }
            }
        });
        jButton.setText("OK");
        this.getContentPane().add(jButton);
        this.springLayout.putConstraint("South", (Component)jButton, 49, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)jButton, 26, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)jButton, 475, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)jButton, 385, "West", (Component)this.getContentPane());
        JButton jButton2 = new JButton();
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CalibrationEditor.this.dispose();
            }
        });
        jButton2.setText("Cancel");
        this.getContentPane().add(jButton2);
        this.springLayout.putConstraint("East", (Component)jButton2, 475, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)jButton2, 385, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)jButton2, 75, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)jButton2, 52, "North", (Component)this.getContentPane());
        this.textArea_ = new JTextArea();
        this.textArea_.setFont(new Font("Arial", 0, 10));
        this.textArea_.setWrapStyleWord(true);
        this.textArea_.setText("Select all settings you want use in this calibration and press OK to save changes.\nYou can also change settings by clicking in the right hand column.");
        this.textArea_.setEditable(false);
        this.textArea_.setOpaque(false);
        this.getContentPane().add(this.textArea_);
        this.springLayout.putConstraint("East", (Component)this.textArea_, -5, "East", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.textArea_, 10, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)this.textArea_, 155, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.textArea_, 122, "North", (Component)this.getContentPane());
    }

    protected boolean applySettings() {
        Object object;
        int n = this.table_.getEditingColumn();
        if (n > -1) {
            object = this.table_.getColumnModel().getColumn(n).getCellEditor();
            if (object == null) {
                object = this.table_.getDefaultEditor(this.table_.getColumnClass(n));
            }
            if (object != null) {
                object.stopCellEditing();
            }
        }
        if (!this.data_.isEditingGroup()) {
            this.data_.updateStatus();
        }
        if ((object = this.data_.findMatchingPreset()) != null && ((String)object).compareTo(this.label_) != 0) {
            JOptionPane.showMessageDialog(this, "This calibration is the same as: " + (String)object + "\nYou must choose a unique set of values.");
            return false;
        }
        return this.data_.applySettings(this.label_, this.presetLabelField_.getText(), this.presetSizeField_.getText());
    }

    public void editNameOnly() {
        this.presetSizeField_.setEditable(false);
        this.tableEditable_ = false;
        if (this.data_.isEditingGroup()) {
            this.textArea_.setText("Please choose the properties to use when defining a pixel size configuration,\nand choose a name for the current pixel size settings.");
        } else {
            this.textArea_.setText("Please choose a name for this pixel size configuration.");
        }
    }

    public void setCore(CMMCore cMMCore) {
        this.data_ = new PropertyTableData(cMMCore, this.flags_);
        this.table_ = new JTable();
        this.table_.setSelectionMode(2);
        this.table_.setAutoCreateColumnsFromModel(false);
        this.scrollPane_.setViewportView(this.table_);
        this.table_.setModel(this.data_);
        if (cMMCore.isPixelSizeConfigDefined(this.label_)) {
            try {
                cMMCore.setPixelSizeConfig(this.label_);
            }
            catch (Exception exception) {
                ReportingUtils.showError(exception);
            }
        }
        PropertyCellEditor propertyCellEditor = new PropertyCellEditor();
        PropertyCellRenderer propertyCellRenderer = new PropertyCellRenderer();
        for (int i = 0; i < this.data_.getColumnCount(); ++i) {
            TableColumn tableColumn = new TableColumn(i, 200, propertyCellRenderer, propertyCellEditor);
            this.table_.addColumn(tableColumn);
        }
        this.showCamerasCheckBox_.setSelected(this.flags_.cameras_);
        this.showStagesCheckBox_.setSelected(this.flags_.stages_);
        this.showShuttersCheckBox_.setSelected(this.flags_.shutters_);
        this.showStateDevicesCheckBox_.setSelected(this.flags_.state_);
        this.showOtherCheckBox_.setSelected(this.flags_.other_);
        if (!this.data_.isEditingGroup()) {
            this.getContentPane().remove(this.showCamerasCheckBox_);
            this.getContentPane().remove(this.showStagesCheckBox_);
            this.getContentPane().remove(this.showShuttersCheckBox_);
            this.getContentPane().remove(this.showStateDevicesCheckBox_);
            this.getContentPane().remove(this.showOtherCheckBox_);
            this.getContentPane().remove(this.showReadonlyCheckBox_);
            this.data_.setShowReadonly(true);
            this.textArea_.setText("Choose values for the properties contained in this calibration.\nAvailable properties are determined by the first preset defined for this group");
        }
        this.data_.updateFlags();
        this.data_.updateStatus();
    }

    public void setParentGUI(ScriptInterface scriptInterface) {
        this.parentGUI_ = scriptInterface;
    }

    private void handleException(Exception exception) {
        String string = "Exception occurred: " + exception.getMessage();
        JOptionPane.showMessageDialog(this, string);
    }

    public boolean isChanged() {
        return this.changed_;
    }

    public class PropertyCellRenderer
    implements TableCellRenderer {
        PropertyItem item_;

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JComponent jComponent;
            PropertyTableData propertyTableData = (PropertyTableData)jTable.getModel();
            this.item_ = propertyTableData.getPropertyItem(n);
            JLabel jLabel = new JLabel();
            jLabel.setHorizontalAlignment(2);
            jLabel.setOpaque(true);
            if (this.item_.readOnly) {
                jLabel.setBackground(Color.LIGHT_GRAY);
            } else {
                jLabel.setBackground(Color.WHITE);
            }
            if (bl2) {
                // empty if block
            }
            if (n2 == 0) {
                jLabel.setText((String)object);
                jComponent = jLabel;
            } else if (n2 == 1) {
                if (this.item_.hasRange) {
                    SliderPanel sliderPanel = new SliderPanel();
                    if (this.item_.isInteger()) {
                        sliderPanel.setLimits((int)this.item_.lowerLimit, (int)this.item_.upperLimit);
                    } else {
                        sliderPanel.setLimits(this.item_.lowerLimit, this.item_.upperLimit);
                    }
                    try {
                        if (this.item_.isFloat()) {
                            object = NumberUtils.doubleToDisplayString(Double.parseDouble((String)object));
                        } else if (this.item_.isInteger()) {
                            object = NumberUtils.intToDisplayString(Integer.parseInt((String)object));
                        }
                    }
                    catch (Exception exception) {
                        ReportingUtils.logError(exception);
                    }
                    sliderPanel.setText((String)object);
                    sliderPanel.setToolTipText((String)object);
                    jComponent = sliderPanel;
                } else {
                    jLabel.setText(this.item_.value.toString());
                    jComponent = jLabel;
                }
            } else if (n2 == 2) {
                JCheckBox jCheckBox = new JCheckBox();
                jCheckBox.setSelected(this.item_.confInclude);
                if (this.item_.readOnly) {
                    jCheckBox.setEnabled(false);
                }
                jComponent = jCheckBox;
            } else {
                jLabel.setText("Undefined");
                jComponent = jLabel;
            }
            return jComponent;
        }

        public void validate() {
        }

        public void revalidate() {
        }

        protected void firePropertyChange(String string, Object object, Object object2) {
        }

        public void firePropertyChange(String string, boolean bl, boolean bl2) {
        }
    }

    public class PropertyCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        JTextField text_ = new JTextField();
        JComboBox combo_ = new JComboBox();
        JCheckBox check_ = new JCheckBox();
        int editingCol_;
        PropertyItem item_;
        SliderPanel slider_ = new SliderPanel();

        public PropertyCellEditor() {
            this.check_.setSelected(false);
            this.check_.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PropertyCellEditor.this.fireEditingStopped();
                }
            });
            this.combo_.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PropertyCellEditor.this.fireEditingStopped();
                }
            });
            this.slider_.addEditActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PropertyCellEditor.this.fireEditingStopped();
                }
            });
            this.slider_.addSliderMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent mouseEvent) {
                    PropertyCellEditor.this.fireEditingStopped();
                }
            });
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (bl) {
                // empty if block
            }
            this.editingCol_ = n2;
            PropertyTableData propertyTableData = (PropertyTableData)jTable.getModel();
            this.item_ = propertyTableData.getPropertyItem(n);
            if (n2 == 1) {
                int n3;
                if (this.item_.allowed.length == 0) {
                    if (this.item_.hasRange) {
                        if (this.item_.isInteger()) {
                            this.slider_.setLimits((int)this.item_.lowerLimit, (int)this.item_.upperLimit);
                        } else {
                            this.slider_.setLimits(this.item_.lowerLimit, this.item_.upperLimit);
                            try {
                                object = NumberUtils.doubleToDisplayString(Double.parseDouble((String)object));
                            }
                            catch (Exception exception) {
                                ReportingUtils.logError(exception);
                            }
                        }
                        this.slider_.setText((String)object);
                        return this.slider_;
                    }
                    this.text_.setText((String)object);
                    return this.text_;
                }
                ActionListener[] actionListenerArray = this.combo_.getActionListeners();
                for (n3 = 0; n3 < actionListenerArray.length; ++n3) {
                    this.combo_.removeActionListener(actionListenerArray[n3]);
                }
                this.combo_.removeAllItems();
                for (n3 = 0; n3 < this.item_.allowed.length; ++n3) {
                    this.combo_.addItem(this.item_.allowed[n3]);
                }
                this.combo_.setSelectedItem(this.item_.value);
                return this.combo_;
            }
            if (n2 == 2) {
                this.check_.setSelected(this.item_.confInclude);
                return this.check_;
            }
            return null;
        }

        public Object getCellEditorValue() {
            if (this.editingCol_ == 1) {
                if (this.item_.allowed.length == 0) {
                    if (this.item_.hasRange) {
                        return this.slider_.getText();
                    }
                    return this.text_.getText();
                }
                return this.combo_.getSelectedItem();
            }
            if (this.editingCol_ == 2) {
                return this.check_.isSelected();
            }
            return null;
        }
    }

    class PropertyTableData
    extends AbstractTableModel {
        private static final long serialVersionUID = -5582899855072387637L;
        public final String[] columnNames_ = new String[]{"Property", "Value", "Use"};
        ArrayList<PropertyItem> propList_ = new ArrayList();
        private CMMCore core_ = null;
        Configuration[] groupData_;
        PropertySetting[] groupSignature_;
        private boolean showReadonly_ = false;
        private String[] presetNames_;

        public PropertyTableData(CMMCore cMMCore, ShowFlags showFlags) {
            this.core_ = cMMCore;
            CalibrationEditor.this.flags_ = showFlags;
            this.updateStatus();
        }

        public String findMatchingPreset() {
            int n;
            ArrayList<PropertyItem> arrayList = new ArrayList<PropertyItem>();
            for (n = 0; n < this.propList_.size(); ++n) {
                PropertyItem propertyItem = this.propList_.get(n);
                if (!propertyItem.confInclude) continue;
                arrayList.add(propertyItem);
            }
            for (n = 0; n < this.groupData_.length; ++n) {
                int n2 = 0;
                for (int i = 0; i < arrayList.size(); ++i) {
                    PropertyItem propertyItem = (PropertyItem)arrayList.get(i);
                    PropertySetting propertySetting = new PropertySetting(propertyItem.device, propertyItem.name, propertyItem.value);
                    if (!this.groupData_[n].isSettingIncluded(propertySetting)) continue;
                    ++n2;
                }
                if (n2 != arrayList.size()) continue;
                return this.presetNames_[n];
            }
            return null;
        }

        public void setShowReadonly(boolean bl) {
            this.showReadonly_ = bl;
        }

        public boolean applySettings(String string, String string2, String string3) {
            Object object;
            if (!string.equals(string2)) {
                try {
                    if (this.core_.isPixelSizeConfigDefined(string)) {
                        this.core_.deletePixelSizeConfig(string);
                    }
                }
                catch (Exception exception) {
                    ReportingUtils.showError(exception);
                    return false;
                }
            }
            ArrayList<PropertyItem> arrayList = new ArrayList<PropertyItem>();
            for (int i = 0; i < this.propList_.size(); ++i) {
                object = this.propList_.get(i);
                if (!((PropertyItem)object).confInclude) continue;
                arrayList.add((PropertyItem)object);
            }
            if (arrayList.isEmpty()) {
                JOptionPane.showMessageDialog(null, "Please select \"Use\" column for at least one Property that affects pixel size");
                return false;
            }
            ArrayList<PropertyItem> arrayList2 = new ArrayList<PropertyItem>();
            object = new ArrayList();
            if (!this.isEditingGroup()) {
                int n;
                for (n = 0; n < arrayList.size(); ++n) {
                    int n2;
                    PropertyItem propertyItem = (PropertyItem)arrayList.get(n);
                    for (n2 = 0; n2 < this.groupSignature_.length && (propertyItem.device.compareTo(this.groupSignature_[n2].getDeviceLabel()) != 0 || propertyItem.name.compareTo(this.groupSignature_[n2].getPropertyName()) != 0); ++n2) {
                    }
                    if (this.groupSignature_.length != n2) continue;
                    arrayList2.add(propertyItem);
                }
                for (n = 0; n < this.groupSignature_.length; ++n) {
                    int n3;
                    for (n3 = 0; n3 < arrayList.size(); ++n3) {
                        PropertyItem propertyItem = (PropertyItem)arrayList.get(n3);
                        if (propertyItem.device.compareTo(this.groupSignature_[n].getDeviceLabel()) == 0 && propertyItem.name.compareTo(this.groupSignature_[n].getPropertyName()) == 0) break;
                    }
                    if (arrayList.size() != n3) continue;
                    ((ArrayList)object).add(this.groupSignature_[n]);
                }
            }
            if (arrayList2.size() > 0 || ((ArrayList)object).size() > 0) {
                String string4 = "";
                for (int i = 0; i < arrayList2.size(); ++i) {
                    string4 = string4 + ((PropertyItem)arrayList2.get((int)i)).device + "-" + ((PropertyItem)arrayList2.get((int)i)).name + "\n";
                }
                String string5 = "";
                for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                    string5 = string5 + ((PropertySetting)((ArrayList)object).get(i)).getDeviceLabel() + "-" + ((PropertySetting)((ArrayList)object).get(i)).getPropertyName() + "\n";
                }
                String string6 = "All presets within a group should operate on the same set of device properties.\nBased on the previously defined presets in this group, the following inconsistencises were detected:\n\n" + (arrayList2.size() > 0 ? "Properties not previously defined:\n" + string4 : "\n") + (((ArrayList)object).size() > 0 ? "Properties prviously defined but missing from this preset:\n" + string5 : "\n") + "\nPlease revise all presets in a single group to use the same set of properties.\n" + "Otherwise some of the presets within the group may appear to be ambiguous";
                JOptionPane.showMessageDialog(null, string6);
            }
            try {
                if (this.core_.isPixelSizeConfigDefined(string2)) {
                    this.core_.deletePixelSizeConfig(string2);
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    PropertyItem propertyItem = (PropertyItem)arrayList.get(i);
                    this.core_.definePixelSizeConfig(string2, propertyItem.device, propertyItem.name, propertyItem.value);
                }
                this.core_.setPixelSizeUm(string2, NumberUtils.displayStringToDouble(string3));
            }
            catch (Exception exception) {
                ReportingUtils.showError(exception);
                return false;
            }
            return true;
        }

        public boolean verifyPresetSignature() {
            return true;
        }

        public void deletePixelSizeConfig(String string) {
            try {
                this.core_.deletePixelSizeConfig(string);
            }
            catch (Exception exception) {
                ReportingUtils.showError(exception);
            }
        }

        public int getRowCount() {
            return this.propList_.size();
        }

        public int getColumnCount() {
            if (this.isEditingGroup()) {
                return this.columnNames_.length;
            }
            return this.columnNames_.length - 1;
        }

        public boolean isEditingGroup() {
            return this.groupSignature_.length == 0;
        }

        public PropertyItem getPropertyItem(int n) {
            return this.propList_.get(n);
        }

        public Object getValueAt(int n, int n2) {
            PropertyItem propertyItem = this.propList_.get(n);
            if (n2 == 0) {
                return propertyItem.device + "-" + propertyItem.name;
            }
            if (n2 == 1) {
                return propertyItem.value;
            }
            if (n2 == 2) {
                return propertyItem.confInclude;
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            PropertyItem propertyItem = this.propList_.get(n);
            if (n2 == 1) {
                try {
                    if (propertyItem.isInteger()) {
                        this.core_.setProperty(propertyItem.device, propertyItem.name, new Integer(NumberUtils.displayStringToInt((String)object)).toString());
                    } else if (propertyItem.isFloat()) {
                        this.core_.setProperty(propertyItem.device, propertyItem.name, new Double(NumberUtils.displayStringToDouble((String)object)).toString());
                    } else {
                        this.core_.setProperty(propertyItem.device, propertyItem.name, object.toString());
                    }
                    this.core_.waitForDevice(propertyItem.device);
                    this.refresh();
                    if (CalibrationEditor.this.parentGUI_ != null) {
                        CalibrationEditor.this.parentGUI_.updateGUI(true);
                    }
                    this.fireTableCellUpdated(n, n2);
                }
                catch (Exception exception) {
                    ReportingUtils.showError(exception);
                }
            } else if (n2 == 2) {
                propertyItem.confInclude = (Boolean)object;
            }
        }

        public String getColumnName(int n) {
            return this.columnNames_[n];
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 1) {
                return CalibrationEditor.this.tableEditable_ && !this.propList_.get((int)n).readOnly;
            }
            if (n2 == 2) {
                return this.isEditingGroup();
            }
            return false;
        }

        StrVector getAvailablePixelSizeConfigs() {
            return this.core_.getAvailablePixelSizeConfigs();
        }

        public void refresh() {
            try {
                for (int i = 0; i < this.propList_.size(); ++i) {
                    PropertyItem propertyItem = this.propList_.get(i);
                    propertyItem.value = this.core_.getProperty(propertyItem.device, propertyItem.name);
                }
                this.fireTableDataChanged();
            }
            catch (Exception exception) {
                ReportingUtils.showError(exception);
            }
        }

        public final void updateStatus() {
            this.groupData_ = new Configuration[0];
            StrVector strVector = new StrVector(0L);
            try {
                int n;
                if (this.core_.isPixelSizeConfigDefined(CalibrationEditor.this.label_)) {
                    CalibrationEditor.this.initialCfg_ = this.core_.getPixelSizeConfigData(CalibrationEditor.this.label_);
                }
                strVector = this.core_.getAvailablePixelSizeConfigs();
                this.groupData_ = new Configuration[(int)strVector.size()];
                this.presetNames_ = new String[(int)strVector.size()];
                for (n = 0; n < this.groupData_.length; ++n) {
                    this.groupData_[n] = this.core_.getPixelSizeConfigData(strVector.get(n));
                    this.presetNames_[n] = strVector.get(n);
                }
                if (this.groupData_.length > 0) {
                    this.groupSignature_ = new PropertySetting[(int)this.groupData_[0].size()];
                    n = 0;
                    while ((long)n < this.groupData_[0].size()) {
                        this.groupSignature_[n] = this.groupData_[0].getSetting(n);
                        ++n;
                    }
                } else {
                    this.groupSignature_ = new PropertySetting[0];
                }
            }
            catch (Exception exception) {
                ReportingUtils.showError(exception);
            }
            try {
                StrVector strVector2 = this.core_.getLoadedDevices();
                this.propList_.clear();
                int n = 0;
                while ((long)n < strVector2.size()) {
                    DeviceType deviceType = this.core_.getDeviceType(strVector2.get(n));
                    boolean bl = false;
                    bl = deviceType == DeviceType.MagnifierDevice ? false : (deviceType == DeviceType.SerialDevice ? false : (deviceType == DeviceType.CameraDevice ? ((CalibrationEditor)CalibrationEditor.this).flags_.cameras_ : (deviceType == DeviceType.ShutterDevice ? ((CalibrationEditor)CalibrationEditor.this).flags_.shutters_ : (deviceType == DeviceType.StageDevice ? ((CalibrationEditor)CalibrationEditor.this).flags_.stages_ : (deviceType == DeviceType.XYStageDevice ? ((CalibrationEditor)CalibrationEditor.this).flags_.stages_ : (deviceType == DeviceType.StateDevice ? ((CalibrationEditor)CalibrationEditor.this).flags_.state_ : ((CalibrationEditor)CalibrationEditor.this).flags_.other_))))));
                    if (bl) {
                        StrVector strVector3 = this.core_.getDevicePropertyNames(strVector2.get(n));
                        int n2 = 0;
                        while ((long)n2 < strVector3.size()) {
                            PropertyItem propertyItem = new PropertyItem();
                            propertyItem.device = strVector2.get(n);
                            propertyItem.name = strVector3.get(n2);
                            propertyItem.value = this.core_.getProperty(strVector2.get(n), strVector3.get(n2));
                            propertyItem.readOnly = this.core_.isPropertyReadOnly(strVector2.get(n), strVector3.get(n2));
                            propertyItem.preInit = this.core_.isPropertyPreInit(strVector2.get(n), strVector3.get(n2));
                            propertyItem.hasRange = this.core_.hasPropertyLimits(strVector2.get(n), strVector3.get(n2));
                            propertyItem.lowerLimit = this.core_.getPropertyLowerLimit(strVector2.get(n), strVector3.get(n2));
                            propertyItem.upperLimit = this.core_.getPropertyUpperLimit(strVector2.get(n), strVector3.get(n2));
                            propertyItem.type = this.core_.getPropertyType(propertyItem.device, propertyItem.name);
                            StrVector strVector4 = this.core_.getAllowedPropertyValues(strVector2.get(n), strVector3.get(n2));
                            propertyItem.allowed = new String[(int)strVector4.size()];
                            int n3 = 0;
                            while ((long)n3 < strVector4.size()) {
                                propertyItem.allowed[n3] = strVector4.get(n3);
                                ++n3;
                            }
                            if (PropertyType.Float == propertyItem.type) {
                                Arrays.sort(propertyItem.allowed, new SortFunctionObjects.DoubleStringComp());
                            } else if (PropertyType.Integer == propertyItem.type) {
                                Arrays.sort(propertyItem.allowed, new SortFunctionObjects.IntStringComp());
                            } else if (PropertyType.String == propertyItem.type) {
                                n3 = 1;
                                for (int i = 0; i < propertyItem.allowed.length; ++i) {
                                    if (!propertyItem.allowed[i].equals("") && Character.isDigit(propertyItem.allowed[i].charAt(0))) continue;
                                    n3 = 0;
                                    break;
                                }
                                if (n3 != 0) {
                                    Arrays.sort(propertyItem.allowed, new SortFunctionObjects.NumericPrefixStringComp());
                                } else {
                                    Arrays.sort(propertyItem.allowed);
                                }
                            }
                            if (!(propertyItem.preInit || propertyItem.readOnly && !this.showReadonly_)) {
                                propertyItem.confInclude = CalibrationEditor.this.initialCfg_.isPropertyIncluded(propertyItem.device, propertyItem.name);
                                if (this.isMatchingSignature(propertyItem) && (deviceType != DeviceType.CameraDevice || !propertyItem.name.equals("Binning"))) {
                                    this.propList_.add(propertyItem);
                                    if (!this.isEditingGroup()) {
                                        propertyItem.confInclude = true;
                                    }
                                }
                            }
                            ++n2;
                        }
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                ReportingUtils.showError(exception);
            }
            this.fireTableStructureChanged();
        }

        private boolean isMatchingSignature(PropertyItem propertyItem) {
            int n;
            if (this.isEditingGroup()) {
                return true;
            }
            for (n = 0; n < this.groupSignature_.length && (propertyItem.device.compareTo(this.groupSignature_[n].getDeviceLabel()) != 0 || propertyItem.name.compareTo(this.groupSignature_[n].getPropertyName()) != 0); ++n) {
            }
            return n != this.groupSignature_.length;
        }

        private void updateFlags() {
            try {
                if (this.core_.isPixelSizeConfigDefined(CalibrationEditor.this.label_)) {
                    CalibrationEditor.this.initialCfg_ = this.core_.getPixelSizeConfigData(CalibrationEditor.this.label_);
                }
                int n = 0;
                while ((long)n < CalibrationEditor.this.initialCfg_.size()) {
                    DeviceType deviceType = this.core_.getDeviceType(CalibrationEditor.this.initialCfg_.getSetting(n).getDeviceLabel());
                    if (deviceType == DeviceType.CameraDevice) {
                        ((CalibrationEditor)CalibrationEditor.this).flags_.cameras_ = true;
                        CalibrationEditor.this.showCamerasCheckBox_.setSelected(true);
                    } else if (deviceType == DeviceType.ShutterDevice) {
                        ((CalibrationEditor)CalibrationEditor.this).flags_.shutters_ = true;
                        CalibrationEditor.this.showShuttersCheckBox_.setSelected(true);
                    } else if (deviceType == DeviceType.StageDevice) {
                        ((CalibrationEditor)CalibrationEditor.this).flags_.stages_ = true;
                        CalibrationEditor.this.showStagesCheckBox_.setSelected(true);
                    } else if (deviceType == DeviceType.StateDevice) {
                        ((CalibrationEditor)CalibrationEditor.this).flags_.state_ = true;
                        CalibrationEditor.this.showStateDevicesCheckBox_.setSelected(true);
                    } else {
                        CalibrationEditor.this.showOtherCheckBox_.setSelected(true);
                        ((CalibrationEditor)CalibrationEditor.this).flags_.other_ = true;
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                ReportingUtils.showError(exception);
            }
        }

        public void showOriginalSelection() {
            for (int i = 0; i < this.propList_.size(); ++i) {
                PropertyItem propertyItem = this.propList_.get(i);
                propertyItem.confInclude = CalibrationEditor.this.initialCfg_.size() == 0L ? false : CalibrationEditor.this.initialCfg_.isPropertyIncluded(propertyItem.device, propertyItem.name);
            }
            this.fireTableDataChanged();
        }
    }
}

