/*
 * Decompiled with CFR 0.152.
 */
package mmcorej;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import mmcorej.CharVector;
import mmcorej.Configuration;
import mmcorej.DeviceDetectionStatus;
import mmcorej.DeviceType;
import mmcorej.DoubleVector;
import mmcorej.LongVector;
import mmcorej.MMCoreJJNI;
import mmcorej.MMEventCallback;
import mmcorej.Metadata;
import mmcorej.PropertyBlock;
import mmcorej.PropertySetting;
import mmcorej.PropertyType;
import mmcorej.StrVector;
import mmcorej.TaggedImage;
import org.json.JSONObject;

public class CMMCore {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected CMMCore(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(CMMCore cMMCore) {
        return cMMCore == null ? 0L : cMMCore.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MMCoreJJNI.delete_CMMCore(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    private JSONObject metadataToMap(Metadata metadata) {
        JSONObject jSONObject = new JSONObject();
        for (String string : metadata.GetKeys()) {
            try {
                jSONObject.put(string, metadata.GetSingleTag(string).GetValue());
            }
            catch (Exception exception) {}
        }
        return jSONObject;
    }

    private String getROITag() throws Exception {
        String string = "";
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        this.getROI(nArray, nArray2, nArray3, nArray4);
        string = string + nArray[0] + "-" + nArray2[0] + "-" + nArray3[0] + "-" + nArray4[0];
        return string;
    }

    private String getPixelType() {
        int n = (int)this.getBytesPerPixel();
        switch (n) {
            case 1: {
                return "GRAY8";
            }
            case 2: {
                return "GRAY16";
            }
            case 4: {
                return "RGB32";
            }
            case 8: {
                return "RGB64";
            }
        }
        return "";
    }

    private String getMultiCameraChannel(JSONObject jSONObject, int n) {
        try {
            String string = jSONObject.getString("Core-Camera");
            String string2 = string + "-Physical Camera " + (1 + n);
            if (jSONObject.has(string2)) {
                try {
                    return jSONObject.getString(string2);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private TaggedImage createTaggedImage(Object object, Metadata metadata, int n) throws Exception {
        TaggedImage taggedImage = this.createTaggedImage(object, metadata);
        taggedImage.tags.put("CameraChannelIndex", n);
        String string = this.getMultiCameraChannel(taggedImage.tags, n);
        if (string != null) {
            taggedImage.tags.put("Camera", string);
        }
        return taggedImage;
    }

    private TaggedImage createTaggedImage(Object object, Metadata metadata) throws Exception {
        JSONObject jSONObject = this.metadataToMap(metadata);
        Configuration configuration = this.getSystemStateCache();
        int n = 0;
        while ((long)n < configuration.size()) {
            PropertySetting propertySetting = configuration.getSetting(n);
            String string = propertySetting.getDeviceLabel() + "-" + propertySetting.getPropertyName();
            String string2 = propertySetting.getPropertyValue();
            jSONObject.put(string, string2);
            ++n;
        }
        jSONObject.put("BitDepth", this.getImageBitDepth());
        jSONObject.put("PixelSizeUm", this.getPixelSizeUm(true));
        jSONObject.put("ROI", this.getROITag());
        jSONObject.put("Width", this.getImageWidth());
        jSONObject.put("Height", this.getImageHeight());
        jSONObject.put("PixelType", this.getPixelType());
        try {
            jSONObject.put("Binning", this.getProperty(this.getCameraDevice(), "Binning"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new TaggedImage(object, jSONObject);
    }

    public TaggedImage getTaggedImage(int n) throws Exception {
        Metadata metadata = new Metadata();
        Object object = this.getImage(n);
        return this.createTaggedImage(object, metadata, n);
    }

    public TaggedImage getTaggedImage() throws Exception {
        return this.getTaggedImage(0);
    }

    public TaggedImage getLastTaggedImage(int n) throws Exception {
        Metadata metadata = new Metadata();
        Object object = this.getLastImageMD(n, 0L, metadata);
        return this.createTaggedImage(object, metadata, n);
    }

    public TaggedImage getLastTaggedImage() throws Exception {
        return this.getLastTaggedImage(0);
    }

    public TaggedImage getNBeforeLastTaggedImage(long l) throws Exception {
        Metadata metadata = new Metadata();
        Object object = this.getNBeforeLastImageMD(l, metadata);
        return this.createTaggedImage(object, metadata);
    }

    public TaggedImage popNextTaggedImage(int n) throws Exception {
        Metadata metadata = new Metadata();
        Object object = this.popNextImageMD(n, 0L, metadata);
        return this.createTaggedImage(object, metadata, n);
    }

    public TaggedImage popNextTaggedImage() throws Exception {
        return this.popNextTaggedImage(0);
    }

    public Rectangle getROI() throws Exception {
        int[][] nArray = new int[4][1];
        this.getROI(nArray[0], nArray[1], nArray[2], nArray[3]);
        return new Rectangle(nArray[0][0], nArray[1][0], nArray[2][0], nArray[3][0]);
    }

    public Point2D.Double getXYStagePosition(String string) throws Exception {
        double[][] dArray = new double[2][1];
        this.getXYPosition(string, dArray[0], dArray[1]);
        return new Point2D.Double(dArray[0][0], dArray[1][0]);
    }

    public Point2D.Double getGalvoPosition(String string) throws Exception {
        double[][] dArray = new double[2][1];
        this.getGalvoPosition(string, dArray[0], dArray[1]);
        return new Point2D.Double(dArray[0][0], dArray[1][0]);
    }

    public CMMCore() {
        this(MMCoreJJNI.new_CMMCore(), true);
    }

    public void loadDevice(String string, String string2, String string3) throws Exception {
        MMCoreJJNI.CMMCore_loadDevice(this.swigCPtr, this, string, string2, string3);
    }

    public void unloadDevice(String string) throws Exception {
        MMCoreJJNI.CMMCore_unloadDevice(this.swigCPtr, this, string);
    }

    public void unloadAllDevices() throws Exception {
        MMCoreJJNI.CMMCore_unloadAllDevices(this.swigCPtr, this);
    }

    public void initializeAllDevices() throws Exception {
        MMCoreJJNI.CMMCore_initializeAllDevices(this.swigCPtr, this);
    }

    public void initializeDevice(String string) throws Exception {
        MMCoreJJNI.CMMCore_initializeDevice(this.swigCPtr, this, string);
    }

    public void updateCoreProperties() throws Exception {
        MMCoreJJNI.CMMCore_updateCoreProperties(this.swigCPtr, this);
    }

    public void reset() throws Exception {
        MMCoreJJNI.CMMCore_reset(this.swigCPtr, this);
    }

    public void clearLog() {
        MMCoreJJNI.CMMCore_clearLog(this.swigCPtr, this);
    }

    public void enableDebugLog(boolean bl) {
        MMCoreJJNI.CMMCore_enableDebugLog(this.swigCPtr, this, bl);
    }

    public boolean debugLogEnabled() {
        return MMCoreJJNI.CMMCore_debugLogEnabled(this.swigCPtr, this);
    }

    public void enableStderrLog(boolean bl) {
        MMCoreJJNI.CMMCore_enableStderrLog(this.swigCPtr, this, bl);
    }

    public String getUserId() {
        return MMCoreJJNI.CMMCore_getUserId(this.swigCPtr, this);
    }

    public String getHostName() {
        return MMCoreJJNI.CMMCore_getHostName(this.swigCPtr, this);
    }

    public void logMessage(String string) {
        MMCoreJJNI.CMMCore_logMessage__SWIG_0(this.swigCPtr, this, string);
    }

    public void logMessage(String string, boolean bl) {
        MMCoreJJNI.CMMCore_logMessage__SWIG_1(this.swigCPtr, this, string, bl);
    }

    public String saveLogArchive() {
        return MMCoreJJNI.CMMCore_saveLogArchive(this.swigCPtr, this);
    }

    public String saveLogArchiveWithPreamble(String string, int n) {
        return MMCoreJJNI.CMMCore_saveLogArchiveWithPreamble(this.swigCPtr, this, string, n);
    }

    public String getVersionInfo() {
        return MMCoreJJNI.CMMCore_getVersionInfo(this.swigCPtr, this);
    }

    public String getAPIVersionInfo() {
        return MMCoreJJNI.CMMCore_getAPIVersionInfo(this.swigCPtr, this);
    }

    public Configuration getSystemState() {
        return new Configuration(MMCoreJJNI.CMMCore_getSystemState(this.swigCPtr, this), true);
    }

    public Configuration getSystemStateCache() {
        return new Configuration(MMCoreJJNI.CMMCore_getSystemStateCache(this.swigCPtr, this), true);
    }

    public void updateSystemStateCache() {
        MMCoreJJNI.CMMCore_updateSystemStateCache(this.swigCPtr, this);
    }

    public void setSystemState(Configuration configuration) {
        MMCoreJJNI.CMMCore_setSystemState(this.swigCPtr, this, Configuration.getCPtr(configuration), configuration);
    }

    public Configuration getConfigState(String string, String string2) throws Exception {
        return new Configuration(MMCoreJJNI.CMMCore_getConfigState(this.swigCPtr, this, string, string2), true);
    }

    public Configuration getConfigGroupState(String string) throws Exception {
        return new Configuration(MMCoreJJNI.CMMCore_getConfigGroupState(this.swigCPtr, this, string), true);
    }

    public Configuration getConfigGroupStateFromCache(String string) throws Exception {
        return new Configuration(MMCoreJJNI.CMMCore_getConfigGroupStateFromCache(this.swigCPtr, this, string), true);
    }

    public void saveSystemState(String string) throws Exception {
        MMCoreJJNI.CMMCore_saveSystemState(this.swigCPtr, this, string);
    }

    public void loadSystemState(String string) throws Exception {
        MMCoreJJNI.CMMCore_loadSystemState(this.swigCPtr, this, string);
    }

    public void saveSystemConfiguration(String string) throws Exception {
        MMCoreJJNI.CMMCore_saveSystemConfiguration(this.swigCPtr, this, string);
    }

    public void loadSystemConfiguration(String string) throws Exception {
        MMCoreJJNI.CMMCore_loadSystemConfiguration(this.swigCPtr, this, string);
    }

    public void registerCallback(MMEventCallback mMEventCallback) {
        MMCoreJJNI.CMMCore_registerCallback(this.swigCPtr, this, MMEventCallback.getCPtr(mMEventCallback), mMEventCallback);
    }

    public StrVector getAvailableDevices(String string) throws Exception {
        return new StrVector(MMCoreJJNI.CMMCore_getAvailableDevices(this.swigCPtr, this, string), true);
    }

    public StrVector getAvailableDeviceDescriptions(String string) throws Exception {
        return new StrVector(MMCoreJJNI.CMMCore_getAvailableDeviceDescriptions(this.swigCPtr, this, string), true);
    }

    public LongVector getAvailableDeviceTypes(String string) throws Exception {
        return new LongVector(MMCoreJJNI.CMMCore_getAvailableDeviceTypes(this.swigCPtr, this, string), true);
    }

    public static void addSearchPath(String string) {
        MMCoreJJNI.CMMCore_addSearchPath(string);
    }

    public static StrVector getDeviceLibraries() throws Exception {
        return new StrVector(MMCoreJJNI.CMMCore_getDeviceLibraries(), true);
    }

    public StrVector getLoadedDevices() {
        return new StrVector(MMCoreJJNI.CMMCore_getLoadedDevices(this.swigCPtr, this), true);
    }

    public StrVector getLoadedDevicesOfType(DeviceType deviceType) {
        return new StrVector(MMCoreJJNI.CMMCore_getLoadedDevicesOfType(this.swigCPtr, this, deviceType.swigValue()), true);
    }

    public StrVector getDevicePropertyNames(String string) throws Exception {
        return new StrVector(MMCoreJJNI.CMMCore_getDevicePropertyNames(this.swigCPtr, this, string), true);
    }

    public String getProperty(String string, String string2) throws Exception {
        return MMCoreJJNI.CMMCore_getProperty(this.swigCPtr, this, string, string2);
    }

    public String getPropertyFromCache(String string, String string2) throws Exception {
        return MMCoreJJNI.CMMCore_getPropertyFromCache(this.swigCPtr, this, string, string2);
    }

    public void setProperty(String string, String string2, String string3) throws Exception {
        MMCoreJJNI.CMMCore_setProperty__SWIG_0(this.swigCPtr, this, string, string2, string3);
    }

    public void setProperty(String string, String string2, boolean bl) throws Exception {
        MMCoreJJNI.CMMCore_setProperty__SWIG_1(this.swigCPtr, this, string, string2, bl);
    }

    public void setProperty(String string, String string2, int n) throws Exception {
        MMCoreJJNI.CMMCore_setProperty__SWIG_2(this.swigCPtr, this, string, string2, n);
    }

    public void setProperty(String string, String string2, float f) throws Exception {
        MMCoreJJNI.CMMCore_setProperty__SWIG_3(this.swigCPtr, this, string, string2, f);
    }

    public void setProperty(String string, String string2, double d) throws Exception {
        MMCoreJJNI.CMMCore_setProperty__SWIG_4(this.swigCPtr, this, string, string2, d);
    }

    public boolean hasProperty(String string, String string2) throws Exception {
        return MMCoreJJNI.CMMCore_hasProperty(this.swigCPtr, this, string, string2);
    }

    public StrVector getAllowedPropertyValues(String string, String string2) throws Exception {
        return new StrVector(MMCoreJJNI.CMMCore_getAllowedPropertyValues(this.swigCPtr, this, string, string2), true);
    }

    public boolean isPropertyReadOnly(String string, String string2) throws Exception {
        return MMCoreJJNI.CMMCore_isPropertyReadOnly(this.swigCPtr, this, string, string2);
    }

    public boolean isPropertyPreInit(String string, String string2) throws Exception {
        return MMCoreJJNI.CMMCore_isPropertyPreInit(this.swigCPtr, this, string, string2);
    }

    public boolean isPropertySequenceable(String string, String string2) throws Exception {
        return MMCoreJJNI.CMMCore_isPropertySequenceable(this.swigCPtr, this, string, string2);
    }

    public boolean hasPropertyLimits(String string, String string2) throws Exception {
        return MMCoreJJNI.CMMCore_hasPropertyLimits(this.swigCPtr, this, string, string2);
    }

    public double getPropertyLowerLimit(String string, String string2) throws Exception {
        return MMCoreJJNI.CMMCore_getPropertyLowerLimit(this.swigCPtr, this, string, string2);
    }

    public double getPropertyUpperLimit(String string, String string2) throws Exception {
        return MMCoreJJNI.CMMCore_getPropertyUpperLimit(this.swigCPtr, this, string, string2);
    }

    public void startPropertySequence(String string, String string2) throws Exception {
        MMCoreJJNI.CMMCore_startPropertySequence(this.swigCPtr, this, string, string2);
    }

    public void stopPropertySequence(String string, String string2) throws Exception {
        MMCoreJJNI.CMMCore_stopPropertySequence(this.swigCPtr, this, string, string2);
    }

    public int getPropertySequenceMaxLength(String string, String string2) throws Exception {
        return MMCoreJJNI.CMMCore_getPropertySequenceMaxLength(this.swigCPtr, this, string, string2);
    }

    public void loadPropertySequence(String string, String string2, StrVector strVector) throws Exception {
        MMCoreJJNI.CMMCore_loadPropertySequence(this.swigCPtr, this, string, string2, StrVector.getCPtr(strVector), strVector);
    }

    public PropertyType getPropertyType(String string, String string2) throws Exception {
        return PropertyType.swigToEnum(MMCoreJJNI.CMMCore_getPropertyType(this.swigCPtr, this, string, string2));
    }

    public DeviceType getDeviceType(String string) throws Exception {
        return DeviceType.swigToEnum(MMCoreJJNI.CMMCore_getDeviceType(this.swigCPtr, this, string));
    }

    public String getDeviceLibrary(String string) throws Exception {
        return MMCoreJJNI.CMMCore_getDeviceLibrary(this.swigCPtr, this, string);
    }

    public void unloadLibrary(String string) throws Exception {
        MMCoreJJNI.CMMCore_unloadLibrary(this.swigCPtr, this, string);
    }

    public String getDeviceName(String string) throws Exception {
        return MMCoreJJNI.CMMCore_getDeviceName(this.swigCPtr, this, string);
    }

    public String getParentLabel(String string) throws Exception {
        return MMCoreJJNI.CMMCore_getParentLabel(this.swigCPtr, this, string);
    }

    public void setParentLabel(String string, String string2) throws Exception {
        MMCoreJJNI.CMMCore_setParentLabel(this.swigCPtr, this, string, string2);
    }

    public String getDeviceDescription(String string) throws Exception {
        return MMCoreJJNI.CMMCore_getDeviceDescription(this.swigCPtr, this, string);
    }

    public boolean deviceBusy(String string) throws Exception {
        return MMCoreJJNI.CMMCore_deviceBusy(this.swigCPtr, this, string);
    }

    public void waitForDevice(String string) throws Exception {
        MMCoreJJNI.CMMCore_waitForDevice(this.swigCPtr, this, string);
    }

    public void waitForConfig(String string, String string2) throws Exception {
        MMCoreJJNI.CMMCore_waitForConfig(this.swigCPtr, this, string, string2);
    }

    public boolean systemBusy() throws Exception {
        return MMCoreJJNI.CMMCore_systemBusy(this.swigCPtr, this);
    }

    public void waitForSystem() throws Exception {
        MMCoreJJNI.CMMCore_waitForSystem(this.swigCPtr, this);
    }

    public void waitForImageSynchro() throws Exception {
        MMCoreJJNI.CMMCore_waitForImageSynchro(this.swigCPtr, this);
    }

    public boolean deviceTypeBusy(DeviceType deviceType) throws Exception {
        return MMCoreJJNI.CMMCore_deviceTypeBusy(this.swigCPtr, this, deviceType.swigValue());
    }

    public void waitForDeviceType(DeviceType deviceType) throws Exception {
        MMCoreJJNI.CMMCore_waitForDeviceType(this.swigCPtr, this, deviceType.swigValue());
    }

    public void sleep(double d) {
        MMCoreJJNI.CMMCore_sleep(this.swigCPtr, this, d);
    }

    public double getDeviceDelayMs(String string) throws Exception {
        return MMCoreJJNI.CMMCore_getDeviceDelayMs(this.swigCPtr, this, string);
    }

    public void setDeviceDelayMs(String string, double d) throws Exception {
        MMCoreJJNI.CMMCore_setDeviceDelayMs(this.swigCPtr, this, string, d);
    }

    public void setTimeoutMs(int n) {
        MMCoreJJNI.CMMCore_setTimeoutMs(this.swigCPtr, this, n);
    }

    public int getTimeoutMs() {
        return MMCoreJJNI.CMMCore_getTimeoutMs(this.swigCPtr, this);
    }

    public boolean usesDeviceDelay(String string) throws Exception {
        return MMCoreJJNI.CMMCore_usesDeviceDelay(this.swigCPtr, this, string);
    }

    public String getCoreErrorText(int n) {
        return MMCoreJJNI.CMMCore_getCoreErrorText(this.swigCPtr, this, n);
    }

    public String getCameraDevice() {
        return MMCoreJJNI.CMMCore_getCameraDevice(this.swigCPtr, this);
    }

    public String getShutterDevice() {
        return MMCoreJJNI.CMMCore_getShutterDevice(this.swigCPtr, this);
    }

    public String getFocusDevice() {
        return MMCoreJJNI.CMMCore_getFocusDevice(this.swigCPtr, this);
    }

    public String getXYStageDevice() {
        return MMCoreJJNI.CMMCore_getXYStageDevice(this.swigCPtr, this);
    }

    public String getAutoFocusDevice() {
        return MMCoreJJNI.CMMCore_getAutoFocusDevice(this.swigCPtr, this);
    }

    public String getImageProcessorDevice() {
        return MMCoreJJNI.CMMCore_getImageProcessorDevice(this.swigCPtr, this);
    }

    public String getSLMDevice() {
        return MMCoreJJNI.CMMCore_getSLMDevice(this.swigCPtr, this);
    }

    public String getGalvoDevice() {
        return MMCoreJJNI.CMMCore_getGalvoDevice(this.swigCPtr, this);
    }

    public String getChannelGroup() {
        return MMCoreJJNI.CMMCore_getChannelGroup(this.swigCPtr, this);
    }

    public void setCameraDevice(String string) throws Exception {
        MMCoreJJNI.CMMCore_setCameraDevice(this.swigCPtr, this, string);
    }

    public void setShutterDevice(String string) throws Exception {
        MMCoreJJNI.CMMCore_setShutterDevice(this.swigCPtr, this, string);
    }

    public void setFocusDevice(String string) throws Exception {
        MMCoreJJNI.CMMCore_setFocusDevice(this.swigCPtr, this, string);
    }

    public void setXYStageDevice(String string) throws Exception {
        MMCoreJJNI.CMMCore_setXYStageDevice(this.swigCPtr, this, string);
    }

    public void setAutoFocusDevice(String string) throws Exception {
        MMCoreJJNI.CMMCore_setAutoFocusDevice(this.swigCPtr, this, string);
    }

    public void setImageProcessorDevice(String string) throws Exception {
        MMCoreJJNI.CMMCore_setImageProcessorDevice(this.swigCPtr, this, string);
    }

    public void setSLMDevice(String string) throws Exception {
        MMCoreJJNI.CMMCore_setSLMDevice(this.swigCPtr, this, string);
    }

    public void setGalvoDevice(String string) throws Exception {
        MMCoreJJNI.CMMCore_setGalvoDevice(this.swigCPtr, this, string);
    }

    public void setChannelGroup(String string) throws Exception {
        MMCoreJJNI.CMMCore_setChannelGroup(this.swigCPtr, this, string);
    }

    public void defineConfig(String string, String string2) throws Exception {
        MMCoreJJNI.CMMCore_defineConfig__SWIG_0(this.swigCPtr, this, string, string2);
    }

    public void defineConfig(String string, String string2, String string3, String string4, String string5) throws Exception {
        MMCoreJJNI.CMMCore_defineConfig__SWIG_1(this.swigCPtr, this, string, string2, string3, string4, string5);
    }

    public void defineConfigGroup(String string) throws Exception {
        MMCoreJJNI.CMMCore_defineConfigGroup(this.swigCPtr, this, string);
    }

    public void deleteConfigGroup(String string) throws Exception {
        MMCoreJJNI.CMMCore_deleteConfigGroup(this.swigCPtr, this, string);
    }

    public void renameConfigGroup(String string, String string2) throws Exception {
        MMCoreJJNI.CMMCore_renameConfigGroup(this.swigCPtr, this, string, string2);
    }

    public boolean isGroupDefined(String string) {
        return MMCoreJJNI.CMMCore_isGroupDefined(this.swigCPtr, this, string);
    }

    public boolean isConfigDefined(String string, String string2) {
        return MMCoreJJNI.CMMCore_isConfigDefined(this.swigCPtr, this, string, string2);
    }

    public void setConfig(String string, String string2) throws Exception {
        MMCoreJJNI.CMMCore_setConfig(this.swigCPtr, this, string, string2);
    }

    public void deleteConfig(String string, String string2) throws Exception {
        MMCoreJJNI.CMMCore_deleteConfig__SWIG_0(this.swigCPtr, this, string, string2);
    }

    public void deleteConfig(String string, String string2, String string3, String string4) throws Exception {
        MMCoreJJNI.CMMCore_deleteConfig__SWIG_1(this.swigCPtr, this, string, string2, string3, string4);
    }

    public void renameConfig(String string, String string2, String string3) throws Exception {
        MMCoreJJNI.CMMCore_renameConfig(this.swigCPtr, this, string, string2, string3);
    }

    public StrVector getAvailableConfigGroups() {
        return new StrVector(MMCoreJJNI.CMMCore_getAvailableConfigGroups(this.swigCPtr, this), true);
    }

    public StrVector getAvailableConfigs(String string) {
        return new StrVector(MMCoreJJNI.CMMCore_getAvailableConfigs(this.swigCPtr, this, string), true);
    }

    public String getCurrentConfig(String string) throws Exception {
        return MMCoreJJNI.CMMCore_getCurrentConfig(this.swigCPtr, this, string);
    }

    public String getCurrentConfigFromCache(String string) throws Exception {
        return MMCoreJJNI.CMMCore_getCurrentConfigFromCache(this.swigCPtr, this, string);
    }

    public Configuration getConfigData(String string, String string2) throws Exception {
        return new Configuration(MMCoreJJNI.CMMCore_getConfigData(this.swigCPtr, this, string, string2), true);
    }

    public String getCurrentPixelSizeConfig() throws Exception {
        return MMCoreJJNI.CMMCore_getCurrentPixelSizeConfig__SWIG_0(this.swigCPtr, this);
    }

    public String getCurrentPixelSizeConfig(boolean bl) throws Exception {
        return MMCoreJJNI.CMMCore_getCurrentPixelSizeConfig__SWIG_1(this.swigCPtr, this, bl);
    }

    public double getPixelSizeUm() {
        return MMCoreJJNI.CMMCore_getPixelSizeUm__SWIG_0(this.swigCPtr, this);
    }

    public double getPixelSizeUm(boolean bl) {
        return MMCoreJJNI.CMMCore_getPixelSizeUm__SWIG_1(this.swigCPtr, this, bl);
    }

    public double getPixelSizeUmByID(String string) throws Exception {
        return MMCoreJJNI.CMMCore_getPixelSizeUmByID(this.swigCPtr, this, string);
    }

    public double getMagnificationFactor() {
        return MMCoreJJNI.CMMCore_getMagnificationFactor(this.swigCPtr, this);
    }

    public void setPixelSizeUm(String string, double d) throws Exception {
        MMCoreJJNI.CMMCore_setPixelSizeUm(this.swigCPtr, this, string, d);
    }

    public void definePixelSizeConfig(String string, String string2, String string3, String string4) {
        MMCoreJJNI.CMMCore_definePixelSizeConfig__SWIG_0(this.swigCPtr, this, string, string2, string3, string4);
    }

    public void definePixelSizeConfig(String string) {
        MMCoreJJNI.CMMCore_definePixelSizeConfig__SWIG_1(this.swigCPtr, this, string);
    }

    public StrVector getAvailablePixelSizeConfigs() {
        return new StrVector(MMCoreJJNI.CMMCore_getAvailablePixelSizeConfigs(this.swigCPtr, this), true);
    }

    public boolean isPixelSizeConfigDefined(String string) {
        return MMCoreJJNI.CMMCore_isPixelSizeConfigDefined(this.swigCPtr, this, string);
    }

    public void setPixelSizeConfig(String string) throws Exception {
        MMCoreJJNI.CMMCore_setPixelSizeConfig(this.swigCPtr, this, string);
    }

    public void renamePixelSizeConfig(String string, String string2) throws Exception {
        MMCoreJJNI.CMMCore_renamePixelSizeConfig(this.swigCPtr, this, string, string2);
    }

    public void deletePixelSizeConfig(String string) throws Exception {
        MMCoreJJNI.CMMCore_deletePixelSizeConfig(this.swigCPtr, this, string);
    }

    public Configuration getPixelSizeConfigData(String string) throws Exception {
        return new Configuration(MMCoreJJNI.CMMCore_getPixelSizeConfigData(this.swigCPtr, this, string), true);
    }

    public void setROI(int n, int n2, int n3, int n4) throws Exception {
        MMCoreJJNI.CMMCore_setROI(this.swigCPtr, this, n, n2, n3, n4);
    }

    public void getROI(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) throws Exception {
        MMCoreJJNI.CMMCore_getROI(this.swigCPtr, this, nArray, nArray2, nArray3, nArray4);
    }

    public void clearROI() throws Exception {
        MMCoreJJNI.CMMCore_clearROI(this.swigCPtr, this);
    }

    public void setExposure(double d) throws Exception {
        MMCoreJJNI.CMMCore_setExposure(this.swigCPtr, this, d);
    }

    public double getExposure() throws Exception {
        return MMCoreJJNI.CMMCore_getExposure(this.swigCPtr, this);
    }

    public Object getImage() throws Exception {
        return MMCoreJJNI.CMMCore_getImage__SWIG_0(this.swigCPtr, this);
    }

    public Object getImage(long l) throws Exception {
        return MMCoreJJNI.CMMCore_getImage__SWIG_1(this.swigCPtr, this, l);
    }

    public void snapImage() throws Exception {
        MMCoreJJNI.CMMCore_snapImage(this.swigCPtr, this);
    }

    public long getImageWidth() {
        return MMCoreJJNI.CMMCore_getImageWidth(this.swigCPtr, this);
    }

    public long getImageHeight() {
        return MMCoreJJNI.CMMCore_getImageHeight(this.swigCPtr, this);
    }

    public long getBytesPerPixel() {
        return MMCoreJJNI.CMMCore_getBytesPerPixel(this.swigCPtr, this);
    }

    public long getImageBitDepth() {
        return MMCoreJJNI.CMMCore_getImageBitDepth(this.swigCPtr, this);
    }

    public long getNumberOfComponents() {
        return MMCoreJJNI.CMMCore_getNumberOfComponents(this.swigCPtr, this);
    }

    public long getNumberOfCameraChannels() {
        return MMCoreJJNI.CMMCore_getNumberOfCameraChannels(this.swigCPtr, this);
    }

    public String getCameraChannelName(long l) {
        return MMCoreJJNI.CMMCore_getCameraChannelName(this.swigCPtr, this, l);
    }

    public int getImageBufferSize() {
        return MMCoreJJNI.CMMCore_getImageBufferSize(this.swigCPtr, this);
    }

    public void assignImageSynchro(String string) throws Exception {
        MMCoreJJNI.CMMCore_assignImageSynchro(this.swigCPtr, this, string);
    }

    public void removeImageSynchro(String string) throws Exception {
        MMCoreJJNI.CMMCore_removeImageSynchro(this.swigCPtr, this, string);
    }

    public void removeImageSynchroAll() {
        MMCoreJJNI.CMMCore_removeImageSynchroAll(this.swigCPtr, this);
    }

    public void setAutoShutter(boolean bl) {
        MMCoreJJNI.CMMCore_setAutoShutter(this.swigCPtr, this, bl);
    }

    public boolean getAutoShutter() {
        return MMCoreJJNI.CMMCore_getAutoShutter(this.swigCPtr, this);
    }

    public void setShutterOpen(boolean bl) throws Exception {
        MMCoreJJNI.CMMCore_setShutterOpen(this.swigCPtr, this, bl);
    }

    public boolean getShutterOpen() throws Exception {
        return MMCoreJJNI.CMMCore_getShutterOpen(this.swigCPtr, this);
    }

    public void startSequenceAcquisition(int n, double d, boolean bl) throws Exception {
        MMCoreJJNI.CMMCore_startSequenceAcquisition__SWIG_0(this.swigCPtr, this, n, d, bl);
    }

    public void startSequenceAcquisition(String string, int n, double d, boolean bl) throws Exception {
        MMCoreJJNI.CMMCore_startSequenceAcquisition__SWIG_1(this.swigCPtr, this, string, n, d, bl);
    }

    public void prepareSequenceAcquisition(String string) throws Exception {
        MMCoreJJNI.CMMCore_prepareSequenceAcquisition(this.swigCPtr, this, string);
    }

    public void startContinuousSequenceAcquisition(double d) throws Exception {
        MMCoreJJNI.CMMCore_startContinuousSequenceAcquisition(this.swigCPtr, this, d);
    }

    public void stopSequenceAcquisition() throws Exception {
        MMCoreJJNI.CMMCore_stopSequenceAcquisition__SWIG_0(this.swigCPtr, this);
    }

    public void stopSequenceAcquisition(String string) throws Exception {
        MMCoreJJNI.CMMCore_stopSequenceAcquisition__SWIG_1(this.swigCPtr, this, string);
    }

    public boolean isSequenceRunning() {
        return MMCoreJJNI.CMMCore_isSequenceRunning__SWIG_0(this.swigCPtr, this);
    }

    public boolean isSequenceRunning(String string) throws Exception {
        return MMCoreJJNI.CMMCore_isSequenceRunning__SWIG_1(this.swigCPtr, this, string);
    }

    public Object getLastImage() throws Exception {
        return MMCoreJJNI.CMMCore_getLastImage(this.swigCPtr, this);
    }

    public Object popNextImage() throws Exception {
        return MMCoreJJNI.CMMCore_popNextImage(this.swigCPtr, this);
    }

    public Object getLastImageMD(long l, long l2, Metadata metadata) throws Exception {
        return MMCoreJJNI.CMMCore_getLastImageMD__SWIG_0(this.swigCPtr, this, l, l2, Metadata.getCPtr(metadata), metadata);
    }

    public Object popNextImageMD(long l, long l2, Metadata metadata) throws Exception {
        return MMCoreJJNI.CMMCore_popNextImageMD__SWIG_0(this.swigCPtr, this, l, l2, Metadata.getCPtr(metadata), metadata);
    }

    public Object getLastImageMD(Metadata metadata) throws Exception {
        return MMCoreJJNI.CMMCore_getLastImageMD__SWIG_1(this.swigCPtr, this, Metadata.getCPtr(metadata), metadata);
    }

    public Object getNBeforeLastImageMD(long l, Metadata metadata) throws Exception {
        return MMCoreJJNI.CMMCore_getNBeforeLastImageMD(this.swigCPtr, this, l, Metadata.getCPtr(metadata), metadata);
    }

    public Object popNextImageMD(Metadata metadata) throws Exception {
        return MMCoreJJNI.CMMCore_popNextImageMD__SWIG_1(this.swigCPtr, this, Metadata.getCPtr(metadata), metadata);
    }

    public int getRemainingImageCount() {
        return MMCoreJJNI.CMMCore_getRemainingImageCount(this.swigCPtr, this);
    }

    public int getBufferTotalCapacity() {
        return MMCoreJJNI.CMMCore_getBufferTotalCapacity(this.swigCPtr, this);
    }

    public int getBufferFreeCapacity() {
        return MMCoreJJNI.CMMCore_getBufferFreeCapacity(this.swigCPtr, this);
    }

    public double getBufferIntervalMs() {
        return MMCoreJJNI.CMMCore_getBufferIntervalMs(this.swigCPtr, this);
    }

    public boolean isBufferOverflowed() {
        return MMCoreJJNI.CMMCore_isBufferOverflowed(this.swigCPtr, this);
    }

    public void setCircularBufferMemoryFootprint(long l) throws Exception {
        MMCoreJJNI.CMMCore_setCircularBufferMemoryFootprint(this.swigCPtr, this, l);
    }

    public void initializeCircularBuffer() throws Exception {
        MMCoreJJNI.CMMCore_initializeCircularBuffer(this.swigCPtr, this);
    }

    public void clearCircularBuffer() throws Exception {
        MMCoreJJNI.CMMCore_clearCircularBuffer(this.swigCPtr, this);
    }

    public boolean isExposureSequenceable(String string) throws Exception {
        return MMCoreJJNI.CMMCore_isExposureSequenceable(this.swigCPtr, this, string);
    }

    public void startExposureSequence(String string) throws Exception {
        MMCoreJJNI.CMMCore_startExposureSequence(this.swigCPtr, this, string);
    }

    public void stopExposureSequence(String string) throws Exception {
        MMCoreJJNI.CMMCore_stopExposureSequence(this.swigCPtr, this, string);
    }

    public int getExposureSequenceMaxLength(String string) throws Exception {
        return MMCoreJJNI.CMMCore_getExposureSequenceMaxLength(this.swigCPtr, this, string);
    }

    public void loadExposureSequence(String string, DoubleVector doubleVector) throws Exception {
        MMCoreJJNI.CMMCore_loadExposureSequence(this.swigCPtr, this, string, DoubleVector.getCPtr(doubleVector), doubleVector);
    }

    public double getLastFocusScore() {
        return MMCoreJJNI.CMMCore_getLastFocusScore(this.swigCPtr, this);
    }

    public double getCurrentFocusScore() {
        return MMCoreJJNI.CMMCore_getCurrentFocusScore(this.swigCPtr, this);
    }

    public void enableContinuousFocus(boolean bl) throws Exception {
        MMCoreJJNI.CMMCore_enableContinuousFocus(this.swigCPtr, this, bl);
    }

    public boolean isContinuousFocusEnabled() throws Exception {
        return MMCoreJJNI.CMMCore_isContinuousFocusEnabled(this.swigCPtr, this);
    }

    public boolean isContinuousFocusLocked() throws Exception {
        return MMCoreJJNI.CMMCore_isContinuousFocusLocked(this.swigCPtr, this);
    }

    public boolean isContinuousFocusDrive(String string) throws Exception {
        return MMCoreJJNI.CMMCore_isContinuousFocusDrive(this.swigCPtr, this, string);
    }

    public void fullFocus() throws Exception {
        MMCoreJJNI.CMMCore_fullFocus(this.swigCPtr, this);
    }

    public void incrementalFocus() throws Exception {
        MMCoreJJNI.CMMCore_incrementalFocus(this.swigCPtr, this);
    }

    public void setAutoFocusOffset(double d) throws Exception {
        MMCoreJJNI.CMMCore_setAutoFocusOffset(this.swigCPtr, this, d);
    }

    public double getAutoFocusOffset() throws Exception {
        return MMCoreJJNI.CMMCore_getAutoFocusOffset(this.swigCPtr, this);
    }

    public void setState(String string, int n) throws Exception {
        MMCoreJJNI.CMMCore_setState(this.swigCPtr, this, string, n);
    }

    public int getState(String string) throws Exception {
        return MMCoreJJNI.CMMCore_getState(this.swigCPtr, this, string);
    }

    public int getNumberOfStates(String string) {
        return MMCoreJJNI.CMMCore_getNumberOfStates(this.swigCPtr, this, string);
    }

    public void setStateLabel(String string, String string2) throws Exception {
        MMCoreJJNI.CMMCore_setStateLabel(this.swigCPtr, this, string, string2);
    }

    public String getStateLabel(String string) throws Exception {
        return MMCoreJJNI.CMMCore_getStateLabel(this.swigCPtr, this, string);
    }

    public void defineStateLabel(String string, int n, String string2) throws Exception {
        MMCoreJJNI.CMMCore_defineStateLabel(this.swigCPtr, this, string, n, string2);
    }

    public StrVector getStateLabels(String string) throws Exception {
        return new StrVector(MMCoreJJNI.CMMCore_getStateLabels(this.swigCPtr, this, string), true);
    }

    public int getStateFromLabel(String string, String string2) throws Exception {
        return MMCoreJJNI.CMMCore_getStateFromLabel(this.swigCPtr, this, string, string2);
    }

    public PropertyBlock getStateLabelData(String string, String string2) {
        return new PropertyBlock(MMCoreJJNI.CMMCore_getStateLabelData(this.swigCPtr, this, string, string2), true);
    }

    public PropertyBlock getData(String string) {
        return new PropertyBlock(MMCoreJJNI.CMMCore_getData(this.swigCPtr, this, string), true);
    }

    public void definePropertyBlock(String string, String string2, String string3) {
        MMCoreJJNI.CMMCore_definePropertyBlock(this.swigCPtr, this, string, string2, string3);
    }

    public StrVector getAvailablePropertyBlocks() {
        return new StrVector(MMCoreJJNI.CMMCore_getAvailablePropertyBlocks(this.swigCPtr, this), true);
    }

    public PropertyBlock getPropertyBlockData(String string) {
        return new PropertyBlock(MMCoreJJNI.CMMCore_getPropertyBlockData(this.swigCPtr, this, string), true);
    }

    public void setPosition(String string, double d) throws Exception {
        MMCoreJJNI.CMMCore_setPosition(this.swigCPtr, this, string, d);
    }

    public double getPosition(String string) throws Exception {
        return MMCoreJJNI.CMMCore_getPosition(this.swigCPtr, this, string);
    }

    public void setRelativePosition(String string, double d) throws Exception {
        MMCoreJJNI.CMMCore_setRelativePosition(this.swigCPtr, this, string, d);
    }

    public void setOrigin(String string) throws Exception {
        MMCoreJJNI.CMMCore_setOrigin(this.swigCPtr, this, string);
    }

    public void setAdapterOrigin(String string, double d) throws Exception {
        MMCoreJJNI.CMMCore_setAdapterOrigin(this.swigCPtr, this, string, d);
    }

    public void setXYPosition(String string, double d, double d2) throws Exception {
        MMCoreJJNI.CMMCore_setXYPosition(this.swigCPtr, this, string, d, d2);
    }

    public void setRelativeXYPosition(String string, double d, double d2) throws Exception {
        MMCoreJJNI.CMMCore_setRelativeXYPosition(this.swigCPtr, this, string, d, d2);
    }

    public void getXYPosition(String string, double[] dArray, double[] dArray2) throws Exception {
        MMCoreJJNI.CMMCore_getXYPosition(this.swigCPtr, this, string, dArray, dArray2);
    }

    public double getXPosition(String string) throws Exception {
        return MMCoreJJNI.CMMCore_getXPosition(this.swigCPtr, this, string);
    }

    public double getYPosition(String string) throws Exception {
        return MMCoreJJNI.CMMCore_getYPosition(this.swigCPtr, this, string);
    }

    public void stop(String string) throws Exception {
        MMCoreJJNI.CMMCore_stop(this.swigCPtr, this, string);
    }

    public void home(String string) throws Exception {
        MMCoreJJNI.CMMCore_home(this.swigCPtr, this, string);
    }

    public void setOriginXY(String string) throws Exception {
        MMCoreJJNI.CMMCore_setOriginXY(this.swigCPtr, this, string);
    }

    public void setAdapterOriginXY(String string, double d, double d2) throws Exception {
        MMCoreJJNI.CMMCore_setAdapterOriginXY(this.swigCPtr, this, string, d, d2);
    }

    public boolean isStageSequenceable(String string) throws Exception {
        return MMCoreJJNI.CMMCore_isStageSequenceable(this.swigCPtr, this, string);
    }

    public void startStageSequence(String string) throws Exception {
        MMCoreJJNI.CMMCore_startStageSequence(this.swigCPtr, this, string);
    }

    public void stopStageSequence(String string) throws Exception {
        MMCoreJJNI.CMMCore_stopStageSequence(this.swigCPtr, this, string);
    }

    public int getStageSequenceMaxLength(String string) throws Exception {
        return MMCoreJJNI.CMMCore_getStageSequenceMaxLength(this.swigCPtr, this, string);
    }

    public void loadStageSequence(String string, DoubleVector doubleVector) throws Exception {
        MMCoreJJNI.CMMCore_loadStageSequence(this.swigCPtr, this, string, DoubleVector.getCPtr(doubleVector), doubleVector);
    }

    public boolean isXYStageSequenceable(String string) throws Exception {
        return MMCoreJJNI.CMMCore_isXYStageSequenceable(this.swigCPtr, this, string);
    }

    public void startXYStageSequence(String string) throws Exception {
        MMCoreJJNI.CMMCore_startXYStageSequence(this.swigCPtr, this, string);
    }

    public void stopXYStageSequence(String string) throws Exception {
        MMCoreJJNI.CMMCore_stopXYStageSequence(this.swigCPtr, this, string);
    }

    public int getXYStageSequenceMaxLength(String string) throws Exception {
        return MMCoreJJNI.CMMCore_getXYStageSequenceMaxLength(this.swigCPtr, this, string);
    }

    public void loadXYStageSequence(String string, DoubleVector doubleVector, DoubleVector doubleVector2) throws Exception {
        MMCoreJJNI.CMMCore_loadXYStageSequence(this.swigCPtr, this, string, DoubleVector.getCPtr(doubleVector), doubleVector, DoubleVector.getCPtr(doubleVector2), doubleVector2);
    }

    public void setSerialProperties(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        MMCoreJJNI.CMMCore_setSerialProperties(this.swigCPtr, this, string, string2, string3, string4, string5, string6, string7);
    }

    public void setSerialPortCommand(String string, String string2, String string3) throws Exception {
        MMCoreJJNI.CMMCore_setSerialPortCommand(this.swigCPtr, this, string, string2, string3);
    }

    public String getSerialPortAnswer(String string, String string2) throws Exception {
        return MMCoreJJNI.CMMCore_getSerialPortAnswer(this.swigCPtr, this, string, string2);
    }

    public void writeToSerialPort(String string, CharVector charVector) throws Exception {
        MMCoreJJNI.CMMCore_writeToSerialPort(this.swigCPtr, this, string, CharVector.getCPtr(charVector), charVector);
    }

    public CharVector readFromSerialPort(String string) throws Exception {
        return new CharVector(MMCoreJJNI.CMMCore_readFromSerialPort(this.swigCPtr, this, string), true);
    }

    public void setSLMImage(String string, byte[] byArray) throws Exception {
        MMCoreJJNI.CMMCore_setSLMImage__SWIG_0(this.swigCPtr, this, string, byArray);
    }

    public void setSLMImage(String string, int[] nArray) throws Exception {
        MMCoreJJNI.CMMCore_setSLMImage__SWIG_1(this.swigCPtr, this, string, nArray);
    }

    public void setSLMPixelsTo(String string, short s) throws Exception {
        MMCoreJJNI.CMMCore_setSLMPixelsTo__SWIG_0(this.swigCPtr, this, string, s);
    }

    public void setSLMPixelsTo(String string, short s, short s2, short s3) throws Exception {
        MMCoreJJNI.CMMCore_setSLMPixelsTo__SWIG_1(this.swigCPtr, this, string, s, s2, s3);
    }

    public void displaySLMImage(String string) throws Exception {
        MMCoreJJNI.CMMCore_displaySLMImage(this.swigCPtr, this, string);
    }

    public long getSLMWidth(String string) {
        return MMCoreJJNI.CMMCore_getSLMWidth(this.swigCPtr, this, string);
    }

    public long getSLMHeight(String string) {
        return MMCoreJJNI.CMMCore_getSLMHeight(this.swigCPtr, this, string);
    }

    public long getSLMNumberOfComponents(String string) {
        return MMCoreJJNI.CMMCore_getSLMNumberOfComponents(this.swigCPtr, this, string);
    }

    public long getSLMBytesPerPixel(String string) {
        return MMCoreJJNI.CMMCore_getSLMBytesPerPixel(this.swigCPtr, this, string);
    }

    public void pointGalvoAndFire(String string, double d, double d2, double d3) throws Exception {
        MMCoreJJNI.CMMCore_pointGalvoAndFire(this.swigCPtr, this, string, d, d2, d3);
    }

    public void setGalvoSpotInterval(String string, double d) throws Exception {
        MMCoreJJNI.CMMCore_setGalvoSpotInterval(this.swigCPtr, this, string, d);
    }

    public void setGalvoPosition(String string, double d, double d2) throws Exception {
        MMCoreJJNI.CMMCore_setGalvoPosition(this.swigCPtr, this, string, d, d2);
    }

    public void getGalvoPosition(String string, double[] dArray, double[] dArray2) throws Exception {
        MMCoreJJNI.CMMCore_getGalvoPosition(this.swigCPtr, this, string, dArray, dArray2);
    }

    public void setGalvoIlluminationState(String string, boolean bl) throws Exception {
        MMCoreJJNI.CMMCore_setGalvoIlluminationState(this.swigCPtr, this, string, bl);
    }

    public double getGalvoXRange(String string) throws Exception {
        return MMCoreJJNI.CMMCore_getGalvoXRange(this.swigCPtr, this, string);
    }

    public double getGalvoYRange(String string) throws Exception {
        return MMCoreJJNI.CMMCore_getGalvoYRange(this.swigCPtr, this, string);
    }

    public void addGalvoPolygonVertex(String string, int n, double d, double d2) throws Exception {
        MMCoreJJNI.CMMCore_addGalvoPolygonVertex(this.swigCPtr, this, string, n, d, d2);
    }

    public void deleteGalvoPolygons(String string) throws Exception {
        MMCoreJJNI.CMMCore_deleteGalvoPolygons(this.swigCPtr, this, string);
    }

    public void loadGalvoPolygons(String string) throws Exception {
        MMCoreJJNI.CMMCore_loadGalvoPolygons(this.swigCPtr, this, string);
    }

    public void setGalvoPolygonRepetitions(String string, int n) throws Exception {
        MMCoreJJNI.CMMCore_setGalvoPolygonRepetitions(this.swigCPtr, this, string, n);
    }

    public void runGalvoPolygons(String string) throws Exception {
        MMCoreJJNI.CMMCore_runGalvoPolygons(this.swigCPtr, this, string);
    }

    public void runGalvoSequence(String string) throws Exception {
        MMCoreJJNI.CMMCore_runGalvoSequence(this.swigCPtr, this, string);
    }

    public String getGalvoChannel(String string) throws Exception {
        return MMCoreJJNI.CMMCore_getGalvoChannel(this.swigCPtr, this, string);
    }

    public void acqBeforeFrame() throws Exception {
        MMCoreJJNI.CMMCore_acqBeforeFrame(this.swigCPtr, this);
    }

    public void acqAfterFrame() throws Exception {
        MMCoreJJNI.CMMCore_acqAfterFrame(this.swigCPtr, this);
    }

    public DeviceDetectionStatus detectDevice(String string) {
        return DeviceDetectionStatus.swigToEnum(MMCoreJJNI.CMMCore_detectDevice(this.swigCPtr, this, string));
    }

    public StrVector getInstalledDevices(String string) {
        return new StrVector(MMCoreJJNI.CMMCore_getInstalledDevices(this.swigCPtr, this, string), true);
    }

    public String getInstalledDeviceDescription(String string, String string2) {
        return MMCoreJJNI.CMMCore_getInstalledDeviceDescription(this.swigCPtr, this, string, string2);
    }

    public StrVector getLoadedPeripheralDevices(String string) {
        return new StrVector(MMCoreJJNI.CMMCore_getLoadedPeripheralDevices(this.swigCPtr, this, string), true);
    }

    public StrVector getMACAddresses() {
        return new StrVector(MMCoreJJNI.CMMCore_getMACAddresses(this.swigCPtr, this), true);
    }
}

