/*
 * Decompiled with CFR 0.152.
 */
package com.swtdesigner;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingResourceManager {
    private static HashMap<String, Image> m_ClassImageMap = new HashMap();

    private static Image getImage(InputStream inputStream) {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.close();
            return Toolkit.getDefaultToolkit().createImage(byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Image getImage(Class<?> clazz, String string) {
        String string2 = clazz.getName() + '|' + string;
        Image image = m_ClassImageMap.get(string2);
        if (image == null) {
            if (string.length() > 0 && string.charAt(0) == '/') {
                String string3 = string.substring(1, string.length());
                image = SwingResourceManager.getImage(new BufferedInputStream(clazz.getClassLoader().getResourceAsStream(string3)));
            } else {
                image = SwingResourceManager.getImage(clazz.getResourceAsStream(string));
            }
            m_ClassImageMap.put(string2, image);
        }
        return image;
    }

    public static Image getImage(String string) {
        return SwingResourceManager.getImage("default", string);
    }

    public static Image getImage(String string, String string2) {
        String string3 = string + '|' + SwingResourceManager.class.getName() + '|' + string2;
        Image image = m_ClassImageMap.get(string3);
        if (image == null) {
            try {
                FileInputStream fileInputStream = new FileInputStream(string2);
                image = SwingResourceManager.getImage(fileInputStream);
                m_ClassImageMap.put(string3, image);
                fileInputStream.close();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return image;
    }

    public static void clearImages(String string) {
        Iterator<String> iterator = m_ClassImageMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (!string2.startsWith(string + '|')) continue;
            Image image = m_ClassImageMap.get(string2);
            image.flush();
            iterator.remove();
        }
    }

    public static ImageIcon getIcon(Class<?> clazz, String string) {
        return SwingResourceManager.getIcon(SwingResourceManager.getImage(clazz, string));
    }

    public static ImageIcon getIcon(String string) {
        return SwingResourceManager.getIcon("default", string);
    }

    public static ImageIcon getIcon(String string, String string2) {
        return SwingResourceManager.getIcon(SwingResourceManager.getImage(string, string2));
    }

    public static ImageIcon getIcon(Image image) {
        if (image == null) {
            return null;
        }
        return new ImageIcon(image);
    }
}

