/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ETable
extends JTable {
    private static final long serialVersionUID = 1L;
    public static final Color MAC_UNFOCUSED_SELECTED_CELL_BACKGROUND_COLOR = new Color(0xC0C0C0);
    public static final Color MAC_UNFOCUSED_UNSELECTED_VERTICAL_LINE_COLOR = new Color(0xD9D9D9);
    public static final Color MAC_UNFOCUSED_SELECTED_VERTICAL_LINE_COLOR = new Color(0xACACAC);
    public static final Color ALTERNATE_ROW_COLOR = new Color(0.92f, 0.95f, 0.99f);
    public static final Color DARK_ORANGE = new Color(1.0f, 0.4f, 0.0f);

    public ETable() {
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension());
        this.getTableHeader().setReorderingAllowed(false);
        if (ETable.isMacOs()) {
            ((JLabel)JLabel.class.cast(this.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(10);
            this.setShowHorizontalLines(true);
            this.setShowVerticalLines(true);
        }
    }

    public ETable(AbstractTableModel atm) {
        this.setModel(atm);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension());
        this.getTableHeader().setReorderingAllowed(false);
        if (ETable.isMacOs()) {
            ((JLabel)JLabel.class.cast(this.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(10);
            this.setShowHorizontalLines(false);
            this.setShowVerticalLines(true);
        }
    }

    public static boolean isMacOs() {
        return System.getProperty("os.name").contains("Mac");
    }

    public static boolean isGtk() {
        return UIManager.getLookAndFeel().getClass().getName().contains("GTK");
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.paintEmptyRows(g);
    }

    protected void paintEmptyRows(Graphics g) {
        int rowCount = this.getRowCount();
        Rectangle clip = g.getClipBounds();
        int height = clip.y + clip.height;
        if (rowCount * this.rowHeight < height) {
            for (int i = rowCount; i <= height / this.rowHeight; ++i) {
                g.setColor(this.colorForRow(i));
                g.fillRect(clip.x, i * this.rowHeight, clip.width, this.rowHeight);
            }
            if (ETable.isMacOs() && this.getShowVerticalLines()) {
                g.setColor(MAC_UNFOCUSED_UNSELECTED_VERTICAL_LINE_COLOR);
                TableColumnModel columnModel = this.getColumnModel();
                int x = 0;
                for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                    TableColumn column = columnModel.getColumn(i);
                    x += column.getWidth();
                    if (column.getCellRenderer() instanceof JCheckBox) continue;
                    g.drawLine(x - 1, rowCount * this.rowHeight, x - 1, height);
                }
            }
        }
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            JViewport parent = (JViewport)this.getParent();
            return parent.getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public Color colorForRow(int row) {
        return row % 2 == 0 ? this.alternateRowColor() : this.getBackground();
    }

    private Color alternateRowColor() {
        return ETable.isGtk() ? Color.WHITE : ALTERNATE_ROW_COLOR;
    }

    public void enableCell(int row, int column, boolean enabled) {
        TableCellRenderer renderer = this.getCellRenderer(row, column);
        Component c = this.prepareRenderer(renderer, row, column);
        if (c instanceof JComponent) {
            c.setEnabled(enabled);
        }
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        boolean focused = this.hasFocus();
        boolean selected = this.isCellSelected(row, column);
        if (selected) {
            if (ETable.isMacOs() && !focused) {
                c.setBackground(MAC_UNFOCUSED_SELECTED_CELL_BACKGROUND_COLOR);
                c.setForeground(UIManager.getColor("Table.foreground"));
            } else {
                c.setBackground(UIManager.getColor("Table.selectionBackground"));
                c.setForeground(UIManager.getColor("Table.selectionForeground"));
            }
        } else {
            c.setBackground(this.colorForRow(row));
            if (c.getForeground() != Color.red && c.getForeground() != DARK_ORANGE) {
                c.setForeground(UIManager.getColor("Table.foreground"));
            }
        }
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            jc.setOpaque(true);
            if (ETable.isGtk() && c instanceof JCheckBox) {
                jc.setOpaque(true);
            }
            if (ETable.isMacOs()) {
                this.fixMacOsCellRendererBorder(jc, selected, focused);
            } else {
                jc.setBorder(null);
            }
            this.initToolTip(jc, row, column);
        }
        return c;
    }

    private void fixMacOsCellRendererBorder(JComponent renderer, boolean selected, boolean focused) {
        Color verticalLineColor = selected ? MAC_UNFOCUSED_SELECTED_VERTICAL_LINE_COLOR : MAC_UNFOCUSED_UNSELECTED_VERTICAL_LINE_COLOR;
        MatteBorder border = BorderFactory.createMatteBorder(0, 0, 0, 1, verticalLineColor);
        renderer.setBorder(border);
    }

    public void initToolTip(JComponent c, int row, int column) {
        if (c instanceof JLabel) {
            JLabel jl = (JLabel)c;
            if (c.getToolTipText() != jl.getText()) {
                return;
            }
        }
        if (c.getToolTipText() != null && !c.getToolTipText().equals(this.getValueAt(row, column).toString())) {
            return;
        }
        String toolTipText = null;
        if (c.getPreferredSize().width > this.getCellRect((int)row, (int)column, (boolean)false).width) {
            toolTipText = this.getValueAt(row, column).toString();
        }
        c.setToolTipText(toolTipText);
    }

    protected void configureEnclosingScrollPane() {
        Container gp;
        super.configureEnclosingScrollPane();
        if (!ETable.isMacOs()) {
            return;
        }
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            Component renderer = new JTableHeader().getDefaultRenderer().getTableCellRendererComponent(null, "", false, false, -1, 0);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add(renderer, "Center");
            scrollPane.setCorner("UPPER_RIGHT_CORNER", panel);
        }
    }
}

