/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import ome.formats.importer.gui.GuiCommonElements;
import ome.formats.importer.gui.ServerListRenderer;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ServerDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    static final String SERVER_PROPERTY = "server";
    static final String CLOSE_PROPERTY = "close";
    static final String REMOVE_PROPERTY = "remove";
    private static final Dimension WINDOW_DIM = new Dimension(450, 250);
    private static final Font FONT = new Font("SansSerif", 2, 10);
    private static final String TITLE = "Servers";
    private static final String TEXT = "Enter a new server or \nselect an existing one.";
    private static final Dimension H_SPACER_SIZE = new Dimension(5, 10);
    protected static final Dimension V_SPACER_SIZE = new Dimension(1, 20);
    private static final String EXAMPLE = "e.g. test.openmicroscopy.org.uk";
    private JTextField serverName;
    private JComboBox server;
    private JButton cancelButton;
    private JButton finishButton;
    private JButton moreOptions;
    private JButton removeButton;
    private JPanel bookmarks;
    private JPanel body;
    private boolean isBookmarksShowing;
    private List existingServers;
    private JList servers;

    private void handleClick() {
        if (this.isBookmarksShowing) {
            this.moreOptions.setIcon(GuiCommonElements.getImageIcon("gfx/nuvola_1rightarrow16.png"));
            this.body.remove(this.bookmarks);
        } else {
            this.moreOptions.setIcon(GuiCommonElements.getImageIcon("gfx/nuvola_1downarrow16.png"));
            this.populateBookmarks();
            this.body.add(this.bookmarks);
        }
        this.isBookmarksShowing = !this.isBookmarksShowing;
        this.setSize(ServerDialog.WINDOW_DIM.width, this.getPreferredSize().height);
        this.serverName.requestFocus();
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
        this.firePropertyChange(CLOSE_PROPERTY, Boolean.FALSE, Boolean.TRUE);
    }

    private void apply() {
        String text = this.serverName.getText();
        String value = null;
        if (text == null || text.trim().length() == 0) {
            if (this.server != null) {
                value = (String)this.server.getSelectedItem();
            }
        } else {
            value = text.trim();
        }
        this.firePropertyChange(SERVER_PROPERTY, null, value);
        this.close();
    }

    private void remove() {
        int index = this.servers.getLeadSelectionIndex();
        if (index == -1) {
            return;
        }
        Object[] obj = (Object[])this.servers.getModel().getElementAt(index);
        if (obj == null) {
            return;
        }
        String v = (String)obj[1];
        this.existingServers.remove(v);
        this.body.removeAll();
        String newValue = null;
        if (this.existingServers.size() != 0) {
            this.server.setModel(new DefaultComboBoxModel<String>(this.listToArray()));
            newValue = (String)this.server.getSelectedItem();
        }
        this.body.add(this.buildBody());
        if (this.existingServers.size() != 0) {
            this.populateBookmarks();
            this.body.add(this.bookmarks);
        }
        this.body.validate();
        this.body.repaint();
        this.setSize(ServerDialog.WINDOW_DIM.width, this.getPreferredSize().height);
        this.firePropertyChange(REMOVE_PROPERTY, v, newValue);
    }

    private void setProperties() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setAlwaysOnTop(true);
    }

    private void populateBookmarks() {
        final Object[][] objects = new Object[this.existingServers.size()][2];
        ImageIcon icon = GuiCommonElements.getImageIcon("gfx/server_connect16.png");
        Iterator i = this.existingServers.iterator();
        int index = 0;
        while (i.hasNext()) {
            objects[index][0] = icon;
            objects[index][1] = i.next();
            ++index;
        }
        AbstractListModel model = new AbstractListModel(){
            private static final long serialVersionUID = 1L;

            public int getSize() {
                return objects.length;
            }

            public Object getElementAt(int i) {
                return objects[i];
            }
        };
        this.servers.setModel(model);
    }

    private String[] listToArray() {
        if (this.existingServers != null && this.existingServers.size() != 0) {
            String[] array = new String[this.existingServers.size()];
            Iterator i = this.existingServers.iterator();
            int index = 0;
            while (i.hasNext()) {
                array[index] = (String)i.next();
                ++index;
            }
            return array;
        }
        return null;
    }

    private void initListeners() {
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ServerDialog.this.close();
            }
        });
        this.finishButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ServerDialog.this.apply();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                ServerDialog.this.serverName.requestFocus();
            }
        });
        this.moreOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ServerDialog.this.handleClick();
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ServerDialog.this.remove();
            }
        });
    }

    private void initComponents() {
        String[] array = this.listToArray();
        if (array != null) {
            this.server = new JComboBox<String>(array);
            this.server.setOpaque(false);
        }
        this.serverName = new JTextField();
        this.serverName.setEditable(true);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText("Close the window.");
        this.finishButton = new JButton("Apply");
        this.getRootPane().setDefaultButton(this.finishButton);
        this.moreOptions = new JButton(GuiCommonElements.getImageIcon("gfx/nuvola_1rightarrow16.png"));
        UIUtilities.unifiedButtonLookAndFeel((AbstractButton)this.moreOptions);
        this.removeButton = new JButton(GuiCommonElements.getImageIcon("gfx/remove.png"));
        this.removeButton.setToolTipText("Remove the selected server from the list.");
        this.buildBookmarks();
    }

    private JPanel buildBody() {
        JLabel label;
        JPanel content = new JPanel();
        content.setLayout(new GridBagLayout());
        content.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(3, 3, 3, 3);
        c.gridy = 0;
        if (this.existingServers != null && this.existingServers.size() != 0) {
            label = UIUtilities.setTextFont((String)"Existing servers:");
            c.gridwidth = -1;
            c.weightx = 0.0;
            content.add((Component)label, c);
            c.gridx = 1;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            content.add((Component)this.server, c);
            ++c.gridy;
            c.gridx = 0;
        }
        label = UIUtilities.setTextFont((String)"New server:");
        c.gridwidth = -1;
        c.weightx = 0.0;
        content.add((Component)label, c);
        c.gridx = 1;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        content.add((Component)this.serverName, c);
        ++c.gridy;
        label = new JLabel(EXAMPLE);
        label.setFont(FONT);
        content.add((Component)label, c);
        if (this.existingServers != null && this.existingServers.size() != 0) {
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = -1;
            c.weightx = 0.0;
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 0));
            p.add(this.moreOptions);
            p.add(new JLabel("More Options"));
            content.add((Component)p, c);
        }
        return content;
    }

    private void buildBookmarks() {
        this.bookmarks = new JPanel();
        this.bookmarks.setLayout(new BoxLayout(this.bookmarks, 1));
        this.bookmarks.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.bookmarks.add(Box.createRigidArea(V_SPACER_SIZE));
        this.bookmarks.add(new JSeparator());
        this.bookmarks.add(Box.createRigidArea(V_SPACER_SIZE));
        this.servers = new JList();
        this.servers.setCellRenderer(new ServerListRenderer());
        this.servers.setSelectionMode(0);
        this.servers.setLayoutOrientation(0);
        JScrollPane scrollpane = new JScrollPane(this.servers);
        this.bookmarks.add(UIUtilities.buildComponentPanel((JComponent)new JLabel("List of existing servers.")));
        this.bookmarks.add(scrollpane);
        this.bookmarks.add(UIUtilities.buildComponentPanel((JComponent)this.removeButton));
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        bar.add(this.finishButton);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        bar.add(this.cancelButton);
        JPanel p = UIUtilities.buildComponentPanelRight((JComponent)bar);
        p.setBorder(BorderFactory.createEtchedBorder());
        p.setOpaque(true);
        return p;
    }

    private void buildGUI() {
        ImageIcon icon = GuiCommonElements.getImageIcon("gfx/nuvola_configure48.png");
        TitlePanel titlePanel = new TitlePanel(TITLE, TEXT, (Icon)icon);
        Container c = this.getContentPane();
        this.setLayout(new BorderLayout(0, 0));
        c.add((Component)titlePanel, "North");
        this.body = new JPanel();
        this.body.setLayout(new BoxLayout(this.body, 1));
        this.body.add(this.buildBody());
        c.add((Component)this.body, "Center");
        c.add((Component)this.buildToolBar(), "South");
    }

    ServerDialog(List servers) {
        this.existingServers = servers;
        this.setProperties();
        this.initComponents();
        this.initListeners();
        this.buildGUI();
        this.setSize(WINDOW_DIM);
        this.toFront();
    }

    public String getCurrentServer() {
        if (this.serverName.getText().length() > 0) {
            return this.serverName.getText().trim();
        }
        if (this.existingServers != null && this.existingServers.size() != 0) {
            return this.server.getSelectedItem().toString().trim();
        }
        return "";
    }
}

