/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.gui.AddScreenDialog;
import ome.formats.importer.gui.GuiCommonElements;
import ome.formats.importer.gui.ScreenItem;
import omero.RLong;
import omero.model.Screen;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SPWDialog
extends JDialog
implements ActionListener {
    boolean debug = false;
    private ImportConfig config;
    private Integer dialogHeight = 200;
    private Integer dialogWidth = 400;
    private JTabbedPane tabbedPane;
    private JPanel importPanel;
    private JPanel sPanel;
    String addIcon = "gfx/add_text.png";
    public JCheckBox archiveImage;
    private JButton addScreenBtn;
    private JButton cancelBtn;
    private JButton importBtn;
    private JComboBox sbox;
    public Screen screen;
    public ScreenItem[] screenItems = null;
    public boolean cancelled = true;
    private boolean ARCHIVE_ENABLED = true;
    private static Log log = LogFactory.getLog(SPWDialog.class);
    public OMEROMetadataStoreClient store;

    SPWDialog(ImportConfig config, JFrame owner, String title, boolean modal, OMEROMetadataStoreClient store) {
        super(owner);
        this.store = store;
        if (store != null) {
            this.screenItems = ScreenItem.createScreenItem(store.getScreens());
        }
        this.setLocation(200, 200);
        this.setTitle(title);
        this.setModal(modal);
        this.setResizable(false);
        this.setSize(new Dimension(this.dialogWidth, this.dialogHeight));
        this.setLocationRelativeTo(owner);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setOpaque(false);
        this.config = config;
        double[][] mainTable = new double[][]{{-1.0, 120.0, 5.0, 160.0, -1.0}, {-2.0, 5.0, -2.0, -1.0, 40.0, 30.0}};
        this.importPanel = GuiCommonElements.addMainPanel(this.tabbedPane, mainTable, 5, 10, 0, 10, this.debug);
        String message = "Import this plate into which screen?";
        GuiCommonElements.addTextPane(this.importPanel, message, "0, 0, 4, 0", this.debug);
        double[][] pdTable = new double[][]{{-1.0, 5.0, 40.0}, {35.0}};
        this.sPanel = GuiCommonElements.addMainPanel(this.importPanel, pdTable, 0, 0, 0, 0, this.debug);
        this.sbox = GuiCommonElements.addComboBox(this.sPanel, "Screen: ", this.screenItems, 80, "Select dataset to use for this import.", 50.0, "0,0,F,C", this.debug);
        String offsetButtons = ",C";
        int addBtnSize = 60;
        if (GuiCommonElements.getIsMac()) {
            addBtnSize = 20;
        }
        this.addScreenBtn = GuiCommonElements.addIconButton(this.sPanel, "", this.addIcon, 20, addBtnSize, null, null, "2,0,f" + offsetButtons, this.debug);
        this.addScreenBtn.addActionListener(this);
        this.importPanel.add((Component)this.sPanel, "0, 2, 4, 2");
        this.cancelBtn = GuiCommonElements.addButton(this.importPanel, "Cancel", 76, "Cancel", "1, 5, f, c", this.debug);
        this.cancelBtn.addActionListener(this);
        this.importBtn = GuiCommonElements.addButton(this.importPanel, "Add to Queue", 81, "Import", "3, 5, f, c", this.debug);
        this.importBtn.addActionListener(this);
        this.getRootPane().setDefaultButton(this.importBtn);
        GuiCommonElements.enterPressesWhenFocused(this.importBtn);
        this.archiveImage = GuiCommonElements.addCheckBox(this.importPanel, "Archive the original imported file(s) to the server.", "0,4,4,4", this.debug);
        this.archiveImage.setSelected(false);
        if (this.ARCHIVE_ENABLED) {
            this.archiveImage.setVisible(true);
        } else {
            this.archiveImage.setVisible(false);
        }
        this.add(this.tabbedPane);
        this.tabbedPane.addTab("Import Settings", null, this.importPanel, "Import Settings");
        this.importBtn.setEnabled(false);
        this.getRootPane().setDefaultButton(this.importBtn);
        this.cancelBtn.addActionListener(this);
        this.importBtn.addActionListener(this);
        this.sbox.addActionListener(this);
        this.buildScreens();
        this.setVisible(true);
    }

    private void buildScreens() {
        if ((Long)this.config.savedScreen.get() != 0L && this.screenItems != null) {
            for (int i = 0; i < this.screenItems.length; ++i) {
                RLong pId = this.screenItems[i].getScreen().getId();
                if (pId == null || pId.getValue() != ((Long)this.config.savedScreen.get()).longValue()) continue;
                this.sbox.setSelectedIndex(i);
            }
        }
    }

    private void refreshAndSetScreen() {
        if (this.store != null) {
            this.screenItems = ScreenItem.createScreenItem(this.store.getScreens());
            for (int k = 0; k < this.screenItems.length; ++k) {
                RLong pId = this.screenItems[k].getScreen().getId();
                if (pId == null || pId.getValue() != ((Long)this.config.savedScreen.get()).longValue()) continue;
                this.sbox.insertItemAt(this.screenItems[k], k);
                this.sbox.setSelectedIndex(k);
            }
            this.buildScreens();
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.addScreenBtn) {
            new AddScreenDialog(this.config, this, "Add a new Screen", true, this.store);
            this.refreshAndSetScreen();
        }
        if (event.getSource() == this.cancelBtn) {
            this.cancelled = true;
            this.dispose();
        }
        if (event.getSource() == this.importBtn) {
            this.cancelled = false;
            this.importBtn.requestFocus();
            this.screen = ((ScreenItem)this.sbox.getSelectedItem()).getScreen();
            this.config.savedScreen.set((Object)((ScreenItem)this.sbox.getSelectedItem()).getScreen().getId().getValue());
            this.dispose();
        }
        if (event.getSource() == this.sbox) {
            this.cancelled = false;
            if (this.sbox.getSelectedIndex() == 0) {
                this.importBtn.setEnabled(false);
            } else {
                this.importBtn.setEnabled(true);
            }
        }
    }

    public static void main(String[] args) {
        String laf = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(laf);
        }
        catch (Exception e) {
            System.err.println(laf + " not supported.");
        }
        SPWDialog dialog = new SPWDialog(null, null, "Plate Import Dialog", true, null);
        if (dialog != null) {
            System.exit(0);
        }
    }
}

