/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.gui;

import Glacier2.CannotCreateSessionException;
import Glacier2.PermissionDeniedException;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import ome.conditions.ValidationException;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.gui.HistoryTableAbstractDataSource;
import ome.formats.importer.gui.ImportEntry;
import omero.ServerError;
import omero.api.IQueryPrx;
import omero.api.IUpdatePrx;
import omero.api.ServiceFactoryPrx;
import omero.grid.Column;
import omero.grid.Data;
import omero.grid.LongColumn;
import omero.grid.StringColumn;
import omero.grid.TablePrx;
import omero.model.IObject;
import omero.model.OriginalFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryTableStore
extends HistoryTableAbstractDataSource {
    private static boolean DEBUG = false;
    private static String SERVER = "warlock.openmicroscopy.org.uk";
    private static String USER = "root";
    private static String PASS = "omero";
    private static String baseDBNAME = "baseFile";
    private static String itemDBNAME = "itemFile";
    private static Log log = LogFactory.getLog(HistoryTableStore.class);
    public SimpleDateFormat day = new SimpleDateFormat("MMM d, ''yy");
    public SimpleDateFormat hour = new SimpleDateFormat("HH:mm");
    private static final int DEFAULT_BUFFER_SIZE = 1;
    public static final int BASE_UID_COLUMN = 0;
    public static final int BASE_DATETIME_COLUMN = 1;
    public static final int BASE_STATUS_COLUMN = 2;
    public static final int ITEM_BASE_UID_COLUMN = 0;
    public static final int ITEM_FILENAME_COLUMN = 1;
    public static final int ITEM_PROJECTID_COLUMN = 2;
    public static final int ITEM_OBJECTID_COLUMN = 3;
    public static final int ITEM_DATETIME_COLUMN = 4;
    public static final int ITEM_FILEPATH_COLUMN = 5;
    public static final int ITEM_STATUS_COLUMN = 6;
    public static final int ITEM_FILENUMBER_COLUMN = 7;
    private OMEROMetadataStoreClient store;
    private ServiceFactoryPrx sf;
    private IQueryPrx iQuery;
    private TablePrx baseTable;
    private Column[] baseColumns;
    private TablePrx itemTable;
    private Column[] itemColumns;
    public boolean historyEnabled = true;
    private static long lastUid = 0L;
    private Data baseData = null;
    private boolean baseDataDirty = true;
    private Data itemData = null;
    private boolean itemDataDirty = true;

    @Deprecated
    public void initialize(OMEROMetadataStoreClient store) throws ServerError {
        this.initialize(store, false);
    }

    public void initialize(OMEROMetadataStoreClient store, boolean disable) throws ServerError {
        this.store = store;
        this.sf = store.getServiceFactory();
        this.iQuery = this.sf.getQueryService();
        if (disable) {
            this.historyEnabled = false;
            log.warn((Object)"History tables service Disabled.");
        } else if (this.sf.sharedResources().areTablesEnabled()) {
            this.historyEnabled = true;
            log.warn((Object)"History tables service Enabled.");
        } else {
            this.historyEnabled = false;
            log.warn((Object)"History tables service Disabled.");
        }
    }

    @Override
    public void initializeDataSource() throws ServerError {
        if (!this.historyEnabled) {
            return;
        }
        this.baseColumns = this.createBaseColumns(1);
        this.itemColumns = this.createItemColumns(1);
        this.initializeBaseTable();
        this.initializeItemTable();
    }

    @Override
    public boolean wipeDataSource(Long experimenterId) throws ServerError {
        if (!this.historyEnabled) {
            return false;
        }
        this.clearTable(itemDBNAME);
        this.clearTable(baseDBNAME);
        this.initializeDataSource();
        return true;
    }

    private void clearTable(String dbName) throws ServerError {
        List<OriginalFile> dbFiles = this.getOriginalFiles(dbName);
        if (dbFiles == null || dbFiles.isEmpty()) {
            if (DEBUG) {
                log.debug((Object)("No " + dbName + " found."));
            }
            return;
        }
        for (OriginalFile file : dbFiles) {
            if (DEBUG) {
                log.debug((Object)("Deleting " + file.getName().getValue()));
            }
            this.deleteOriginalFile(file);
        }
    }

    @Override
    public void shutdownDataSource() throws Exception {
    }

    public List<OriginalFile> getOriginalFiles(String fileName) {
        try {
            String queryString = "from OriginalFile as o where o.details.owner.id = '" + this.store.getExperimenterID() + "' and o.name = '" + fileName + "'";
            List l = this.iQuery.findAllByQuery(queryString, null);
            return l;
        }
        catch (NullPointerException npe) {
            return null;
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    private void deleteOriginalFile(OriginalFile file) throws ServerError {
        IUpdatePrx update = this.sf.getUpdateService();
        try {
            update.deleteObject((IObject)file);
        }
        catch (ValidationException e) {
            throw new RuntimeException(e);
        }
    }

    public void displayTableData() {
        try {
            Data baseData = this.getBaseTableData();
            LongColumn uids = (LongColumn)baseData.columns[0];
            LongColumn baseImportTimes = (LongColumn)baseData.columns[1];
            StringColumn baseStatuses = (StringColumn)baseData.columns[2];
            for (int i = 0; i < uids.values.length; ++i) {
                log.debug((Object)("UID[" + uids.values[i] + "]: " + baseImportTimes.values[i] + ", '" + baseStatuses.values[i].trim() + "'"));
            }
            if (DEBUG) {
                log.debug((Object)("Rows in item table: " + this.itemTable.getNumberOfRows()));
            }
            Data itemData = this.getItemTableData();
            LongColumn baseUids = (LongColumn)itemData.columns[0];
            StringColumn fileNames = (StringColumn)itemData.columns[1];
            LongColumn projectIDs = (LongColumn)itemData.columns[2];
            LongColumn objectIDs = (LongColumn)itemData.columns[3];
            LongColumn importTimes = (LongColumn)itemData.columns[4];
            StringColumn filePaths = (StringColumn)itemData.columns[5];
            StringColumn statuses = (StringColumn)itemData.columns[6];
            LongColumn fileNumbers = (LongColumn)itemData.columns[7];
            for (int i = 0; i < baseUids.values.length; ++i) {
                log.debug((Object)("UID[" + baseUids.values[i] + "]: '" + fileNames.values[i].trim() + "', " + projectIDs.values[i] + ", " + objectIDs.values[i] + ", " + importTimes.values[i] + ", '" + filePaths.values[i].trim() + "', '" + statuses.values[i].trim() + "'" + fileNumbers.values[i]));
            }
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    private Column[] createBaseColumns(int rows) {
        Column[] newColumns = new Column[]{new LongColumn("Uid", "", new long[rows]), new LongColumn("DateTime", "", new long[rows]), new StringColumn("Status", "", 64L, new String[rows])};
        return newColumns;
    }

    private void initializeBaseTable() throws ServerError {
        if (!this.historyEnabled) {
            return;
        }
        List<OriginalFile> baseFiles = this.getOriginalFiles(baseDBNAME);
        if (baseFiles == null || baseFiles.isEmpty()) {
            this.createBaseTable();
        } else {
            log.debug((Object)("Using existing " + baseDBNAME));
            this.baseTable = this.sf.sharedResources().openTable(baseFiles.get(0));
            if (this.baseTable == null) {
                if (DEBUG) {
                    System.err.println("baseTable is null");
                }
            } else {
                this.historyEnabled = true;
                lastUid = this.getHighestBaseTableUid();
            }
        }
    }

    private void createBaseTable() throws ServerError {
        log.debug((Object)("Creating new " + baseDBNAME));
        this.baseTable = this.sf.sharedResources().newTable(1L, baseDBNAME);
        if (this.baseTable == null) {
            if (DEBUG) {
                System.err.println("baseTable is null");
            }
        } else {
            this.historyEnabled = true;
            this.baseTable.initialize(this.baseColumns);
            Column[] newRow = this.createBaseColumns(2);
            LongColumn uids = (LongColumn)newRow[0];
            LongColumn importTimes = (LongColumn)newRow[1];
            StringColumn statuses = (StringColumn)newRow[2];
            uids.values[0] = 0L;
            importTimes.values[0] = 0L;
            statuses.values[0] = String.format("%1$-64s", " ");
            uids.values[1] = 0L;
            importTimes.values[1] = 0L;
            statuses.values[1] = String.format("%1$-64s", " ");
            this.baseTable.addData(newRow);
            this.baseDataDirty = true;
            lastUid = this.getHighestBaseTableUid();
        }
    }

    @Override
    public int getLastBaseUid() throws ServerError {
        return (int)lastUid;
    }

    private long getHighestBaseTableUid() throws ServerError {
        long highestUid = 0L;
        Data d = this.getBaseTableData();
        if (d == null) {
            log.error((Object)"Error retrieving base table data.");
            return highestUid;
        }
        LongColumn uids = (LongColumn)d.columns[0];
        int length = uids.values.length;
        if (length == 0) {
            return highestUid;
        }
        for (long id : uids.values) {
            if (id <= highestUid) continue;
            highestUid = id;
        }
        return highestUid;
    }

    @Override
    public int addBaseTableRow(Long experimenterID, String import_status) throws ServerError {
        return (int)this.addBaseTableRow(import_status);
    }

    private long addBaseTableRow(String import_status) throws ServerError {
        long newUid;
        Column[] newRow = this.createBaseColumns(1);
        LongColumn uids = (LongColumn)newRow[0];
        LongColumn importTimes = (LongColumn)newRow[1];
        StringColumn statuses = (StringColumn)newRow[2];
        uids.values[0] = newUid = lastUid + 1L;
        importTimes.values[0] = new Date().getTime();
        statuses.values[0] = String.format("%1$-64s", import_status);
        if (DEBUG) {
            log.debug((Object)("Adding base row UID[" + uids.values[0] + "], " + importTimes.values[0] + ", " + statuses.values[0]));
        }
        this.baseTable.addData(newRow);
        this.baseDataDirty = true;
        lastUid = newUid;
        return lastUid;
    }

    @Override
    public Integer updateBaseStatus(int baseUid, String newStatus) throws ServerError {
        Data baseData;
        Long uid = baseUid;
        String searchString = "(Uid==" + uid + ")";
        long[] ids = this.baseTable.getWhereList(searchString, null, 0L, this.baseTable.getNumberOfRows(), 1L);
        int returnedRows = ids.length;
        if (DEBUG) {
            log.debug((Object)("updateBaseStatus returned rows: " + returnedRows));
        }
        if ((baseData = this.getBaseTableData()) == null) {
            log.error((Object)"Error retrieving base table data.");
            return returnedRows;
        }
        for (int h = 0; h < returnedRows; ++h) {
            int i = (int)ids[h];
            ((StringColumn)baseData.columns[2]).values[i] = newStatus;
        }
        this.baseTable.update(baseData);
        this.baseDataDirty = true;
        return returnedRows;
    }

    @Override
    public Vector<Object> getBaseQuery(Long ExperimenterID) {
        Vector<Object> rows = new Vector<Object>();
        try {
            Data d = this.getBaseTableData();
            if (d == null) {
                log.error((Object)"Error retrieving base table data.");
                return rows;
            }
            int returnedRows = (int)this.getBaseTableNumberOfRows();
            LongColumn importTimes = (LongColumn)d.columns[1];
            StringColumn statuses = (StringColumn)d.columns[2];
            for (int i = 0; i < returnedRows; ++i) {
                Vector<Object> row = new Vector<Object>();
                row.add(new Date(importTimes.values[i]));
                row.add(statuses.values[i].trim());
                rows.add(row);
            }
        }
        catch (NullPointerException npe) {
        }
        catch (Exception e) {
            log.error((Object)"exception.", (Throwable)e);
        }
        return rows;
    }

    @Override
    public DefaultListModel getBaseTableDataByDate(Date start, Date end) {
        try {
            Data d;
            long uid = 0L;
            long importTime = 0L;
            DefaultListModel<ImportEntry> list = new DefaultListModel<ImportEntry>();
            String searchString = "(DateTime>=" + start.getTime() + ") & (DateTime<=" + end.getTime() + ")";
            long[] ids = this.baseTable.getWhereList(searchString, null, 0L, this.baseTable.getNumberOfRows(), 1L);
            int returnedRows = ids.length;
            if (DEBUG) {
                log.debug((Object)("getBaseTableDataByDate returned rows: " + returnedRows));
            }
            if ((d = this.getBaseTableData()) == null) {
                log.error((Object)"Error retrieving base table data.");
                return new DefaultListModel();
            }
            LongColumn uids = (LongColumn)d.columns[0];
            LongColumn importTimes = (LongColumn)d.columns[1];
            StringColumn statuses = (StringColumn)d.columns[2];
            for (int h = 0; h < returnedRows; ++h) {
                String status;
                int i = (int)ids[h];
                try {
                    uid = uids.values[i];
                    importTime = importTimes.values[i];
                    status = statuses.values[i].trim();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.err.println("ids[" + h + "] not found in dataset.");
                    continue;
                }
                String icon = status.equals("complete") ? "gfx/import_done_16.png" : "gfx/warning_msg16.png";
                String dayString = this.day.format(new Date(importTime));
                String hourString = this.hour.format(new Date(importTime));
                if (this.day.format(new Date()).equals(dayString)) {
                    dayString = "Today";
                }
                if (this.day.format(this.getYesterday()).equals(dayString)) {
                    dayString = "Yesterday";
                }
                ImportEntry entry = new ImportEntry(dayString + " " + hourString, icon, (int)uid);
                list.addElement(entry);
            }
            return list;
        }
        catch (Exception e) {
            String s = String.format("Error retrieving base list from %s to %s.", start.toString(), end.toString());
            log.error((Object)s, (Throwable)e);
            return new DefaultListModel();
        }
    }

    public Data getBaseTableData() throws ServerError {
        if (this.baseDataDirty) {
            long rows = this.baseTable.getNumberOfRows();
            long[] ColNumbers = new long[]{0L, 1L, 2L};
            this.baseData = this.baseTable.read(ColNumbers, 0L, rows);
            this.baseDataDirty = false;
            if (DEBUG) {
                log.debug((Object)("Getting " + rows + " rows in " + baseDBNAME));
            }
        }
        return this.baseData;
    }

    public long getBaseTableNumberOfRows() {
        try {
            return this.baseTable.getNumberOfRows();
        }
        catch (ServerError e) {
            log.error((Object)"Error in getBaseTableNumberOfRows: ", (Throwable)e);
            e.printStackTrace();
            return 0L;
        }
    }

    private Column[] createItemColumns(int rows) {
        Column[] newColumns = new Column[]{new LongColumn("BaseUid", "", new long[rows]), new StringColumn("Filename", "", 256L, new String[rows]), new LongColumn("ProjectId", "", new long[rows]), new LongColumn("ObjectId", "", new long[rows]), new LongColumn("DateTime", "", new long[rows]), new StringColumn("Filepath", "", 1024L, new String[rows]), new StringColumn("Status", "", 32L, new String[rows]), new LongColumn("FileNumber", "", new long[rows])};
        return newColumns;
    }

    private void initializeItemTable() throws ServerError {
        if (!this.historyEnabled) {
            return;
        }
        List<OriginalFile> itemFiles = this.getOriginalFiles(itemDBNAME);
        if (itemFiles.isEmpty()) {
            if (DEBUG) {
                log.debug((Object)("Creating new " + itemDBNAME));
            }
            this.itemTable = this.sf.sharedResources().newTable(1L, itemDBNAME);
            this.itemTable.initialize(this.itemColumns);
            Column[] newRow = this.createItemColumns(2);
            LongColumn baseUids = (LongColumn)newRow[0];
            StringColumn fileNames = (StringColumn)newRow[1];
            LongColumn projectIDs = (LongColumn)newRow[2];
            LongColumn objectIDs = (LongColumn)newRow[3];
            LongColumn importTimes = (LongColumn)newRow[4];
            StringColumn filePaths = (StringColumn)newRow[5];
            StringColumn Statuses = (StringColumn)newRow[6];
            LongColumn fileNumbers = (LongColumn)newRow[7];
            baseUids.values[0] = 0L;
            fileNames.values[0] = String.format("%1$-256s", " ");
            projectIDs.values[0] = -1L;
            objectIDs.values[0] = -1L;
            importTimes.values[0] = 0L;
            filePaths.values[0] = String.format("%1$-1024s", " ");
            Statuses.values[0] = String.format("%1$-32s", " ");
            fileNumbers.values[0] = -1L;
            baseUids.values[1] = 0L;
            fileNames.values[1] = String.format("%1$-256s", " ");
            projectIDs.values[1] = -1L;
            objectIDs.values[1] = -1L;
            importTimes.values[1] = 0L;
            filePaths.values[1] = String.format("%1$-1024s", " ");
            Statuses.values[1] = String.format("%1$-32s", " ");
            fileNumbers.values[1] = -1L;
            this.itemTable.addData(newRow);
            this.itemDataDirty = true;
        } else {
            if (DEBUG) {
                log.debug((Object)("Using existing " + itemDBNAME));
            }
            this.itemTable = this.sf.sharedResources().openTable(itemFiles.get(0));
            if (this.itemTable == null && DEBUG) {
                System.err.println("itemTable is null");
            }
        }
    }

    @Override
    public int addItemTableRow(Long experimenterID, Integer baseUid, Integer fileNumber, String fileName, Long projectID, Long objectID, String status, File file) throws ServerError {
        this.addItemTableRow(baseUid.intValue(), fileName, (long)fileNumber.intValue(), projectID, (long)objectID, new Date().getTime(), status, file.getAbsolutePath());
        return -1;
    }

    public void addItemTableRow(long baseUid, String fileName, long fileNumber, long projectID, long objectID, long importTime, String status, String filePath) throws ServerError {
        Column[] newRow = this.createItemColumns(1);
        LongColumn baseUids = (LongColumn)newRow[0];
        StringColumn fileNames = (StringColumn)newRow[1];
        LongColumn projectIDs = (LongColumn)newRow[2];
        LongColumn objectIDs = (LongColumn)newRow[3];
        LongColumn importTimes = (LongColumn)newRow[4];
        StringColumn filePaths = (StringColumn)newRow[5];
        StringColumn Statuses = (StringColumn)newRow[6];
        LongColumn fileNumbers = (LongColumn)newRow[7];
        baseUids.values[0] = baseUid;
        fileNames.values[0] = String.format("%1$-256s", fileName);
        projectIDs.values[0] = projectID;
        objectIDs.values[0] = objectID;
        importTimes.values[0] = importTime;
        filePaths.values[0] = String.format("%1$-1024s", filePath);
        Statuses.values[0] = String.format("%1$-32s", status);
        fileNumbers.values[0] = 0L;
        this.itemTable.addData(newRow);
        this.itemDataDirty = true;
        if (DEBUG) {
            this.displayTableData();
        }
    }

    @Override
    public Integer updateItemStatus(int baseUid, int index, String newStatus) throws ServerError {
        try {
            Long uid = baseUid;
            String searchString = "(BaseUid==" + uid + ")";
            long[] ids = this.itemTable.getWhereList(searchString, null, 0L, this.itemTable.getNumberOfRows(), 1L);
            int returnedRows = ids.length;
            if (DEBUG) {
                log.debug((Object)("updateItemStatus returned rows: " + returnedRows));
            }
            Data itemData = this.getItemTableData();
            for (int h = 0; h < returnedRows; ++h) {
                int i = (int)ids[h];
                if (h != index) continue;
                ((StringColumn)itemData.columns[6]).values[i] = newStatus;
            }
            this.itemTable.update(itemData);
            this.itemDataDirty = true;
            return returnedRows;
        }
        catch (Exception e) {
            String s = String.format("Error updating item status for index %i with status %s.", index, newStatus);
            log.error((Object)s, (Throwable)e);
            return 0;
        }
    }

    public long[] getItemTableIDsByQuery(Long baseId, String queryString, Date start, Date end) {
        try {
            String searchString = "";
            searchString = start == null || end == null ? (queryString.trim().length() > 0 ? "(BaseUid==" + baseId + ")" : "(BaseUid==" + baseId + ")") : "(DateTime>=" + start.getTime() + ") & (DateTime<=" + end.getTime() + ")";
            long[] ids = this.itemTable.getWhereList(searchString, null, 0L, this.itemTable.getNumberOfRows(), 1L);
            return ids;
        }
        catch (Exception e) {
            String s = String.format("Error retrieving import list from %s to %s.", start.toString(), end.toString());
            log.error((Object)s, (Throwable)e);
            return null;
        }
    }

    @Override
    public Vector<Object> getItemQuery(Long importID, Long experimenterID, String queryString, Date from, Date to) {
        Vector<Object> rows = new Vector<Object>();
        try {
            Data d = this.getItemTableData();
            long[] ids = this.getItemTableIDsByQuery(importID, "", from, to);
            StringColumn fileNames = (StringColumn)d.columns[1];
            LongColumn projectIDs = (LongColumn)d.columns[2];
            LongColumn objectIDs = (LongColumn)d.columns[3];
            LongColumn importTimes = (LongColumn)d.columns[4];
            StringColumn filePaths = (StringColumn)d.columns[1];
            StringColumn statuses = (StringColumn)d.columns[6];
            String fileName = "";
            String filePath = "";
            String status = "";
            Long objectID = 0L;
            Long projectID = 0L;
            Long importTime = 0L;
            int returnedRows = 0;
            if (ids != null) {
                returnedRows = ids.length;
            }
            for (int h = 0; h < returnedRows; ++h) {
                int i = (int)ids[h];
                fileName = fileNames.values[i].trim();
                projectID = projectIDs.values[i];
                objectID = objectIDs.values[i];
                importTime = importTimes.values[i];
                filePath = filePaths.values[i].trim();
                status = statuses.values[i].trim();
                Vector<Object> row = new Vector<Object>();
                row.add(fileName);
                row.add(importTime);
                row.add(status);
                row.add(filePath);
                row.add(objectID);
                row.add(projectID);
                rows.add(row);
            }
        }
        catch (NullPointerException npe) {
            log.error((Object)"Null pointer exception.", (Throwable)npe);
        }
        catch (Exception e) {
            log.error((Object)"exception.", (Throwable)e);
        }
        return rows;
    }

    public Data getItemTableData() throws ServerError {
        if (this.itemDataDirty) {
            long rows = this.itemTable.getNumberOfRows();
            long[] colNumbers = new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L};
            this.itemData = this.itemTable.read(colNumbers, 0L, rows);
            this.itemDataDirty = false;
        }
        return this.itemData;
    }

    public long getItemTableNumberOfRows() {
        try {
            return this.itemTable.getNumberOfRows();
        }
        catch (ServerError e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static void main(String[] args) throws CannotCreateSessionException, PermissionDeniedException, ServerError {
        DEBUG = true;
        OMEROMetadataStoreClient store = new OMEROMetadataStoreClient();
        store.initialize(USER, PASS, SERVER, 4064);
        boolean CLEAN = true;
        boolean TEST = false;
        HistoryTableStore hts = new HistoryTableStore();
        try {
            hts.initialize(store, false);
            if (CLEAN) {
                hts.clearTable(baseDBNAME);
                hts.clearTable(itemDBNAME);
            }
            hts.initializeDataSource();
            lastUid = hts.getHighestBaseTableUid();
            if (DEBUG) {
                log.debug((Object)("Last UID: " + lastUid));
            }
            if (TEST) {
                long testid = hts.addBaseTableRow("test");
                if (DEBUG) {
                    log.debug((Object)("Last UID: " + lastUid));
                }
                hts.addItemTableRow(testid, "nofile", 0L, 0L, 0L, 0L, "test", "nopath");
            }
            hts.displayTableData();
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
        finally {
            store.logout();
        }
        System.err.println("Done");
    }
}

