/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.gui.GuiCommonElements;
import ome.formats.importer.gui.GuiImporter;
import ome.formats.importer.gui.HistoryDB;
import ome.formats.importer.gui.HistoryTableStore;
import ome.formats.importer.gui.HistoryTaskBar;
import ome.formats.importer.util.ETable;
import omero.ServerError;
import omero.model.Dataset;
import omero.model.Screen;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;

public class HistoryTable
extends JPanel
implements ActionListener,
PropertyChangeListener,
IObserver,
IObservable,
ListSelectionListener {
    private static Log log = LogFactory.getLog(HistoryTable.class);
    final ArrayList<IObserver> observers;
    public HistoryTableModel table;
    public ETable eTable;
    private static final String DATE_FORMAT = "yy/MM/dd";
    Boolean debug;
    int buttonSize;
    int statusWidth;
    int dateWidth;
    String searchIcon;
    String clearIcon;
    JPanel mainPanel;
    JPanel topSidePanel;
    JPanel bottomSidePanel;
    JPanel filterPanel;
    JTextPane sideLabel;
    JLabel fromLabel;
    JLabel toLabel;
    JXDatePicker fromDate;
    JXDatePicker toDate;
    JTextField searchField;
    JTextPane filterLabel;
    JCheckBox doneCheckBox;
    JCheckBox failedCheckBox;
    JCheckBox invalidCheckBox;
    JCheckBox pendingCheckBox;
    JButton searchBtn;
    JButton reimportBtn;
    JButton clearBtn;
    final HistoryTableStore db;
    private final GuiImporter viewer;
    private final HistoryTaskBar historyTaskBar;
    JList todayList;
    JList yesterdayList;
    JList thisWeekList;
    JList lastWeekList;
    JList thisMonthList;
    private boolean unknownProjectDatasetFlag;

    HistoryTable(GuiImporter viewer) {
        HistoryTableStore db;
        block4: {
            this.observers = new ArrayList();
            this.table = new HistoryTableModel();
            this.eTable = new ETable(this.table);
            this.debug = false;
            this.buttonSize = 40;
            this.statusWidth = 100;
            this.dateWidth = 180;
            this.searchIcon = "gfx/add.png";
            this.clearIcon = "gfx/nuvola_editdelete16.png";
            this.historyTaskBar = new HistoryTaskBar();
            this.todayList = new JList(this.historyTaskBar.today);
            this.yesterdayList = new JList(this.historyTaskBar.yesterday);
            this.thisWeekList = new JList(this.historyTaskBar.thisWeek);
            this.lastWeekList = new JList(this.historyTaskBar.lastWeek);
            this.thisMonthList = new JList(this.historyTaskBar.thisMonth);
            this.viewer = viewer;
            try {
                this.historyTaskBar.addPropertyChangeListener(this);
            }
            catch (Exception ex) {
                log.error((Object)"Exception adding property change listener.", (Throwable)ex);
            }
            db = null;
            try {
                db = new HistoryTableStore();
                db.addObserver(this);
            }
            catch (Exception e) {
                db = null;
                log.error((Object)"Could not start history DB.", (Throwable)e);
                if (HistoryDB.alertOnce) break block4;
                JOptionPane.showMessageDialog(null, "We were not able to connect to the history DB.\nIn the meantime, you will still be able to use \nthe importer, but the history feature will be disable.", "Warning", 0);
                HistoryDB.alertOnce = true;
            }
        }
        this.db = db;
        this.setLayout(new BoxLayout(this, 2));
        this.setOpaque(false);
        double[][] mainTable = new double[][]{{170.0, 10.0, -1.0, 90.0}, {5.0, 30.0, 35.0, 70.0, -1.0, 35.0, 5.0}};
        this.mainPanel = GuiCommonElements.addMainPanel(this, mainTable, 0, 0, 0, 0, this.debug);
        double[][] topSideTable = new double[][]{{-1.0}, {20.0, 20.0, 20.0, 20.0, 35.0}};
        this.topSidePanel = GuiCommonElements.addBorderedPanel(this.mainPanel, topSideTable, " Date Filter ", this.debug);
        String[] dateFormats = new String[]{DATE_FORMAT};
        this.fromDate = new JXDatePicker();
        this.fromDate.setToolTipText("Pick a from date.");
        this.fromDate.setFormats(dateFormats);
        this.toDate = new JXDatePicker();
        this.toDate.setToolTipText("Pick a to date.");
        this.toDate.setFormats(dateFormats);
        this.fromLabel = new JLabel("From (yy/mm/dd):");
        this.topSidePanel.add((Component)this.fromLabel, "0,0");
        this.topSidePanel.add((Component)this.fromDate, "0,1");
        this.toLabel = new JLabel("To (yy/mm/dd):");
        this.topSidePanel.add((Component)this.toLabel, "0,2");
        this.topSidePanel.add((Component)this.toDate, "0,3");
        double[][] bottomSideTable = new double[][]{{-1.0}, {-1.0}};
        this.historyTaskBar.addTaskPane("Today", this.historyTaskBar.getList(this.todayList));
        this.historyTaskBar.addTaskPane("Yesterday", this.historyTaskBar.getList(this.yesterdayList));
        this.historyTaskBar.addTaskPane("This Week", this.historyTaskBar.getList(this.thisWeekList));
        this.historyTaskBar.addTaskPane("Last Week", this.historyTaskBar.getList(this.lastWeekList));
        this.historyTaskBar.addTaskPane("This Month", this.historyTaskBar.getList(this.thisMonthList));
        this.bottomSidePanel = GuiCommonElements.addBorderedPanel(this.mainPanel, bottomSideTable, " Quick Date ", this.debug);
        this.bottomSidePanel.add((Component)((Object)this.historyTaskBar), "0,0");
        this.clearBtn = GuiCommonElements.addIconButton(this.mainPanel, "Wipe History", this.clearIcon, 130, 32, 83, "Click here to clear your history log.", "0,5,C,C", this.debug);
        this.clearBtn.setActionCommand("CLEARHISTORY");
        this.clearBtn.addActionListener(this);
        this.searchField = new JTextField("*.*");
        this.searchField.setVisible(false);
        this.searchBtn = GuiCommonElements.addButton(this.topSidePanel, "Search", 83, "Click here to search", "0,4,C,C", this.debug);
        this.searchBtn.setActionCommand("HISTORYSEARCH");
        this.searchBtn.addActionListener(this);
        TableColumnModel cModel = this.eTable.getColumnModel();
        TableColumn hiddenColumn = cModel.getColumn(6);
        cModel.removeColumn(hiddenColumn);
        hiddenColumn = cModel.getColumn(5);
        cModel.removeColumn(hiddenColumn);
        hiddenColumn = cModel.getColumn(4);
        cModel.removeColumn(hiddenColumn);
        MyTableHeaderRenderer myHeader = new MyTableHeaderRenderer();
        cModel.getColumn(0).setHeaderRenderer(myHeader);
        cModel.getColumn(1).setHeaderRenderer(myHeader);
        cModel.getColumn(2).setHeaderRenderer(myHeader);
        cModel.getColumn(3).setHeaderRenderer(myHeader);
        cModel.getColumn(0).setCellRenderer(new LeftDotRenderer());
        cModel.getColumn(1).setCellRenderer(new TextCellCenter());
        cModel.getColumn(2).setCellRenderer(new TextCellCenter());
        cModel.getColumn(3).setCellRenderer(new TextCellCenter());
        TableColumn statusColumn = this.eTable.getColumnModel().getColumn(3);
        statusColumn.setPreferredWidth(this.statusWidth);
        statusColumn.setMaxWidth(this.statusWidth);
        statusColumn.setMinWidth(this.statusWidth);
        TableColumn dateColumn = this.eTable.getColumnModel().getColumn(2);
        dateColumn.setPreferredWidth(this.dateWidth);
        dateColumn.setMaxWidth(this.dateWidth);
        dateColumn.setMinWidth(this.dateWidth);
        JScrollPane scrollPane = new JScrollPane(this.eTable);
        this.reimportBtn = GuiCommonElements.addButton(this.mainPanel, "Reimport", 82, "Click here to reimport selected images", "3,5,C,C", this.debug);
        this.reimportBtn.setEnabled(false);
        this.reimportBtn.setActionCommand("HISTORYREIMPORT");
        this.reimportBtn.addActionListener(this);
        ListSelectionModel selectionModel = this.eTable.getSelectionModel();
        selectionModel.addListSelectionListener(this);
        this.mainPanel.add((Component)scrollPane, "2,1,3,4");
        this.mainPanel.add((Component)this.bottomSidePanel, "0,4,0,0");
        this.mainPanel.add((Component)this.topSidePanel, "0,0,0,3");
        this.add(this.mainPanel);
    }

    private void ClearHistory() {
        String message = "This will delete your import history. \nAre you sure you want to continue?";
        Object[] o = new Object[]{"Yes", "No"};
        int result = JOptionPane.showOptionDialog(this, message, "Warning", -1, 2, null, o, o[1]);
        if (result == 0) {
            try {
                this.db.wipeDataSource(this.getExperimenterID());
            }
            catch (ServerError e) {
                log.error((Object)"exception.", (Throwable)e);
            }
            this.updateOutlookBar();
            this.getItemQuery(-1L, this.getExperimenterID(), this.searchField.getText(), this.fromDate.getDate(), this.toDate.getDate());
        }
    }

    public void getBaseQuery(Long ExperimenterID) {
        try {
            int count = this.table.getRowCount();
            for (int r = count - 1; r >= 0; --r) {
                this.table.removeRow(r);
            }
            Vector<Object> query = this.db.getBaseQuery(ExperimenterID);
            int returnedRows = query.size();
            for (int i = 0; i < returnedRows; ++i) {
                Vector queryRow = (Vector)query.get(i);
                Vector<Object> row = new Vector<Object>();
                row.add(new Date((Long)queryRow.get(0)));
                row.add((String)queryRow.get(1));
                this.table.addRow(row);
            }
        }
        catch (NullPointerException npe) {
        }
        catch (Exception e) {
            log.error((Object)"exception.", (Throwable)e);
        }
    }

    public void getItemQuery(long importID, long experimenterID, String queryString, Date from, Date to) {
        String objectName = "";
        String projectName = "";
        String pdsString = "";
        String fileName = "";
        String filePath = "";
        String status = "";
        long oldObjectID = 0L;
        long objectID = 0L;
        long oldProjectID = 0L;
        long projectID = 0L;
        long importTime = 0L;
        try {
            for (int r = this.table.getRowCount() - 1; r >= 0; --r) {
                this.table.removeRow(r);
            }
            Vector<Object> query = this.db.getItemQuery(importID, experimenterID, queryString, from, to);
            int returnedRows = query.size();
            for (int i = 0; i < returnedRows; ++i) {
                Vector queryRow = (Vector)query.get(i);
                fileName = (String)queryRow.get(0);
                importTime = (Long)queryRow.get(1);
                status = (String)queryRow.get(2);
                filePath = (String)queryRow.get(3);
                objectID = (Long)queryRow.get(4);
                projectID = (Long)queryRow.get(5);
                if (oldObjectID != objectID) {
                    oldObjectID = objectID;
                    if (projectID != 0L) {
                        try {
                            objectName = ((Dataset)this.getStore().getTarget(Dataset.class, objectID)).getName().getValue();
                        }
                        catch (Exception e) {
                            objectName = "unknown";
                            this.displayAccessError();
                        }
                        if (oldProjectID != projectID) {
                            oldProjectID = projectID;
                            try {
                                projectName = this.getStore().getProject(projectID).getName().getValue();
                            }
                            catch (Exception e) {
                                projectName = "unknown";
                                this.displayAccessError();
                            }
                        }
                        pdsString = projectName + "/" + objectName;
                    } else {
                        try {
                            objectName = ((Screen)this.getStore().getTarget(Screen.class, objectID)).getName().getValue();
                        }
                        catch (Exception e) {
                            objectName = "unknown";
                            this.displayAccessError();
                        }
                        pdsString = objectName;
                    }
                }
                String dayString = this.db.day.format(new Date(importTime));
                String hourString = this.db.hour.format(new Date(importTime));
                if (this.db.day.format(new Date()).equals(dayString)) {
                    dayString = "Today";
                }
                if (this.db.day.format(this.db.getYesterday()).equals(dayString)) {
                    dayString = "Yesterday";
                }
                Vector<Object> row = new Vector<Object>();
                row.add(fileName);
                row.add(pdsString);
                row.add(dayString + " " + hourString);
                row.add(status);
                row.add(filePath);
                row.add(objectID);
                row.add(projectID);
                this.table.addRow(row);
                this.unknownProjectDatasetFlag = false;
            }
        }
        catch (NullPointerException npe) {
            log.error((Object)"Null pointer exception.", (Throwable)npe);
        }
        catch (Exception e) {
            log.error((Object)"exception.", (Throwable)e);
        }
    }

    private void displayAccessError() {
        if (this.unknownProjectDatasetFlag) {
            return;
        }
        this.unknownProjectDatasetFlag = true;
        JOptionPane.showMessageDialog(null, "We were not able to retrieve the project/dataset for\none or more of the imports in this history selection.\nThe most likely cause is that the original project or\ndataset was deleted.\n\nAs a result, the imported items in question cannot be\nreimported automatically using the \"reimport\" button.\n\nClick OK to continue.", "Warning", 0);
    }

    public void updateOutlookBar() {
        GregorianCalendar newCal = new GregorianCalendar();
        int dayOfWeek = newCal.get(7);
        int dayOfMonth = newCal.get(5);
        DefaultListModel today = this.db.getBaseTableDataByDate(this.db.getStartOfDay(new Date()), this.db.getEndOfDay(new Date()));
        this.historyTaskBar.updateList(this.todayList, this.historyTaskBar.today, today);
        DefaultListModel yesterday = this.db.getBaseTableDataByDate(this.db.getStartOfDay(this.db.getYesterday()), this.db.getEndOfDay(this.db.getYesterday()));
        this.historyTaskBar.updateList(this.yesterdayList, this.historyTaskBar.yesterday, yesterday);
        DefaultListModel thisWeek = this.db.getBaseTableDataByDate(this.db.getStartOfDay(this.db.getDaysBefore(new Date(), -dayOfWeek)), this.db.getEndOfDay(new Date()));
        this.historyTaskBar.updateList(this.thisWeekList, this.historyTaskBar.thisWeek, thisWeek);
        DefaultListModel lastWeek = this.db.getBaseTableDataByDate(this.db.getStartOfDay(this.db.getDaysBefore(new Date(), -(dayOfWeek + 7))), this.db.getEndOfDay(this.db.getDaysBefore(new Date(), -dayOfWeek)));
        this.historyTaskBar.updateList(this.lastWeekList, this.historyTaskBar.lastWeek, lastWeek);
        DefaultListModel thisMonth = this.db.getBaseTableDataByDate(this.db.getStartOfDay(this.db.getDaysBefore(new Date(), -dayOfMonth)), this.db.getEndOfDay(new Date()));
        this.historyTaskBar.updateList(this.thisMonthList, this.historyTaskBar.thisMonth, thisMonth);
    }

    private void getQuickHistory(Integer importKey) {
        this.getItemQuery(importKey.intValue(), this.getExperimenterID(), null, null, null);
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.searchBtn || src == this.doneCheckBox || src == this.failedCheckBox || src == this.invalidCheckBox || src == this.pendingCheckBox) {
            if (this.fromDate.getDate() == null) {
                this.fromDate.setDate(this.db.getStartOfDay(new Date()));
            }
            if (this.toDate.getDate() == null) {
                this.toDate.setDate(this.db.getEndOfDay(new Date()));
            }
            this.getItemQuery(-1L, this.getExperimenterID(), this.searchField.getText(), this.db.getStartOfDay(this.fromDate.getDate()), this.db.getEndOfDay(this.toDate.getDate()));
        }
        if (src == this.clearBtn) {
            this.ClearHistory();
        }
        if (src == this.reimportBtn) {
            this.notifyObservers((ImportEvent)new ImportEvent.REIMPORT());
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("QUICK_HISTORY")) {
            this.getQuickHistory((Integer)e.getNewValue());
        }
        if (prop.equals("date")) {
            this.getItemQuery(-1L, this.getExperimenterID(), this.searchField.getText(), this.fromDate.getDate(), this.toDate.getDate());
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.eTable.getSelectedRowCount() > 0) {
            this.reimportBtn.setEnabled(true);
        } else {
            this.reimportBtn.setEnabled(false);
        }
    }

    private OMEROMetadataStoreClient getStore() {
        return this.viewer.getLoginHandler().getMetadataStore();
    }

    private long getExperimenterID() {
        return this.getStore().getExperimenterID();
    }

    public void update(IObservable importLibrary, ImportEvent event) {
        long experimenterID = this.getExperimenterID();
        if ((experimenterID != -1L && event instanceof ImportEvent.LOGGED_IN || event instanceof ImportEvent.QUICKBAR_UPDATE) && this.db.historyEnabled) {
            this.updateOutlookBar();
        }
    }

    public boolean addObserver(IObserver object) {
        return this.observers.add(object);
    }

    public boolean deleteObserver(IObserver object) {
        return this.observers.remove(object);
    }

    public void notifyObservers(ImportEvent event) {
        for (IObserver observer : this.observers) {
            observer.update((IObservable)this, event);
        }
    }

    private static class TextCellCenter
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private TextCellCenter() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setFont(UIManager.getFont("TableCell.font"));
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    private static class LeftDotRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private LeftDotRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int availableWidth = table.getColumnModel().getColumn(column).getWidth();
            availableWidth = (int)((double)availableWidth - table.getIntercellSpacing().getWidth());
            Insets borderInsets = this.getBorder().getBorderInsets(this);
            String cellText = this.getText();
            FontMetrics fm = this.getFontMetrics(this.getFont());
            if (fm.stringWidth(cellText) > (availableWidth -= borderInsets.left + borderInsets.right)) {
                int nChars;
                String dots = "...";
                int textWidth = fm.stringWidth(dots);
                for (nChars = cellText.length() - 1; nChars > 0 && (textWidth += fm.charWidth(cellText.charAt(nChars))) <= availableWidth; --nChars) {
                }
                this.setText(dots + cellText.substring(nChars + 1));
            }
            this.setFont(UIManager.getFont("TableCell.font"));
            return this;
        }
    }

    private static class MyTableHeaderRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private MyTableHeaderRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table == null) {
                return null;
            }
            this.setBorder(BorderFactory.createLineBorder(new Color(0xE0E0E0)));
            this.setForeground(UIManager.getColor("TableHeader.foreground"));
            this.setBackground(UIManager.getColor("TableHeader.background"));
            this.setFont(UIManager.getFont("TableHeader.font"));
            this.setFont(this.getFont().deriveFont(1));
            this.setHorizontalAlignment(0);
            this.setText(value.toString());
            this.setOpaque(true);
            this.setToolTipText((String)value);
            this.setEnabled(table.isEnabled());
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return this;
        }

        public void validate() {
        }

        public void revalidate() {
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    static class HistoryTableModel
    extends DefaultTableModel
    implements TableModelListener {
        private static final long serialVersionUID = 1L;
        private String[] columnNames = new String[]{"File Name", "Project/Dataset or Screen", "Import Date/Time", "Status", "FilePath", "DatasetID", "ProjectID"};

        HistoryTableModel() {
        }

        public void tableChanged(TableModelEvent arg0) {
        }

        public boolean rowSelectionAllowed() {
            return true;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

