/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.gui.GuiCommonElements;
import ome.formats.importer.util.ETable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openmicroscopy.shoola.util.ui.IconManager;

public class FileQueueTable
extends JPanel
implements ActionListener,
IObserver {
    private Log log = LogFactory.getLog(FileQueueTable.class);
    private static QueueTableModel table = new QueueTableModel();
    private static ETable queue = new ETable(FileQueueTable.getTable());
    private static final long serialVersionUID = -4239932269937114120L;
    JButton refreshBtn;
    JButton addBtn;
    JButton removeBtn;
    JButton importBtn;
    JButton clearDoneBtn;
    JButton clearFailedBtn;
    JButton groupBtn;
    private int row;
    private int maxPlanes;
    public boolean cancel = false;
    public boolean abort = false;
    public boolean importing = false;
    public boolean failedFiles;
    public boolean doneFiles;
    private MyTableHeaderRenderer headerCellRenderer;
    private LeftDotRenderer fileCellRenderer;
    private CenterTextRenderer dpCellRenderer;
    private CenterTextRenderer statusCellRenderer;

    FileQueueTable() {
        Boolean debugBorders = false;
        int buttonSize = 40;
        String addIcon = "gfx/add.png";
        String removeIcon = "gfx/remove.png";
        int statusWidth = 100;
        this.setLayout(new BoxLayout(this, 2));
        this.setBorder(BorderFactory.createEmptyBorder(6, 5, 9, 8));
        JPanel buttonPanel = new JPanel();
        if (debugBorders.booleanValue()) {
            buttonPanel.setBorder(BorderFactory.createLineBorder(Color.red, 1));
        }
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 3));
        this.addBtn = GuiCommonElements.addBasicButton(null, addIcon, null);
        this.addBtn.setMaximumSize(new Dimension(buttonSize, buttonSize));
        this.addBtn.setPreferredSize(new Dimension(buttonSize, buttonSize));
        this.addBtn.setMinimumSize(new Dimension(buttonSize, buttonSize));
        this.addBtn.setSize(new Dimension(buttonSize, buttonSize));
        this.addBtn.setActionCommand("add");
        this.addBtn.addActionListener(this);
        this.addBtn.setToolTipText("Add files to the import queue.");
        this.removeBtn = GuiCommonElements.addBasicButton(null, removeIcon, null);
        this.removeBtn.setMaximumSize(new Dimension(buttonSize, buttonSize));
        this.removeBtn.setPreferredSize(new Dimension(buttonSize, buttonSize));
        this.removeBtn.setMinimumSize(new Dimension(buttonSize, buttonSize));
        this.removeBtn.setSize(new Dimension(buttonSize, buttonSize));
        this.removeBtn.setActionCommand("remove");
        this.removeBtn.addActionListener(this);
        this.removeBtn.setToolTipText("Remove files from the import queue.");
        buttonPanel.add(Box.createRigidArea(new Dimension(0, 60)));
        buttonPanel.add(Box.createVerticalGlue());
        buttonPanel.add(this.addBtn);
        buttonPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        buttonPanel.add(this.removeBtn);
        buttonPanel.add(Box.createVerticalGlue());
        buttonPanel.add(Box.createRigidArea(new Dimension(0, 60)));
        this.add(buttonPanel);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        JPanel queuePanel = new JPanel();
        if (debugBorders.booleanValue()) {
            queuePanel.setBorder(BorderFactory.createLineBorder(Color.red, 1));
        }
        queuePanel.setLayout(new BoxLayout(queuePanel, 3));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 2));
        JLabel label = new JLabel("Import Queue:");
        labelPanel.add(label);
        labelPanel.add(Box.createHorizontalGlue());
        this.groupBtn = GuiCommonElements.addBasicButton("Group: ", null, "Current Group");
        this.groupBtn.setToolTipText("The user group you are logged into.");
        labelPanel.add(this.groupBtn);
        queuePanel.add(labelPanel);
        queuePanel.add(Box.createRigidArea(new Dimension(0, 5)));
        TableColumnModel cModel = FileQueueTable.getQueue().getColumnModel();
        this.headerCellRenderer = new MyTableHeaderRenderer();
        this.fileCellRenderer = new LeftDotRenderer();
        this.dpCellRenderer = new CenterTextRenderer();
        this.statusCellRenderer = new CenterTextRenderer();
        cModel.getColumn(0).setHeaderRenderer(this.headerCellRenderer);
        cModel.getColumn(1).setHeaderRenderer(this.headerCellRenderer);
        cModel.getColumn(2).setHeaderRenderer(this.headerCellRenderer);
        cModel.getColumn(0).setCellRenderer(this.fileCellRenderer);
        cModel.getColumn(1).setCellRenderer(this.dpCellRenderer);
        cModel.getColumn(2).setCellRenderer(this.statusCellRenderer);
        TableColumn statusColumn = FileQueueTable.getQueue().getColumnModel().getColumn(2);
        statusColumn.setPreferredWidth(statusWidth);
        statusColumn.setMaxWidth(statusWidth);
        statusColumn.setMinWidth(statusWidth);
        SelectionListener listener = new SelectionListener(FileQueueTable.getQueue());
        FileQueueTable.getQueue().getSelectionModel().addListSelectionListener(listener);
        TableColumnModel tcm = FileQueueTable.getQueue().getColumnModel();
        TableColumn projectColumn = tcm.getColumn(6);
        tcm.removeColumn(projectColumn);
        TableColumn userPixelColumn = tcm.getColumn(6);
        tcm.removeColumn(userPixelColumn);
        TableColumn userSpecifiedNameColumn = tcm.getColumn(6);
        tcm.removeColumn(userSpecifiedNameColumn);
        TableColumn datasetColumn = tcm.getColumn(3);
        tcm.removeColumn(datasetColumn);
        TableColumn pathColumn = tcm.getColumn(3);
        tcm.removeColumn(pathColumn);
        TableColumn archiveColumn = tcm.getColumn(3);
        tcm.removeColumn(archiveColumn);
        JScrollPane scrollPane = new JScrollPane(FileQueueTable.getQueue());
        queuePanel.add(scrollPane);
        JPanel importPanel = new JPanel();
        importPanel.setLayout(new BoxLayout(importPanel, 2));
        this.clearDoneBtn = GuiCommonElements.addBasicButton("Clear Done", null, null);
        this.clearFailedBtn = GuiCommonElements.addBasicButton("Clear Failed", null, null);
        this.importBtn = GuiCommonElements.addBasicButton("Import", null, null);
        importPanel.add(Box.createHorizontalGlue());
        importPanel.add(this.clearDoneBtn);
        this.clearDoneBtn.setEnabled(false);
        this.clearDoneBtn.setActionCommand("clear_done");
        this.clearDoneBtn.addActionListener(this);
        this.clearDoneBtn.setToolTipText("Clear all 'done' entries from the import queue.");
        importPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        importPanel.add(this.clearFailedBtn);
        this.clearFailedBtn.setEnabled(false);
        this.clearFailedBtn.setActionCommand("clear_failed");
        this.clearFailedBtn.addActionListener(this);
        this.clearFailedBtn.setToolTipText("Clear all 'failed' entries from the import queue.");
        importPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        importPanel.add(this.importBtn);
        this.importBtn.setEnabled(false);
        this.importBtn.setActionCommand("import");
        this.importBtn.addActionListener(this);
        this.importBtn.setToolTipText("Begin importing files.");
        GuiCommonElements.enterPressesWhenFocused(this.importBtn);
        queuePanel.add(Box.createRigidArea(new Dimension(0, 5)));
        queuePanel.add(importPanel);
        this.add(queuePanel);
    }

    public void setProgressInfo(int row, int maxPlanes) {
        this.row = row;
        this.maxPlanes = maxPlanes;
    }

    public boolean setProgressPending(int row) {
        if (FileQueueTable.getTable().getValueAt(row, 2).equals("added")) {
            FileQueueTable.getTable().setValueAt("pending", row, 2);
            return true;
        }
        return false;
    }

    public void setProgressInvalid(int row) {
        if (FileQueueTable.getTable().getValueAt(row, 2).equals("added")) {
            FileQueueTable.getTable().setValueAt("invalid format", row, 2);
        }
    }

    public void setImportProgress(int count, int series, int step) {
        String text = count > 1 ? series + 1 + "/" + count + ": " + step + "/" + this.maxPlanes : step + "/" + this.maxPlanes;
        FileQueueTable.getTable().setValueAt(text, this.row, 2);
    }

    public void setProgressFailed(int row) {
        FileQueueTable.getTable().setValueAt("failed", row, 2);
        this.failedFiles = true;
    }

    public void setProgressUnknown(int row) {
        FileQueueTable.getTable().setValueAt("unreadable", row, 2);
        this.failedFiles = true;
    }

    public void setProgressPrepping(int row) {
        FileQueueTable.getTable().setValueAt("prepping", row, 2);
    }

    public void setProgressPixelsStored(int row) {
        FileQueueTable.getTable().setValueAt("pixels stored", row, 2);
        this.doneFiles = true;
    }

    public void setProgressDone(int row) {
        FileQueueTable.getTable().setValueAt("done", row, 2);
        FileQueueTable.getTable().fireTableRowsUpdated(row, row);
        this.doneFiles = true;
    }

    public void setProgressSaveToDb(int row) {
        FileQueueTable.getTable().setValueAt("saving to db", row, 2);
    }

    public void setProgressOverlays(int row) {
        FileQueueTable.getTable().setValueAt("overlays", row, 2);
    }

    public void setProgressArchiving(int row) {
        FileQueueTable.getTable().setValueAt("archiving", row, 2);
    }

    public void setProgressProcessing(int row) {
        FileQueueTable.getTable().setValueAt("processing", row, 2);
    }

    public void setProgressAnalyzing(int row) {
        FileQueueTable.getTable().setValueAt("analyzing", row, 2);
    }

    public int getMaximumPlanes() {
        return this.maxPlanes;
    }

    public ImportContainer[] getImportContainersFromTable() {
        int num = FileQueueTable.getTable().getRowCount();
        ImportContainer[] importContainer = new ImportContainer[num];
        for (int i = 0; i < num; ++i) {
            importContainer[i] = (ImportContainer)FileQueueTable.getTable().getValueAt(i, 3);
        }
        return importContainer;
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.addBtn) {
            this.firePropertyChange("add", false, true);
        }
        if (src == this.removeBtn) {
            this.firePropertyChange("remove", false, true);
        }
        if (src == this.clearDoneBtn) {
            this.firePropertyChange("clear_done", false, true);
        }
        if (src == this.clearFailedBtn) {
            this.firePropertyChange("clear_failed", false, true);
        }
        if (src == this.importBtn) {
            FileQueueTable.getQueue().clearSelection();
            this.firePropertyChange("import", false, true);
        }
    }

    public void centerOnRow(int row) {
        FileQueueTable.getQueue().getSelectionModel().setSelectionInterval(row, row);
        Rectangle visibleRect = FileQueueTable.getQueue().getVisibleRect();
        int centerY = visibleRect.y + visibleRect.height / 2;
        Rectangle cellRect = FileQueueTable.getQueue().getCellRect(row, 0, true);
        cellRect.y = centerY < cellRect.y ? cellRect.y - visibleRect.y + centerY : cellRect.y + visibleRect.y - centerY;
        FileQueueTable.getQueue().scrollRectToVisible(cellRect);
    }

    public void update(IObservable importLibrary, ImportEvent event) {
        if (event instanceof ImportEvent.LOADING_IMAGE) {
            ImportEvent.LOADING_IMAGE ev = (ImportEvent.LOADING_IMAGE)event;
            this.setProgressPrepping(ev.index);
        } else if (event instanceof ImportEvent.LOADED_IMAGE) {
            ImportEvent.LOADED_IMAGE ev = (ImportEvent.LOADED_IMAGE)event;
            this.setProgressAnalyzing(ev.index);
        } else if (event instanceof ImportEvent.DATASET_STORED) {
            ImportEvent.DATASET_STORED ev = (ImportEvent.DATASET_STORED)event;
            this.setProgressInfo(ev.index, ev.size.imageCount);
        } else if (event instanceof ImportEvent.IMPORT_STEP) {
            ImportEvent.IMPORT_STEP ev = (ImportEvent.IMPORT_STEP)event;
            if (ev.step <= this.getMaximumPlanes()) {
                this.setImportProgress(ev.seriesCount, ev.series, ev.step);
            }
        } else if (event instanceof ImportEvent.DATA_STORED) {
            ImportEvent.DATA_STORED ev = (ImportEvent.DATA_STORED)event;
            this.setProgressPixelsStored(ev.index);
        } else if (event instanceof ImportEvent.IMPORT_DONE) {
            ImportEvent.IMPORT_DONE ev = (ImportEvent.IMPORT_DONE)event;
            this.setProgressDone(ev.index);
        } else if (event instanceof ImportEvent.IMPORT_ARCHIVING) {
            ImportEvent.IMPORT_ARCHIVING ev = (ImportEvent.IMPORT_ARCHIVING)event;
            this.setProgressArchiving(ev.index);
        } else if (event instanceof ImportEvent.BEGIN_SAVE_TO_DB) {
            ImportEvent.BEGIN_SAVE_TO_DB ev = (ImportEvent.BEGIN_SAVE_TO_DB)event;
            this.setProgressSaveToDb(ev.index);
        } else if (event instanceof ImportEvent.IMPORT_OVERLAYS) {
            ImportEvent.IMPORT_OVERLAYS ev = (ImportEvent.IMPORT_OVERLAYS)event;
            this.setProgressOverlays(ev.index);
        } else if (event instanceof ImportEvent.IMPORT_PROCESSING) {
            ImportEvent.IMPORT_PROCESSING ev = (ImportEvent.IMPORT_PROCESSING)event;
            this.setProgressProcessing(ev.index);
        } else if (event instanceof ImportEvent.IMPORT_QUEUE_STARTED) {
            this.importBtn.setText("Cancel");
            this.importing = true;
        } else if (event instanceof ImportEvent.IMPORT_QUEUE_DONE) {
            this.importBtn.setText("Import");
            this.importBtn.setEnabled(true);
            FileQueueTable.getQueue().setRowSelectionAllowed(true);
            this.removeBtn.setEnabled(true);
            if (this.failedFiles) {
                this.clearFailedBtn.setEnabled(true);
            }
            if (this.doneFiles) {
                this.clearDoneBtn.setEnabled(true);
            }
            this.importing = false;
            this.cancel = false;
            this.abort = false;
        } else if (event instanceof ImportEvent.GROUP_SET) {
            ImportEvent.GROUP_SET ev = (ImportEvent.GROUP_SET)event;
            this.updateGroupBtn(ev.groupName, ev.groupType);
        }
    }

    private void updateGroupBtn(String groupName, int groupLevel) {
        this.groupBtn.setText(groupName);
        IconManager icons = IconManager.getInstance();
        Icon groupIcon = null;
        if (groupLevel == 0) {
            groupIcon = icons.getIcon(144);
        }
        if (groupLevel == 1) {
            groupIcon = icons.getIcon(142);
        }
        if (groupLevel == 2) {
            groupIcon = icons.getIcon(143);
        }
        if (groupLevel == 3) {
            groupIcon = icons.getIcon(141);
        }
        this.groupBtn.setIcon(groupIcon);
        this.groupBtn.setPreferredSize(new Dimension(160, 20));
        DefaultButtonModel model = new DefaultButtonModel(){
            private static final long serialVersionUID = 1L;

            public void setArmed(boolean armed) {
            }

            public void setPressed(boolean pressed) {
            }

            public void setRollover(boolean rollover) {
            }
        };
        this.groupBtn.setModel(model);
        this.groupBtn.invalidate();
        this.groupBtn.setFocusable(false);
    }

    public MyTableHeaderRenderer getHeaderCellRenderer() {
        return this.headerCellRenderer;
    }

    public LeftDotRenderer getFileCellRenderer() {
        return this.fileCellRenderer;
    }

    public CenterTextRenderer getDpCellRenderer() {
        return this.dpCellRenderer;
    }

    public CenterTextRenderer getStatusCellRenderer() {
        return this.statusCellRenderer;
    }

    public static void main(String[] args) {
        String laf = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(laf);
        }
        catch (Exception e) {
            System.err.println(laf + " not supported.");
        }
        FileQueueTable q = new FileQueueTable();
        JFrame f = new JFrame();
        f.getContentPane().add(q);
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
        f.pack();
    }

    public static void setTable(QueueTableModel table) {
        FileQueueTable.table = table;
    }

    public static QueueTableModel getTable() {
        return table;
    }

    public static void setQueue(ETable queue) {
        FileQueueTable.queue = queue;
    }

    public static ETable getQueue() {
        return queue;
    }

    private class SelectionListener
    implements ListSelectionListener {
        JTable table;

        SelectionListener(JTable table) {
            this.table = table;
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() == this.table.getSelectionModel() && this.table.getRowSelectionAllowed()) {
                this.dselectRows();
            }
        }

        private void dselectRows() {
            int rows = FileQueueTable.getQueue().getRowCount();
            for (int i = 0; i < rows; ++i) {
                try {
                    if (FileQueueTable.getQueue().getValueAt(i, 2).equals("added") || FileQueueTable.getQueue().getValueAt(i, 2).equals("pending") || !this.table.getSelectionModel().isSelectedIndex(i)) continue;
                    this.table.getSelectionModel().removeSelectionInterval(i, i);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    FileQueueTable.this.log.error((Object)"Error deselecting rows in table.", (Throwable)e);
                }
            }
        }
    }

    private static class CenterTextRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private CenterTextRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setFont(UIManager.getFont("TableCell.font"));
            this.setHorizontalAlignment(0);
            this.setToolTipText((String)value);
            if (FileQueueTable.getQueue().getValueAt(row, 2).equals("done")) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            if (FileQueueTable.getQueue().getValueAt(row, 2).equals("failed")) {
                this.setForeground(Color.red);
            } else if (FileQueueTable.getQueue().getValueAt(row, 2).equals("unreadable")) {
                this.setForeground(ETable.DARK_ORANGE);
            } else {
                this.setForeground(null);
            }
            return this;
        }
    }

    private static class LeftDotRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private LeftDotRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int availableWidth = table.getColumnModel().getColumn(column).getWidth();
            availableWidth = (int)((double)availableWidth - table.getIntercellSpacing().getWidth());
            Insets borderInsets = this.getBorder().getBorderInsets(this);
            String cellText = this.getText();
            FontMetrics fm = this.getFontMetrics(this.getFont());
            ImportContainer ic = (ImportContainer)FileQueueTable.getQueue().getModel().getValueAt(row, 3);
            this.setToolTipText(ic.getFile().getAbsolutePath());
            if (fm.stringWidth(cellText) > (availableWidth -= borderInsets.left + borderInsets.right)) {
                int nChars;
                String dots = "...";
                int textWidth = fm.stringWidth(dots);
                for (nChars = cellText.length() - 1; nChars > 0 && (textWidth += fm.charWidth(cellText.charAt(nChars))) <= availableWidth; --nChars) {
                }
                this.setText(dots + cellText.substring(nChars + 1));
            }
            this.setFont(UIManager.getFont("TableCell.font"));
            if (FileQueueTable.getQueue().getValueAt(row, 2).equals("done")) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            if (FileQueueTable.getQueue().getValueAt(row, 2).equals("failed")) {
                this.setForeground(Color.red);
            } else if (FileQueueTable.getQueue().getValueAt(row, 2).equals("unreadable")) {
                this.setForeground(ETable.DARK_ORANGE);
            } else {
                this.setForeground(null);
            }
            return this;
        }
    }

    private static class MyTableHeaderRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private MyTableHeaderRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table == null) {
                return null;
            }
            this.setBorder(BorderFactory.createLineBorder(new Color(0xE0E0E0)));
            this.setForeground(UIManager.getColor("TableHeader.foreground"));
            this.setBackground(UIManager.getColor("TableHeader.background"));
            this.setFont(UIManager.getFont("TableHeader.font"));
            this.setFont(this.getFont().deriveFont(1));
            this.setHorizontalAlignment(0);
            this.setText(value.toString());
            this.setOpaque(true);
            this.setEnabled(table == null || table.isEnabled());
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return this;
        }

        public void validate() {
        }

        public void revalidate() {
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    protected static class QueueTableModel
    extends DefaultTableModel
    implements TableModelListener {
        private static final long serialVersionUID = 1L;
        private String[] columnNames = new String[]{"Files in Queue", "Project/Dataset or Screen", "Status", "DatasetNum", "Path", "Archive", "ProjectNum", "UserPixels", "UserSpecifiedName"};

        protected QueueTableModel() {
        }

        public void tableChanged(TableModelEvent arg0) {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public boolean rowSelectionAllowed() {
            return true;
        }
    }
}

