/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.gui.GuiCommonElements;
import ome.formats.importer.util.ETable;
import ome.formats.importer.util.ErrorContainer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorTable
extends JPanel
implements ActionListener,
PropertyChangeListener,
IObserver,
IObservable,
MouseListener {
    private static Log log = LogFactory.getLog(ErrorTable.class);
    ArrayList<IObserver> observers = new ArrayList();
    public ErrorTableModel table = new ErrorTableModel();
    public ETable eTable = new ETable(this.table);
    Boolean debug = false;
    int buttonSize = 40;
    int statusWidth = 80;
    int errorWidth = 470;
    int uploadWidth = 20;
    String searchIcon = "gfx/add.png";
    String clearIcon = "gfx/nuvola_editdelete16.png";
    JPanel mainPanel;
    private JButton sendBtn;
    private JButton cancelBtn;
    private JButton clearDoneBtn;
    private ArrayList<ErrorContainer> errors;
    private boolean failedFiles = false;
    private CheckboxRenderer cbr;
    private CheckboxCellEditor cbe;
    private JPanel progressPanel;
    private JProgressBar bytesProgressBar;
    private JProgressBar filesProgressBar;
    private Thread runThread;

    public ErrorTable() {
        this.setLayout(new BoxLayout(this, 2));
        this.setOpaque(false);
        double[][] mainTable = new double[][]{{5.0, 200.0, 140.0, -1.0, 140.0, 5.0}, {5.0, -2.0, -1.0, 5.0, 29.0, 5.0}};
        this.mainPanel = GuiCommonElements.addMainPanel(this, mainTable, 0, 0, 0, 0, this.debug);
        String message = "All errors accumulated during your import are displayed here, and will be uploaded to us if check-marked. You can send us feedback on these problems by clicking the 'Send Feedback' button.";
        JTextPane instructions = GuiCommonElements.addTextPane(this.mainPanel, message, "1,1,4,0", this.debug);
        instructions.setMargin(new Insets(10, 10, 10, 10));
        TableColumnModel cModel = this.eTable.getColumnModel();
        TableColumn hiddenColumn = cModel.getColumn(6);
        cModel.removeColumn(hiddenColumn);
        hiddenColumn = cModel.getColumn(5);
        cModel.removeColumn(hiddenColumn);
        hiddenColumn = cModel.getColumn(4);
        cModel.removeColumn(hiddenColumn);
        MyTableHeaderRenderer myHeader = new MyTableHeaderRenderer();
        cModel.getColumn(0).setHeaderRenderer(myHeader);
        cModel.getColumn(1).setHeaderRenderer(myHeader);
        cModel.getColumn(2).setHeaderRenderer(myHeader);
        cModel.getColumn(3).setHeaderRenderer(myHeader);
        this.cbe = new CheckboxCellEditor(new JCheckBox());
        this.cbe.checkbox.addMouseListener(this);
        this.cbr = new CheckboxRenderer();
        cModel.getColumn(0).setCellEditor(this.cbe);
        cModel.getColumn(0).setCellRenderer(this.cbr);
        cModel.getColumn(1).setCellRenderer(new LeftDotRenderer());
        cModel.getColumn(2).setCellRenderer(new TextLeftRenderer());
        cModel.getColumn(3).setCellRenderer(new StatusRenderer());
        TableColumn statusColumn = this.eTable.getColumnModel().getColumn(3);
        statusColumn.setPreferredWidth(this.statusWidth);
        statusColumn.setMaxWidth(this.statusWidth);
        statusColumn.setMinWidth(this.statusWidth);
        TableColumn dateColumn = this.eTable.getColumnModel().getColumn(2);
        dateColumn.setPreferredWidth(this.errorWidth);
        dateColumn.setMaxWidth(this.errorWidth);
        dateColumn.setMinWidth(this.errorWidth);
        TableColumn uploadColumn = this.eTable.getColumnModel().getColumn(0);
        uploadColumn.setPreferredWidth(this.uploadWidth);
        uploadColumn.setMaxWidth(this.uploadWidth);
        uploadColumn.setMinWidth(this.uploadWidth);
        this.eTable.setRowSelectionAllowed(false);
        JScrollPane scrollPane = new JScrollPane(this.eTable);
        this.mainPanel.add((Component)scrollPane, "1,2,4,1");
        double[][] progressTable = new double[][]{{200.0}, {12.0, 5.0, 12.0}};
        this.progressPanel = GuiCommonElements.addPlanePanel(this.mainPanel, progressTable, this.debug);
        this.runThread = new Thread(){

            public void run() {
                try {
                    ErrorTable.this.bytesProgressBar = new JProgressBar();
                    ErrorTable.this.progressPanel.add((Component)ErrorTable.this.bytesProgressBar, "0,0");
                    ErrorTable.this.filesProgressBar = new JProgressBar(0, 20);
                    ErrorTable.this.progressPanel.add((Component)ErrorTable.this.filesProgressBar, "0,2");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        this.runThread.start();
        this.mainPanel.add((Component)this.progressPanel, "1,4");
        this.progressPanel.setVisible(false);
        this.cancelBtn = GuiCommonElements.addButton(this.mainPanel, "Cancel", 99, "Cancel sending", "2,4,L,C", this.debug);
        this.cancelBtn.addActionListener(this);
        this.cancelBtn.setVisible(false);
        this.clearDoneBtn = GuiCommonElements.addButton(this.mainPanel, "Clear Done", 100, "Clear done", "3,4,R,C", this.debug);
        this.clearDoneBtn.addActionListener(this);
        this.clearDoneBtn.setOpaque(false);
        this.clearDoneBtn.setEnabled(false);
        this.sendBtn = GuiCommonElements.addButton(this.mainPanel, "Send Feedback", 115, "Send your errors to the OMERO team", "4,4,R,C", this.debug);
        this.sendBtn.setOpaque(false);
        this.sendBtn.addActionListener(this);
        this.sendBtn.setEnabled(false);
        this.add(this.mainPanel);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.sendBtn) {
            this.notifyObservers((ImportEvent)new ImportEvent.ERRORS_SEND());
        }
        if (event.getSource() == this.cancelBtn) {
            this.enableCancelBtn(false);
            this.notifyObservers((ImportEvent)new ImportEvent.ERRORS_UPLOAD_CANCELLED());
        }
        if (event.getSource() == this.clearDoneBtn) {
            int numRows = this.table.getRowCount();
            for (int i = numRows - 1; i >= 0; --i) {
                if (this.table.getValueAt(i, 3) != Integer.valueOf(20)) continue;
                this.removeFileFromQueue(i);
                this.notifyObservers((ImportEvent)new ImportEvent.ERRORS_CLEARED(i));
            }
            this.clearDoneBtn.setEnabled(false);
        }
    }

    private void removeFileFromQueue(int row) {
        this.table.removeRow(row);
        if (this.table.getRowCount() == 0) {
            this.sendBtn.setEnabled(false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this.cbe.checkbox) {
            this.cbe.stopCellEditing();
        }
    }

    public void update(IObservable importLibrary, ImportEvent event) {
    }

    public boolean addObserver(IObserver object) {
        return this.observers.add(object);
    }

    public boolean deleteObserver(IObserver object) {
        return this.observers.remove(object);
    }

    public void notifyObservers(ImportEvent event) {
        for (IObserver observer : this.observers) {
            observer.update((IObservable)this, event);
        }
    }

    public ArrayList<ErrorContainer> getErrors() {
        return this.errors;
    }

    public void setErrors(ArrayList<ErrorContainer> errors) {
        this.errors = errors;
    }

    public void fireTableDataChanged() {
        this.table.fireTableDataChanged();
    }

    public void addRow(Vector<Object> rowData) {
        this.table.addRow(rowData);
        this.sendBtn.setEnabled(true);
    }

    public void setProgressSending(int row) {
        this.table.setValueAt(1, row, 3);
        this.setFailedFiles(false);
        this.progressPanel.setVisible(true);
        this.cancelBtn.setVisible(true);
        this.invalidate();
    }

    public void setProgressDone(int row) {
        this.table.setValueAt(20, row, 3);
        this.setFailedFiles(false);
        this.clearDoneBtn.setEnabled(true);
    }

    public void resetProgress() {
        this.filesProgressBar.setValue(0);
        this.bytesProgressBar.setValue(0);
        this.progressPanel.setVisible(false);
    }

    public void setFilesProgress(int value) {
        this.filesProgressBar.setValue(value);
    }

    public void setFilesInSet(int value) {
        this.filesProgressBar.setMaximum(value);
    }

    public void setBytesProgress(int value) {
        this.bytesProgressBar.setValue(value);
    }

    public void setBytesFileSize(int value) {
        this.bytesProgressBar.setMaximum(value);
    }

    public void enableSendBtn(boolean enabled) {
        this.sendBtn.setEnabled(enabled);
    }

    public void enableCancelBtn(boolean enabled) {
        if (enabled) {
            this.cancelBtn.setText("Cancel");
            this.cancelBtn.setEnabled(enabled);
        } else {
            this.cancelBtn.setText("Cancelling...");
            this.cancelBtn.setEnabled(enabled);
        }
    }

    public void setCancelBtnCancelled() {
        this.cancelBtn.setText("Cancelled");
    }

    public void setCancelBtnVisible(boolean visible) {
        this.cancelBtn.setVisible(visible);
    }

    public void setFailedFiles(boolean failedFiles) {
        this.failedFiles = failedFiles;
    }

    public boolean getFailedFiles() {
        return this.failedFiles;
    }

    class CheckboxCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        JCheckBox checkbox;

        public CheckboxCellEditor(JCheckBox checkbox) {
            this.checkbox = checkbox;
        }

        public Object getCellEditorValue() {
            return this.checkbox.isSelected();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.checkbox.setSelected((Boolean)value);
            this.checkbox.setBackground(ErrorTable.this.eTable.colorForRow(row));
            this.checkbox.setHorizontalAlignment(0);
            this.checkbox.setBorderPaintedFlat(true);
            this.checkbox.setOpaque(true);
            this.checkbox.setLayout(new BorderLayout());
            this.checkbox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            ErrorTable.this.setLayout(new BorderLayout());
            ErrorTable.this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            ErrorTable.this.setFocusable(false);
            if (ErrorTable.this.eTable.getValueAt(row, 3) == Integer.valueOf(20)) {
                this.checkbox.setEnabled(false);
            } else {
                this.checkbox.setEnabled(true);
            }
            return this.checkbox;
        }
    }

    class CheckboxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        CheckboxRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Boolean) {
                this.setSelected((Boolean)value);
            }
            this.setHorizontalAlignment(0);
            this.setBorderPaintedFlat(true);
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.setFocusable(false);
            if (ErrorTable.this.eTable.getValueAt(row, 3) == Integer.valueOf(20)) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            return this;
        }
    }

    class StatusRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        StatusRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setFont(UIManager.getFont("TableCell.font"));
            this.setHorizontalAlignment(0);
            Integer i = (Integer)value;
            String text = "pending";
            if (i < 0) {
                text = "pending";
            } else if (i < 20) {
                text = "sending";
            } else if (i == 20) {
                text = "done";
            }
            super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
            if (ErrorTable.this.eTable.getValueAt(row, 3) == Integer.valueOf(20)) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            return this;
        }
    }

    class TextCellCenter
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        TextCellCenter() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setFont(UIManager.getFont("TableCell.font"));
            this.setHorizontalAlignment(0);
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (ErrorTable.this.eTable.getValueAt(row, 3) == Integer.valueOf(20)) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            return this;
        }
    }

    class TextLeftRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        TextLeftRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setFont(UIManager.getFont("TableCell.font"));
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setToolTipText(value.toString());
            if (ErrorTable.this.eTable.getValueAt(row, 3) == Integer.valueOf(20)) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            return this;
        }
    }

    class LeftDotRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        LeftDotRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int availableWidth = table.getColumnModel().getColumn(column).getWidth();
            availableWidth = (int)((double)availableWidth - table.getIntercellSpacing().getWidth());
            Insets borderInsets = this.getBorder().getBorderInsets(this);
            String cellText = this.getText();
            FontMetrics fm = this.getFontMetrics(this.getFont());
            if (fm.stringWidth(cellText) > (availableWidth -= borderInsets.left + borderInsets.right)) {
                int nChars;
                String dots = "...";
                int textWidth = fm.stringWidth(dots);
                for (nChars = cellText.length() - 1; nChars > 0 && (textWidth += fm.charWidth(cellText.charAt(nChars))) <= availableWidth; --nChars) {
                }
                this.setText(dots + cellText.substring(nChars + 1));
            }
            this.setFont(UIManager.getFont("TableCell.font"));
            this.setFont(UIManager.getFont("TableCell.font"));
            if (ErrorTable.this.eTable.getValueAt(row, 3) == Integer.valueOf(20)) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            return this;
        }
    }

    static class MyTableHeaderRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        MyTableHeaderRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBorder(BorderFactory.createLineBorder(new Color(0xE0E0E0)));
            this.setForeground(UIManager.getColor("TableHeader.foreground"));
            this.setBackground(UIManager.getColor("TableHeader.background"));
            this.setFont(UIManager.getFont("TableHeader.font"));
            this.setFont(this.getFont().deriveFont(1));
            this.setHorizontalAlignment(0);
            this.setText(value.toString());
            this.setOpaque(true);
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return this;
        }

        public void validate() {
        }

        public void revalidate() {
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    static class ErrorTableModel
    extends DefaultTableModel
    implements TableModelListener {
        private static final long serialVersionUID = 1L;
        private String[] columnNames = new String[]{"", "Image Filename (checkmark to send)", "Error Message", "Status", "FilePath", "DatasetID", "ProjectID"};

        ErrorTableModel() {
        }

        public void tableChanged(TableModelEvent arg0) {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        public boolean rowSelectionAllowed() {
            return false;
        }
    }
}

