/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.Vector;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.gui.DebugMessenger;
import ome.formats.importer.gui.ErrorTable;
import ome.formats.importer.util.ErrorContainer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ErrorHandler
extends JPanel
implements IObserver,
IObservable {
    private static Log log = LogFactory.getLog(ErrorHandler.class);
    public final MyErrorHandler delegate;
    private final ScheduledExecutorService ex;
    private final ErrorTable errorTable;

    public ErrorHandler(ScheduledExecutorService ex, ImportConfig config) {
        this.ex = ex;
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.errorTable = new ErrorTable();
        this.delegate = new MyErrorHandler(config, this);
        if (this.errorTable != null) {
            this.add((Component)this.errorTable, "Center");
        }
        this.errorTable.addObserver(this);
    }

    public void update(IObservable importLibrary, ImportEvent event) {
        this.delegate.update(importLibrary, event);
    }

    public boolean addObserver(IObserver object) {
        return this.delegate.addObserver(object);
    }

    public boolean deleteObserver(IObserver object) {
        return this.delegate.deleteObserver(object);
    }

    public void notifyObservers(ImportEvent event) {
        this.delegate.notifyObservers(event);
    }

    class MyErrorHandler
    extends ome.formats.importer.util.ErrorHandler {
        private final JPanel panel;
        private DebugMessenger debugMessenger;

        MyErrorHandler(ImportConfig config, JPanel panel) {
            super(config);
            this.panel = panel;
        }

        public void onUpdate(IObservable importLibrary, ImportEvent event) {
            if (event instanceof ImportEvent.ERRORS_SEND) {
                this.cancelUploads = false;
                ErrorHandler.this.errorTable.enableCancelBtn(true);
                this.debugMessenger = new DebugMessenger(null, "OMERO.importer Error Dialog", this.config, false, this.errors);
                this.debugMessenger.addObserver((IObserver)this);
                this.debugMessenger.setAlwaysOnTop(true);
            }
            if (event instanceof ImportEvent.DEBUG_SEND) {
                ImportEvent.DEBUG_SEND ev = (ImportEvent.DEBUG_SEND)event;
                this.sendFiles = ev.sendFiles;
                Runnable run = new Runnable(){

                    public void run() {
                        try {
                            MyErrorHandler.this.sendErrors();
                        }
                        catch (Throwable error) {
                            error.printStackTrace();
                        }
                    }
                };
                ErrorHandler.this.ex.execute(run);
            } else if (event instanceof ImportEvent.FILE_UPLOAD_STARTED) {
                ImportEvent.FILE_UPLOAD_STARTED ev = (ImportEvent.FILE_UPLOAD_STARTED)event;
                ErrorHandler.this.errorTable.setFilesInSet(ev.fileTotal);
            } else if (event instanceof ImportEvent.FILE_UPLOAD_BYTES) {
                ImportEvent.FILE_UPLOAD_BYTES ev = (ImportEvent.FILE_UPLOAD_BYTES)event;
                ErrorHandler.this.errorTable.setBytesFileSize(Long.valueOf(ev.contentLength).intValue());
                ErrorHandler.this.errorTable.setBytesProgress(Long.valueOf(ev.uploadedBytes).intValue());
                ErrorHandler.this.errorTable.setFilesProgress(ev.fileIndex);
            } else if (event instanceof ImportEvent.FILE_UPLOAD_COMPLETE) {
                ImportEvent.FILE_UPLOAD_COMPLETE ev = (ImportEvent.FILE_UPLOAD_COMPLETE)event;
                ErrorHandler.this.errorTable.setFilesProgress(ev.fileIndex);
            } else if (event instanceof ImportEvent.FILE_UPLOAD_ERROR) {
                ImportEvent.FILE_UPLOAD_ERROR ev = (ImportEvent.FILE_UPLOAD_ERROR)event;
                ErrorHandler.this.errorTable.setFilesProgress(ev.fileIndex);
                this.log.info((Object)("Error while sending QA Feedback file:" + ev.filename));
                this.fileUploadErrors = true;
            } else if (event instanceof ImportEvent.FILE_UPLOAD_CANCELLED || event instanceof ImportEvent.ERRORS_UPLOAD_CANCELLED) {
                ErrorHandler.this.errorTable.resetProgress();
                this.log.debug((Object)"Uploads Cancelled");
                this.cancelUploads = true;
                this.cancelUploads = true;
            } else if (event instanceof ImportEvent.ERRORS_CLEARED) {
                ImportEvent.ERRORS_CLEARED ev = (ImportEvent.ERRORS_CLEARED)event;
                super.clearErrors(ev.index);
            }
        }

        protected void onCancel() {
            super.onCancel();
            ErrorHandler.this.errorTable.enableSendBtn(true);
        }

        protected void sendErrors() {
            ErrorHandler.this.errorTable.enableSendBtn(false);
            super.sendErrors();
        }

        protected boolean isSend(int index) {
            return super.isSend(index) && (Boolean)((ErrorHandler)ErrorHandler.this).errorTable.table.getValueAt(index, 0) != false;
        }

        protected void onSending(int index) {
            super.onSending(index);
            ErrorHandler.this.errorTable.setProgressSending(index);
        }

        protected void onSent(int index) {
            super.onSent(index);
            ErrorHandler.this.errorTable.setProgressDone(index);
        }

        protected void onNotSending(int index, String serverReply) {
            super.onNotSending(index, serverReply);
            JEditorPane reply = new JEditorPane("text/html", serverReply);
            reply.setEditable(false);
            reply.setOpaque(false);
            ErrorHandler.this.errorTable.setProgressDone(index);
        }

        protected void onException(Exception e) {
            super.onException(e);
            String sendErrorMsg = "Sorry, but due to an error we were not able to automatically \n send your debug information. \n\nPleae let us know about this problem by contacting \n\nus at <a href='mailto:comments@openmicroscopy.org.uk'>.";
            try {
                JEditorPane popup = new JEditorPane(sendErrorMsg);
                JOptionPane.showMessageDialog(this.panel, popup);
                ErrorHandler.this.errorTable.enableSendBtn(true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected void finishCancelled() {
            super.finishCancelled();
            ErrorHandler.this.errorTable.setCancelBtnCancelled();
            JOptionPane.showMessageDialog(this.panel, "\nThank you for your support!\n\nYou have cancelled uploading your data\nfiles to us, however some files may have\nbeen sent (as shown on the error list).\n\nIf you wish to continue uploading your\nfiles, simply click the 'Send Feedback'\nbutton again.", "Cancelled Upload!", 1);
            ErrorHandler.this.errorTable.resetProgress();
        }

        protected void finishComplete() {
            super.finishComplete();
            ErrorHandler.this.errorTable.setCancelBtnVisible(false);
            JOptionPane.showMessageDialog(this.panel, "\nThank you for your support, your errors \nhave successfully been collected.\n\nIf you have provided us with an email\naddress, you should receive a message\nshortly detailing how you can track the\nstatus of your errors.", "Success!", 1);
            ErrorHandler.this.errorTable.resetProgress();
        }

        protected void finishWithErroredFiles() {
            super.finishWithErroredFiles();
            ErrorHandler.this.errorTable.setCancelBtnCancelled();
            JOptionPane.showMessageDialog(this.panel, "\nThank you for your support, your errors \nhave successfully been collected.\n\nIf you have provided us with an email\naddress, you should receive a message\nshortly detailing how you can track the\nstatus of your errors.\n\n Please note that during the import\nthere were problems sending some of your\nincluded files, however the error itself\nhas been reported.", "Success!", 1);
            ErrorHandler.this.errorTable.resetProgress();
        }

        protected void onAddError(ErrorContainer errorContainer, String message) {
            super.onAddError(errorContainer, message);
            Vector<Object> row = new Vector<Object>();
            row.add(true);
            if (errorContainer.getSelectedFile() == null) {
                row.add("None");
            } else {
                row.add(errorContainer.getSelectedFile().getName());
            }
            row.add(message);
            row.add(-1);
            row.add(null);
            row.add(null);
            row.add(null);
            ErrorHandler.this.errorTable.addRow(row);
            ErrorHandler.this.errorTable.fireTableDataChanged();
            this.notifyObservers((ImportEvent)new ImportEvent.ERRORS_PENDING());
        }
    }
}

