/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.gui.FileSizeChecker;
import ome.formats.importer.gui.GuiCommonElements;
import ome.formats.importer.util.ErrorContainer;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugMessenger
extends JDialog
implements ActionListener,
IObservable,
IObserver {
    private final ImportConfig config;
    private static final boolean debug = false;
    private static final String ICON = "gfx/nuvola_mail_send64.png";
    private ArrayList<IObserver> observers = new ArrayList();
    private JFrame owner;
    private JPanel mainPanel;
    private JPanel commentPanel;
    private static JButton quitBtn;
    private static JButton cancelBtn;
    private static JButton sendBtn;
    private static JButton sendWithFilesBtn;
    private static JButton ignoreBtn;
    private static JButton copyBtn;
    private JTextPane instructions;
    private JTextField emailTextField;
    private String emailText = "";
    private JTextArea commentTextArea;
    private String commentText = "";
    private JTextPane debugTextPane;
    private ArrayList<ErrorContainer> errorsArrayList;
    private JCheckBox uploadCheckmark;
    private JCheckBox logUploadCheckmark;
    private long total_files;
    private long total_file_length;
    private FileSizeChecker checker;
    private String file_info;

    DebugMessenger(JFrame owner, String title, ImportConfig config, Boolean modal, ArrayList<ErrorContainer> errorsArrayList) {
        super(owner);
        this.config = config;
        this.owner = owner;
        this.errorsArrayList = errorsArrayList;
        this.setDefaultCloseOperation(2);
        this.setTitle(title);
        this.setModal(modal);
        this.setResizable(true);
        this.setSize(new Dimension(680, 400));
        this.setLocationRelativeTo(owner);
        this.file_info = "(Calculating file info)";
        double[][] mainTable = new double[][]{{10.0, 150.0, -1.0, 100.0, 5.0, 150.0, 5.0, 150.0, 10.0}, {-1.0, 20.0, 40.0}};
        this.mainPanel = GuiCommonElements.addMainPanel(this, mainTable, 10, 10, 10, 10, false);
        cancelBtn = GuiCommonElements.addButton(this.mainPanel, "Cancel", 67, "Cancel your message", "5, 2, f, c", false);
        cancelBtn.addActionListener(this);
        sendBtn = GuiCommonElements.addButton(this.mainPanel, "Send Comment", 83, "Send your comment to the development team", "7, 2, f, c", false);
        sendBtn.addActionListener(this);
        this.getRootPane().setDefaultButton(sendBtn);
        GuiCommonElements.enterPressesWhenFocused(sendBtn);
        this.uploadCheckmark = GuiCommonElements.addCheckBox(this.mainPanel, "Send the image files for these errors. " + this.file_info, "1,1,7,1", false);
        this.uploadCheckmark.setSelected(true);
        this.logUploadCheckmark = GuiCommonElements.addCheckBox(this.mainPanel, "Send importer log file.", "1,2,7,2", false);
        config.sendLogFile.load();
        this.uploadCheckmark.setSelected((Boolean)config.sendLogFile.get());
        ImageIcon icon = GuiCommonElements.getImageIcon(ICON);
        int iconSpace = 0;
        if (icon != null) {
            iconSpace = icon.getIconWidth() + 10;
        }
        double[][] commentTable = new double[][]{{iconSpace, 160 - iconSpace, -1.0}, {100.0, 30.0, -1.0, 110.0}};
        this.commentPanel = GuiCommonElements.addMainPanel(this, commentTable, 10, 10, 10, 10, false);
        String message = "To help us improve our software, please fill out the following form. \n\nPlease note that providing your email address is optional, however doing so will make it easier for us to contact you for addition information about your errors, and for you to track their status.";
        JLabel iconLabel = new JLabel(icon);
        this.commentPanel.add((Component)iconLabel, "0,0, l, c");
        this.instructions = GuiCommonElements.addTextPane(this.commentPanel, message, "1,0,2,0", false);
        this.emailTextField = GuiCommonElements.addTextField(this.commentPanel, "Email: ", this.emailText, 69, "Input your email address here.", "(Optional)", -2.0, "0, 1, 2, 1", false);
        this.emailTextField.setText((String)config.email.get());
        this.commentTextArea = GuiCommonElements.addScrollingTextArea(this.commentPanel, "Please provide any additional information of importance.", "", 87, "0, 2, 2, 3", false);
        this.mainPanel.add((Component)this.commentPanel, "0, 0, 8, 0");
        this.add((Component)this.mainPanel, "Center");
        this.setVisible(true);
        this.checker = new FileSizeChecker(errorsArrayList);
        this.checker.addObserver(this);
        this.checker.run();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                DebugMessenger.this.checker.doStop();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (quitBtn != null && source == quitBtn && GuiCommonElements.quitConfirmed(this, "Abandon your import and quit the application?")) {
            System.exit(0);
        }
        if (cancelBtn != null && source == cancelBtn) {
            this.dispose();
        }
        if (sendBtn != null && source == sendBtn) {
            this.emailText = this.emailTextField.getText();
            this.commentText = this.commentTextArea.getText();
            if (GuiCommonElements.validEmail(this.emailText) || this.emailText.trim().length() == 0) {
                sendBtn.setEnabled(false);
                this.config.email.set((Object)this.emailText);
                this.config.sendFiles.set((Object)this.uploadCheckmark.isSelected());
                this.config.sendLogFile.set((Object)this.logUploadCheckmark.isSelected());
                this.sendRequest(this.emailText, this.commentText, "");
                this.dispose();
            } else {
                JOptionPane.showMessageDialog(this, "Your email address must be valid\n(or blank) to send feedback.");
            }
        }
        if (ignoreBtn != null && source == ignoreBtn) {
            this.dispose();
        }
        if (copyBtn != null && source == copyBtn && this.debugTextPane != null) {
            this.debugTextPane.selectAll();
            this.debugTextPane.copy();
        }
    }

    private void sendRequest(String emailText, String commentText, String extraText) {
        for (ErrorContainer errorContainer : this.errorsArrayList) {
            errorContainer.setEmail(emailText);
            errorContainer.setComment(commentText);
            errorContainer.setExtra(extraText);
        }
        this.notifyObservers((ImportEvent)new ImportEvent.DEBUG_SEND(this.uploadCheckmark.isSelected(), this.logUploadCheckmark.isSelected()));
    }

    public boolean addObserver(IObserver object) {
        return this.observers.add(object);
    }

    public boolean deleteObserver(IObserver object) {
        return this.observers.remove(object);
    }

    public void notifyObservers(ImportEvent event) {
        for (IObserver observer : this.observers) {
            observer.update((IObservable)this, event);
        }
    }

    public void update(IObservable importLibrary, ImportEvent event) {
        if (event instanceof ImportEvent.FILE_SIZE_STEP) {
            ImportEvent.FILE_SIZE_STEP ev = (ImportEvent.FILE_SIZE_STEP)event;
            this.total_files = ev.total_files;
            this.total_file_length = ev.total_files_length;
            this.file_info = "Total files: " + this.total_files + " (" + FileUtils.byteCountToDisplaySize((long)this.total_file_length) + ")";
            this.file_info = ev.total_files > 100L || ev.total_files_length >= 0x6400000L ? "<html>Send the image files for these errors. <font color='AA0000'>" + this.file_info + "</font></html>" : "Send the image files for these errors. " + this.file_info;
            this.uploadCheckmark.setText(this.file_info);
            this.uploadCheckmark.repaint();
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            HttpClient client = new HttpClient();
            PostMethod method = new PostMethod("blarg");
            client.executeMethod((HttpMethod)method);
        }
        catch (Exception e) {
            new DebugMessenger(null, "Error Dialog Test", new ImportConfig(), true, null);
        }
    }
}

