/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.gui.GuiCommonElements;
import ome.formats.importer.util.HtmlMessenger;
import ome.formats.importer.util.HtmlMessengerException;
import org.apache.commons.httpclient.methods.multipart.StringPart;

public class CommentMessenger
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -894653530593047377L;
    private static final String ICON = "gfx/nuvola_mail_send64.png";
    private ImportConfig config;
    private JPanel mainPanel;
    private JPanel commentPanel;
    private JPanel debugPanel;
    private JTextPane instructions;
    private JButton sendBtn;
    private JButton cancelBtn;
    private JButton copyBtn;
    private JTextField emailTextField;
    private String emailText = "";
    private JTextArea commentTextArea;
    private String commentText = "";
    private String message;

    CommentMessenger(JFrame owner, String title, ImportConfig config, Boolean modal, boolean debug) {
        super(owner);
        this.config = config;
        this.setDefaultCloseOperation(2);
        this.setTitle(title);
        this.setModal(modal);
        this.setResizable(true);
        this.setSize(new Dimension(680, 400));
        this.setLocationRelativeTo(owner);
        double[][] mainTable = new double[][]{{10.0, 150.0, -1.0, 100.0, 5.0, 100.0, 10.0}, {-1.0, 40.0}};
        this.mainPanel = GuiCommonElements.addMainPanel(this, mainTable, 10, 10, 10, 10, debug);
        this.cancelBtn = GuiCommonElements.addButton(this.mainPanel, "Cancel", 67, "Cancel your message", "3, 1, f, c", debug);
        this.cancelBtn.addActionListener(this);
        this.sendBtn = GuiCommonElements.addButton(this.mainPanel, "Send", 83, "Send your comment to the development team", "5, 1, f, c", debug);
        this.sendBtn.addActionListener(this);
        this.getRootPane().setDefaultButton(this.sendBtn);
        GuiCommonElements.enterPressesWhenFocused(this.sendBtn);
        ImageIcon icon = GuiCommonElements.getImageIcon(ICON);
        int iconSpace = 0;
        if (icon != null) {
            iconSpace = icon.getIconWidth() + 20;
        }
        double[][] commentTable = new double[][]{{iconSpace, 160 - iconSpace, -1.0}, {90.0, 30.0, -1.0}};
        this.commentPanel = GuiCommonElements.addMainPanel(this, commentTable, 10, 10, 10, 10, debug);
        this.message = "Thank you for taking the time to send us your comments. \n\nYour feedback will be used to further the developmment of the importer and improve our software. Any personal details you provide are purely optional, and will only be used for development purposes.";
        JLabel iconLabel = new JLabel(icon);
        this.commentPanel.add((Component)iconLabel, "0,0, l, c");
        this.instructions = GuiCommonElements.addTextPane(this.commentPanel, this.message, "1,0,2,0", debug);
        this.emailTextField = GuiCommonElements.addTextField(this.commentPanel, "Email: ", this.emailText, 69, "Input tyour email address here.", "(Optional)", -2.0, "0, 1, 2, 1", debug);
        this.emailTextField.setText((String)config.email.get());
        this.commentTextArea = GuiCommonElements.addScrollingTextArea(this.commentPanel, "Comment:", "", 87, "0, 2, 2, 2", debug);
        this.mainPanel.add((Component)this.commentPanel, "0, 0, 6, 0");
        this.add((Component)this.mainPanel, "Center");
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.cancelBtn) {
            this.dispose();
        }
        if (source == this.sendBtn) {
            this.emailText = this.emailTextField.getText();
            this.commentText = this.commentTextArea.getText();
            if (GuiCommonElements.validEmail(this.emailText) || this.emailText.trim().length() == 0) {
                this.sendBtn.setEnabled(false);
                this.config.email.set((Object)this.emailText);
                this.sendRequest(this.emailText, this.commentText, "");
            } else {
                JOptionPane.showMessageDialog(this, "Your email address must be valid\n(or blank) to send a comment.");
            }
        }
    }

    private void sendRequest(String email, String comment, String extra) {
        ArrayList<StringPart> postList = new ArrayList<StringPart>();
        postList.add(new StringPart("java_version", System.getProperty("java.version")));
        postList.add(new StringPart("java_classpath", System.getProperty("java.class.path")));
        postList.add(new StringPart("os_name", System.getProperty("os.name")));
        postList.add(new StringPart("os_arch", System.getProperty("os.arch")));
        postList.add(new StringPart("os_version", System.getProperty("os.version")));
        postList.add(new StringPart("extra", extra));
        postList.add(new StringPart("comment", comment));
        postList.add(new StringPart("email", email));
        postList.add(new StringPart("app_name", "1"));
        postList.add(new StringPart("import_session", "test"));
        try {
            HtmlMessenger messenger = new HtmlMessenger(this.config.getTokenUrl(), postList);
            String serverReply = messenger.executePost();
            System.err.println(serverReply);
            if (serverReply != null) {
                JOptionPane.showMessageDialog(this, "Thank you for your feedback.\n\nIf you included your email address, you\nshould receive a confirmation shortly.");
            }
            this.dispose();
        }
        catch (HtmlMessengerException e) {
            JOptionPane.showMessageDialog(this, "Sorry, but due to an error we were not able to automatically \nsend your comment information. \n\nYou can still send us your comments by emailing us at \ncomments@openmicroscopy.org.uk.");
            this.sendBtn.setEnabled(true);
        }
    }

    public static void main(String[] args) throws Exception {
        new CommentMessenger(null, "Comment Dialog Test", new ImportConfig(), true, false);
    }
}

