/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.gui.GuiCommonElements;
import omero.model.Project;

public class AddProjectDialog
extends JDialog
implements ActionListener {
    private boolean debug = false;
    private ImportConfig config;
    private Window owner;
    private JPanel mainPanel;
    private JPanel internalPanel;
    private JTextPane instructions;
    private String message;
    private JButton OKBtn;
    private JButton cancelBtn;
    private JTextField nameField;
    private JTextArea descriptionArea;
    private String projectName;
    private String projectDescription;
    private Project project;
    private OMEROMetadataStoreClient store;

    AddProjectDialog(ImportConfig config, Window owner, String title, Boolean modal, OMEROMetadataStoreClient store) {
        this.store = store;
        this.owner = owner;
        this.config = config;
        this.setDefaultCloseOperation(2);
        this.setTitle(title);
        this.setModal(modal);
        this.setResizable(true);
        this.setSize(new Dimension(480, 300));
        this.setLocationRelativeTo(owner);
        double[][] mainTable = new double[][]{{-1.0, 100.0, 5.0, 100.0, 10.0}, {-1.0, 40.0}};
        this.mainPanel = GuiCommonElements.addMainPanel(this, mainTable, 10, 10, 10, 10, this.debug);
        this.cancelBtn = GuiCommonElements.addButton(this.mainPanel, "Cancel", 67, "Cancel adding a project", "1, 1, f, c", this.debug);
        this.cancelBtn.addActionListener(this);
        this.OKBtn = GuiCommonElements.addButton(this.mainPanel, "OK", 79, "Accept your new project", "3, 1, f, c", this.debug);
        this.OKBtn.addActionListener(this);
        this.OKBtn.setEnabled(false);
        this.getRootPane().setDefaultButton(this.OKBtn);
        GuiCommonElements.enterPressesWhenFocused(this.OKBtn);
        double[][] internalTable = new double[][]{{160.0, -1.0}, {30.0, 30.0, -1.0}};
        this.internalPanel = GuiCommonElements.addMainPanel(this, internalTable, 10, 10, 10, 10, this.debug);
        this.message = "Please enter your project name and an optional description below.";
        this.instructions = GuiCommonElements.addTextPane(this.internalPanel, this.message, "0,0,1,0", this.debug);
        this.nameField = GuiCommonElements.addTextField(this.internalPanel, "Project Name: ", "", 69, "Input your project name here.", "", -2.0, "0, 1, 1, 1", this.debug);
        this.nameField.getDocument().addDocumentListener(new MyDocumentListener());
        this.descriptionArea = GuiCommonElements.addScrollingTextArea(this.internalPanel, "Description: (optional)", "", 87, "0, 2, 1, 2", this.debug);
        this.mainPanel.add((Component)this.internalPanel, "0, 0, 4, 0");
        this.add((Component)this.mainPanel, "Center");
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.OKBtn) {
            this.projectName = this.nameField.getText();
            this.projectDescription = this.descriptionArea.getText();
            if (this.projectName.length() > 255) {
                JOptionPane.showMessageDialog(this.owner, "The project's name can not be longer than 255 characters.");
            } else if (this.projectName.trim().length() > 0) {
                this.project = this.store.addProject(this.projectName, this.projectDescription);
                this.config.savedProject.set((Object)this.project.getId().getValue());
                this.dispose();
            } else {
                JOptionPane.showMessageDialog(this.owner, "The project's name can not be blank.");
            }
        }
        if (source == this.cancelBtn) {
            this.dispose();
        }
    }

    public static void main(String[] args) throws Exception {
        String laf = UIManager.getSystemLookAndFeelClassName();
        if (laf.equals("apple.laf.AquaLookAndFeel")) {
            System.setProperty("Quaqua.design", "panther");
            try {
                UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
            }
            catch (Exception e) {
                System.err.println(laf + " not supported.");
            }
        } else {
            try {
                UIManager.setLookAndFeel(laf);
            }
            catch (Exception e) {
                System.err.println(laf + " not supported.");
            }
        }
        new AddProjectDialog(null, null, "Add a Project", true, null);
    }

    class MyDocumentListener
    implements DocumentListener {
        MyDocumentListener() {
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            if (AddProjectDialog.this.nameField.getText().trim().length() < 1) {
                AddProjectDialog.this.OKBtn.setEnabled(false);
            } else {
                AddProjectDialog.this.OKBtn.setEnabled(true);
            }
        }

        public void removeUpdate(DocumentEvent e) {
            if (AddProjectDialog.this.nameField.getText().trim().length() < 1) {
                AddProjectDialog.this.OKBtn.setEnabled(false);
            } else {
                AddProjectDialog.this.OKBtn.setEnabled(true);
            }
        }
    }
}

