/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.cli;

import ome.formats.importer.IObservable;
import ome.formats.importer.ImportCandidates;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.util.ErrorContainer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ErrorHandler
extends ome.formats.importer.util.ErrorHandler {
    private static final Log log = LogFactory.getLog(ErrorHandler.class);

    public ErrorHandler(ImportConfig config) {
        super(config);
    }

    public void onUpdate(IObservable importLibrary, ImportEvent event) {
        if (event instanceof ImportEvent.IMPORT_DONE) {
            log.info((Object)("Number of errors: " + this.errors.size()));
        } else if (event instanceof ImportCandidates.SCANNING) {
            log.debug((Object)event.toLog());
        } else if (event instanceof ImportEvent.DEBUG_SEND) {
            for (ErrorContainer error : this.errors) {
                error.setEmail((String)this.config.email.get());
                error.setComment("Sent from CLI");
            }
            if (this.errors.size() > 0) {
                this.sendFiles = ((ImportEvent.DEBUG_SEND)event).sendFiles;
                this.sendLogs = ((ImportEvent.DEBUG_SEND)event).sendLogs;
                log.info((Object)("Sending error report " + (this.sendFiles ? "with files " : " ") + "..."));
                if (this.sendLogs) {
                    log.info((Object)"Sending log file...");
                }
                this.sendErrors();
            }
        }
    }
}

