/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection;

import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.ejb3.BeanContext;
import org.jboss.injection.AbstractPropertyInjector;
import org.jboss.injection.PojoInjector;
import org.jboss.injection.lang.reflect.BeanProperty;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiPropertyInjector
extends AbstractPropertyInjector
implements PojoInjector {
    private static final Logger log = Logger.getLogger(JndiPropertyInjector.class);
    private String jndiName;
    private Context ctx;

    public JndiPropertyInjector(BeanProperty property, String jndiName, Context ctx) {
        super(property);
        this.jndiName = jndiName;
        this.ctx = ctx;
    }

    @Override
    public void inject(BeanContext bctx) {
        this.inject(bctx, bctx.getInstance());
    }

    @Override
    public Class<?> getInjectionClass() {
        return this.property.getType();
    }

    protected Object lookup(String jndiName) {
        Object dependency = null;
        try {
            dependency = this.ctx.lookup(jndiName);
        }
        catch (NamingException e) {
            Throwable cause = e;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            throw new RuntimeException("Unable to inject jndi dependency: " + jndiName + " into property " + this.property + ": " + cause.getMessage(), e);
        }
        return dependency;
    }

    @Override
    public void inject(BeanContext bctx, Object instance) {
        this.inject(instance);
    }

    @Override
    public void inject(Object instance) {
        Object value = this.lookup(this.jndiName);
        this.property.set(instance, value);
    }
}

