/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateless;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.ejb.EJBLocalObject;
import javax.ejb.LocalHome;
import org.jboss.annotation.ejb.LocalBinding;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.JBossProxy;
import org.jboss.ejb3.NonSerializableFactory;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.stateless.BaseStatelessProxyFactory;
import org.jboss.ejb3.stateless.StatelessHandleImpl;
import org.jboss.ejb3.stateless.StatelessLocalProxy;
import org.jboss.logging.Logger;

public class StatelessLocalProxyFactory
extends BaseStatelessProxyFactory {
    private static final Logger log = Logger.getLogger(StatelessLocalProxyFactory.class);

    protected Class[] getInterfaces() {
        EJBContainer statelessContainer = (EJBContainer)this.container;
        LocalHome localHome = (LocalHome)statelessContainer.resolveAnnotation(LocalHome.class);
        boolean bindTogether = false;
        if (localHome != null && this.bindHomeAndBusinessTogether(statelessContainer)) {
            bindTogether = true;
        }
        Class[] localInterfaces = ProxyFactoryHelper.getLocalInterfaces(this.container);
        Class[] interfaces = bindTogether ? new Class[localInterfaces.length + 3] : new Class[localInterfaces.length + 2];
        System.arraycopy(localInterfaces, 0, interfaces, 0, localInterfaces.length);
        interfaces[localInterfaces.length] = JBossProxy.class;
        interfaces[localInterfaces.length + 1] = EJBLocalObject.class;
        if (bindTogether) {
            interfaces[localInterfaces.length + 2] = localHome.value();
        }
        return interfaces;
    }

    protected boolean bindHomeAndBusinessTogether(EJBContainer container) {
        return ProxyFactoryHelper.getLocalHomeJndiName(container).equals(ProxyFactoryHelper.getLocalJndiName(container));
    }

    protected void initializeJndiName() {
        this.jndiName = ProxyFactoryHelper.getLocalJndiName(this.container);
    }

    public void start() throws Exception {
        super.start();
        EJBContainer statelessContainer = (EJBContainer)this.container;
        LocalHome localHome = (LocalHome)statelessContainer.resolveAnnotation(LocalHome.class);
        if (localHome != null && !this.bindHomeAndBusinessTogether(statelessContainer)) {
            Class[] interfaces = new Class[]{localHome.value()};
            Object homeProxy = Proxy.newProxyInstance(this.container.getBeanClass().getClassLoader(), interfaces, (InvocationHandler)new StatelessLocalProxy(this.container));
            NonSerializableFactory.rebind(this.container.getInitialContext(), ProxyFactoryHelper.getLocalHomeJndiName(this.container), homeProxy);
        }
    }

    public void stop() throws Exception {
        super.stop();
        EJBContainer statelessContainer = (EJBContainer)this.container;
        LocalHome localHome = (LocalHome)statelessContainer.resolveAnnotation(LocalHome.class);
        if (localHome != null && !this.bindHomeAndBusinessTogether(statelessContainer)) {
            NonSerializableFactory.unbind(this.container.getInitialContext(), ProxyFactoryHelper.getLocalHomeJndiName(this.container));
        }
    }

    public Object createProxy() {
        return this.constructProxy(new StatelessLocalProxy(this.container));
    }

    protected StatelessHandleImpl getHandle() {
        StatelessHandleImpl handle = new StatelessHandleImpl();
        LocalBinding localBinding = (LocalBinding)this.advisor.resolveAnnotation(LocalBinding.class);
        if (localBinding != null) {
            handle.jndiName = localBinding.jndiBinding();
        }
        return handle;
    }
}

