/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.vertical;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VerticalCT;
import ucar.unidata.geoloc.vertical.VerticalTransformImpl;

public class AtmosSigma
extends VerticalTransformImpl {
    public static final String PTOP = "PressureTop_variableName";
    public static final String PS = "SurfacePressure_variableName";
    public static final String SIGMA = "Sigma_variableName";
    private Variable psVar;
    private double[] sigma;
    private double ptop;

    public AtmosSigma(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        super(timeDim);
        String psName = vCT.findParameterIgnoreCase(PS).getStringValue();
        this.psVar = ds.findStandardVariable(psName);
        String ptopName = vCT.findParameterIgnoreCase(PTOP).getStringValue();
        Variable ptopVar = ds.findStandardVariable(ptopName);
        try {
            this.ptop = ptopVar.readScalarDouble();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("AtmosSigma failed to read " + ptopVar + " err= " + e.getMessage());
        }
        String sigmaName = vCT.findParameterIgnoreCase(SIGMA).getStringValue();
        Variable sigmaVar = ds.findStandardVariable(sigmaName);
        try {
            Array data = sigmaVar.read();
            this.sigma = (double[])data.get1DJavaArray(Double.TYPE);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("AtmosSigma failed to read " + sigmaName + " err= " + e.getMessage());
        }
        this.units = ds.findAttValueIgnoreCase(this.psVar, "units", "none");
    }

    public ArrayDouble.D3 getCoordinateArray(int timeIndex) throws IOException, InvalidRangeException {
        Array ps = this.readArray(this.psVar, timeIndex);
        Index psIndex = ps.getIndex();
        int nz = this.sigma.length;
        int[] shape2D = ps.getShape();
        int ny = shape2D[0];
        int nx = shape2D[1];
        ArrayDouble.D3 result = new ArrayDouble.D3(nz, ny, nx);
        for (int y = 0; y < ny; ++y) {
            for (int x = 0; x < nx; ++x) {
                double psVal = ps.getDouble(psIndex.set(y, x));
                for (int z = 0; z < nz; ++z) {
                    result.set(z, y, x, this.ptop + this.sigma[z] * (psVal - this.ptop));
                }
            }
        }
        return result;
    }
}

