/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.util.Format;

public class LatLonProjection
extends ProjectionImpl {
    private double centerLon = 0.0;
    private ProjectionRect projR1 = new ProjectionRect();
    private ProjectionRect projR2 = new ProjectionRect();
    private ProjectionRect[] rects = new ProjectionRect[2];

    public ProjectionImpl constructCopy() {
        return new LatLonProjection(this.getName(), this.getDefaultMapArea());
    }

    public LatLonProjection() {
        this("");
    }

    public LatLonProjection(String name) {
        this(name, new ProjectionRect(-180.0, -90.0, 180.0, 90.0));
    }

    public LatLonProjection(String name, ProjectionRect defaultMapArea) {
        this.addParameter("Projection_Name", "LatLon");
        this.name = name;
        this.isLatLon = true;
        this.defaultMapArea = defaultMapArea;
    }

    public String getClassName() {
        return "LatLon";
    }

    public String getProjectionTypeLabel() {
        return "Lat/Lon";
    }

    public String paramsToString() {
        return "Center lon:" + Format.d(this.centerLon, 3);
    }

    public boolean equals(Object p) {
        if (!(p instanceof LatLonProjection)) {
            return false;
        }
        LatLonProjection that = (LatLonProjection)p;
        return that.defaultMapArea.equals(this.defaultMapArea) && Double.doubleToLongBits(that.centerLon) == Double.doubleToLongBits(this.centerLon);
    }

    public ProjectionPoint latLonToProj(LatLonPoint latlon, ProjectionPointImpl result) {
        result.setLocation(LatLonPointImpl.lonNormal(latlon.getLongitude(), this.centerLon), latlon.getLatitude());
        return result;
    }

    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        result.setLongitude(world.getX());
        result.setLatitude(world.getY());
        return result;
    }

    public float[][] projToLatLon(float[][] from, float[][] to) {
        float[] fromX = from[0];
        float[] fromY = from[1];
        to[0] = fromY;
        to[1] = fromX;
        return to;
    }

    public float[][] latLonToProj(float[][] from, float[][] to, int latIndex, int lonIndex) {
        int cnt = from[0].length;
        float[] toX = to[0];
        float[] toY = to[1];
        float[] fromLat = from[latIndex];
        float[] fromLon = from[lonIndex];
        for (int i = 0; i < cnt; ++i) {
            float lon;
            float lat = fromLat[i];
            toX[i] = lon = (float)(this.centerLon + Math.IEEEremainder((double)fromLon[i] - this.centerLon, 360.0));
            toY[i] = lat;
        }
        return to;
    }

    public double[][] projToLatLon(double[][] from, double[][] to) {
        double[] fromX = from[0];
        double[] fromY = from[1];
        to[0] = fromY;
        to[1] = fromX;
        return to;
    }

    public double[][] latLonToProj(double[][] from, double[][] to, int latIndex, int lonIndex) {
        int cnt = from[0].length;
        double[] toX = to[0];
        double[] toY = to[1];
        double[] fromLat = from[latIndex];
        double[] fromLon = from[lonIndex];
        for (int i = 0; i < cnt; ++i) {
            double lon;
            double lat = fromLat[i];
            toX[i] = lon = this.centerLon + Math.IEEEremainder(fromLon[i] - this.centerLon, 360.0);
            toY[i] = lat;
        }
        return to;
    }

    public Object clone() {
        LatLonProjection pp = (LatLonProjection)super.clone();
        pp.centerLon = this.centerLon;
        return pp;
    }

    public double setCenterLon(double centerLon) {
        this.centerLon = LatLonPointImpl.lonNormal(centerLon);
        return this.centerLon;
    }

    public double getCenterLon() {
        return this.centerLon;
    }

    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        return Math.abs(pt1.getX() - pt2.getX()) > 270.0;
    }

    public void setDefaultMapArea(ProjectionRect bb) {
        super.setDefaultMapArea(bb);
        this.centerLon = bb.getCenterX();
    }

    public ProjectionRect[] latLonToProjRect(LatLonRect latlonR) {
        double lon1;
        double lat0 = latlonR.getLowerLeftPoint().getLatitude();
        double height = Math.abs(latlonR.getUpperRightPoint().getLatitude() - lat0);
        double width = latlonR.getWidth();
        double lon0 = LatLonPointImpl.lonNormal(latlonR.getLowerLeftPoint().getLongitude(), this.centerLon);
        if (lon0 < (lon1 = LatLonPointImpl.lonNormal(latlonR.getUpperRightPoint().getLongitude(), this.centerLon))) {
            this.projR1.setRect(lon0, lat0, width, height);
            this.rects[0] = this.projR1;
            this.rects[1] = null;
        } else {
            double y = this.centerLon + 180.0 - lon0;
            this.projR1.setRect(lon0, lat0, y, height);
            this.projR2.setRect(lon1 - width + y, lat0, width - y, height);
            this.rects[0] = this.projR1;
            this.rects[1] = this.projR2;
        }
        return this.rects;
    }

    public ProjectionRect[] latLonToProjRect(double lat0, double lon0, double lat1, double lon1) {
        double height = Math.abs(lat1 - lat0);
        lat0 = Math.min(lat1, lat0);
        double width = lon1 - lon0;
        if (width < 1.0E-8) {
            width = 360.0;
        }
        lon0 = LatLonPointImpl.lonNormal(lon0, this.centerLon);
        lon1 = LatLonPointImpl.lonNormal(lon1, this.centerLon);
        if (width >= 360.0) {
            this.projR1.setRect(this.centerLon - 180.0, lat0, 360.0, height);
            this.rects[0] = this.projR1;
            this.rects[1] = null;
        } else if (lon0 < lon1) {
            this.projR1.setRect(lon0, lat0, width, height);
            this.rects[0] = this.projR1;
            this.rects[1] = null;
        } else {
            double y = this.centerLon + 180.0 - lon0;
            this.projR1.setRect(lon0, lat0, y, height);
            this.projR2.setRect(lon1 - width + y, lat0, width - y, height);
            this.rects[0] = this.projR1;
            this.rects[1] = this.projR2;
        }
        return this.rects;
    }
}

