/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.units;

import java.util.Date;
import java.util.StringTokenizer;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.units.TimeUnit;
import ucar.units.TimeScaleUnit;

public class DateUnit
extends SimpleUnit {
    private double value;
    private String timeUnitString;
    private String udunitString;
    private TimeUnit timeUnit = null;
    private DateFormatter formatter;

    public static Date getStandardDate(String text) {
        DateUnit du;
        String udunitString;
        double value;
        text = text.trim();
        StringTokenizer stoker = new StringTokenizer(text);
        String firstToke = stoker.nextToken();
        try {
            value = Double.parseDouble(firstToke);
            udunitString = text.substring(firstToke.length());
        }
        catch (NumberFormatException e) {
            value = 0.0;
            udunitString = text;
        }
        try {
            du = new DateUnit(udunitString);
        }
        catch (Exception e) {
            return null;
        }
        return du.makeDate(value);
    }

    public static Date getStandardOrISO(String text) {
        Date result = DateUnit.getStandardDate(text);
        if (result == null) {
            DateFormatter formatter = new DateFormatter();
            result = formatter.getISODate(text);
        }
        return result;
    }

    public DateUnit(String text) throws Exception {
        text = text.trim();
        StringTokenizer stoker = new StringTokenizer(text);
        String firstToke = stoker.nextToken();
        try {
            this.value = Double.parseDouble(firstToke);
            this.udunitString = text.substring(firstToke.length());
            this.timeUnitString = stoker.nextToken();
        }
        catch (NumberFormatException e) {
            this.value = 0.0;
            this.udunitString = text;
            this.timeUnitString = firstToke;
        }
        this.uu = SimpleUnit.makeUnit(this.udunitString);
        this.timeUnit = new TimeUnit(this.timeUnitString);
    }

    public Date getDateOrigin() {
        if (!(this.uu instanceof TimeScaleUnit)) {
            return null;
        }
        TimeScaleUnit tu = (TimeScaleUnit)this.uu;
        return tu.getOrigin();
    }

    public String getTimeUnitString() {
        return this.timeUnitString;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public Date getDate() {
        double secs = this.timeUnit.getValueInSeconds(this.value);
        return new Date(this.getDateOrigin().getTime() + (long)(1000.0 * secs));
    }

    public Date makeDate(double val) {
        double secs = this.timeUnit.getValueInSeconds(val);
        return new Date(this.getDateOrigin().getTime() + (long)(1000.0 * secs));
    }

    public double makeValue(Date date) {
        double secs = date.getTime() / 1000L;
        double origin_secs = this.getDateOrigin().getTime() / 1000L;
        double diff = secs - origin_secs;
        try {
            this.timeUnit.setValueInSeconds(diff);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return this.timeUnit.getValue();
    }

    public String makeStandardDateString(double value) {
        Date date = this.makeDate(value);
        if (date == null) {
            return null;
        }
        if (this.formatter == null) {
            this.formatter = new DateFormatter();
        }
        return this.formatter.toDateTimeStringISO(date);
    }

    public String toString() {
        return this.value + " " + this.udunitString;
    }

    public String getUnitsString() {
        return this.udunitString;
    }
}

