/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.netcdf3;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.iosp.Indexer;
import ucar.nc2.iosp.netcdf3.N3iosp;
import ucar.unidata.io.RandomAccessFile;

public class N3raf
extends N3iosp {
    protected void _open(RandomAccessFile raf) throws IOException {
    }

    protected void _create(RandomAccessFile raf) throws IOException {
    }

    protected Object readData(Indexer index, DataType dataType) throws IOException {
        int size = (int)index.getTotalNelems();
        if (dataType == DataType.BYTE || dataType == DataType.CHAR) {
            byte[] pa = new byte[size];
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                this.raf.seek(chunk.getFilePos());
                this.raf.read(pa, (int)chunk.getStartElem(), chunk.getNelems());
            }
            return dataType == DataType.BYTE ? pa : (byte[])N3raf.convertByteToChar(pa);
        }
        if (dataType == DataType.SHORT) {
            short[] pa = new short[size];
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                this.raf.seek(chunk.getFilePos());
                this.raf.readShort(pa, (int)chunk.getStartElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType == DataType.INT) {
            int[] pa = new int[size];
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                this.raf.seek(chunk.getFilePos());
                this.raf.readInt(pa, (int)chunk.getStartElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType == DataType.FLOAT) {
            float[] pa = new float[size];
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                this.raf.seek(chunk.getFilePos());
                this.raf.readFloat(pa, (int)chunk.getStartElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType == DataType.DOUBLE) {
            double[] pa = new double[size];
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                this.raf.seek(chunk.getFilePos());
                this.raf.readDouble(pa, (int)chunk.getStartElem(), chunk.getNelems());
            }
            return pa;
        }
        throw new IllegalStateException();
    }

    protected long readData(Indexer index, DataType dataType, WritableByteChannel out) throws IOException {
        long count;
        block5: {
            block7: {
                block6: {
                    block4: {
                        count = 0L;
                        if (dataType != DataType.BYTE && dataType != DataType.CHAR) break block4;
                        while (index.hasNext()) {
                            Indexer.Chunk chunk = index.next();
                            count += this.raf.readToByteChannel(out, chunk.getFilePos(), chunk.getNelems());
                        }
                        break block5;
                    }
                    if (dataType != DataType.SHORT) break block6;
                    while (index.hasNext()) {
                        Indexer.Chunk chunk = index.next();
                        count += this.raf.readToByteChannel(out, chunk.getFilePos(), 2 * chunk.getNelems());
                    }
                    break block5;
                }
                if (dataType != DataType.INT && dataType != DataType.FLOAT) break block7;
                while (index.hasNext()) {
                    Indexer.Chunk chunk = index.next();
                    count += this.raf.readToByteChannel(out, chunk.getFilePos(), 4 * chunk.getNelems());
                }
                break block5;
            }
            if (dataType != DataType.DOUBLE && dataType != DataType.LONG) break block5;
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                count += this.raf.readToByteChannel(out, chunk.getFilePos(), 8 * chunk.getNelems());
            }
        }
        return count;
    }

    protected void writeData(Array values, Indexer index, DataType dataType) throws IOException {
        if (dataType == DataType.BYTE || dataType == DataType.CHAR) {
            IndexIterator ii = values.getIndexIterator();
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                this.raf.seek(chunk.getFilePos());
                for (int k = 0; k < chunk.getNelems(); ++k) {
                    this.raf.write(ii.getByteNext());
                }
            }
            return;
        }
        if (dataType == DataType.STRING) {
            IndexIterator ii = values.getIndexIterator();
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                this.raf.seek(chunk.getFilePos());
                for (int k = 0; k < chunk.getNelems(); ++k) {
                    String val = (String)ii.getObjectNext();
                    if (val == null) continue;
                    this.raf.write(val.getBytes("UTF-8"));
                }
            }
            return;
        }
        if (dataType == DataType.SHORT) {
            IndexIterator ii = values.getIndexIterator();
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                this.raf.seek(chunk.getFilePos());
                for (int k = 0; k < chunk.getNelems(); ++k) {
                    this.raf.writeShort(ii.getShortNext());
                }
            }
            return;
        }
        if (dataType == DataType.INT) {
            IndexIterator ii = values.getIndexIterator();
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                this.raf.seek(chunk.getFilePos());
                for (int k = 0; k < chunk.getNelems(); ++k) {
                    this.raf.writeInt(ii.getIntNext());
                }
            }
            return;
        }
        if (dataType == DataType.FLOAT) {
            IndexIterator ii = values.getIndexIterator();
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                this.raf.seek(chunk.getFilePos());
                for (int k = 0; k < chunk.getNelems(); ++k) {
                    this.raf.writeFloat(ii.getFloatNext());
                }
            }
            return;
        }
        if (dataType == DataType.DOUBLE) {
            IndexIterator ii = values.getIndexIterator();
            while (index.hasNext()) {
                Indexer.Chunk chunk = index.next();
                this.raf.seek(chunk.getFilePos());
                for (int k = 0; k < chunk.getNelems(); ++k) {
                    this.raf.writeDouble(ii.getDoubleNext());
                }
            }
            return;
        }
        throw new IllegalStateException("dataType= " + dataType);
    }
}

