/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf4;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.NetcdfFile;
import ucar.nc2.iosp.hdf4.TagEnum;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Format;

public class H4header {
    private static Logger log = LoggerFactory.getLogger(H4header.class);
    private static final byte[] head = new byte[]{14, 3, 19, 1};
    private static final String shead = new String(head);
    private static final long maxHeaderPos = 500000L;
    private NetcdfFile ncfile;
    private RandomAccessFile raf;
    private long actualSize;
    private MemTracker memTracker;
    private PrintStream debugOut = System.out;
    private boolean debug = true;
    private boolean debugTracker = true;

    static boolean isValidFile(RandomAccessFile raf) throws IOException {
        long pos = 0L;
        long size = raf.length();
        byte[] b = new byte[4];
        while (pos < size && pos < 500000L) {
            raf.seek(pos);
            raf.read(b);
            String magic = new String(b);
            if (magic.equals(shead)) {
                return true;
            }
            pos = pos == 0L ? 512L : 2L * pos;
        }
        return false;
    }

    void read(RandomAccessFile myRaf, NetcdfFile ncfile) throws IOException {
        this.ncfile = ncfile;
        this.raf = myRaf;
        this.actualSize = this.raf.length();
        this.memTracker = new MemTracker(this.actualSize);
        if (!H4header.isValidFile(myRaf)) {
            throw new IOException("Not an HDF4 file ");
        }
        this.memTracker.add("header", 0L, this.raf.getFilePointer());
        this.raf.order(0);
        if (this.debug) {
            this.debugOut.println("H4header 0pened file to read:'" + this.raf.getLocation() + "', size=" + this.actualSize);
        }
        this.readDDH();
        if (this.debugTracker) {
            this.memTracker.report();
        }
    }

    private void readDDH() throws IOException {
        long start = this.raf.getFilePointer();
        int ndd = this.raf.readShort();
        int link = this.raf.readInt();
        System.out.println(" DDHeader ndd=" + ndd + " link=" + link);
        long pos = this.raf.getFilePointer();
        for (int i = 0; i < ndd; ++i) {
            this.raf.seek(pos);
            Tag tag = this.factory();
            pos += 12L;
            if (!this.debug || tag.code <= 1) continue;
            this.debugOut.println(tag);
        }
        this.memTracker.add("DD block", start, this.raf.getFilePointer());
    }

    Tag factory() throws IOException {
        short code = this.raf.readShort();
        switch (code) {
            case 30: {
                return new TagVersion(code);
            }
            case 1962: {
                return new TagVH(code);
            }
            case 1963: {
                return new TagVS(code);
            }
            case 1965: {
                return new TagVG(code);
            }
        }
        return new Tag(code);
    }

    String readString(int len) throws IOException {
        byte[] b = new byte[len];
        this.raf.read(b);
        int count = len - 1;
        while (b[count] == 0) {
            --count;
        }
        return new String(b, 0, count + 1);
    }

    public static void main(String[] args) throws IOException {
        String filename = "17766010.hdf";
        String filename2 = "balloon_sonde.o3_knmi000_de.bilt_s2_20060905t112100z_002.hdf";
        String filename3 = "TOVS_BROWSE_MONTHLY_AM_B861001.E861031_NF.HDF";
        RandomAccessFile raf = new RandomAccessFile("C:/data/hdf4/" + filename3, "r");
        H4header header = new H4header();
        header.read(raf, null);
    }

    private class MemTracker {
        private List<Mem> memList = new ArrayList<Mem>();
        private StringBuffer sbuff = new StringBuffer();
        private long fileSize;

        MemTracker(long fileSize) {
            this.fileSize = fileSize;
        }

        void add(String name, long start, long end) {
            this.memList.add(new Mem(name, start, end));
        }

        void addByLen(String name, long start, long size) {
            this.memList.add(new Mem(name, start, start + size));
        }

        void report() {
            H4header.this.debugOut.println("======================================");
            H4header.this.debugOut.println("Memory used file size= " + this.fileSize);
            H4header.this.debugOut.println("  start    end   size   name");
            Collections.sort(this.memList);
            Mem prev = null;
            for (Mem m : this.memList) {
                if (prev != null && m.start > prev.end) {
                    this.doOne('+', prev.end, m.start, m.start - prev.end, "HOLE");
                }
                char c = prev != null && prev.end != m.start ? (char)'*' : ' ';
                this.doOne(c, m.start, m.end, m.end - m.start, m.name);
                prev = m;
            }
            H4header.this.debugOut.println();
        }

        private void doOne(char c, long start, long end, long size, String name) {
            this.sbuff.setLength(0);
            this.sbuff.append(c);
            this.sbuff.append(Format.l(start, 6));
            this.sbuff.append(" ");
            this.sbuff.append(Format.l(end, 6));
            this.sbuff.append(" ");
            this.sbuff.append(Format.l(size, 6));
            this.sbuff.append(" ");
            this.sbuff.append(name);
            H4header.this.debugOut.println(this.sbuff.toString());
        }

        class Mem
        implements Comparable {
            public String name;
            public long start;
            public long end;

            public Mem(String name, long start, long end) {
                this.name = name;
                this.start = start;
                this.end = end;
            }

            public int compareTo(Object o1) {
                Mem m = (Mem)o1;
                return (int)(this.start - m.start);
            }
        }
    }

    private class TagVS
    extends Tag {
        TagVS(short code) throws IOException {
            super(code);
        }
    }

    private class TagVH
    extends Tag {
        short interlace;
        short ivsize;
        short nfields;
        short extag;
        short exref;
        short version;
        short[] fld_type;
        short[] fld_isize;
        short[] fld_offset;
        short[] fld_order;
        String[] fld_name;
        int nvert;
        String name;
        String className;

        TagVH(short code) throws IOException {
            int i;
            super(code);
            H4header.this.raf.seek(this.offset);
            this.interlace = H4header.this.raf.readShort();
            this.nvert = H4header.this.raf.readInt();
            this.ivsize = H4header.this.raf.readShort();
            this.nfields = H4header.this.raf.readShort();
            this.fld_type = new short[this.nfields];
            for (i = 0; i < this.nfields; ++i) {
                this.fld_type[i] = H4header.this.raf.readShort();
            }
            this.fld_isize = new short[this.nfields];
            for (i = 0; i < this.nfields; ++i) {
                this.fld_isize[i] = H4header.this.raf.readShort();
            }
            this.fld_offset = new short[this.nfields];
            for (i = 0; i < this.nfields; ++i) {
                this.fld_offset[i] = H4header.this.raf.readShort();
            }
            this.fld_order = new short[this.nfields];
            for (i = 0; i < this.nfields; ++i) {
                this.fld_order[i] = H4header.this.raf.readShort();
            }
            this.fld_name = new String[this.nfields];
            for (i = 0; i < this.nfields; ++i) {
                short len = H4header.this.raf.readShort();
                this.fld_name[i] = H4header.this.readString(len);
            }
            short len = H4header.this.raf.readShort();
            this.name = H4header.this.readString(len);
            len = H4header.this.raf.readShort();
            this.className = H4header.this.readString(len);
            this.extag = H4header.this.raf.readShort();
            this.exref = H4header.this.raf.readShort();
            this.version = H4header.this.raf.readShort();
        }

        public String toString() {
            StringBuffer sbuff = new StringBuffer(super.toString());
            sbuff.append(" class= ").append(this.className);
            sbuff.append(" interlace= ").append(this.interlace);
            sbuff.append(" nvert= ").append(this.nvert);
            sbuff.append(" ivsize= ").append(this.ivsize);
            sbuff.append(" extag= ").append(this.extag);
            sbuff.append(" exref= ").append(this.exref);
            sbuff.append(" version= ").append(this.version);
            sbuff.append("\n");
            sbuff.append(" name= ").append(this.name);
            sbuff.append("\n");
            sbuff.append("   name    type  isize  offset  order\n   ");
            for (int i = 0; i < this.nfields; ++i) {
                sbuff.append(this.fld_name[i]).append(" ");
                sbuff.append(this.fld_type[i]).append(" ");
                sbuff.append(this.fld_isize[i]).append(" ");
                sbuff.append(this.fld_offset[i]).append(" ");
                sbuff.append(this.fld_order[i]).append(" ");
                sbuff.append("\n   ");
            }
            return sbuff.toString();
        }
    }

    private class TagVG
    extends Tag {
        short nelems;
        short extag;
        short exref;
        short version;
        short[] elem_tag;
        short[] elem_ref;
        String name;
        String className;

        TagVG(short code) throws IOException {
            int i;
            super(code);
            H4header.this.raf.seek(this.offset);
            this.nelems = H4header.this.raf.readShort();
            this.elem_tag = new short[this.nelems];
            for (i = 0; i < this.nelems; ++i) {
                this.elem_tag[i] = H4header.this.raf.readShort();
            }
            this.elem_ref = new short[this.nelems];
            for (i = 0; i < this.nelems; ++i) {
                this.elem_ref[i] = H4header.this.raf.readShort();
            }
            short len = H4header.this.raf.readShort();
            this.name = H4header.this.readString(len);
            len = H4header.this.raf.readShort();
            this.className = H4header.this.readString(len);
            this.extag = H4header.this.raf.readShort();
            this.exref = H4header.this.raf.readShort();
            this.version = H4header.this.raf.readShort();
        }

        public String toString() {
            StringBuffer sbuff = new StringBuffer(super.toString());
            sbuff.append(" class= ").append(this.className);
            sbuff.append(" extag= ").append(this.extag);
            sbuff.append(" exref= ").append(this.exref);
            sbuff.append(" version= ").append(this.version);
            sbuff.append("\n");
            sbuff.append(" name= ").append(this.name);
            sbuff.append("\n");
            sbuff.append("   tag ref\n   ");
            for (int i = 0; i < this.nelems; ++i) {
                sbuff.append(this.elem_tag[i]).append(" ");
                sbuff.append(this.elem_ref[i]).append(" ");
                sbuff.append("\n   ");
            }
            return sbuff.toString();
        }
    }

    private class TagVersion
    extends Tag {
        int major;
        int minor;
        int release;
        String name;

        TagVersion(short code) throws IOException {
            super(code);
            H4header.this.raf.seek(this.offset);
            this.major = H4header.this.raf.readInt();
            this.minor = H4header.this.raf.readInt();
            this.release = H4header.this.raf.readInt();
            this.name = H4header.this.readString(this.length - 12);
        }

        public String toString() {
            return super.toString() + " version= " + this.major + "." + this.minor + "." + this.release + " (" + this.name + ")";
        }
    }

    private class Tag {
        short code;
        short refno;
        int offset;
        int length;
        TagEnum t;

        Tag(short code) throws IOException {
            this.code = code;
            this.refno = H4header.this.raf.readShort();
            this.offset = H4header.this.raf.readInt();
            this.length = H4header.this.raf.readInt();
            this.t = TagEnum.getTag(code);
            if (code > 1) {
                H4header.this.memTracker.add(this.t.getName(), this.offset, this.offset + this.length);
            }
        }

        public String toString() {
            if (this.t != null) {
                return " tag= " + this.t + " refno=" + this.refno + " offset=" + this.offset + " length=" + this.length;
            }
            return " tag= " + this.code + " refno=" + this.refno + " offset=" + this.offset + " length=" + this.length;
        }
    }
}

