/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Variable;
import ucar.nc2.iosp.IOServiceProvider;

public abstract class AbstractIOServiceProvider
implements IOServiceProvider {
    public Array readNestedData(Variable v2, Section section) throws IOException, InvalidRangeException {
        throw new UnsupportedOperationException("IOSP " + this.getClass().getName() + " does not support nested variables");
    }

    public long readData(Variable v2, Section section, WritableByteChannel channel) throws IOException, InvalidRangeException {
        Array result = this.readData(v2, section);
        IndexIterator iterA = result.getIndexIterator();
        Class classType = result.getElementType();
        DataOutputStream outStream = new DataOutputStream(Channels.newOutputStream(channel));
        if (classType == Double.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeDouble(iterA.getDoubleNext());
            }
        } else if (classType == Float.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeFloat(iterA.getFloatNext());
            }
        } else if (classType == Long.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeLong(iterA.getLongNext());
            }
        } else if (classType == Integer.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeInt(iterA.getIntNext());
            }
        } else if (classType == Short.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeShort(iterA.getShortNext());
            }
        } else if (classType == Character.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeChar(iterA.getCharNext());
            }
        } else if (classType == Byte.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeByte(iterA.getByteNext());
            }
        } else if (classType == Boolean.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeBoolean(iterA.getBooleanNext());
            }
        } else {
            throw new UnsupportedOperationException("Class type = " + classType.getName());
        }
        return 0L;
    }

    public Object sendIospMessage(Object message) {
        return null;
    }

    public boolean syncExtend() throws IOException {
        return false;
    }

    public boolean sync() throws IOException {
        return false;
    }

    public String toStringDebug(Object o) {
        return "";
    }

    public String getDetailInfo() {
        return "";
    }
}

