/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.trajectory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.StructurePseudo;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.DatatypeIterator;
import ucar.nc2.dt.EarthLocation;
import ucar.nc2.dt.PointObsDatatype;
import ucar.nc2.dt.TrajectoryObsDataset;
import ucar.nc2.dt.TrajectoryObsDatatype;
import ucar.nc2.dt.TypedDatasetImpl;
import ucar.nc2.dt.VariableSimpleAdapter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;
import ucar.unidata.geoloc.LatLonRect;

public abstract class SingleTrajectoryObsDataset
extends TypedDatasetImpl
implements TrajectoryObsDataset {
    protected String trajectoryId;
    protected int trajectoryNumPoint;
    protected HashMap trajectoryVarsMap;
    protected Dimension timeDim;
    protected Variable timeVar;
    protected Structure recordVar;
    protected Variable latVar;
    protected Variable lonVar;
    protected Variable elevVar;
    protected String timeVarUnitsString;
    protected double elevVarUnitsConversionFactor;
    protected TrajectoryObsDatatype trajectory;
    protected static SimpleUnit meterUnit = SimpleUnit.factory("meters");

    public SingleTrajectoryObsDataset() {
    }

    public SingleTrajectoryObsDataset(NetcdfDataset ncfile) {
        super(ncfile);
    }

    public void setTrajectoryInfo(Config trajConfig) throws IOException {
        Object result;
        if (this.timeDim != null) {
            throw new IllegalStateException("The setTrajectoryInfo() method can only be called once.");
        }
        this.trajectoryId = trajConfig.getTrajectoryId();
        this.timeDim = trajConfig.getTimeDim();
        this.timeVar = trajConfig.getTimeVar();
        this.latVar = trajConfig.getLatVar();
        this.lonVar = trajConfig.getLonVar();
        this.elevVar = trajConfig.getElevVar();
        this.trajectoryNumPoint = this.timeDim.getLength();
        this.timeVarUnitsString = this.timeVar.findAttribute("units").getStringValue();
        if (DateUnit.getStandardDate(this.timeVarUnitsString) == null) {
            throw new IllegalArgumentException("Units of time variable <" + this.timeVarUnitsString + "> not a date unit.");
        }
        String latVarUnitsString = this.latVar.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible(latVarUnitsString, "degrees_north")) {
            throw new IllegalArgumentException("Units of lat var <" + latVarUnitsString + "> not compatible with \"degrees_north\".");
        }
        String lonVarUnitsString = this.lonVar.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible(lonVarUnitsString, "degrees_east")) {
            throw new IllegalArgumentException("Units of lon var <" + lonVarUnitsString + "> not compatible with \"degrees_east\".");
        }
        String elevVarUnitsString = this.elevVar.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible(elevVarUnitsString, "meters")) {
            throw new IllegalArgumentException("Units of elev var <" + elevVarUnitsString + "> not compatible with \"meters\".");
        }
        try {
            this.elevVarUnitsConversionFactor = SingleTrajectoryObsDataset.getMetersConversionFactor(elevVarUnitsString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Exception on getMetersConversionFactor() for the units of elev var <" + elevVarUnitsString + ">.");
        }
        this.recordVar = this.ncfile.hasUnlimitedDimension() && this.ncfile.getUnlimitedDimension().equals(this.timeDim) ? ((result = this.ncfile.sendIospMessage("AddRecordStructure")) != null && ((Boolean)result).booleanValue() ? (Structure)this.ncfile.getRootGroup().findVariable("record") : new StructurePseudo((NetcdfFile)this.ncfile, null, "record", this.timeDim)) : new StructurePseudo((NetcdfFile)this.ncfile, null, "record", this.timeDim);
        Variable elevVarInRecVar = this.recordVar.findVariable(this.elevVar.getName());
        if (!elevVarUnitsString.equals(elevVarInRecVar.findAttribute("units").getStringValue())) {
            elevVarInRecVar.addAttribute(new Attribute("units", elevVarUnitsString));
        }
        this.trajectoryVarsMap = new HashMap();
        for (Variable curVar : this.ncfile.getRootGroup().getVariables()) {
            if (curVar.getRank() <= 0 || curVar.equals(this.timeVar) || curVar.equals(this.latVar) || curVar.equals(this.lonVar) || curVar.equals(this.elevVar) || this.recordVar != null && curVar.equals(this.recordVar)) continue;
            MyTypedDataVariable typedVar = new MyTypedDataVariable(new VariableDS(null, curVar, true));
            this.dataVariables.add(typedVar);
            this.trajectoryVarsMap.put(typedVar.getName(), typedVar);
        }
        this.trajectory = new SingleTrajectory(this.trajectoryId, this.trajectoryNumPoint, this.timeVar, this.timeVarUnitsString, this.latVar, this.lonVar, this.elevVar, this.dataVariables, this.trajectoryVarsMap);
        this.startDate = this.trajectory.getTime(0);
        this.endDate = this.trajectory.getTime(this.trajectoryNumPoint - 1);
        ((SingleTrajectory)this.trajectory).setStartDate(this.startDate);
        ((SingleTrajectory)this.trajectory).setEndDate(this.endDate);
    }

    protected static double getMetersConversionFactor(String unitsString) throws Exception {
        SimpleUnit unit = SimpleUnit.factoryWithExceptions(unitsString);
        return unit.convertTo(1.0, meterUnit);
    }

    protected void setStartDate() {
    }

    protected void setEndDate() {
    }

    protected void setBoundingBox() {
    }

    public List getTrajectoryIds() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.trajectoryId);
        return l;
    }

    public List getTrajectories() {
        ArrayList<TrajectoryObsDatatype> l = new ArrayList<TrajectoryObsDatatype>();
        l.add(this.trajectory);
        return l;
    }

    public TrajectoryObsDatatype getTrajectory(String trajectoryId) {
        if (!trajectoryId.equals(this.trajectoryId)) {
            return null;
        }
        return this.trajectory;
    }

    public String getDetailInfo() {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("TrajectoryObsDataset\n");
        sbuff.append("  adapter   = " + this.getClass().getName() + "\n");
        sbuff.append("  trajectories:\n");
        Iterator it = this.getTrajectoryIds().iterator();
        while (it.hasNext()) {
            sbuff.append("      " + (String)it.next() + "\n");
        }
        sbuff.append(super.getDetailInfo());
        return sbuff.toString();
    }

    public boolean syncExtend() {
        if (!this.ncfile.hasUnlimitedDimension()) {
            return false;
        }
        try {
            if (!this.ncfile.syncExtend()) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        int newNumPoints = this.timeDim.getLength();
        if (this.trajectoryNumPoint >= newNumPoints) {
            return false;
        }
        this.trajectoryNumPoint = newNumPoints;
        ((SingleTrajectory)this.trajectory).setNumPoints(this.trajectoryNumPoint);
        try {
            this.endDate = this.trajectory.getTime(this.trajectoryNumPoint - 1);
        }
        catch (IOException e) {
            return false;
        }
        ((SingleTrajectory)this.trajectory).setEndDate(this.endDate);
        return true;
    }

    private class MyTypedDataVariable
    extends VariableSimpleAdapter {
        private int rank;
        private int[] shape;

        private MyTypedDataVariable(VariableDS v) {
            super(v);
            this.rank = super.getRank() - 1;
            int[] varShape = super.getShape();
            this.shape = new int[varShape.length - 1];
            int trajDimIndex = v.findDimensionIndex(SingleTrajectoryObsDataset.this.timeDim.getName());
            int j = 0;
            for (int i = 0; i < varShape.length; ++i) {
                if (i == trajDimIndex) continue;
                this.shape[j++] = varShape[i];
            }
        }

        public int getRank() {
            return this.rank;
        }

        public int[] getShape() {
            return this.shape;
        }
    }

    private class SingleTrajectory
    implements TrajectoryObsDatatype {
        private String id;
        private String description = null;
        private int numPoints;
        private Date startDate;
        private Date endDate;
        private String timeVarUnitsString;
        private Variable timeVar;
        private Variable latVar;
        private Variable lonVar;
        private Variable elevVar;
        private List variables;
        private HashMap variablesMap;

        private SingleTrajectory(String id, int numPoints, Variable timeVar, String timeVarUnitsString, Variable latVar, Variable lonVar, Variable elevVar, List variables, HashMap variablesMap) {
            this.id = id;
            this.numPoints = numPoints;
            this.timeVarUnitsString = timeVarUnitsString;
            this.timeVar = timeVar;
            this.variables = variables;
            this.variablesMap = variablesMap;
            this.latVar = latVar;
            this.lonVar = lonVar;
            this.elevVar = elevVar;
        }

        protected void setNumPoints(int numPoints) {
            this.numPoints = numPoints;
        }

        protected void setStartDate(Date startDate) {
            if (this.startDate != null) {
                throw new IllegalStateException("Can only call setStartDate() once.");
            }
            this.startDate = startDate;
        }

        protected void setEndDate(Date endDate) {
            this.endDate = endDate;
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        public int getNumberPoints() {
            return this.numPoints;
        }

        public List getDataVariables() {
            return this.variables;
        }

        public VariableSimpleIF getDataVariable(String name) {
            return (VariableSimpleIF)this.variablesMap.get(name);
        }

        public PointObsDatatype getPointObsData(int point) throws IOException {
            return new MyPointObsDatatype(point);
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public LatLonRect getBoundingBox() {
            return null;
        }

        public Date getTime(int point) throws IOException {
            return DateUnit.getStandardDate(this.getTimeValue(point) + " " + this.timeVarUnitsString);
        }

        public EarthLocation getLocation(int point) throws IOException {
            return new MyEarthLocation(point);
        }

        public String getTimeUnitsIdentifier() {
            return this.timeVarUnitsString;
        }

        public double getTimeValue(int point) throws IOException {
            Array array = null;
            try {
                array = this.getTime(this.getPointRange(point));
            }
            catch (InvalidRangeException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Point <" + point + "> not in valid range <0, " + (this.getNumberPoints() - 1) + ">: " + e.getMessage());
                iae.initCause(e);
                throw iae;
            }
            if (array instanceof ArrayDouble) {
                return array.getDouble(array.getIndex());
            }
            if (array instanceof ArrayFloat) {
                return array.getFloat(array.getIndex());
            }
            if (array instanceof ArrayInt) {
                return array.getInt(array.getIndex());
            }
            throw new IOException("Time variable not float, double, or integer <" + array.getElementType().toString() + ">.");
        }

        public double getLatitude(int point) throws IOException {
            Array array = null;
            try {
                array = this.getLatitude(this.getPointRange(point));
            }
            catch (InvalidRangeException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Point <" + point + "> not in valid range <0, " + (this.getNumberPoints() - 1) + ">: " + e.getMessage());
                iae.initCause(e);
                throw iae;
            }
            if (array instanceof ArrayDouble) {
                return array.getDouble(array.getIndex());
            }
            if (array instanceof ArrayFloat) {
                return array.getFloat(array.getIndex());
            }
            throw new IOException("Latitude variable not float or double <" + array.getElementType().toString() + ">.");
        }

        public double getLongitude(int point) throws IOException {
            Array array = null;
            try {
                array = this.getLongitude(this.getPointRange(point));
            }
            catch (InvalidRangeException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Point <" + point + "> not in valid range <0, " + (this.getNumberPoints() - 1) + ">: " + e.getMessage());
                iae.initCause(e);
                throw iae;
            }
            if (array instanceof ArrayDouble) {
                return array.getDouble(array.getIndex());
            }
            if (array instanceof ArrayFloat) {
                return array.getFloat(array.getIndex());
            }
            throw new IOException("Longitude variable not float or double <" + array.getElementType().toString() + ">.");
        }

        public double getElevation(int point) throws IOException {
            Array array = null;
            try {
                array = this.getElevation(this.getPointRange(point));
            }
            catch (InvalidRangeException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Point <" + point + "> not in valid range <0, " + (this.getNumberPoints() - 1) + ">: " + e.getMessage());
                iae.initCause(e);
                throw iae;
            }
            if (array instanceof ArrayDouble) {
                return array.getDouble(array.getIndex());
            }
            if (array instanceof ArrayFloat) {
                return array.getFloat(array.getIndex());
            }
            throw new IOException("Elevation variable not float or double <" + array.getElementType().toString() + ">.");
        }

        public StructureData getData(int point) throws IOException, InvalidRangeException {
            return SingleTrajectoryObsDataset.this.recordVar.readStructure(point);
        }

        public Array getData(int point, String parameterName) throws IOException {
            try {
                return this.getData(this.getPointRange(point), parameterName);
            }
            catch (InvalidRangeException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Point <" + point + "> not in valid range <0, " + (this.getNumberPoints() - 1) + ">: " + e.getMessage());
                iae.initCause(e);
                throw iae;
            }
        }

        public Range getFullRange() {
            Range range = null;
            try {
                range = new Range(0, this.getNumberPoints() - 1);
            }
            catch (InvalidRangeException e) {
                IllegalStateException ise = new IllegalStateException("Full trajectory range invalid <0, " + (this.getNumberPoints() - 1) + ">: " + e.getMessage());
                ise.initCause(e);
                throw ise;
            }
            return range;
        }

        public Range getPointRange(int point) throws InvalidRangeException {
            if (point >= this.getNumberPoints()) {
                throw new InvalidRangeException("Point <" + point + "> not in acceptible range <0, " + (this.getNumberPoints() - 1) + ">.");
            }
            return new Range(point, point);
        }

        public Range getRange(int start, int end, int stride) throws InvalidRangeException {
            if (end >= this.getNumberPoints()) {
                throw new InvalidRangeException("End point <" + end + "> not in acceptible range <0, " + (this.getNumberPoints() - 1) + ">.");
            }
            return new Range(start, end, stride);
        }

        public Array getTime(Range range) throws IOException, InvalidRangeException {
            ArrayList<Range> section = new ArrayList<Range>(1);
            section.add(range);
            return this.timeVar.read(section);
        }

        public Array getLatitude(Range range) throws IOException, InvalidRangeException {
            ArrayList<Range> section = new ArrayList<Range>(1);
            section.add(range);
            return this.latVar.read(section);
        }

        public Array getLongitude(Range range) throws IOException, InvalidRangeException {
            ArrayList<Range> section = new ArrayList<Range>(1);
            section.add(range);
            return this.lonVar.read(section);
        }

        public Array getElevation(Range range) throws IOException, InvalidRangeException {
            ArrayList<Range> section = new ArrayList<Range>(1);
            section.add(range);
            Array a = this.elevVar.read(section);
            if (SingleTrajectoryObsDataset.this.elevVarUnitsConversionFactor == 1.0) {
                return a;
            }
            IndexIterator it = a.getIndexIterator();
            while (it.hasNext()) {
                if (this.elevVar.getDataType() == DataType.DOUBLE) {
                    double val = it.getDoubleNext();
                    it.setDoubleCurrent(val * SingleTrajectoryObsDataset.this.elevVarUnitsConversionFactor);
                    continue;
                }
                if (this.elevVar.getDataType() == DataType.FLOAT) {
                    float val = it.getFloatNext();
                    it.setFloatCurrent((float)((double)val * SingleTrajectoryObsDataset.this.elevVarUnitsConversionFactor));
                    continue;
                }
                if (this.elevVar.getDataType() == DataType.INT) {
                    int val = it.getIntNext();
                    it.setIntCurrent((int)((double)val * SingleTrajectoryObsDataset.this.elevVarUnitsConversionFactor));
                    continue;
                }
                if (this.elevVar.getDataType() == DataType.LONG) {
                    long val = it.getLongNext();
                    it.setLongCurrent((long)((double)val * SingleTrajectoryObsDataset.this.elevVarUnitsConversionFactor));
                    continue;
                }
                throw new IllegalStateException("Elevation variable type <" + this.elevVar.getDataType().toString() + "> not double, float, int, or long.");
            }
            return a;
        }

        public Array getData(Range range, String parameterName) throws IOException, InvalidRangeException {
            Variable variable = SingleTrajectoryObsDataset.this.ncfile.getRootGroup().findVariable(parameterName);
            int varRank = variable.getRank();
            int[] varShape = variable.getShape();
            ArrayList<Range> section = new ArrayList<Range>(varRank);
            section.add(range);
            for (int i = 1; i < varRank; ++i) {
                section.add(new Range(0, varShape[i] - 1));
            }
            Array array = variable.read(section);
            if (array.getShape()[0] == 1) {
                return array.reduce(0);
            }
            return array;
        }

        public DataIterator getDataIterator(int bufferSize) throws IOException {
            return new PointDatatypeIterator(SingleTrajectoryObsDataset.this.recordVar, bufferSize);
        }

        private class MyEarthLocation
        implements EarthLocation {
            private double latitude;
            private double longitude;
            private double elevation;

            private MyEarthLocation(int point) throws IOException {
                this.latitude = SingleTrajectory.this.getLatitude(point);
                this.longitude = SingleTrajectory.this.getLongitude(point);
                this.elevation = SingleTrajectory.this.getElevation(point);
            }

            private MyEarthLocation(StructureData sdata) {
                this.latitude = sdata.getScalarDouble(SingleTrajectory.this.latVar.getName());
                this.longitude = sdata.getScalarDouble(SingleTrajectory.this.lonVar.getName());
                this.elevation = sdata.getScalarDouble(SingleTrajectory.this.elevVar.getName());
                if (SingleTrajectoryObsDataset.this.elevVarUnitsConversionFactor != 1.0) {
                    this.elevation *= SingleTrajectoryObsDataset.this.elevVarUnitsConversionFactor;
                }
            }

            public double getLatitude() {
                return this.latitude;
            }

            public double getLongitude() {
                return this.longitude;
            }

            public double getAltitude() {
                return this.elevation;
            }
        }

        private class MyPointObsDatatype
        implements PointObsDatatype {
            private int point;
            private StructureData sdata;
            private double time;
            private EarthLocation earthLoc;

            private MyPointObsDatatype(int point) throws IOException {
                this.point = point;
                this.time = SingleTrajectory.this.getTimeValue(point);
                this.earthLoc = SingleTrajectory.this.getLocation(point);
            }

            private MyPointObsDatatype(int point, StructureData sdata) {
                this.point = point;
                this.sdata = sdata;
                this.time = sdata.getScalarDouble(SingleTrajectory.this.timeVar.getName());
                this.earthLoc = new MyEarthLocation(sdata);
            }

            public double getNominalTime() {
                return this.time;
            }

            public double getObservationTime() {
                return this.time;
            }

            public Date getNominalTimeAsDate() {
                String dateStr = this.getNominalTime() + " " + SingleTrajectory.this.timeVarUnitsString;
                return DateUnit.getStandardDate(dateStr);
            }

            public Date getObservationTimeAsDate() {
                String dateStr = this.getObservationTime() + " " + SingleTrajectory.this.timeVarUnitsString;
                return DateUnit.getStandardDate(dateStr);
            }

            public EarthLocation getLocation() {
                return this.earthLoc;
            }

            public StructureData getData() throws IOException {
                if (this.sdata != null) {
                    return this.sdata;
                }
                try {
                    return SingleTrajectory.this.getData(this.point);
                }
                catch (InvalidRangeException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }
        }

        private class PointDatatypeIterator
        extends DatatypeIterator {
            protected Object makeDatatypeWithData(int recnum, StructureData sdata) {
                return new MyPointObsDatatype(recnum, sdata);
            }

            PointDatatypeIterator(Structure struct, int bufferSize) {
                super(struct, bufferSize);
            }
        }
    }

    public static class Config {
        protected String trajectoryId;
        protected Dimension timeDim;
        protected Variable timeVar;
        protected Variable latVar;
        protected Variable lonVar;
        protected Variable elevVar;

        public Config() {
        }

        public Config(String trajectoryId, Dimension timeDim, Variable timeVar, Variable latVar, Variable lonVar, Variable elevVar) {
            this.trajectoryId = trajectoryId;
            this.timeDim = timeDim;
            this.timeVar = timeVar;
            this.latVar = latVar;
            this.lonVar = lonVar;
            this.elevVar = elevVar;
        }

        public void setTrajectoryId(String trajectoryId) {
            this.trajectoryId = trajectoryId;
        }

        public void setTimeDim(Dimension timeDim) {
            this.timeDim = timeDim;
        }

        public void setTimeVar(Variable timeVar) {
            this.timeVar = timeVar;
        }

        public void setLatVar(Variable latVar) {
            this.latVar = latVar;
        }

        public void setLonVar(Variable lonVar) {
            this.lonVar = lonVar;
        }

        public void setElevVar(Variable elevVar) {
            this.elevVar = elevVar;
        }

        public String getTrajectoryId() {
            return this.trajectoryId;
        }

        public Dimension getTimeDim() {
            return this.timeDim;
        }

        public Variable getTimeVar() {
            return this.timeVar;
        }

        public Variable getLatVar() {
            return this.latVar;
        }

        public Variable getLonVar() {
            return this.lonVar;
        }

        public Variable getElevVar() {
            return this.elevVar;
        }
    }
}

