/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.DataType;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.AxisType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.DatatypeIterator;
import ucar.nc2.dt.Station;
import ucar.nc2.dt.StationImpl;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.point.RecordDatasetHelper;
import ucar.nc2.dt.point.StationObsDatasetImpl;
import ucar.nc2.dt.point.UnidataObsDatasetHelper;
import ucar.nc2.util.CancelTask;

public class UnidataStationObsDataset
extends StationObsDatasetImpl
implements TypedDatasetFactoryIF {
    private static Logger log = LoggerFactory.getLogger(UnidataStationObsDataset.class);
    private Variable latVar;
    private Variable lonVar;
    private Variable altVar;
    private Variable timeVar;
    private Variable timeNominalVar;
    private Variable lastVar;
    private Variable prevVar;
    private Variable firstVar;
    private Variable nextVar;
    private Variable numChildrenVar;
    private Variable stationIndexVar;
    private Variable stationIdVar;
    private Variable stationDescVar;
    private Variable numStationsVar;
    private boolean isForwardLinkedList;
    private boolean isBackwardLinkedList;
    private boolean isContiguousList;
    private Structure recordVar;
    private RecordDatasetHelper recordHelper;
    private boolean debugRead = false;

    public static boolean isValidFile(NetcdfFile ds) {
        if (!ds.findAttValueIgnoreCase(null, "cdm_data_type", "").equalsIgnoreCase(DataType.STATION.toString()) && !ds.findAttValueIgnoreCase(null, "cdm_datatype", "").equalsIgnoreCase(DataType.STATION.toString())) {
            return false;
        }
        String conv = ds.findAttValueIgnoreCase(null, "Conventions", null);
        if (conv == null) {
            return false;
        }
        StringTokenizer stoke = new StringTokenizer(conv, ",");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken().trim();
            if (!toke.equalsIgnoreCase("Unidata Observation Dataset v1.0")) continue;
            return true;
        }
        return false;
    }

    public boolean isMine(NetcdfDataset ds) {
        return UnidataStationObsDataset.isValidFile(ds);
    }

    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuffer errlog) throws IOException {
        return new UnidataStationObsDataset(ncd);
    }

    public UnidataStationObsDataset() {
    }

    public UnidataStationObsDataset(NetcdfDataset ds) throws IOException {
        super(ds);
        this.latVar = UnidataObsDatasetHelper.getCoordinate(ds, AxisType.Lat);
        this.lonVar = UnidataObsDatasetHelper.getCoordinate(ds, AxisType.Lon);
        this.altVar = UnidataObsDatasetHelper.getCoordinate(ds, AxisType.Height);
        this.timeVar = UnidataObsDatasetHelper.getCoordinate(ds, AxisType.Time);
        if (this.latVar == null) {
            throw new IllegalStateException("Missing latitude variable");
        }
        if (this.lonVar == null) {
            throw new IllegalStateException("Missing longitude coordinate variable");
        }
        if (this.timeVar == null) {
            throw new IllegalStateException("Missing time coordinate variable");
        }
        this.timeNominalVar = UnidataObsDatasetHelper.findVariable(ds, "time_nominal");
        this.lastVar = UnidataObsDatasetHelper.findVariable(ds, "lastChild");
        this.prevVar = UnidataObsDatasetHelper.findVariable(ds, "prevChild");
        this.firstVar = UnidataObsDatasetHelper.findVariable(ds, "firstChild");
        this.nextVar = UnidataObsDatasetHelper.findVariable(ds, "nextChild");
        this.numChildrenVar = UnidataObsDatasetHelper.findVariable(ds, "numChildren");
        this.stationIndexVar = UnidataObsDatasetHelper.findVariable(ds, "parent_index");
        if (this.stationIndexVar == null) {
            throw new IllegalStateException("Missing parent_index variable");
        }
        this.isForwardLinkedList = this.nextVar != null;
        boolean bl = this.isBackwardLinkedList = !this.isForwardLinkedList && this.prevVar != null;
        if (this.isForwardLinkedList) {
            if (this.firstVar == null) {
                throw new IllegalStateException("Missing firstChild variable");
            }
        } else if (this.isBackwardLinkedList) {
            if (this.lastVar == null) {
                throw new IllegalStateException("Missing lastChild variable");
            }
        } else {
            if (this.firstVar == null) {
                throw new IllegalStateException("Missing firstChild variable");
            }
            if (this.numChildrenVar == null) {
                throw new IllegalStateException("Missing numChildren variable");
            }
            this.isContiguousList = true;
        }
        this.stationIdVar = UnidataObsDatasetHelper.findVariable(ds, "station_id");
        this.stationDescVar = UnidataObsDatasetHelper.findVariable(ds, "station_description");
        this.numStationsVar = UnidataObsDatasetHelper.findVariable(ds, "number_stations");
        if (this.stationIdVar == null) {
            throw new IllegalStateException("Missing station id variable");
        }
        this.recordHelper = new RecordDatasetHelper(ds, this.timeVar.getName(), this.timeNominalVar == null ? null : this.timeNominalVar.getName(), this.dataVariables, this.parseInfo);
        this.recordHelper.setStationInfo(this.stationIndexVar.getName(), this.stationDescVar == null ? null : this.stationDescVar.getName());
        this.removeDataVariable(this.stationIndexVar.getName());
        this.removeDataVariable(this.timeVar.getName());
        if (this.timeNominalVar != null) {
            this.removeDataVariable(this.timeNominalVar.getName());
        }
        if (this.prevVar != null) {
            this.removeDataVariable(this.prevVar.getName());
        }
        if (this.nextVar != null) {
            this.removeDataVariable(this.nextVar.getName());
        }
        this.recordVar = this.recordHelper.recordVar;
        this.timeUnit = this.recordHelper.timeUnit;
        this.readStations();
        this.startDate = UnidataObsDatasetHelper.getStartDate(ds);
        this.endDate = UnidataObsDatasetHelper.getEndDate(ds);
        this.boundingBox = UnidataObsDatasetHelper.getBoundingBox(ds);
        if (null == this.boundingBox) {
            this.setBoundingBox();
        }
        if (null == this.startDate) {
            Variable minTimeVar = ds.findVariable("minimum_time_observation");
            int minTimeValue = minTimeVar.readScalarInt();
            this.startDate = this.timeUnit.makeDate(minTimeValue);
        }
        if (null == this.endDate) {
            Variable maxTimeVar = ds.findVariable("maximum_time_observation");
            int maxTimeValue = maxTimeVar.readScalarInt();
            this.endDate = this.timeUnit.makeDate(maxTimeValue);
        }
        this.title = ds.findAttValueIgnoreCase(null, "title", "");
        this.desc = ds.findAttValueIgnoreCase(null, "description", "");
    }

    private void readStations() throws IOException {
        Array stationIdArray = this.stationIdVar.read();
        ArrayChar stationDescArray = null;
        if (this.stationDescVar != null) {
            stationDescArray = (ArrayChar)this.stationDescVar.read();
        }
        Array latArray = this.latVar.read();
        Array lonArray = this.lonVar.read();
        Array elevArray = this.altVar != null ? this.altVar.read() : null;
        Array firstRecordArray = this.isForwardLinkedList || this.isContiguousList ? this.firstVar.read() : this.lastVar.read();
        Array numChildrenArray = null;
        if (this.numChildrenVar != null) {
            numChildrenArray = this.numChildrenVar.read();
        }
        Dimension stationDim = UnidataObsDatasetHelper.findDimension(this.ncfile, "station");
        int n = 0;
        n = this.numStationsVar != null ? this.numStationsVar.readScalarInt() : stationDim.getLength();
        Index ima = latArray.getIndex();
        this.recordHelper.stnHash = new HashMap(2 * n);
        for (int i = 0; i < n; ++i) {
            String stationDesc;
            String stationName;
            ima.set(i);
            if (stationIdArray instanceof ArrayChar) {
                stationName = ((ArrayChar)stationIdArray).getString(i).trim();
                String string = stationDesc = this.stationDescVar != null ? stationDescArray.getString(i) : null;
                if (stationDesc != null) {
                    stationDesc = stationDesc.trim();
                }
            } else {
                stationName = (String)stationIdArray.getObject(ima);
                stationDesc = this.stationDescVar != null ? (String)stationDescArray.getObject(ima) : null;
            }
            UnidataStationImpl bean = new UnidataStationImpl(stationName, stationDesc, latArray.getFloat(ima), lonArray.getFloat(ima), this.altVar != null ? (double)elevArray.getFloat(ima) : Double.NaN, firstRecordArray.getInt(ima), this.numChildrenVar != null ? numChildrenArray.getInt(ima) : -1);
            this.stations.add(bean);
            this.recordHelper.stnHash.put(new Integer(i), bean);
        }
    }

    protected void setTimeUnits() {
    }

    protected void setStartDate() {
    }

    protected void setEndDate() {
    }

    protected void setBoundingBox() {
        this.boundingBox = this.stationHelper.getBoundingBox();
    }

    public List getData(CancelTask cancel) throws IOException {
        ArrayList<RecordDatasetHelper.RecordStationObs> allData = new ArrayList<RecordDatasetHelper.RecordStationObs>();
        int n = this.getDataCount();
        for (int i = 0; i < n; ++i) {
            RecordDatasetHelper.RecordStationObs obs = this.makeObs(i, false, null);
            if (obs != null) {
                allData.add(obs);
            }
            if (cancel == null || !cancel.isCancel()) continue;
            return null;
        }
        return allData;
    }

    public int getDataCount() {
        Dimension unlimitedDim = this.ncfile.getUnlimitedDimension();
        return unlimitedDim.getLength();
    }

    public List getData(Station s, CancelTask cancel) throws IOException {
        return ((UnidataStationImpl)s).getObservations();
    }

    public void checkLinks(StringBuffer sbuff) throws IOException {
        int countErrs = 0;
        if (this.isBackwardLinkedList) {
            Array lastArray = this.lastVar.read();
            Array prevArray = this.prevVar.read();
            Array stnArray = this.stationIndexVar.read();
            Index prevIndex = prevArray.getIndex();
            Index stnIndex = stnArray.getIndex();
            int stnIdx = 0;
            IndexIterator stnIter = lastArray.getIndexIterator();
            while (stnIter.hasNext()) {
                HashSet<Integer> records = new HashSet<Integer>(500);
                int recNo = stnIter.getIntNext();
                System.out.print("Station " + stnIdx);
                while (recNo >= 0) {
                    System.out.print(" " + recNo);
                    records.add(recNo);
                    int stnFromRecord = stnArray.getInt(stnIndex.set(recNo));
                    if (stnFromRecord != stnIdx) {
                        sbuff.append("recno " + recNo + " has bad station index\n");
                        if (++countErrs > 10) {
                            return;
                        }
                    }
                    if (!records.contains(recNo = prevArray.getInt(prevIndex.set(recNo)))) continue;
                    sbuff.append("stn " + stnIdx + " has circular links\n");
                    if (++countErrs <= 10) break;
                    return;
                }
                System.out.println();
                ++stnIdx;
            }
        }
        sbuff.append("done");
    }

    public static void main(String[] args) throws IOException {
        String filename = "C:/data/199707010000.LAKEOUT_DOMAIN2";
        UnidataStationObsDataset ods = new UnidataStationObsDataset(NetcdfDataset.openDataset(filename));
        StringBuffer sbuff = new StringBuffer(50000);
        ods.checkLinks(sbuff);
        System.out.println("\n\n" + sbuff.toString());
    }

    protected RecordDatasetHelper.RecordStationObs makeObs(int recno, boolean storeData, StructureData sdata) throws IOException {
        try {
            double nomTime;
            int stationIndex;
            if (recno > this.getDataCount()) {
                int n = this.getDataCount();
                this.ncfile.syncExtend();
                log.info("UnidataStationObsDataset.makeObs recno=" + recno + " > " + n + "; after sync= " + this.getDataCount());
            }
            if (null == sdata) {
                sdata = this.recordVar.readStructure(recno);
            }
            if ((stationIndex = sdata.getScalarInt(this.stationIndexVar.getShortName())) < 0 || stationIndex >= this.stations.size()) {
                this.parseInfo.append("cant find station at index = " + stationIndex + "\n");
                return null;
            }
            Station station = (Station)this.stations.get(stationIndex);
            if (station == null) {
                this.parseInfo.append("cant find station at index = " + stationIndex + "\n");
                return null;
            }
            double obsTime = this.getTime(this.timeVar, sdata);
            double d = nomTime = this.timeNominalVar == null ? obsTime : this.getTime(this.timeNominalVar, sdata);
            if (storeData) {
                RecordDatasetHelper recordDatasetHelper = this.recordHelper;
                recordDatasetHelper.getClass();
                return recordDatasetHelper.new RecordDatasetHelper.RecordStationObs(station, obsTime, nomTime, sdata);
            }
            RecordDatasetHelper recordDatasetHelper = this.recordHelper;
            recordDatasetHelper.getClass();
            return recordDatasetHelper.new RecordDatasetHelper.RecordStationObs(station, obsTime, nomTime, recno);
        }
        catch (InvalidRangeException e) {
            log.error("UnidataStationObsDataset.makeObs recno=" + recno, (Throwable)e);
            throw new IOException(e.getMessage());
        }
        catch (ParseException e) {
            log.error("UnidataStationObsDataset.makeObs recno=" + recno, (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    public DataIterator getDataIterator(Station s) {
        return ((UnidataStationImpl)s).iterator();
    }

    public DataIterator getDataIterator(Station s, Date start, Date end) {
        return ((UnidataStationImpl)s).iterator(start, end);
    }

    public DataIterator getDataIterator(int bufferSize) throws IOException {
        return new StationDatatypeIterator(this.recordHelper.recordVar, bufferSize);
    }

    private class StationDatatypeIterator
    extends DatatypeIterator {
        protected Object makeDatatypeWithData(int recnum, StructureData sdata) throws IOException {
            return UnidataStationObsDataset.this.makeObs(recnum, true, sdata);
        }

        StationDatatypeIterator(Structure struct, int bufferSize) {
            super(struct, bufferSize);
        }
    }

    private class UnidataStationImpl
    extends StationImpl {
        private int firstRecord;
        private Variable next;

        private UnidataStationImpl(String name, String desc, double lat, double lon, double elev, int firstRecord, int count) {
            super(name, desc, lat, lon, elev, count);
            this.firstRecord = firstRecord;
            this.next = UnidataStationObsDataset.this.isForwardLinkedList ? UnidataStationObsDataset.this.nextVar : UnidataStationObsDataset.this.prevVar;
        }

        protected ArrayList readObservations() throws IOException {
            ArrayList<RecordDatasetHelper.RecordStationObs> obs = new ArrayList<RecordDatasetHelper.RecordStationObs>();
            int recno = this.firstRecord;
            int end = this.firstRecord + this.count - 1;
            int nextRecord = this.firstRecord;
            while (recno >= 0) {
                try {
                    if (recno > UnidataStationObsDataset.this.getDataCount()) {
                        int n = UnidataStationObsDataset.this.getDataCount();
                        UnidataStationObsDataset.this.ncfile.syncExtend();
                        log.info("UnidataStationObsDataset.makeObs recno=" + recno + " > " + n + "; after sync= " + UnidataStationObsDataset.this.getDataCount());
                    }
                    StructureData sdata = UnidataStationObsDataset.this.recordVar.readStructure(recno);
                    if (UnidataStationObsDataset.this.isContiguousList) {
                        if (nextRecord++ > end) {
                            break;
                        }
                    } else {
                        nextRecord = sdata.getScalarInt(this.next.getName());
                    }
                    double obsTime = UnidataStationObsDataset.this.getTime(UnidataStationObsDataset.this.timeVar, sdata);
                    double nomTime = UnidataStationObsDataset.this.timeNominalVar == null ? obsTime : UnidataStationObsDataset.this.getTime(UnidataStationObsDataset.this.timeNominalVar, sdata);
                    RecordDatasetHelper recordDatasetHelper = UnidataStationObsDataset.this.recordHelper;
                    recordDatasetHelper.getClass();
                    obs.add(recordDatasetHelper.new RecordDatasetHelper.RecordStationObs((Station)this, obsTime, nomTime, recno));
                    recno = nextRecord;
                }
                catch (InvalidRangeException e) {
                    log.error("UnidataStationObsDataset.readObservation recno=" + recno, (Throwable)e);
                    throw new IOException(e.getMessage());
                }
                catch (ParseException e) {
                    log.error("UnidataStationObsDataset.readObservation recno=" + recno, (Throwable)e);
                    throw new IOException(e.getMessage());
                }
            }
            Collections.sort(obs);
            return obs;
        }

        DataIterator iterator() {
            return new StationIterator();
        }

        DataIterator iterator(Date start, Date end) {
            return new StationIterator(start, end);
        }

        private class StationIterator
        implements DataIterator {
            int nextRecno;
            int last;
            double startTime;
            double endTime;
            boolean hasDateRange;

            StationIterator() {
                this.nextRecno = UnidataStationImpl.this.firstRecord;
                this.last = UnidataStationImpl.this.firstRecord + UnidataStationImpl.this.count - 1;
            }

            StationIterator(Date start, Date end) {
                this.nextRecno = UnidataStationImpl.this.firstRecord;
                this.last = UnidataStationImpl.this.firstRecord + UnidataStationImpl.this.count - 1;
                this.startTime = UnidataStationObsDataset.this.timeUnit.makeValue(start);
                this.endTime = UnidataStationObsDataset.this.timeUnit.makeValue(end);
                this.hasDateRange = true;
            }

            public boolean hasNext() {
                return this.nextRecno >= 0;
            }

            public Object nextData() throws IOException {
                double timeValue;
                RecordDatasetHelper.RecordStationObs sobs = UnidataStationObsDataset.this.makeObs(this.nextRecno, true, null);
                if (!sobs.getStation().getName().equals(UnidataStationImpl.this.getName())) {
                    throw new IllegalStateException("BAD Station link (" + this.nextRecno + ") station name=" + sobs.getStation().getName() + " should be " + UnidataStationImpl.this.getName());
                }
                if (UnidataStationObsDataset.this.isContiguousList) {
                    ++this.nextRecno;
                    if (this.nextRecno > this.last) {
                        this.nextRecno = -1;
                    }
                } else {
                    this.nextRecno = sobs.sdata.getScalarInt(UnidataStationImpl.this.next.getName());
                }
                if (this.hasDateRange && ((timeValue = sobs.getObservationTime()) < this.startTime || timeValue > this.endTime)) {
                    return this.nextData();
                }
                return sobs;
            }

            public Object next() {
                try {
                    return this.nextData();
                }
                catch (IOException e) {
                    log.error("UnidataStationObsDataset.StationIterator.next recno=" + this.nextRecno, (Throwable)e);
                    throw new IllegalStateException(e.getMessage());
                }
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

