/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import thredds.catalog.DataType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.DataIteratorAdapter;
import ucar.nc2.dt.Station;
import ucar.nc2.dt.StationImpl;
import ucar.nc2.dt.StationObsDataset;
import ucar.nc2.dt.StationObsDatatype;
import ucar.nc2.dt.point.PointObsDatasetImpl;
import ucar.nc2.dt.point.StationDatasetHelper;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.LatLonRect;

public abstract class StationObsDatasetImpl
extends PointObsDatasetImpl
implements StationObsDataset {
    protected StationDatasetHelper stationHelper;
    protected ArrayList stations = new ArrayList();

    public StationObsDatasetImpl() {
        this.stationHelper = new StationDatasetHelper(this);
    }

    public StationObsDatasetImpl(String title, String description, String location) {
        super(title, description, location);
        this.stationHelper = new StationDatasetHelper(this);
    }

    public StationObsDatasetImpl(NetcdfDataset ncfile) {
        super(ncfile);
        this.stationHelper = new StationDatasetHelper(this);
    }

    public String getDetailInfo() {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("StationObsDataset\n");
        sbuff.append(super.getDetailInfo());
        return sbuff.toString();
    }

    public DataType getScientificDataType() {
        return DataType.STATION;
    }

    public Class getDataClass() {
        return StationObsDatatype.class;
    }

    public List getStations() throws IOException {
        return this.getStations((CancelTask)null);
    }

    public List getStations(CancelTask cancel) throws IOException {
        return this.stations;
    }

    public List getStations(LatLonRect boundingBox) throws IOException {
        return this.getStations(boundingBox, null);
    }

    public List getStations(LatLonRect boundingBox, CancelTask cancel) throws IOException {
        return this.stationHelper.getStations(boundingBox, cancel);
    }

    public Station getStation(String id) {
        return this.stationHelper.getStation(id);
    }

    public int getStationDataCount(Station s) {
        StationImpl si = (StationImpl)s;
        return si.getNumObservations();
    }

    public List getData(Station s) throws IOException {
        return this.getData(s, null);
    }

    public List getData(Station s, Date start, Date end) throws IOException {
        return this.getData(s, start, end, null);
    }

    public List getData(Station s, Date start, Date end, CancelTask cancel) throws IOException {
        double startTime = this.timeUnit.makeValue(start);
        double endTime = this.timeUnit.makeValue(end);
        return this.stationHelper.getStationObs(s, startTime, endTime, cancel);
    }

    public List getData(List stations) throws IOException {
        return this.getData(stations, (CancelTask)null);
    }

    public List getData(List stations, CancelTask cancel) throws IOException {
        return this.stationHelper.getStationObs(stations, cancel);
    }

    public List getData(List stations, Date start, Date end) throws IOException {
        return this.getData(stations, start, end, (CancelTask)null);
    }

    public List getData(List stations, Date start, Date end, CancelTask cancel) throws IOException {
        double startTime = this.timeUnit.makeValue(start);
        double endTime = this.timeUnit.makeValue(end);
        return this.stationHelper.getStationObs(stations, startTime, endTime, cancel);
    }

    public List getData(LatLonRect boundingBox, CancelTask cancel) throws IOException {
        return this.stationHelper.getStationObs(boundingBox, cancel);
    }

    public List getData(LatLonRect boundingBox, Date start, Date end, CancelTask cancel) throws IOException {
        double startTime = this.timeUnit.makeValue(start);
        double endTime = this.timeUnit.makeValue(end);
        return this.stationHelper.getStationObs(boundingBox, startTime, endTime, cancel);
    }

    public void sortByTime(List stationObs) {
        this.stationHelper.sortByTime(stationObs);
    }

    public DataIterator getDataIterator(Station s) {
        try {
            return new DataIteratorAdapter(this.getData(s).iterator());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public DataIterator getDataIterator(Station s, Date start, Date end) {
        try {
            return new DataIteratorAdapter(this.getData(s, start, end).iterator());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

