/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import java.util.StringTokenizer;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.unidata.geoloc.vertical.HybridSigmaPressure;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.unidata.util.Parameter;

public class VAtmHybridSigmaPressure
extends AbstractCoordTransBuilder {
    private String a = "";
    private String b = "";
    private String ps = "";
    private String p0 = "";

    public String getTransformName() {
        return "atmosphere_hybrid_sigma_pressure_coordinate";
    }

    public TransformType getTransformType() {
        return TransformType.Vertical;
    }

    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        String formula_terms = this.getFormula(ds, ctv);
        if (null == formula_terms) {
            return null;
        }
        StringTokenizer stoke = new StringTokenizer(formula_terms);
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken();
            if (toke.equalsIgnoreCase("a:")) {
                this.a = stoke.nextToken();
                continue;
            }
            if (toke.equalsIgnoreCase("b:")) {
                this.b = stoke.nextToken();
                continue;
            }
            if (toke.equalsIgnoreCase("ps:")) {
                this.ps = stoke.nextToken();
                continue;
            }
            if (!toke.equalsIgnoreCase("p0:")) continue;
            this.p0 = stoke.nextToken();
        }
        VerticalCT rs = new VerticalCT("AtmHybridSigmaPressure_Transform_" + ctv.getName(), this.getTransformName(), VerticalCT.Type.HybridSigmaPressure, this);
        rs.addParameter(new Parameter("standard_name", this.getTransformName()));
        rs.addParameter(new Parameter("formula_terms", formula_terms));
        rs.addParameter(new Parameter("formula", "pressure(x,y,z) = a(z)*p0 + b(z)*surfacePressure(x,y)"));
        if (!this.addParameter(rs, "SurfacePressure_variableName", ds, this.ps)) {
            return null;
        }
        if (!this.addParameter(rs, "A_variableName", ds, this.a)) {
            return null;
        }
        if (!this.addParameter(rs, "B_variableName", ds, this.b)) {
            return null;
        }
        if (!this.addParameter(rs, "P0_variableName", ds, this.p0)) {
            return null;
        }
        return rs;
    }

    public String toString() {
        return "HybridSigma:ps:" + this.ps + " p0:" + this.p0 + " a:" + this.a + " b:" + this.b;
    }

    public VerticalTransform makeMathTransform(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        return new HybridSigmaPressure(ds, timeDim, vCT);
    }
}

