/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.FileWriter;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileCache;
import ucar.nc2.NetcdfFileFactory;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDatasetCache;
import ucar.nc2.dataset.NetcdfDatasetInfo;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.ncml.AggregationIF;
import ucar.nc2.ncml.NcMLGWriter;
import ucar.nc2.ncml.NcMLWriter;
import ucar.nc2.ncml4.NcMLReader;
import ucar.nc2.thredds.ThreddsDataFactory;
import ucar.nc2.util.CancelTask;
import ucar.unidata.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetcdfDataset
extends NetcdfFile {
    private static Logger log = LoggerFactory.getLogger(NetcdfDataset.class);
    protected static boolean useNaNs = true;
    protected static boolean fillValueIsMissing = true;
    protected static boolean invalidDataIsMissing = true;
    protected static boolean missingDataIsMissing = true;
    private NetcdfFile orgFile = null;
    private EnhanceMode isEnhanced = EnhanceMode.None;
    private List<CoordinateSystem> coordSys = new ArrayList<CoordinateSystem>();
    private List<CoordinateAxis> coordAxes = new ArrayList<CoordinateAxis>();
    private List<CoordinateTransform> coordTransforms = new ArrayList<CoordinateTransform>();
    private boolean coordSysWereAdded = false;
    private boolean scaleOffsetWasAdded = false;
    private AggregationIF agg = null;
    private NetcdfDatasetInfo info = null;

    public static void setUseNaNs(boolean b) {
        useNaNs = b;
    }

    public static boolean getUseNaNs() {
        return useNaNs;
    }

    public static void setFillValueIsMissing(boolean b) {
        fillValueIsMissing = b;
    }

    public static boolean getFillValueIsMissing() {
        return fillValueIsMissing;
    }

    public static void setInvalidDataIsMissing(boolean b) {
        invalidDataIsMissing = b;
    }

    public static boolean getInvalidDataIsMissing() {
        return invalidDataIsMissing;
    }

    public static void setMissingDataIsMissing(boolean b) {
        missingDataIsMissing = b;
    }

    public static boolean getMissingDataIsMissing() {
        return missingDataIsMissing;
    }

    public static NetcdfDataset openDataset(String location) throws IOException {
        return NetcdfDataset.openDataset(location, true, null);
    }

    public static NetcdfDataset openDataset(String location, boolean enhance, CancelTask cancelTask) throws IOException {
        return NetcdfDataset.openDataset(location, enhance, -1, cancelTask, null);
    }

    public static NetcdfDataset openDataset(String location, boolean enhance, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        return NetcdfDataset.openDataset(location, enhance ? EnhanceMode.All : EnhanceMode.None, buffer_size, cancelTask, spiObject);
    }

    public static NetcdfDataset openDataset(String location, EnhanceMode enhanceMode, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        NetcdfDataset ds;
        NetcdfFile ncfile = NetcdfDataset.openFile(location, buffer_size, cancelTask, spiObject);
        if (ncfile instanceof NetcdfDataset) {
            ds = (NetcdfDataset)ncfile;
            NetcdfDataset.enhance(ds, enhanceMode, cancelTask);
        } else {
            ds = new NetcdfDataset(ncfile, enhanceMode);
        }
        return ds;
    }

    private static void enhance(NetcdfDataset ds, EnhanceMode mode, CancelTask cancelTask) throws IOException {
        if (mode == EnhanceMode.None) {
            return;
        }
        if (mode == EnhanceMode.All || mode == EnhanceMode.CoordSystems) {
            if (!ds.coordSysWereAdded) {
                CoordSysBuilder.addCoordinateSystems(ds, cancelTask);
            }
            ds.coordSysWereAdded = true;
        }
        if (mode == EnhanceMode.All || mode == EnhanceMode.ScaleMissing) {
            for (Variable v : ds.getVariables()) {
                VariableEnhanced ve = (VariableEnhanced)((Object)v);
                ve.enhance();
                if (cancelTask == null || !cancelTask.isCancel()) continue;
                return;
            }
            ds.scaleOffsetWasAdded = true;
        }
        ds.finish();
        ds.isEnhanced = ds.coordSysWereAdded && ds.scaleOffsetWasAdded ? EnhanceMode.All : (ds.coordSysWereAdded ? EnhanceMode.CoordSystems : (ds.scaleOffsetWasAdded ? EnhanceMode.ScaleMissing : EnhanceMode.None));
    }

    public static NetcdfDataset acquireDataset(String location, CancelTask cancelTask) throws IOException {
        NetcdfDataset ds;
        NetcdfFile ncfile = NetcdfDataset.acquireFile(location, cancelTask);
        if (ncfile instanceof NetcdfDataset) {
            ds = (NetcdfDataset)ncfile;
            NetcdfDataset.enhance(ds, EnhanceMode.All, cancelTask);
        } else {
            ds = new NetcdfDataset(ncfile, true);
        }
        return ds;
    }

    public static NetcdfFile acquireFile(String location, CancelTask cancelTask) throws IOException {
        NetcdfFile ncfile;
        if (location == null) {
            throw new IOException("NetcdfDataset.openFile: location is null");
        }
        location = location.trim();
        if ((location = StringUtil.replace(location, '\\', "/")).startsWith("dods:")) {
            ncfile = NetcdfDataset.acquireDODS(location, cancelTask);
        } else if (location.endsWith(".xml") || location.endsWith(".ncml")) {
            if (!location.startsWith("http:") && !location.startsWith("file:")) {
                location = "file:" + location;
            }
            ncfile = NetcdfFileCache.acquire(location, -1, cancelTask, null, new NetcdfFileFactory(){

                public NetcdfFile open(String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
                    return NcMLReader.readNcML(location, cancelTask);
                }
            });
        } else {
            ncfile = location.startsWith("http:") ? (NetcdfDataset.isDODS(location) ? NetcdfDataset.acquireDODS(location, cancelTask) : NetcdfFileCache.acquire(location, cancelTask)) : NetcdfFileCache.acquire(location, cancelTask);
        }
        return ncfile;
    }

    public static NetcdfFile openFile(String location, CancelTask cancelTask) throws IOException {
        return NetcdfDataset.openFile(location, -1, cancelTask, null);
    }

    public static NetcdfFile openFile(String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        NetcdfFile ncfile;
        if (location == null) {
            throw new IOException("NetcdfDataset.openFile: location is null");
        }
        location = location.trim();
        if ((location = StringUtil.replace(location, '\\', "/")).startsWith("dods:")) {
            ncfile = NetcdfDataset.openDODS(location, cancelTask);
        } else if (location.startsWith("thredds:")) {
            ThreddsDataFactory tdf = new ThreddsDataFactory();
            StringBuffer log = new StringBuffer();
            ncfile = tdf.openDataset(location, false, cancelTask, log);
            if (ncfile == null) {
                throw new IOException(log.toString());
            }
        } else {
            if (location.endsWith(".xml") || location.endsWith(".ncml")) {
                if (!location.startsWith("http:") && !location.startsWith("file:")) {
                    location = "file:" + location;
                }
                return NcMLReader.readNcML(location, cancelTask);
            }
            ncfile = location.startsWith("http:") ? (NetcdfDataset.isDODS(location) ? NetcdfDataset.openDODS(location, cancelTask) : NetcdfFile.open(location, buffer_size, cancelTask, spiObject)) : NetcdfFile.open(location, buffer_size, cancelTask, spiObject);
        }
        return ncfile;
    }

    private static boolean isDODS(String location) throws IOException {
        try {
            URL u = new URL(location + ".dds");
            HttpURLConnection conn = (HttpURLConnection)u.openConnection();
            conn.setRequestMethod("HEAD");
            int code = conn.getResponseCode();
            return code == 200;
        }
        catch (Exception e) {
            throw new IOException(location + " is not a valid URL." + e.getMessage());
        }
    }

    private static NetcdfFile acquireDODS(String location, CancelTask cancelTask) throws IOException {
        return NetcdfFileCache.acquire(location, -1, cancelTask, null, new NetcdfFileFactory(){

            public NetcdfFile open(String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
                return NetcdfDataset.openDODS(location, cancelTask);
            }
        });
    }

    private static NetcdfFile openDODS(String location, CancelTask cancelTask) throws IOException {
        String dodsUri = null;
        try {
            dodsUri = DODSNetcdfFile.canonicalURL(location);
            return new DODSNetcdfFile(dodsUri, cancelTask);
        }
        catch (IOException e) {
            throw new FileNotFoundException("Cant open " + location + " or as DODS " + dodsUri + "\n" + e.getMessage());
        }
    }

    public Variable findStandardVariable(String name) {
        return this.findVariable(name);
    }

    public AggregationIF getAggregation() {
        return this.agg;
    }

    public void setAggregation(AggregationIF agg) {
        this.agg = agg;
    }

    public List<CoordinateSystem> getCoordinateSystems() {
        return this.coordSys;
    }

    public EnhanceMode getEnhanceMode() {
        return this.isEnhanced;
    }

    public boolean isEnhancedScaleOffset() {
        return this.isEnhanced == EnhanceMode.All || this.isEnhanced == EnhanceMode.ScaleMissing;
    }

    public boolean isEnhancedCoordSystems() {
        return this.isEnhanced == EnhanceMode.All || this.isEnhanced == EnhanceMode.CoordSystems;
    }

    public List<CoordinateTransform> getCoordinateTransforms() {
        return this.coordTransforms;
    }

    public List<CoordinateAxis> getCoordinateAxes() {
        return this.coordAxes;
    }

    public void clearCoordinateSystems() {
        this.coordSys = new ArrayList<CoordinateSystem>();
        this.coordAxes = new ArrayList<CoordinateAxis>();
        this.coordTransforms = new ArrayList<CoordinateTransform>();
        this.coordSysWereAdded = false;
    }

    public void setCoordSysWereAdded(boolean coordSysWereAdded) {
        this.coordSysWereAdded = coordSysWereAdded;
    }

    public CoordinateAxis findCoordinateAxis(String fullName) {
        if (fullName == null) {
            return null;
        }
        for (CoordinateAxis v : this.coordAxes) {
            if (!fullName.equals(v.getName())) continue;
            return v;
        }
        return null;
    }

    public CoordinateSystem findCoordinateSystem(String name) {
        if (name == null) {
            return null;
        }
        for (CoordinateSystem v : this.coordSys) {
            if (!name.equals(v.getName())) continue;
            return v;
        }
        return null;
    }

    public CoordinateTransform findCoordinateTransform(String name) {
        if (name == null) {
            return null;
        }
        for (CoordinateTransform v : this.coordTransforms) {
            if (!name.equals(v.getName())) continue;
            return v;
        }
        return null;
    }

    @Override
    public void setCacheState(int cacheState) {
        super.setCacheState(cacheState);
    }

    @Override
    protected void setCacheName(String cacheName) {
        super.setCacheName(cacheName);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.getCacheState() == 3) {
            return;
        }
        if (this.getCacheState() == 2) {
            NetcdfDatasetCache.release(this);
        } else if (this.getCacheState() == 1) {
            if (this.agg != null) {
                this.agg.persist();
            }
            NetcdfFileCache.release(this);
        } else {
            if (this.isClosed) {
                return;
            }
            if (this.agg != null) {
                this.agg.close();
            }
            this.agg = null;
            if (this.orgFile != null) {
                this.orgFile.close();
            }
            this.orgFile = null;
            this.isClosed = true;
        }
    }

    @Override
    public boolean sync() throws IOException {
        if (this.agg != null) {
            return this.agg.sync();
        }
        if (this.orgFile != null) {
            return this.orgFile.sync();
        }
        return false;
    }

    @Override
    public boolean syncExtend() throws IOException {
        boolean wasExtended;
        if (this.agg != null) {
            return this.agg.syncExtend(false);
        }
        if (this.orgFile != null && (wasExtended = this.orgFile.syncExtend())) {
            Dimension ndim = this.orgFile.getUnlimitedDimension();
            int newLength = ndim.getLength();
            Dimension udim = this.getUnlimitedDimension();
            udim.setLength(newLength);
            for (Variable v : this.getVariables()) {
                if (!v.isUnlimited()) continue;
                v.setDimensions(v.getDimensions());
            }
            return true;
        }
        return false;
    }

    @Override
    public void writeNcML(OutputStream os, String uri) throws IOException {
        new NcMLWriter().writeXML(this, os, uri);
    }

    public void writeNcMLG(OutputStream os, boolean showCoords, String uri) throws IOException {
        new NcMLGWriter().writeXML(this, os, showCoords, uri);
    }

    public NetcdfDataset(NetcdfFile ncfile) throws IOException {
        this(ncfile, true);
    }

    public NetcdfDataset(NetcdfFile ncfile, boolean enhance) throws IOException {
        this(ncfile, enhance ? EnhanceMode.All : EnhanceMode.None);
    }

    public NetcdfDataset(NetcdfFile ncfile, EnhanceMode mode) throws IOException {
        super(ncfile);
        this.orgFile = ncfile;
        this.convertGroup(this.getRootGroup(), ncfile.getRootGroup());
        this.finish();
        NetcdfDataset.enhance(this, mode, null);
    }

    private void convertGroup(Group g, Group from) {
        for (Dimension d : from.getDimensions()) {
            g.addDimension(d);
        }
        for (Attribute a : from.getAttributes()) {
            g.addAttribute(a);
        }
        for (Variable v : from.getVariables()) {
            g.addVariable(this.convertVariable(g, v));
        }
        for (Group nested : from.getGroups()) {
            Group nnested = new Group(this, g, nested.getShortName());
            g.addGroup(nnested);
            this.convertGroup(nnested, nested);
        }
    }

    private Variable convertVariable(Group g, Variable v) {
        Variable newVar;
        if (v instanceof Structure) {
            newVar = new StructureDS(g, (Structure)v, false);
            this.convertStructure(g, (Structure)newVar);
        } else {
            newVar = new VariableDS(g, v, false);
        }
        return newVar;
    }

    private void convertStructure(Group g, Structure newStructure) {
        ArrayList<Variable> newList = new ArrayList<Variable>();
        for (Variable v : newStructure.getVariables()) {
            Variable newVar;
            if (v instanceof Structure) {
                newVar = new StructureDS(g, (Structure)v, false);
                this.convertStructure(g, (Structure)newVar);
            } else {
                newVar = new VariableDS(g, v, false);
            }
            newList.add(newVar);
        }
        newStructure.setMemberVariables(newList);
    }

    @Override
    protected Boolean makeRecordStructure() {
        if (this.orgFile == null) {
            return false;
        }
        Boolean hasRecord = (Boolean)this.orgFile.sendIospMessage("AddRecordStructure");
        if (hasRecord == null || !hasRecord.booleanValue()) {
            return false;
        }
        Variable orgV = this.orgFile.getRootGroup().findVariable("record");
        if (orgV == null || !(orgV instanceof Structure)) {
            return false;
        }
        Structure orgStructure = (Structure)orgV;
        Dimension udim = this.getUnlimitedDimension();
        if (udim == null) {
            return false;
        }
        Group root = this.getRootGroup();
        StructureDS newStructure = new StructureDS(this, root, null, "record", udim.getName(), null, null);
        newStructure.setOriginalVariable(orgStructure);
        for (Variable v : this.getVariables()) {
            if (!v.isUnlimited()) continue;
            VariableDS memberV = new VariableDS(root, v, this.isEnhancedScaleOffset());
            memberV.setParentStructure(newStructure);
            memberV.createNewCache();
            orgV = orgStructure.findVariable(v.getShortName());
            if (orgV != null) {
                memberV.setOriginalVariable(orgV);
            }
            ArrayList<Dimension> dims = new ArrayList<Dimension>(v.getDimensions());
            dims.remove(0);
            memberV.setDimensions(dims);
            newStructure.addMemberVariable(memberV);
        }
        root.addVariable(newStructure);
        this.finish();
        return true;
    }

    public void sort() {
        Collections.sort(this.variables, new VariableComparator());
        Collections.sort(this.coordAxes, new VariableComparator());
    }

    public NetcdfDataset() {
    }

    public NetcdfFile getReferencedFile() {
        return this.orgFile;
    }

    public void setReferencedFile(NetcdfFile ncfile) {
        this.orgFile = ncfile;
    }

    @Override
    protected String toStringDebug(Object o) {
        return "";
    }

    public void addCoordinateSystem(CoordinateSystem cs) {
        this.coordSys.add(cs);
    }

    public void addCoordinateTransform(CoordinateTransform ct) {
        if (!this.coordTransforms.contains(ct)) {
            this.coordTransforms.add(ct);
        }
    }

    public CoordinateAxis addCoordinateAxis(VariableDS v) {
        if (v == null) {
            return null;
        }
        CoordinateAxis oldVar = this.findCoordinateAxis(v.getName());
        if (oldVar != null) {
            this.coordAxes.remove(oldVar);
        }
        CoordinateAxis ca = v instanceof CoordinateAxis ? (CoordinateAxis)v : CoordinateAxis.factory(this, v);
        this.coordAxes.add(ca);
        if (v.isMemberOfStructure()) {
            Structure parentOrg = v.getParentStructure();
            Structure parent = (Structure)this.findVariable(parentOrg.getName());
            parent.replaceMemberVariable(ca);
        } else {
            this.removeVariable(v.getParentGroup(), v.getShortName());
            this.addVariable(ca.getParentGroup(), ca);
        }
        return ca;
    }

    @Override
    public Variable addVariable(Group g, Variable v) {
        if (!(v instanceof VariableDS) && !(v instanceof StructureDS)) {
            throw new IllegalArgumentException("NetcdfDataset variables must be VariableEnhanced objects");
        }
        return super.addVariable(g, v);
    }

    public void enhance() throws IOException {
        NetcdfDataset.enhance(this, EnhanceMode.All, null);
    }

    public void enhance(EnhanceMode mode) throws IOException {
        NetcdfDataset.enhance(this, mode, null);
    }

    public void setValues(Variable v, int npts, double start, double incr) {
        if ((long)npts != v.getSize()) {
            throw new IllegalArgumentException("bad npts = " + npts + " should be " + v.getSize());
        }
        Array data = NetcdfDataset.makeArray(v.getDataType(), npts, start, incr);
        if (v.getRank() > 1) {
            data = data.reshape(v.getShape());
        }
        v.setCachedData(data, true);
    }

    public void setValues(Variable v, List<String> values) throws IllegalArgumentException {
        Array data = NetcdfDataset.makeArray(v.getDataType(), values);
        if (data.getSize() != v.getSize()) {
            throw new IllegalArgumentException("Incorrect number of values specified for the Variable " + v.getName() + " needed= " + v.getSize() + " given=" + data.getSize());
        }
        if (v.getRank() > 1) {
            data = data.reshape(v.getShape());
        }
        v.setCachedData(data, true);
    }

    public static Array makeArray(DataType dtype, List<String> stringValues) throws NumberFormatException {
        Array result = Array.factory(dtype.getPrimitiveClassType(), new int[]{stringValues.size()});
        IndexIterator dataI = result.getIndexIterator();
        for (String s : stringValues) {
            if (dtype == DataType.STRING) {
                dataI.setObjectNext(s);
                continue;
            }
            if (dtype == DataType.LONG) {
                long val = Long.parseLong(s);
                dataI.setLongNext(val);
                continue;
            }
            double val = Double.parseDouble(s);
            dataI.setDoubleNext(val);
        }
        return result;
    }

    public static Array makeArray(DataType dtype, int npts, double start, double incr) {
        Array result = Array.factory(dtype.getPrimitiveClassType(), new int[]{npts});
        IndexIterator dataI = result.getIndexIterator();
        for (int i = 0; i < npts; ++i) {
            double val = start + (double)i * incr;
            dataI.setDoubleNext(val);
        }
        return result;
    }

    @Override
    public String getDetailInfo() {
        StringBuffer sbuff = new StringBuffer(5000);
        sbuff.append("NetcdfDataset location= ").append(this.getLocation()).append("\n");
        sbuff.append("  title= ").append(this.getTitle()).append("\n");
        sbuff.append("  id= ").append(this.getId()).append("\n");
        if (this.orgFile == null) {
            sbuff.append("  has no referenced NetcdfFile!\n");
        } else {
            sbuff.append("\nReferenced File:\n");
            sbuff.append(this.orgFile.getDetailInfo());
        }
        return sbuff.toString();
    }

    public NetcdfDatasetInfo getInfo() {
        if (null == this.info) {
            this.info = new NetcdfDatasetInfo(this);
        }
        return this.info;
    }

    void dumpClasses(Group g, PrintStream out) {
        out.println("Dimensions:");
        for (Dimension ds : g.getDimensions()) {
            out.println("  " + ds.getName() + " " + ds.getClass().getName());
        }
        out.println("Atributes:");
        for (Attribute a : g.getAttributes()) {
            out.println("  " + a.getName() + " " + a.getClass().getName());
        }
        out.println("Variables:");
        this.dumpVariables(g.getVariables(), out);
        out.println("Groups:");
        for (Group nested : g.getGroups()) {
            out.println("  " + nested.getName() + " " + nested.getClass().getName());
            this.dumpClasses(nested, out);
        }
    }

    private void dumpVariables(List<Variable> vars, PrintStream out) {
        for (Variable v : vars) {
            out.print("  " + v.getName() + " " + v.getClass().getName());
            if (v instanceof CoordinateAxis) {
                out.println("  " + ((CoordinateAxis)v).getAxisType());
            } else {
                out.println();
            }
            if (!(v instanceof Structure)) continue;
            this.dumpVariables(((Structure)v).getVariables(), out);
        }
    }

    public static void debugDump(PrintStream out, NetcdfDataset ncd) {
        String referencedLocation = ncd.orgFile == null ? "(null)" : ncd.orgFile.getLocation();
        out.println("\nNetcdfDataset dump = " + ncd.getLocation() + " uri= " + referencedLocation + "\n");
        ncd.dumpClasses(ncd.getRootGroup(), out);
    }

    public static void main2(String[] arg) {
        String defaultUrl = "C:/data/grib/nam/conus12/NAM_CONUS_12km_20060604_1800.grib2";
        String filename = arg.length > 0 ? arg[0] : defaultUrl;
        try {
            NetcdfDataset ncDataset = NetcdfDataset.openDataset(filename, true, null);
            System.out.println("NetcdfDataset = " + filename + "\n" + ncDataset);
            NetcdfDataset.debugDump(System.out, ncDataset);
        }
        catch (Exception ioe) {
            System.out.println("error = " + filename);
            ioe.printStackTrace();
        }
    }

    public static void main(String[] arg) throws IOException {
        String datasetIn = "//zero/share/testdata/fmrc/NAMfmrc.nc";
        String filenameOut = "C:/temp/test.nc";
        NetcdfFile ncfileIn = NetcdfDataset.openFile(datasetIn, null);
        FileWriter.writeToFile(ncfileIn, filenameOut);
    }

    private class VariableComparator
    implements Comparator {
        private VariableComparator() {
        }

        public int compare(Object o1, Object o2) {
            String cs2;
            VariableEnhanced v1 = (VariableEnhanced)o1;
            VariableEnhanced v2 = (VariableEnhanced)o2;
            List<CoordinateSystem> list1 = v1.getCoordinateSystems();
            String cs1 = list1.size() > 0 ? list1.get(0).getName() : "";
            List<CoordinateSystem> list2 = v2.getCoordinateSystems();
            String string = cs2 = list2.size() > 0 ? list2.get(0).getName() : "";
            if (cs2.equals(cs1)) {
                return v1.getName().compareToIgnoreCase(v2.getName());
            }
            return cs1.compareToIgnoreCase(cs2);
        }

        public boolean equals(Object obj) {
            return this == obj;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnhanceMode {
        None,
        ScaleMissing,
        CoordSystems,
        All;

    }
}

