/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.ForbiddenConversionException;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;

public abstract class ArrayStructure
extends Array {
    protected StructureMembers members;
    protected int nelems;
    protected StructureData[] sdata;

    public ArrayStructure(StructureMembers members, int[] shape) {
        super(shape);
        this.members = members;
        this.nelems = (int)this.indexCalc.getSize();
    }

    protected ArrayStructure(StructureMembers members, Index ima) {
        super(ima);
        this.members = members;
        this.nelems = (int)this.indexCalc.getSize();
    }

    public Array createView(Index index) {
        if (index.getSize() == this.getSize()) {
            return this;
        }
        throw new UnsupportedOperationException();
    }

    public Array copy() {
        throw new UnsupportedOperationException();
    }

    void copyFrom1DJavaArray(IndexIterator iter, Object javaArray) {
        Object[] ja = (Object[])javaArray;
        for (int i = 0; i < ja.length; ++i) {
            iter.setObjectNext(ja[i]);
        }
    }

    void copyTo1DJavaArray(IndexIterator iter, Object javaArray) {
        Object[] ja = (Object[])javaArray;
        for (int i = 0; i < ja.length; ++i) {
            ja[i] = iter.getObjectNext();
        }
    }

    public Class getElementType() {
        return StructureData.class;
    }

    public StructureMembers getStructureMembers() {
        return this.members;
    }

    public Object getObject(Index i) {
        return this.getObject(i.currentElement());
    }

    public void setObject(Index i, Object value) {
        this.setObject(i.currentElement(), value);
    }

    public Object getObject(int index) {
        return this.getStructureData(index);
    }

    void setObject(int index, Object value) {
        if (this.sdata == null) {
            this.sdata = new StructureData[this.nelems];
        }
        this.sdata[index] = (StructureData)value;
    }

    public StructureData getStructureData(Index i) {
        return this.getStructureData(i.currentElement());
    }

    public StructureData getStructureData(int index) {
        if (this.sdata == null) {
            this.sdata = new StructureData[this.nelems];
        }
        if (index >= this.sdata.length) {
            throw new IllegalArgumentException(index + " > " + this.sdata.length);
        }
        if (this.sdata[index] == null) {
            this.sdata[index] = this.makeStructureData(this, index);
        }
        return this.sdata[index];
    }

    protected abstract StructureData makeStructureData(ArrayStructure var1, int var2);

    public int getStructureSize() {
        return this.members.getStructureSize();
    }

    public Array getArray(int recno, StructureMembers.Member m) {
        DataType dataType = m.getDataType();
        if (dataType == DataType.DOUBLE) {
            double[] pa = this.getJavaArrayDouble(recno, m);
            return Array.factory(Double.TYPE, m.getShape(), (Object)pa);
        }
        if (dataType == DataType.FLOAT) {
            float[] pa = this.getJavaArrayFloat(recno, m);
            return Array.factory(Float.TYPE, m.getShape(), (Object)pa);
        }
        if (dataType == DataType.BYTE) {
            byte[] pa = this.getJavaArrayByte(recno, m);
            return Array.factory(Byte.TYPE, m.getShape(), (Object)pa);
        }
        if (dataType == DataType.SHORT) {
            short[] pa = this.getJavaArrayShort(recno, m);
            return Array.factory(Short.TYPE, m.getShape(), (Object)pa);
        }
        if (dataType == DataType.INT) {
            int[] pa = this.getJavaArrayInt(recno, m);
            return Array.factory(Integer.TYPE, m.getShape(), (Object)pa);
        }
        if (dataType == DataType.LONG) {
            long[] pa = this.getJavaArrayLong(recno, m);
            return Array.factory(Long.TYPE, m.getShape(), (Object)pa);
        }
        if (dataType == DataType.CHAR) {
            char[] pa = this.getJavaArrayChar(recno, m);
            return Array.factory(Character.TYPE, m.getShape(), (Object)pa);
        }
        if (dataType == DataType.STRING) {
            String[] pa = this.getJavaArrayString(recno, m);
            return Array.factory(String.class, m.getShape(), (Object)pa);
        }
        if (dataType == DataType.STRUCTURE) {
            return this.getArrayStructure(recno, m);
        }
        throw new RuntimeException("Dont have implemenation for " + dataType);
    }

    public Object getObject(int recno, StructureMembers.Member m) {
        return this.getScalarObject(recno, m);
    }

    public Object getScalarObject(int recno, StructureMembers.Member m) {
        DataType dataType = m.getDataType();
        if (dataType == DataType.DOUBLE) {
            return this.getScalarDouble(recno, m);
        }
        if (dataType == DataType.FLOAT) {
            return Float.valueOf(this.getScalarFloat(recno, m));
        }
        if (dataType == DataType.BYTE) {
            return this.getScalarByte(recno, m);
        }
        if (dataType == DataType.SHORT) {
            return this.getScalarShort(recno, m);
        }
        if (dataType == DataType.INT) {
            return this.getScalarInt(recno, m);
        }
        if (dataType == DataType.LONG) {
            return this.getScalarLong(recno, m);
        }
        if (dataType == DataType.CHAR) {
            return this.getScalarString(recno, m);
        }
        if (dataType == DataType.STRING) {
            return this.getScalarString(recno, m);
        }
        if (dataType == DataType.STRUCTURE) {
            return this.getScalarStructure(recno, m);
        }
        throw new RuntimeException("Dont have implemenation for " + dataType);
    }

    public abstract double getScalarDouble(int var1, StructureMembers.Member var2);

    public abstract double[] getJavaArrayDouble(int var1, StructureMembers.Member var2);

    public double[] getArrayDouble(int recnum, StructureMembers.Member m) {
        return this.getJavaArrayDouble(recnum, m);
    }

    public abstract float getScalarFloat(int var1, StructureMembers.Member var2);

    public abstract float[] getJavaArrayFloat(int var1, StructureMembers.Member var2);

    public float[] getArrayFloat(int recnum, StructureMembers.Member m) {
        return this.getJavaArrayFloat(recnum, m);
    }

    public abstract byte getScalarByte(int var1, StructureMembers.Member var2);

    public abstract byte[] getJavaArrayByte(int var1, StructureMembers.Member var2);

    public byte[] getArrayByte(int recnum, StructureMembers.Member m) {
        return this.getJavaArrayByte(recnum, m);
    }

    public abstract short getScalarShort(int var1, StructureMembers.Member var2);

    public abstract short[] getJavaArrayShort(int var1, StructureMembers.Member var2);

    public short[] getArrayShort(int recnum, StructureMembers.Member m) {
        return this.getJavaArrayShort(recnum, m);
    }

    public abstract int getScalarInt(int var1, StructureMembers.Member var2);

    public abstract int[] getJavaArrayInt(int var1, StructureMembers.Member var2);

    public int[] getArrayInt(int recnum, StructureMembers.Member m) {
        return this.getJavaArrayInt(recnum, m);
    }

    public abstract long getScalarLong(int var1, StructureMembers.Member var2);

    public abstract long[] getJavaArrayLong(int var1, StructureMembers.Member var2);

    public long[] getArrayLong(int recnum, StructureMembers.Member m) {
        return this.getJavaArrayLong(recnum, m);
    }

    public abstract char getScalarChar(int var1, StructureMembers.Member var2);

    public abstract char[] getJavaArrayChar(int var1, StructureMembers.Member var2);

    public char[] getArrayChar(int recnum, StructureMembers.Member m) {
        return this.getJavaArrayChar(recnum, m);
    }

    public abstract String getScalarString(int var1, StructureMembers.Member var2);

    public abstract String[] getJavaArrayString(int var1, StructureMembers.Member var2);

    public String[] getArrayString(int recnum, StructureMembers.Member m) {
        return this.getJavaArrayString(recnum, m);
    }

    public abstract StructureData getScalarStructure(int var1, StructureMembers.Member var2);

    public abstract ArrayStructure getArrayStructure(int var1, StructureMembers.Member var2);

    public double getDouble(Index i) {
        throw new ForbiddenConversionException();
    }

    public void setDouble(Index i, double value) {
        throw new ForbiddenConversionException();
    }

    public float getFloat(Index i) {
        throw new ForbiddenConversionException();
    }

    public void setFloat(Index i, float value) {
        throw new ForbiddenConversionException();
    }

    public long getLong(Index i) {
        throw new ForbiddenConversionException();
    }

    public void setLong(Index i, long value) {
        throw new ForbiddenConversionException();
    }

    public int getInt(Index i) {
        throw new ForbiddenConversionException();
    }

    public void setInt(Index i, int value) {
        throw new ForbiddenConversionException();
    }

    public short getShort(Index i) {
        throw new ForbiddenConversionException();
    }

    public void setShort(Index i, short value) {
        throw new ForbiddenConversionException();
    }

    public byte getByte(Index i) {
        throw new ForbiddenConversionException();
    }

    public void setByte(Index i, byte value) {
        throw new ForbiddenConversionException();
    }

    public boolean getBoolean(Index i) {
        throw new ForbiddenConversionException();
    }

    public void setBoolean(Index i, boolean value) {
        throw new ForbiddenConversionException();
    }

    public char getChar(Index i) {
        throw new ForbiddenConversionException();
    }

    public void setChar(Index i, char value) {
        throw new ForbiddenConversionException();
    }

    double getDouble(int index) {
        throw new ForbiddenConversionException();
    }

    void setDouble(int index, double value) {
        throw new ForbiddenConversionException();
    }

    float getFloat(int index) {
        throw new ForbiddenConversionException();
    }

    void setFloat(int index, float value) {
        throw new ForbiddenConversionException();
    }

    long getLong(int index) {
        throw new ForbiddenConversionException();
    }

    void setLong(int index, long value) {
        throw new ForbiddenConversionException();
    }

    int getInt(int index) {
        throw new ForbiddenConversionException();
    }

    void setInt(int index, int value) {
        throw new ForbiddenConversionException();
    }

    short getShort(int index) {
        throw new ForbiddenConversionException();
    }

    void setShort(int index, short value) {
        throw new ForbiddenConversionException();
    }

    byte getByte(int index) {
        throw new ForbiddenConversionException();
    }

    void setByte(int index, byte value) {
        throw new ForbiddenConversionException();
    }

    char getChar(int index) {
        throw new ForbiddenConversionException();
    }

    void setChar(int index, char value) {
        throw new ForbiddenConversionException();
    }

    boolean getBoolean(int index) {
        throw new ForbiddenConversionException();
    }

    void setBoolean(int index, boolean value) {
        throw new ForbiddenConversionException();
    }
}

