/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.VirtualSocket;
import org.jboss.remoting.transport.multiplex.utility.GrowablePipedInputStream;
import org.jboss.remoting.transport.multiplex.utility.GrowablePipedOutputStream;
import org.jboss.remoting.transport.multiplex.utility.VirtualSelector;

public class MultiplexingInputStream
extends GrowablePipedInputStream {
    protected static final Logger log = Logger.getLogger(class$org$jboss$remoting$transport$multiplex$MultiplexingInputStream == null ? (class$org$jboss$remoting$transport$multiplex$MultiplexingInputStream = MultiplexingInputStream.class$("org.jboss.remoting.transport.multiplex.MultiplexingInputStream")) : class$org$jboss$remoting$transport$multiplex$MultiplexingInputStream);
    private VirtualSocket socket;
    private boolean eof = false;
    private boolean closed = false;
    private boolean remoteShutDownPending = false;
    private Set readingThreads = new HashSet();
    private IOException readException;
    private long skipCount = 0L;
    private boolean tracing;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$MultiplexingInputStream;

    public MultiplexingInputStream(GrowablePipedOutputStream sourceStream, MultiplexingManager manager) throws IOException {
        this(sourceStream, manager, null, null);
    }

    public MultiplexingInputStream(GrowablePipedOutputStream sourceStream, MultiplexingManager manager, VirtualSocket socket) throws IOException {
        this(sourceStream, manager, socket, null);
    }

    public MultiplexingInputStream(GrowablePipedOutputStream sourceStream, MultiplexingManager manager, VirtualSocket socket, VirtualSelector virtualSelector) throws IOException {
        super(sourceStream, virtualSelector);
        this.socket = socket;
        this.tracing = log.isTraceEnabled();
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        log.debug("MultiplexingInputStream closing");
        this.closed = true;
        super.close();
        if (this.socket != null) {
            this.socket.close();
        }
        this.interruptReadingThreads();
    }

    public synchronized int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.closed) {
            throw new SocketException("Socket closed");
        }
        if (this.readException != null) {
            throw this.readException;
        }
        if (this.skipCount > 0L) {
            this.skip(this.skipCount);
        }
        try {
            this.readingThreads.add(Thread.currentThread());
            int b = super.read();
            this.readingThreads.remove(Thread.currentThread());
            if (this.tracing) {
                log.trace("read(): super.read() returned: " + b);
            }
            if (this.remoteShutDownPending && this.available() == 0) {
                this.setEOF();
            }
            return b & 0xFF;
        }
        catch (IOException e) {
            this.readingThreads.remove(Thread.currentThread());
            if (this.closed) {
                throw new SocketException("Socket closed");
            }
            if (this.eof) {
                return -1;
            }
            if (this.readException != null) {
                throw this.readException;
            }
            throw e;
        }
    }

    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    public synchronized int read(byte[] bytes, int off, int len) throws IOException {
        log.trace("entering read()");
        if (this.eof) {
            return -1;
        }
        if (this.closed) {
            throw new SocketException("Socket closed");
        }
        if (this.readException != null) {
            throw this.readException;
        }
        if (this.skipCount > 0L) {
            this.skip(this.skipCount);
        }
        try {
            this.readingThreads.add(Thread.currentThread());
            int n = super.read(bytes, off, len);
            this.readingThreads.remove(Thread.currentThread());
            if (this.tracing) {
                log.trace("super.read() returned " + n + " bytes: " + "[" + (0xFF & bytes[off]) + ".." + (0xFF & bytes[off + n - 1]) + "]");
            }
            if (this.remoteShutDownPending && this.available() == 0) {
                this.setEOF();
            }
            return n;
        }
        catch (IOException e) {
            this.readingThreads.remove(Thread.currentThread());
            if (this.eof) {
                return -1;
            }
            if (this.closed) {
                throw new SocketException("Socket closed");
            }
            throw e;
        }
    }

    public synchronized long skip(long n) throws IOException {
        if (this.eof) {
            return 0L;
        }
        if (this.closed) {
            throw new SocketException("Socket closed");
        }
        if (this.readException != null) {
            throw this.readException;
        }
        if (n <= 0L) {
            return 0L;
        }
        try {
            int skipped;
            this.readingThreads.add(Thread.currentThread());
            for (skipped = 0; (long)skipped < n && (skipped == 0 || this.available() > 0) && this.read() != -1; ++skipped) {
            }
            this.readingThreads.remove(Thread.currentThread());
            if (this.remoteShutDownPending && this.available() == 0) {
                this.setEOF();
            }
            return skipped;
        }
        catch (IOException e) {
            this.readingThreads.remove(Thread.currentThread());
            if (this.eof) {
                return -1L;
            }
            if (this.closed) {
                throw new SocketException("Socket closed");
            }
            throw e;
        }
    }

    protected VirtualSocket getSocket() {
        return this.socket;
    }

    protected synchronized void handleRemoteShutdown() throws IOException {
        log.debug("entering handleRemoteShutdown()");
        if (this.eof) {
            return;
        }
        this.remoteShutDownPending = true;
        if (this.available() == 0) {
            this.setEOF();
            this.interruptReadingThreads();
        }
        log.debug("leaving handleRemoteShutdown()");
    }

    protected synchronized void interruptReadingThreads() {
        Iterator it = this.readingThreads.iterator();
        while (it.hasNext()) {
            Thread t = (Thread)it.next();
            it.remove();
            t.interrupt();
        }
    }

    public final int readInt() throws IOException {
        int b4;
        int b3;
        int b2;
        int b1 = this.read();
        if ((b1 | (b2 = this.read()) | (b3 = this.read()) | (b4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + (b4 << 0);
    }

    protected void setEOF() {
        this.eof = true;
    }

    protected void setReadException(IOException e) {
        this.readException = e;
        this.interruptReadingThreads();
    }

    protected synchronized void setSkip(long n) {
        this.skipCount += n;
    }

    protected void setSocket(VirtualSocket socket) {
        this.socket = socket;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

