/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.TimerService;
import javax.transaction.UserTransaction;
import javax.xml.ws.WebServiceContext;
import org.jboss.ejb3.Container;
import org.jboss.injection.EJBContextPropertyInjector;
import org.jboss.injection.EnvEntryEncInjector;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.InjectionHandler;
import org.jboss.injection.InjectionUtil;
import org.jboss.injection.Injector;
import org.jboss.injection.JndiPropertyInjector;
import org.jboss.injection.LinkRefEncInjector;
import org.jboss.injection.TimerServicePropertyInjector;
import org.jboss.injection.UserTransactionPropertyInjector;
import org.jboss.injection.ValueEncInjector;
import org.jboss.injection.WebServiceContextPropertyInjector;
import org.jboss.injection.lang.reflect.BeanProperty;
import org.jboss.injection.lang.reflect.BeanPropertyFactory;
import org.jboss.injection.lang.reflect.FieldBeanProperty;
import org.jboss.injection.lang.reflect.MethodBeanProperty;
import org.jboss.logging.Logger;
import org.jboss.metamodel.descriptor.EnvEntry;
import org.jboss.metamodel.descriptor.EnvironmentRefGroup;
import org.jboss.metamodel.descriptor.MessageDestinationRef;
import org.jboss.metamodel.descriptor.Ref;
import org.jboss.metamodel.descriptor.ResourceEnvRef;
import org.jboss.metamodel.descriptor.ResourceRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceHandler
implements InjectionHandler {
    private static final Logger log = Logger.getLogger(ResourceHandler.class);

    private static void loadEnvEntry(InjectionContainer container, Collection<EnvEntry> envEntries) {
        for (EnvEntry envEntry : envEntries) {
            String encName = "env/" + envEntry.getEnvEntryName();
            InjectionUtil.injectionTarget(encName, (Ref)envEntry, container, container.getEncInjections());
            if (container.getEncInjectors().containsKey(encName)) continue;
            log.trace("adding env-entry injector " + encName);
            container.getEncInjectors().put(encName, new EnvEntryEncInjector(encName, envEntry.getEnvEntryType(), envEntry.getEnvEntryValue()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadXmlResourceRefs(InjectionContainer container, Collection<ResourceRef> refs) {
        for (ResourceRef envRef : refs) {
            String encName = "env/" + envRef.getResRefName();
            if (container.getEncInjectors().containsKey(encName)) continue;
            if (envRef.getMappedName() == null || envRef.getMappedName().equals("")) {
                if (envRef.getResUrl() == null) throw new RuntimeException("mapped-name is required for " + envRef.getResRefName() + " of deployment " + container.getIdentifier());
                try {
                    container.getEncInjectors().put(encName, new ValueEncInjector(encName, new URL(envRef.getResUrl().trim()), "<resource-ref>"));
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            } else {
                container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, envRef.getMappedName(), "<resource-ref>"));
            }
            InjectionUtil.injectionTarget(encName, (Ref)envRef, container, container.getEncInjections());
        }
    }

    private static void loadXmlResourceEnvRefs(InjectionContainer container, Collection<ResourceEnvRef> refs) {
        for (ResourceEnvRef envRef : refs) {
            String resTypeName = envRef.getResType();
            try {
                Class<?> resType;
                if (resTypeName != null && EJBContext.class.isAssignableFrom(resType = Class.forName(resTypeName))) {
                    AccessibleObject ao = InjectionUtil.findInjectionTarget(container.getClassloader(), envRef.getInjectionTarget());
                    container.getInjectors().add(new EJBContextPropertyInjector(BeanPropertyFactory.create(ao)));
                    continue;
                }
            }
            catch (ClassNotFoundException e) {
                throw new EJBException(e);
            }
            String encName = "env/" + envRef.getResRefName();
            if (container.getEncInjectors().containsKey(encName)) continue;
            if (envRef.getMappedName() == null || envRef.getMappedName().equals("")) {
                throw new RuntimeException("mapped-name is required for " + envRef.getResRefName() + " of deployment " + container.getIdentifier());
            }
            container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, envRef.getMappedName(), "<resource-ref>"));
            InjectionUtil.injectionTarget(encName, (Ref)envRef, container, container.getEncInjections());
        }
    }

    private static void loadXmlMessageDestinationRefs(InjectionContainer container, Collection<MessageDestinationRef> refs) {
        for (MessageDestinationRef envRef : refs) {
            String encName = "env/" + envRef.getMessageDestinationRefName();
            if (container.getEncInjectors().containsKey(encName)) continue;
            if (envRef.getMappedName() == null || envRef.getMappedName().equals("")) {
                String link = envRef.getMessageDestinationLink();
                if (link != null) {
                    // empty if block
                }
                throw new RuntimeException("mapped-name is required for " + envRef.getMessageDestinationRefName() + " of deployment " + container.getIdentifier());
            }
            container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, envRef.getMappedName(), "<message-destination-ref>"));
            InjectionUtil.injectionTarget(encName, (Ref)envRef, container, container.getEncInjections());
        }
    }

    @Override
    public void loadXml(EnvironmentRefGroup xml, InjectionContainer container) {
        if (xml == null) {
            return;
        }
        if (xml.getMessageDestinationRefs() != null) {
            ResourceHandler.loadXmlMessageDestinationRefs(container, xml.getMessageDestinationRefs());
        }
        if (xml.getResourceEnvRefs() != null) {
            ResourceHandler.loadXmlResourceEnvRefs(container, xml.getResourceEnvRefs());
        }
        if (xml.getResourceRefs() != null) {
            ResourceHandler.loadXmlResourceRefs(container, xml.getResourceRefs());
        }
        if (xml.getEnvEntries() != null) {
            ResourceHandler.loadEnvEntry(container, xml.getEnvEntries());
        }
    }

    @Override
    public void handleClassAnnotations(Class clazz, InjectionContainer container) {
        Resource res;
        Resources resources = container.getAnnotation(Resources.class, clazz);
        if (resources != null) {
            for (Resource ref : resources.value()) {
                this.handleClassAnnotation(ref, container, clazz);
            }
        }
        if ((res = container.getAnnotation(Resource.class, clazz)) != null) {
            this.handleClassAnnotation(res, container, clazz);
        }
    }

    private void handleClassAnnotation(Resource ref, InjectionContainer container, Class clazz) {
        String encName = ref.name();
        if (encName == null || encName.equals("")) {
            throw new RuntimeException("JBoss requires name() for class level @Resource");
        }
        encName = "env/" + ref.name();
        if (container.getEncInjectors().containsKey(encName)) {
            return;
        }
        String mappedName = ref.mappedName();
        if (mappedName == null || mappedName.equals("")) {
            throw new RuntimeException("You did not specify a @Resource.mappedName() for name: " + ref.name() + ", class: " + clazz.getName() + " and there is no binding for that enc name in XML");
        }
        if (ref.type() == URL.class) {
            try {
                URL url = new URL(ref.mappedName().trim());
                container.getEncInjectors().put(encName, new ValueEncInjector(encName, url, "@Resource"));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        } else {
            container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, ref.mappedName(), "@Resource"));
        }
    }

    @Override
    public void handleMethodAnnotations(Method method, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        Resource ref = container.getAnnotation(Resource.class, method);
        if (ref == null) {
            return;
        }
        log.trace("method " + method + " has @Resource");
        this.handlePropertyAnnotation(ref, new MethodBeanProperty(method), container, injectors);
    }

    @Override
    public void handleFieldAnnotations(Field field, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        Resource ref = container.getAnnotation(Resource.class, field);
        if (ref == null) {
            return;
        }
        log.trace("field " + field + " has @Resource");
        this.handlePropertyAnnotation(ref, new FieldBeanProperty(field), container, injectors);
    }

    private void handlePropertyAnnotation(Resource ref, BeanProperty property, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        assert (ref != null);
        assert (property != null);
        assert (container != null);
        assert (injectors != null);
        String encName = ref.name();
        if (encName == null || encName.equals("")) {
            encName = property.getDeclaringClass().getName() + "/" + property.getName();
        }
        if (!encName.startsWith("env/")) {
            encName = "env/" + encName;
        }
        AccessibleObject accObj = property.getAccessibleObject();
        Class type = property.getType();
        if (!ref.type().equals(Object.class)) {
            type = ref.type();
        }
        if (type.equals(UserTransaction.class)) {
            injectors.put(accObj, new UserTransactionPropertyInjector(property, container));
        } else if (type.equals(TimerService.class)) {
            injectors.put(accObj, new TimerServicePropertyInjector(property, (Container)((Object)container)));
        } else if (EJBContext.class.isAssignableFrom(type)) {
            injectors.put(accObj, new EJBContextPropertyInjector(property));
        } else if (type.equals(WebServiceContext.class)) {
            injectors.put(accObj, new WebServiceContextPropertyInjector(property));
        } else if (type.equals(String.class) || type.equals(Character.class) || type.equals(Byte.class) || type.equals(Short.class) || type.equals(Integer.class) || type.equals(Long.class) || type.equals(Boolean.class) || type.equals(Double.class) || type.equals(Float.class) || type.isPrimitive()) {
            if (container.getEncInjectors().containsKey(encName)) {
                injectors.put(accObj, new JndiPropertyInjector(property, encName, container.getEnc()));
            } else {
                if (ref.mappedName() != null && ref.mappedName().length() > 0) {
                    String s = ref.mappedName().trim();
                    try {
                        throw new RuntimeException("NYI");
                    }
                    catch (Throwable t) {
                        throw new RuntimeException("Failed to convert: " + ref.mappedName() + " to type:" + type, t);
                    }
                }
                log.warn("Not injecting " + property.getName() + ", no matching enc injector " + encName + " found");
            }
        } else {
            if (!container.getEncInjectors().containsKey(encName)) {
                String mappedName = ref.mappedName();
                if (mappedName == null || mappedName.equals("")) {
                    throw new RuntimeException("You did not specify a @Resource.mappedName() on " + accObj + " and there is no binding for enc name " + encName + " in XML");
                }
                container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, ref.mappedName(), "@Resource"));
            }
            injectors.put(accObj, new JndiPropertyInjector(property, encName, container.getEnc()));
        }
    }
}

