/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.ejb3.Container;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3Registry {
    private static final Logger log = Logger.getLogger(Ejb3Registry.class);
    private static Map<String, Container> containers = new HashMap<String, Container>();

    public static Container findContainer(String oid) {
        return containers.get(oid);
    }

    public static boolean hasContainer(String oid) {
        return containers.containsKey(oid);
    }

    private static final String oid(Container container) {
        return container.getObjectName().getCanonicalName();
    }

    public static void register(Container container) {
        String oid = Ejb3Registry.oid(container);
        if (Ejb3Registry.hasContainer(oid)) {
            throw new IllegalStateException("Container " + oid + " + is already registered");
        }
        containers.put(oid, container);
    }

    public static void unregister(Container container) {
        String oid = Ejb3Registry.oid(container);
        if (!Ejb3Registry.hasContainer(oid)) {
            throw new IllegalStateException("Container " + oid + " + is not registered");
        }
        containers.remove(oid);
    }

    public static Container getContainer(String oid) {
        if (!Ejb3Registry.hasContainer(oid)) {
            throw new IllegalStateException("Container " + oid + " is not registered");
        }
        return containers.get(oid);
    }

    public static Collection<Container> getContainers() {
        return Collections.unmodifiableCollection(containers.values());
    }
}

