/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.LineBorder;
import org.micromanager.conf.Device;
import org.micromanager.conf.PagePanel;

public class SynchroPage
extends PagePanel {
    private JList deviceList_;
    private JList synchroList_;
    private Device[] availableDevices_;

    public SynchroPage(Preferences preferences) {
        this.title_ = "Select devices to synchronize with image acquisition";
        this.helpText_ = "Select devices to be automatically synchronized with the camera.\nThe camera will wait for each device in the sycnhro list to finish current actions, before taking an image.\n\nSelecting a large number of devices for the sycnhro list may degrade the peformance of the system.Select only devices that are likely to interfere with imaging, such as filter wheels and stages.";
        this.prefs_ = preferences;
        this.setLayout(null);
        this.synchroList_ = new JList();
        this.synchroList_.setSelectionMode(0);
        this.synchroList_.setBorder(new LineBorder(Color.black, 1, false));
        this.synchroList_.setBounds(10, 33, 164, 244);
        this.add(this.synchroList_);
        this.deviceList_ = new JList();
        this.deviceList_.setSelectionMode(0);
        this.deviceList_.setBorder(new LineBorder(Color.black, 1, false));
        this.deviceList_.setBounds(280, 33, 164, 244);
        this.add(this.deviceList_);
        JButton jButton = new JButton();
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object e = SynchroPage.this.deviceList_.getSelectedValue();
                if (e == null) {
                    return;
                }
                SynchroPage.this.addSynchro((String)e);
            }
        });
        jButton.setText("<< Add");
        jButton.setBounds(181, 108, 93, 23);
        this.add(jButton);
        JButton jButton2 = new JButton();
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object e = SynchroPage.this.synchroList_.getSelectedValue();
                if (e == null) {
                    return;
                }
                SynchroPage.this.removeSynchro((String)e);
            }
        });
        jButton2.setText("Remove >>");
        jButton2.setBounds(181, 137, 93, 23);
        this.add(jButton2);
        JLabel jLabel = new JLabel();
        jLabel.setText("Synchronized devices");
        jLabel.setBounds(10, 13, 157, 14);
        this.add(jLabel);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("AvailableDevices");
        jLabel2.setBounds(280, 13, 162, 14);
        this.add(jLabel2);
    }

    public boolean enterPage(boolean bl) {
        String[] stringArray = this.model_.getSynchroList();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        this.synchroList_.setListData(vector);
        this.availableDevices_ = this.model_.getDevices();
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < this.availableDevices_.length; ++i) {
            if (this.isInSynchroList(this.availableDevices_[i].getName()) || this.availableDevices_[i].isCore() || this.availableDevices_[i].isCamera()) continue;
            vector2.add(this.availableDevices_[i].getName());
        }
        this.deviceList_.setListData(vector2);
        return true;
    }

    public boolean exitPage(boolean bl) {
        this.model_.clearSynchroDevices();
        for (int i = 0; i < this.synchroList_.getModel().getSize(); ++i) {
            this.model_.addSynchroDevice((String)this.synchroList_.getModel().getElementAt(i));
        }
        return true;
    }

    public void refresh() {
    }

    public void loadSettings() {
    }

    public void saveSettings() {
    }

    private boolean isInSynchroList(String string) {
        for (int i = 0; i < this.synchroList_.getModel().getSize(); ++i) {
            if (((String)this.synchroList_.getModel().getElementAt(i)).compareTo(string) != 0) continue;
            return true;
        }
        return false;
    }

    private void addSynchro(String string) {
        Vector vector = new Vector();
        for (int i = 0; i < this.synchroList_.getModel().getSize(); ++i) {
            vector.add(this.synchroList_.getModel().getElementAt(i));
        }
        vector.add(string);
        this.synchroList_.setListData(vector);
        Vector vector2 = new Vector();
        for (int i = 0; i < this.deviceList_.getModel().getSize(); ++i) {
            if (string.compareTo((String)this.deviceList_.getModel().getElementAt(i)) == 0) continue;
            vector2.add(this.deviceList_.getModel().getElementAt(i));
        }
        this.deviceList_.setListData(vector2);
    }

    private void removeSynchro(String string) {
        Vector vector = new Vector();
        for (int i = 0; i < this.deviceList_.getModel().getSize(); ++i) {
            vector.add(this.deviceList_.getModel().getElementAt(i));
        }
        vector.add(string);
        this.deviceList_.setListData(vector);
        Vector vector2 = new Vector();
        for (int i = 0; i < this.synchroList_.getModel().getSize(); ++i) {
            if (string.compareTo((String)this.synchroList_.getModel().getElementAt(i)) == 0) continue;
            vector2.add(this.synchroList_.getModel().getElementAt(i));
        }
        this.synchroList_.setListData(vector2);
    }
}

